/* bzflag
 * Copyright (c) 1993-2025 Tim Riker
 *
 * This package is free software;  you can redistribute it and/or
 * modify it under the terms of the license found in the file
 * named COPYING that should have accompanied this file.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef __BZWERROR_H__
#define __BZWERROR_H__

#include "common.h"

/* implementation-specific system headers */
#include <string>


class BZWError
{

public:
    BZWError(std::string _location);
    ~BZWError();

    /* return false if error reporting failed, true otherwise */
    bool fatalError(std::string errorMsg, int line);
    bool warning(std::string warningMsg, int line);

    /* status */
    bool hasHadError() const
    {
        return hadError;
    };
    bool hasHadWarning() const
    {
        return hadWarning;
    };

private:
    /* data */
    bool hadError;
    bool hadWarning;
    std::string location;

    /* no public default constructor */
    BZWError();
};

#endif //__BZWERROR_H__

// Local Variables: ***
// mode: C++ ***
// tab-width: 4 ***
// c-basic-offset: 4 ***
// indent-tabs-mode: nil ***
// End: ***
// ex: shiftwidth=4 tabstop=4
