//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Tests/SimFactory/MakeSimulations.h
//! @brief     Declares simulation builders for standard tests.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_TESTS_SIMFACTORY_MAKESIMULATIONS_H
#define BORNAGAIN_TESTS_SIMFACTORY_MAKESIMULATIONS_H

#include <memory>
#include <string>

class DepthprobeSimulation;
class IBeamScan;
class MultiLayer;
class OffspecSimulation;
class ScatteringSimulation;
class SpecularSimulation;

//! Simulations for standard tests.

namespace test::makeSimulation {

std::unique_ptr<ScatteringSimulation> MiniGISAS(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISAS_v2(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniZPolarizedGISAS(const MultiLayer& sample,
                                                          const std::string& polCase);
std::unique_ptr<ScatteringSimulation> BasicGISAS(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> SpinflipGISAS(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISASBeamDivergence(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISASDetectorResolution(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISASSpecularPeak(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> GISASWithMasks(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MaxiGISAS(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MaxiGISAS00(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> RectDetectorGeneric(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> RectDetectorPerpToSample(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> RectDetectorPerpToDirectBeam(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> RectDetectorPerpToReflectedBeam(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISASMonteCarlo(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> SphericalDetWithRoi(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> RectDetWithRoi(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> MiniGISASFit(const MultiLayer& sample);
std::unique_ptr<ScatteringSimulation> ExtraLongWavelengthGISAS(const MultiLayer& sample);

std::unique_ptr<OffspecSimulation> MiniOffspec(const MultiLayer& sample);

IBeamScan* BasicSpecularScan(bool vsQ);
std::unique_ptr<SpecularSimulation> BasicSpecular(const MultiLayer& sample, bool vsQ,
                                                  double intensity = 1.);
std::unique_ptr<SpecularSimulation> BasicYPolarizedSpecular(const MultiLayer& sample,
                                                            const std::string& polCase, bool vsQ);
std::unique_ptr<SpecularSimulation> SpecularWithGaussianBeam(const MultiLayer& sample);
std::unique_ptr<SpecularSimulation> SpecularWithSquareBeam(const MultiLayer& sample);
std::unique_ptr<SpecularSimulation> SpecularDivergentBeam(const MultiLayer& sample);
std::unique_ptr<SpecularSimulation> TOFRWithRelativeResolution(const MultiLayer& sample);
std::unique_ptr<SpecularSimulation> TOFRWithPointwiseResolution(const MultiLayer& sample);

std::unique_ptr<DepthprobeSimulation> BasicDepthprobe(const MultiLayer& sample);

} // namespace test::makeSimulation

#endif // BORNAGAIN_TESTS_SIMFACTORY_MAKESIMULATIONS_H
