//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Support/Util/CoordName.cpp
//! @brief     Implements namespace GUI::Util::CoordName
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "GUI/Support/Util/CoordName.h"
#include <map>

//! Correspondence of domain detector axes types to their GUI counterpart.

QString GUI::Util::CoordName::nameFromCoord(Coords units)
{
    static const std::map<Coords, QString> names_from_coords{{Coords::NBINS, "nbins"},
                                                             {Coords::RADIANS, "Radians"},
                                                             {Coords::MM, "mm"},
                                                             {Coords::QSPACE, "q-space"},
                                                             {Coords::DEGREES, "Degrees"}};
    const auto it = names_from_coords.find(units);
    if (it == names_from_coords.end())
        return "";
    return it->second;
}

//! Correspondence of GUI axes units names to their domain counterpart.

Coords GUI::Util::CoordName::coordFromName(const QString& name)
{
    static const std::map<QString, Coords> units_from_names{{"nbins", Coords::NBINS},
                                                            {"Radians", Coords::RADIANS},
                                                            {"Degrees", Coords::DEGREES},
                                                            {"mm", Coords::MM},
                                                            {"q-space", Coords::QSPACE}};
    return units_from_names.at(name);
}
