/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.dff;

import com.kreative.dff.DFFResource;
import com.kreative.dff.DFFResourceAlreadyExistsException;

public abstract class DFFResourceProvider {
    public static final int MAGIC_NUMBER_DFF1 = 625231430;
    public static final int MAGIC_NUMBER_DFF2 = 625231410;
    public static final int MAGIC_NUMBER_DFF3 = 625231411;
    public static final int MAGIC_NUMBER_DFF1R = 1179010085;
    public static final int MAGIC_NUMBER_DFF2R = 843465765;
    public static final int MAGIC_NUMBER_DFF3R = 860242981;

    public abstract boolean isReadOnly();

    public abstract void flush();

    public abstract void close();

    public abstract boolean add(DFFResource var1) throws DFFResourceAlreadyExistsException;

    public abstract boolean contains(long var1, int var3);

    public abstract boolean contains(long var1, String var3);

    public abstract DFFResource get(long var1, int var3);

    public abstract DFFResource get(long var1, String var3);

    public abstract DFFResource getAttributes(long var1, int var3);

    public abstract DFFResource getAttributes(long var1, String var3);

    public abstract long getLength(long var1, int var3);

    public abstract long getLength(long var1, String var3);

    public abstract byte[] getData(long var1, int var3);

    public abstract byte[] getData(long var1, String var3);

    public abstract int read(long var1, int var3, long var4, byte[] var6, int var7, int var8);

    public abstract int read(long var1, String var3, long var4, byte[] var6, int var7, int var8);

    public abstract boolean remove(long var1, int var3);

    public abstract boolean remove(long var1, String var3);

    public abstract boolean set(long var1, int var3, DFFResource var4) throws DFFResourceAlreadyExistsException;

    public abstract boolean set(long var1, String var3, DFFResource var4) throws DFFResourceAlreadyExistsException;

    public abstract boolean setAttributes(long var1, int var3, DFFResource var4) throws DFFResourceAlreadyExistsException;

    public abstract boolean setAttributes(long var1, String var3, DFFResource var4) throws DFFResourceAlreadyExistsException;

    public abstract boolean setLength(long var1, int var3, long var4);

    public abstract boolean setLength(long var1, String var3, long var4);

    public abstract boolean setData(long var1, int var3, byte[] var4);

    public abstract boolean setData(long var1, String var3, byte[] var4);

    public abstract int write(long var1, int var3, long var4, byte[] var6, int var7, int var8);

    public abstract int write(long var1, String var3, long var4, byte[] var6, int var7, int var8);

    public abstract int getTypeCount();

    public abstract long getType(int var1);

    public abstract long[] getTypes();

    public abstract int getResourceCount(long var1);

    public abstract int getID(long var1, int var3);

    public abstract int[] getIDs(long var1);

    public abstract String getName(long var1, int var3);

    public abstract String[] getNames(long var1);

    public final int getNextAvailableID(long type) {
        return this.getNextAvailableID(type, 0);
    }

    public abstract int getNextAvailableID(long var1, int var3);

    public abstract String getNameFromID(long var1, int var3);

    public abstract int getIDFromName(long var1, String var3);

    public final DFFResourceProvider copyTo(DFFResourceProvider rp) throws DFFResourceAlreadyExistsException {
        long[] lArray = this.getTypes();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long type = lArray[n2];
            int[] nArray = this.getIDs(type);
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                rp.add(this.get(type, id));
                ++n4;
            }
            ++n2;
        }
        return rp;
    }

    public final DFFResourceProvider copyFrom(DFFResourceProvider rp) throws DFFResourceAlreadyExistsException {
        long[] lArray = rp.getTypes();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long type = lArray[n2];
            int[] nArray = rp.getIDs(type);
            int n3 = nArray.length;
            int n4 = 0;
            while (n4 < n3) {
                int id = nArray[n4];
                this.add(rp.get(type, id));
                ++n4;
            }
            ++n2;
        }
        return this;
    }
}

