#!/bin/sh

set -e

if [ "$#" -lt 2 ]; then
    echo "Usage: $0 <version> <path>"
    exit 1
fi

VERSION=$1
BASE=$2/ocaml-$VERSION
THIS=$(dirname $(dirname $0))

mkdir -p $BASE
cd $BASE
mkdir -p ben build pool
ln -sfT $THIS usr

cat > pool/apt-ftparchive.conf <<EOF
APT::FTPArchive::Release {
        Origin "ocaml.debian.net";
        Label "ocaml-$VERSION";
        Suite "unstable-ocaml";
        Architectures "source amd64";
        Description "Debian packages rebuilt for transition to OCaml $VERSION";
};
EOF

touch pool/stamp && make -C pool -f ../usr/lib/Makefile.pool

if ! [ -f build/ocaml-$VERSION.tgz ]; then
    sudo ./usr/lib/create-chroot.sh $VERSION $BASE
fi
