// BookmarkItem.cs
//
//  Copyright (C) 2009 Christian Eide
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
//

using System;
using System.Collections.Generic;

namespace bareFTP.Preferences.Bookmarks
{
	
	public abstract class BookmarkItem
	{
		string name;
		List<BookmarkItem> items;
		
		public BookmarkItem(string name)
		{
			this.name = name;
			items = new List<BookmarkItem>();
		}
		
		public BookmarkItem()
		{
		}

		public string Name {
			get {
				return name;
			}
			set {
				name = value;
			}
		}

		public List<BookmarkItem> Items {
			get {
				return items;
			}
		}

		
	}
}
