//
// BAGEL - Parallel electron correlation program.
// Filename: _complex_eriroot_1.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot1(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[1] = {5.000000000000001e-01};
  static constexpr double aw[1] = {8.862269254527578e-01};
  static constexpr double xr[2100] = {   8.601810857312775e-01,  -1.010657426965544e-01,   1.643145504217249e-03,   5.801045676462243e-04,  -2.187801369965509e-05,
  -4.585463875318442e-06,   2.676958846771667e-07,   3.712907221167327e-08,  -3.073938538870011e-09,  -2.939222100729337e-10,   3.377818713428330e-11,   2.209494777553635e-12,
  -3.590011848477326e-13,  -1.513361485391230e-14,   8.603138582291704e-01,  -1.009158591301066e-01,   1.632536513606348e-03,   5.763083673864984e-04,  -2.157120277066245e-05,
  -4.524351665834687e-06,   2.615722195657112e-07,   3.634763298350274e-08,  -2.974000974035463e-09,  -2.854296776295519e-10,   3.234332970370890e-11,   2.130309152790241e-12,
  -3.401790869316731e-13,  -1.452973495400726e-14,   8.605475147542975e-01,  -1.006521722222625e-01,   1.613941740511749e-03,   5.696529718206236e-04,  -2.103611605068803e-05,
  -4.417670329590290e-06,   2.509562621588938e-07,   3.499004888956493e-08,  -2.801946474574586e-09,  -2.707457573203970e-10,   2.989208922219625e-11,   1.993865015661335e-12,
  -3.082931072287052e-13,  -1.348713231064374e-14,   8.608289971771335e-01,  -1.003346518885514e-01,   1.591668102410133e-03,   5.616780649215961e-04,  -2.039966839216818e-05,
  -4.290612870140646e-06,   2.384365158387646e-07,   3.338419366398678e-08,  -2.601035219848277e-09,  -2.534945970511813e-10,   2.706134771513749e-11,   1.834374380199512e-12,
  -2.719142770592287e-13,  -1.226562667291230e-14,   8.611011532038766e-01,  -1.000277968614999e-01,   1.570264420523609e-03,   5.540117725289644e-04,  -1.979273267331767e-05,
  -4.169274725866924e-06,   2.266076085273358e-07,   3.186202652577097e-08,  -2.413257009601101e-09,  -2.372648448260451e-10,   2.444786396714952e-11,   1.685182686988862e-12,
  -2.387771669395706e-13,  -1.112090441513510e-14,   8.613196124680035e-01,  -9.978158793218173e-02,   1.553177431335301e-03,   5.478895931572970e-04,  -1.931149832385308e-05,
  -4.072945255035161e-06,   2.173063773568764e-07,   3.066166980270856e-08,  -2.267042938232940e-09,  -2.245532597045658e-10,   2.243542106358856e-11,   1.568952164952747e-12,
  -2.135742664575330e-13,  -1.022813034708687e-14,   8.614635830363960e-01,  -9.961937986556743e-02,   1.541962207704214e-03,   5.438702570131869e-04,  -1.899723346070765e-05,
  -4.009979603238863e-06,   2.112699686216551e-07,   2.988098297791368e-08,  -2.172845934795426e-09,  -2.163282446479466e-10,   2.114978651538394e-11,   1.494052463071742e-12,
  -1.976241558068488e-13,  -9.652557018110497e-15,   8.615374005475157e-01,  -9.953622701112198e-02,   1.536225892365380e-03,   5.418141631044787e-04,  -1.883698598933091e-05,
  -3.977854625869216e-06,   2.082034938948374e-07,   2.948388587229017e-08,  -2.125207179542289e-09,  -2.121576391994568e-10,   2.050292328508601e-11,   1.456169335582810e-12,
  -1.896449868371013e-13,  -9.361400766128838e-15,   8.615630746081193e-01,  -9.950730854065330e-02,   1.534233003623756e-03,   5.410997951184162e-04,  -1.878139142252678e-05,
  -3.966706666114448e-06,   2.071414780208216e-07,   2.934627776189128e-08,  -2.108742170565499e-09,  -2.107144546081436e-10,   2.027988059601971e-11,   1.443075696968018e-12,
  -1.869010218852146e-13,  -9.260764939124001e-15,   8.615671478360035e-01,  -9.950272069923723e-02,   1.533916934497323e-03,   5.409864951800887e-04,  -1.877257790722583e-05,
  -3.964939222729109e-06,   2.069732015500879e-07,   2.932446991018511e-08,  -2.106134890519663e-09,  -2.104858402570670e-10,   2.024458617858094e-11,   1.441002268239345e-12,
  -1.864671615072239e-13,  -9.244828803593579e-15,   5.125671110320857e-01,  -6.992660708037263e-02,   5.011897315586900e-03,  -3.212867666806300e-05,  -2.988157235835503e-05,
   2.471736410213285e-06,   3.109171137348383e-08,  -2.062274948177391e-08,   1.330993621043906e-09,   5.432839925265779e-11,  -1.432011593803170e-11,   6.889112008423514e-13,
   5.733442466657841e-14,  -9.891679666485124e-15,   5.130040947954899e-01,  -6.992862742310148e-02,   4.995509617231116e-03,  -3.011857668756549e-05,  -2.980947108828487e-05,
   2.434762245638206e-06,   3.361325363721272e-08,  -2.039933392989624e-08,   1.282205219655327e-09,   5.611432039940303e-11,  -1.395779796330084e-11,   6.399811120432562e-13,
   5.781874596088989e-14,  -9.453059826243695e-15,   5.137739673229925e-01,  -6.993178472079159e-02,   4.966632381604643e-03,  -2.659875791747488e-05,  -2.967973212300705e-05,
   2.369895028916103e-06,   3.796547087811897e-08,  -2.000143002758538e-08,   1.197356768262708e-09,   5.908376321520176e-11,  -1.331849573267616e-11,   5.561178517446751e-13,
   5.844162981625638e-14,  -8.688374849980401e-15,   5.147028755799604e-01,  -6.993491141126006e-02,   4.931781061978439e-03,  -2.238844857391238e-05,  -2.951863311464065e-05,
   2.292098152869608e-06,   4.306448251259802e-08,  -1.951431356094375e-08,   1.096867245632406e-09,   6.237125464305173e-11,  -1.254617053196114e-11,   4.588841724597685e-13,
   5.881598083779525e-14,  -7.780494127124211e-15,   5.156025218092258e-01,  -6.993722793504183e-02,   4.898019337854656e-03,  -1.834895291385844e-05,  -2.935791485450852e-05,
   2.217249560574719e-06,   4.784534413383588e-08,  -1.903557469056092e-08,   1.001518498061831e-09,   6.525387991749448e-11,  -1.179803743941841e-11,   3.688040254425559e-13,
   5.880298851879404e-14,  -6.917890303086937e-15,   5.163257475047922e-01,  -6.993858254412899e-02,   4.870873007187495e-03,  -1.512885307490518e-05,  -2.922540559752114e-05,
   2.157438844305608e-06,   5.157714564545072e-08,  -1.864598619244258e-08,   9.262823441725878e-10,   6.736087946120512e-11,  -1.119710479628424e-11,   2.992836308853214e-13,
   5.853684167046895e-14,  -6.237189704243071e-15,   5.168029001803816e-01,  -6.993922857333734e-02,   4.852960721906330e-03,  -1.301767372837776e-05,  -2.913638416714004e-05,
   2.118156075015228e-06,   5.398514400463672e-08,  -1.838674026011154e-08,   8.773371745457940e-10,   6.865019869031492e-11,  -1.080110687387221e-11,   2.548198655629682e-13,
   5.824133025760289e-14,  -5.794636044940968e-15,   5.170477116764310e-01,  -6.993948360924403e-02,   4.843769848034362e-03,  -1.193860164779688e-05,  -2.909022069747528e-05,
   2.098056630353906e-06,   5.520399533874369e-08,  -1.825306710840168e-08,   8.524390354240558e-10,   6.928100026476441e-11,  -1.059812682015833e-11,   2.324375937987546e-13,
   5.805373136063585e-14,  -5.569660724208949e-15,   5.171328840857392e-01,  -6.993956018752324e-02,   4.840572148733210e-03,  -1.156383435678555e-05,  -2.907408243526515e-05,
   2.091072654375085e-06,   5.562541080259748e-08,  -1.820645729782395e-08,   8.438107867127873e-10,   6.949561482030513e-11,  -1.052754300533716e-11,   2.247188493535680e-13,
   5.798283245024806e-14,  -5.491726653666366e-15,   5.171463980429660e-01,  -6.993957176130799e-02,   4.840064778198623e-03,  -1.150440254622165e-05,  -2.907151817114277e-05,
   2.089964955037374e-06,   5.569215015302480e-08,  -1.819905703204786e-08,   8.424433949962002e-10,   6.952943750988240e-11,  -1.051634550670669e-11,   2.234973833935179e-13,
   5.797131781460938e-14,  -5.479377283664112e-15,   3.036483193678985e-01,  -3.610614329756407e-02,   3.189467510831545e-03,  -1.865306967050286e-04,   3.670406734835461e-06,
   5.743316335932937e-07,  -7.409096463155993e-08,   4.109848964428573e-09,  -6.905110360721754e-12,  -2.079216330162724e-11,   2.033092501956177e-12,  -8.688626213663241e-14,
  -2.314928509662371e-15,   6.861478716005529e-16,   3.039503053072382e-01,  -3.615649792949831e-02,   3.190955640816923e-03,  -1.859357368738935e-04,   3.568051001221112e-06,
   5.812010568715998e-07,  -7.395550849131531e-08,   4.033747740187911e-09,   6.865932154901650e-13,  -2.104854215442343e-11,   2.004518698010370e-12,  -8.193193350090973e-14,
  -2.645550217870342e-15,   6.874726727085371e-16,   3.044832094377903e-01,  -3.624520407303049e-02,   3.193535180603805e-03,  -1.848810661286950e-04,   3.387656650771114e-06,
   5.931978889185186e-07,  -7.370092521533499e-08,   3.898902661216089e-09,   1.397246429444327e-11,  -2.148033967592826e-11,   1.952610768163276e-12,  -7.320504370599704e-14,
  -3.213350663167872e-15,   6.880817962148435e-16,   3.051276775646187e-01,  -3.635221992705799e-02,   3.196575551337527e-03,  -1.835975353015665e-04,   3.169898417190015e-06,
   6.074920189582088e-07,  -7.336670617279828e-08,   3.734924488056318e-09,   2.984740470466362e-11,  -2.196744982377434e-11,   1.887359502212864e-12,  -6.268488586541820e-14,
  -3.873097999199538e-15,   6.859102220070265e-16,   3.057533914301525e-01,  -3.645584795115307e-02,   3.199444651074644e-03,  -1.823429910245515e-04,   2.958911701577389e-06,
   6.211452993997108e-07,  -7.301485509596543e-08,   3.574820582738519e-09,   4.505499343284284e-11,  -2.240376197096923e-11,   1.821484779528479e-12,  -5.251462659600455e-14,
  -4.485141123193868e-15,   6.808084394524832e-16,   3.062575103250013e-01,  -3.653914167704118e-02,   3.201696976914160e-03,  -1.813263052694527e-04,   2.789247181288170e-06,
   6.319838575063397e-07,  -7.271193685177696e-08,   3.445220460068966e-09,   5.715739566618839e-11,  -2.272913630239745e-11,   1.766654594320941e-12,  -4.435798503708152e-14,
  -4.957618468393487e-15,   6.745913664273705e-16,   3.065906477138808e-01,  -3.659408857225072e-02,   3.203156428246296e-03,  -1.806515635880315e-04,   2.677288745727163e-06,
   6.390671125037629e-07,  -7.250230464377895e-08,   3.359292040118495e-09,   6.508056153865295e-11,  -2.293139003744445e-11,   1.729581304495569e-12,  -3.898839593085854e-14,
  -5.259670339892962e-15,   6.694672628128981e-16,   3.067617371357159e-01,  -3.662227789580662e-02,   3.203897013051894e-03,  -1.803041492683692e-04,   2.619840893522984e-06,
   6.426803399023441e-07,  -7.239173390500195e-08,   3.315076640632918e-09,   6.912640320361036e-11,  -2.303132317340129e-11,   1.710286220992422e-12,  -3.623759171029267e-14,
  -5.411633001512470e-15,   6.665250241271485e-16,   3.068212875433769e-01,  -3.663208490068227e-02,   3.204153362035779e-03,  -1.801830853619935e-04,   2.599853388742430e-06,
   6.439340752803471e-07,  -7.235278598500064e-08,   3.299673469663360e-09,   7.053090003335283e-11,  -2.306548033381164e-11,   1.703529996889524e-12,  -3.528126559834632e-14,
  -5.464021318942296e-15,   6.654517865408573e-16,   3.068307374280437e-01,  -3.663364092132732e-02,   3.204193973769339e-03,  -1.801638673998333e-04,   2.596682016339687e-06,
   6.441328414925223e-07,  -7.234658354284898e-08,   3.297228558385695e-09,   7.075359849070572e-11,  -2.307087092729161e-11,   1.702455967448210e-12,  -3.512956370464186e-14,
  -5.472310685877033e-15,   6.652791508319579e-16,   1.980621925108184e-01,  -1.812571792915628e-02,   1.464429795644336e-03,  -9.863587222049130e-05,   5.096651149575978e-06,
  -1.556210769265846e-07,  -3.250073612372841e-09,   8.688794769773356e-10,  -7.015163433552855e-11,   3.470833985139442e-12,  -7.555737097831716e-14,  -5.187717846572017e-15,
   7.506329183490981e-16,  -5.205783967871222e-17,   1.982051568082642e-01,  -1.815391331430290e-02,   1.467257169173697e-03,  -9.876582797016203e-05,   5.089869956970299e-06,
  -1.537444370799663e-07,  -3.436774841440392e-09,   8.794832860501070e-10,  -7.030068793167992e-11,   3.430314854995874e-12,  -7.035904093260160e-14,  -5.545896555272418e-15,
   7.636245297783589e-16,  -5.174649852620916e-17,   1.984576297911495e-01,  -1.820369139577481e-02,   1.472242491030990e-03,  -9.899365642486651e-05,   5.077690199397282e-06,
  -1.504166765200476e-07,  -3.766425908418432e-09,   8.980726690667051e-10,  -7.054541156795626e-11,   3.357344353877026e-12,  -6.112899196404848e-14,  -6.175164231302820e-15,
   7.858498738123844e-16,  -5.113095860024320e-17,   1.987632809979662e-01,  -1.826392917199174e-02,   1.478264550304927e-03,  -9.926661639456913e-05,   5.062596919579871e-06,
  -1.463648906747970e-07,  -4.165380911308140e-09,   9.203417533332954e-10,  -7.081003510094565e-11,   3.266603886375962e-12,  -4.987235547354585e-14,  -6.931132062079058e-15,
   8.115175025891838e-16,  -5.027369881542437e-17,   1.990603766164969e-01,  -1.832245438764509e-02,   1.484104035428046e-03,  -9.952893859094924e-05,   5.047561885478591e-06,
  -1.424025338275766e-07,  -4.552998105272888e-09,   9.417374419481268e-10,  -7.103399693566961e-11,   3.175905003574318e-12,  -3.884776092600274e-14,  -7.659484862363994e-15,
   8.351501031896973e-16,  -4.932311763124762e-17,   1.992999812097425e-01,  -1.836963529817963e-02,   1.488803440814429e-03,  -9.973834683906821e-05,   5.035175558250308e-06,
  -1.391898952620163e-07,  -4.865461170548915e-09,   9.588114877739727e-10,  -7.119071734380779e-11,   3.100978403389466e-12,  -2.989939820162493e-14,  -8.242032828810202e-15,
   8.532531696034141e-16,  -4.847249886385242e-17,   1.994584388829089e-01,  -1.840082804227935e-02,   1.491906345669393e-03,  -9.987577944190611e-05,   5.026856565778683e-06,
  -1.370569998286724e-07,  -5.072020988470111e-09,   9.700133907037157e-10,  -7.128262928436556e-11,   3.050560928494948e-12,  -2.395456521433434e-14,  -8.624813898698111e-15,
   8.647518526607556e-16,  -4.786888372743389e-17,   1.995398550405928e-01,  -1.841685207359745e-02,   1.493499094997344e-03,  -9.994606613160548e-05,   5.022542818386371e-06,
  -1.359585619882850e-07,  -5.178124983567616e-09,   9.757410546791820e-10,  -7.132622005231059e-11,   3.024389371352919e-12,  -2.089194014877632e-14,  -8.820702560076199e-15,
   8.705124403926881e-16,  -4.754605356452545e-17,   1.995681991351656e-01,  -1.842243018904008e-02,   1.494053347589596e-03,  -9.997048359031994e-05,   5.021034764443115e-06,
  -1.355757490853136e-07,  -5.215059344214042e-09,   9.777306141717631e-10,  -7.134081666740513e-11,   3.015235655721797e-12,  -1.982444411372442e-14,  -8.888772055384991e-15,
   8.724943499497790e-16,  -4.743164496146239e-17,   1.995726972590268e-01,  -1.842331539730008e-02,   1.494141294212612e-03,  -9.997435609765566e-05,   5.020795143025007e-06,
  -1.355149786346652e-07,  -5.220920499587884e-09,   9.780461392907935e-10,  -7.134310561047697e-11,   3.013780977714560e-12,  -1.965497533608207e-14,  -8.899568423229670e-15,
   8.728077521996769e-16,  -4.741339283536929e-17,   1.431376096022458e-01,  -9.995654893004647e-03,   6.679982817405821e-04,  -4.128019811046899e-05,   2.264687359235590e-06,
  -1.043483917467934e-07,   3.580489677913010e-09,  -4.725378437675786e-11,  -5.083964225575217e-12,   5.581275959364099e-13,  -3.487535238619660e-14,   1.573084768019420e-15,
  -4.721836225035678e-17,   1.542218290562072e-19,   1.432028467186617e-01,  -1.000761121307956e-02,   6.692993378381217e-04,  -4.137848942306838e-05,   2.269521632031409e-06,
  -1.044077494055194e-07,   3.563937917274402e-09,  -4.516550667704013e-11,  -5.238213794264519e-12,   5.660155550122923e-13,  -3.510663201559759e-14,   1.568291971238597e-15,
  -4.596549374528684e-17,   4.948639852942676e-20,   1.433180609937946e-01,  -1.002873087096846e-02,   6.715972334129228e-04,  -4.155196067985259e-05,   2.278031588594815e-06,
  -1.045090440867170e-07,   3.534398734780424e-09,  -4.145925031295062e-11,  -5.511127393608561e-12,   5.799077028794175e-13,  -3.550796466863926e-14,   1.559188547944889e-15,
  -4.371310243505374e-17,  -1.371045907071947e-19,   1.434575539567683e-01,  -1.005430742700075e-02,   6.743795521973505e-04,  -4.176178127486613e-05,   2.288287223124649e-06,
  -1.046256370189647e-07,   3.498110246279221e-09,  -3.694107569226094e-11,  -5.842378908577646e-12,   5.966595342456479e-13,  -3.598158347166509e-14,   1.547071294629329e-15,
  -4.091835208015159e-17,  -3.657430933383715e-19,   1.435931543136137e-01,  -1.007917696171720e-02,   6.770844228414246e-04,  -4.196552910973258e-05,   2.298206545454452e-06,
  -1.047326218605202e-07,   3.462284458874021e-09,  -3.251673113091180e-11,  -6.165230889925328e-12,   6.128705893030024e-13,  -3.642895268299748e-14,   1.534137532268440e-15,
  -3.813070219762378e-17,  -5.908140713930138e-19,   1.437025234113646e-01,  -1.009924038120413e-02,   6.792661792488021e-04,  -4.212970533481801e-05,   2.306170910610544e-06,
  -1.048143431161319e-07,   3.432994630568399e-09,  -2.892523602479860e-11,  -6.426217287287520e-12,   6.258915052115733e-13,  -3.678032495423024e-14,   1.522873358868000e-15,
  -3.583155381637922e-17,  -7.743295195056157e-19,   1.437748568458614e-01,  -1.011251205571616e-02,   6.807091878807779e-04,  -4.223820878002666e-05,   2.311420544139859e-06,
  -1.048661487624184e-07,   3.413430006638979e-09,  -2.653869543947166e-11,  -6.599107440998517e-12,   6.344759469980643e-13,  -3.700803548831950e-14,   1.515014021524152e-15,
  -3.428613387039720e-17,  -8.966590194493851e-19,   1.438120234135702e-01,  -1.011933206382358e-02,   6.814506566109989e-04,  -4.229393613542462e-05,   2.314112417421011e-06,
  -1.048920730343307e-07,   3.403317483991401e-09,  -2.530897061695764e-11,  -6.688028006008971e-12,   6.388782742368742e-13,  -3.712358219956485e-14,   1.510848644680200e-15,
  -3.348438739411854e-17,  -9.598080619208250e-19,   1.438249627447356e-01,  -1.012170652553938e-02,   6.817087975735542e-04,  -4.231333343751937e-05,   2.315048699631856e-06,
  -1.049009877330994e-07,   3.399787348882326e-09,  -2.488029783852511e-11,  -6.718998709761514e-12,   6.404095450922988e-13,  -3.716357644372370e-14,   1.509378226773471e-15,
  -3.320404262391578e-17,  -9.818394872095062e-19,   1.438270161887461e-01,  -1.012208335292701e-02,   6.817497641204832e-04,  -4.231641156400409e-05,   2.315197243879955e-06,
  -1.049023972198168e-07,   3.399226672198781e-09,  -2.481224224874854e-11,  -6.723914332566815e-12,   6.406524889713488e-13,  -3.716991238012128e-14,   1.509143911847580e-15,
  -3.315949454753790e-17,  -9.853380264030279e-19,   1.114007844970514e-01,  -6.148377269362779e-03,   3.346448136086434e-04,  -1.768732608579505e-05,   8.873933953525990e-07,
  -4.106194386968898e-08,   1.687411890632281e-09,  -5.770320704657139e-11,   1.361087898482925e-12,   2.776437182403889e-15,  -2.764260039755245e-15,   2.066304102589984e-16,
  -1.067178839248098e-17,   4.348254007083334e-19,   1.114331871197841e-01,  -6.153490961725796e-03,   3.351576020845481e-04,  -1.772676980467365e-05,   8.898045940619080e-07,
  -4.117482302579240e-08,   1.690689112427315e-09,  -5.766224094486094e-11,   1.347117939563153e-12,   3.969075252100827e-15,  -2.835282260028627e-15,   2.098887255312858e-16,
  -1.078094973752077e-17,   4.364264069392493e-19,   1.114904027785862e-01,  -6.162523336204664e-03,   3.360635369518758e-04,  -1.779645465262015e-05,   8.940628196469726e-07,
  -4.137391869745176e-08,   1.696440594899049e-09,  -5.758658935493397e-11,   1.322219788181008e-12,   6.087235131727674e-15,  -2.961140251040972e-15,   2.156459685709939e-16,
  -1.097260166957249e-17,   4.391326661089567e-19,   1.115596580571937e-01,  -6.173461052523371e-03,   3.371608994182588e-04,  -1.788086453560547e-05,   8.992180713442640e-07,
  -4.161452479067458e-08,   1.703341737661883e-09,  -5.748934500896070e-11,   1.291688673113378e-12,   8.671969624787784e-15,  -3.114243123613273e-15,   2.226206463068002e-16,
  -1.120266212127322e-17,   4.422000382270360e-19,   1.116269627309261e-01,  -6.184095627412323e-03,   3.382281871212702e-04,  -1.796296124301921e-05,   9.042291183550864e-07,
  -4.184794694904560e-08,   1.709984637274504e-09,  -5.738887111198502e-11,   1.261603994668855e-12,   1.120574857735115e-14,  -3.263825278120188e-15,   2.294044643431380e-16,
  -1.142418049049857e-17,   4.449597167198303e-19,   1.116812347498489e-01,  -6.192674486129844e-03,   3.390894050192788e-04,  -1.802920689802390e-05,   9.082705279504085e-07,
  -4.203587499721778e-08,   1.715295178211914e-09,  -5.730355764599592e-11,   1.237047782786038e-12,   1.326454433853693e-14,  -3.385005867305288e-15,   2.348782168121020e-16,
  -1.160129049464720e-17,   4.470242725018290e-19,   1.117171223373057e-01,  -6.198349017495567e-03,   3.396591804766042e-04,  -1.807303449765763e-05,   9.109432502213177e-07,
  -4.215999739748622e-08,   1.718784132843283e-09,  -5.724503347261585e-11,   1.220664157228268e-12,   1.463359187479204e-14,  -3.465411000681039e-15,   2.384992941076950e-16,
  -1.171764894359332e-17,   4.483098824460429e-19,   1.117355602535671e-01,  -6.201264947672105e-03,   3.399520033864419e-04,  -1.809555865496503e-05,   9.123165088829274e-07,
  -4.222372223287927e-08,   1.720569615858224e-09,  -5.721431142233993e-11,   1.212201634100164e-12,   1.533933415805576e-14,  -3.506805001533777e-15,   2.403601240923544e-16,
  -1.177719323052500e-17,   4.489455893495564e-19,   1.117419790009256e-01,  -6.202280148426768e-03,   3.400539574686649e-04,  -1.810340103461032e-05,   9.127945934700342e-07,
  -4.224589936041011e-08,   1.721190070081901e-09,  -5.720351195147694e-11,   1.209248406289738e-12,   1.558539954608294e-14,  -3.521228793263790e-15,   2.410079957799782e-16,
  -1.179788422312469e-17,   4.491629319090846e-19,   1.117429976276388e-01,  -6.202441260315493e-03,   3.400701378099842e-04,  -1.810464563759485e-05,   9.128704640965342e-07,
  -4.224941842762696e-08,   1.721288480121458e-09,  -5.720179317036604e-11,   1.208779400711178e-12,   1.562446692813901e-14,  -3.523518420345652e-15,   2.411108131724608e-16,
  -1.180116598137935e-17,   4.491972346671062e-19,   9.109092400114568e-02,  -4.129336938841726e-03,   1.863180706402323e-04,  -8.323042277366686e-06,   3.643505664019120e-07,
  -1.538867133176450e-08,   6.143146642754415e-10,  -2.256964474846129e-11,   7.333245192890875e-13,  -1.939889264079660e-14,   3.056335184907192e-16,   6.426845123965980e-18,
  -8.713559181436108e-19,   5.038434692107926e-20,   9.110881290775137e-02,  -4.131730040711755e-03,   1.865280364682240e-04,  -8.337852268341617e-06,   3.652374976168249e-07,
  -1.543412178782605e-08,   6.162612826139113e-10,  -2.263375632855242e-11,   7.344042418351361e-13,  -1.934928531901951e-14,   2.992662812209185e-16,   6.842653688313017e-18,
  -8.921255597084784e-19,   5.123539301209763e-20,   9.114039477354510e-02,  -4.135956160120929e-03,   1.868989355318082e-04,  -8.364019684770386e-06,   3.668047355064970e-07,
  -1.551442174965273e-08,   6.196982958201052e-10,  -2.274673382015834e-11,   7.362867235183420e-13,  -1.925996042612720e-14,   2.879245364298892e-16,   7.581483490183933e-18,
  -9.289704638046874e-19,   5.274226941958198e-20,   9.117861224469884e-02,  -4.141072322953541e-03,   1.873481322316152e-04,  -8.395721257219016e-06,   3.687036667494643e-07,
  -1.561169492547841e-08,   6.238580425806182e-10,  -2.288309094847056e-11,   7.385240716718345e-13,  -1.914887748039376e-14,   2.740274458172228e-16,   8.483650499675574e-18,
  -9.738588079737808e-19,   5.457318994620495e-20,   9.121574281185811e-02,  -4.146045184608232e-03,   1.877849402069154e-04,  -8.426559130294534e-06,   3.705511086297958e-07,
  -1.570630761409781e-08,   6.279000560572526e-10,  -2.301519113421293e-11,   7.406549181557686e-13,  -1.903780589488611e-14,   2.603443817149411e-16,   9.368664628300795e-18,
  -1.017786482424408e-18,   5.635973767146383e-20,   9.124567601959849e-02,  -4.150055689775559e-03,   1.881373547153439e-04,  -8.451446573579739e-06,   3.720422456814206e-07,
  -1.578265630336811e-08,   6.311589436450620e-10,  -2.312141064805938e-11,   7.423417996151393e-13,  -1.894599739264274e-14,   2.491833005338411e-16,   1.008823494046247e-17,
  -1.053425371986376e-18,   5.780543388022497e-20,   9.126546579004396e-02,  -4.152707932434859e-03,   1.883704825681644e-04,  -8.467913733481382e-06,   3.730289643150057e-07,
  -1.583316971330312e-08,   6.333136650437473e-10,  -2.319150007371056e-11,   7.434418256288395e-13,  -1.888418539150241e-14,   2.417403532812880e-16,   1.056696015720076e-17,
  -1.077097944569792e-18,   5.876387106513423e-20,   9.127563201448602e-02,  -4.154070658177931e-03,   1.884902849115902e-04,  -8.476377209835698e-06,   3.735361251972646e-07,
  -1.585913040770077e-08,   6.344206189515003e-10,  -2.322746360492311e-11,   7.440021957006578e-13,  -1.885208622529148e-14,   2.378969915444835e-16,   1.081381387219779e-17,
  -1.089292984697561e-18,   5.925704239797728e-20,   9.127917097644371e-02,  -4.154545074411020e-03,   1.885319959610641e-04,  -8.479324083508532e-06,   3.737127162353670e-07,
  -1.586816939082250e-08,   6.348059680550285e-10,  -2.323997612306165e-11,   7.441965121500325e-13,  -1.884085707829892e-14,   2.365559180981203e-16,   1.089989376962345e-17,
  -1.093543635710533e-18,   5.942884883174553e-20,   9.127973258539233e-02,  -4.154620362816648e-03,   1.885386155353882e-04,  -8.479791763206784e-06,   3.737407420792406e-07,
  -1.586960390131872e-08,   6.348671206678748e-10,  -2.324196145339423e-11,   7.442273130173966e-13,  -1.883907247168869e-14,   2.363429487878713e-16,   1.091356107191142e-17,
  -1.094218442952149e-18,   5.945611943067560e-20,   7.703664128417091e-02,  -2.958280375153926e-03,   1.133690453298780e-04,  -4.329102801831292e-06,   1.641140154696098e-07,
  -6.133437730260251e-09,   2.235309748741263e-10,  -7.826752980563750e-12,   2.582592016628462e-13,  -7.819628699967233e-15,   2.076649388180716e-16,  -4.334321582216082e-18,
   3.977245892871104e-20,   2.299281669691734e-21,   7.704745863720767e-02,  -2.959518686959289e-03,   1.134631847934290e-04,  -4.334986485417372e-06,   1.644366160799026e-07,
  -6.149276475912468e-09,   2.242271062725752e-10,  -7.853699535327204e-12,   2.591399319528946e-13,  -7.841075158038611e-15,   2.078233417844127e-16,  -4.312004637253678e-18,
   3.792398772758538e-20,   2.397182494763196e-21,   7.706655342227432e-02,  -2.961705076405579e-03,   1.136294448476385e-04,  -4.345380542927800e-06,   1.650066529864932e-07,
  -6.177267594820309e-09,   2.254573232729168e-10,  -7.901305318548634e-12,   2.606944592395015e-13,  -7.878818490193858e-15,   2.080932159179367e-16,  -4.272026991713124e-18,
   3.463247303949620e-20,   2.571187054223954e-21,   7.708965565842782e-02,  -2.964351217726989e-03,   1.138307434286017e-04,  -4.357969982115897e-06,   1.656973184550178e-07,
  -6.211188823834492e-09,   2.269481247141232e-10,  -7.958969720150090e-12,   2.625749797242702e-13,  -7.924287102258610e-15,   2.084030258434995e-16,  -4.222659003412118e-18,
   3.060121305010340e-20,   2.783745607787330e-21,   7.711209613328854e-02,  -2.966922494479312e-03,   1.140264281189796e-04,  -4.370213437819296e-06,   1.663692418562519e-07,
  -6.244196610575847e-09,   2.283987310677991e-10,  -8.015052724850472e-12,   2.644013326281797e-13,  -7.968245906439289e-15,   2.086863460586506e-16,  -4.173651762490664e-18,
   2.663392351724391e-20,   2.992354642446626e-21,   7.713018337024841e-02,  -2.968995637737383e-03,   1.141842610618979e-04,  -4.380092279689677e-06,   1.669115657729851e-07,
  -6.270842943213348e-09,   2.295697301394120e-10,  -8.060306374156852e-12,   2.658731539063441e-13,  -8.003527035449546e-15,   2.089019966214395e-16,  -4.133392489982280e-18,
   2.339917683727997e-20,   3.162033620063686e-21,   7.714213973994861e-02,  -2.970366394436052e-03,   1.142886483114557e-04,  -4.386627724715876e-06,   1.672704291768718e-07,
  -6.288477654731569e-09,   2.303446854000130e-10,  -8.090245295794456e-12,   2.668459606863897e-13,  -8.026775143208401e-15,   2.090382928009817e-16,  -4.106406237167796e-18,
   2.124266264244257e-20,   3.274953281222037e-21,   7.714828134524948e-02,  -2.971070609878403e-03,   1.143422852652385e-04,  -4.389986366039464e-06,   1.674548791261032e-07,
  -6.297542367307958e-09,   2.307430269540004e-10,  -8.105631518458241e-12,   2.673456200904042e-13,  -8.038693909380859e-15,   2.091063612634500e-16,  -4.092428455932144e-18,
   2.012928095454476e-20,   3.333190516300463e-21,   7.715041921610499e-02,  -2.971315760919223e-03,   1.143609587337310e-04,  -4.391155750583241e-06,   1.675191035325784e-07,
  -6.300698768327989e-09,   2.308817314835485e-10,  -8.110988608492594e-12,   2.675195431500955e-13,  -8.042839109101990e-15,   2.091297457423245e-16,  -4.087544372366070e-18,
   1.974081613928166e-20,   3.353499983808054e-21,   7.715075847763368e-02,  -2.971354665026601e-03,   1.143639221761050e-04,  -4.391341333785364e-06,   1.675292962442563e-07,
  -6.301199709549771e-09,   2.309037447405669e-10,  -8.111838789107440e-12,   2.675471429120966e-13,  -8.043496741338160e-15,   2.091334419303485e-16,  -4.086768433379704e-18,
   1.967912736739538e-20,   3.356724691084505e-21,   6.674114499411440e-02,  -2.222226732095734e-03,   7.390147527955833e-05,  -2.453690166741754e-06,   8.124539200850625e-08,
  -2.675878708977853e-09,   8.723901688438111e-11,  -2.793627720692374e-12,   8.691903381641655e-14,  -2.590338532077237e-15,   7.255743677337545e-17,  -1.857132697241230e-18,
   4.117885468505396e-20,  -6.810018721773388e-22,   6.674816642751047e-02,  -2.222925845561739e-03,   7.394788546245508e-05,  -2.456246391956269e-06,   8.137085712114889e-08,
  -2.681522340911581e-09,   8.747369439141484e-11,  -2.802625064113345e-12,   8.723330611872126e-14,  -2.600092623593852e-15,   7.281168163106285e-17,  -1.861769529562439e-18,
   4.117096938998649e-20,  -6.749871984362685e-22,   6.676055948013040e-02,  -2.224160035123294e-03,   7.402983499878099e-05,  -2.460761237660121e-06,   8.159251316765843e-08,
  -2.691495145522184e-09,   8.788846220491838e-11,  -2.818527912300667e-12,   8.778871596574115e-14,  -2.617322948537060e-15,   7.326023113962282e-17,  -1.869913672584517e-18,
   4.115437178891031e-20,  -6.642368664395329e-22,   6.677555147232668e-02,  -2.225653441884473e-03,   7.412902830006290e-05,  -2.466228055436456e-06,   8.186100443528612e-08,
  -2.703579167223898e-09,   8.839115720695142e-11,  -2.837803698459009e-12,   8.846180913353859e-14,  -2.638190458468858e-15,   7.380249400779868e-17,  -1.879696942938121e-18,
   4.112969727331460e-20,  -6.510020514157965e-22,   6.679011191507944e-02,  -2.227104275495532e-03,   7.422542727002466e-05,  -2.471542925451993e-06,   8.212213601945053e-08,
  -2.715336134225881e-09,   8.888037419404427e-11,  -2.856564400942261e-12,   8.911679180762285e-14,  -2.658482079986872e-15,   7.432876731265746e-17,  -1.889125876117172e-18,
   4.110088564389822e-20,  -6.379058621054017e-22,   6.680184626145527e-02,  -2.228273808424696e-03,   7.430315949797704e-05,  -2.475830095391693e-06,   8.233284814346179e-08,
  -2.724826055185802e-09,   8.927534869920149e-11,  -2.871712276163884e-12,   8.964555162213845e-14,  -2.674852865672629e-15,   7.475261300896914e-17,  -1.896672109220880e-18,
   4.107416896604714e-20,  -6.271769099941494e-22,   6.680960238300730e-02,  -2.229046987435969e-03,   7.435456006391725e-05,  -2.478665715707135e-06,   8.247225350400193e-08,
  -2.731105973705328e-09,   8.953676610881122e-11,  -2.881738625797696e-12,   8.999549218779017e-14,  -2.685682157517457e-15,   7.503262378326215e-17,  -1.901634034755002e-18,
   4.105478784815986e-20,  -6.199994039033417e-22,   6.681358622619789e-02,  -2.229444167102172e-03,   7.438096800687633e-05,  -2.480122788772880e-06,   8.254389761020026e-08,
  -2.734333843687771e-09,   8.967114808125030e-11,  -2.886892866365238e-12,   9.017537209412128e-14,  -2.691247147684153e-15,   7.517640375300426e-17,  -1.904174602250015e-18,
   4.104429834093898e-20,  -6.162860995509649e-22,   6.681497295134819e-02,  -2.229582427474794e-03,   7.439016133170250e-05,  -2.480630071190568e-06,   8.256884240430804e-08,
  -2.735457784352610e-09,   8.971794192091465e-11,  -2.888687679905770e-12,   9.023800779545777e-14,  -2.693184670690329e-15,   7.522644460337185e-17,  -1.905057653144551e-18,
   4.104056178226541e-20,  -6.149892934647882e-22,   6.681519301085083e-02,  -2.229604368363127e-03,   7.439162027112979e-05,  -2.480710576324012e-06,   8.257280119876254e-08,
  -2.735636159669510e-09,   8.972536845419809e-11,  -2.888972531641892e-12,   9.024794849337422e-14,  -2.693492156293787e-15,   7.523438524936547e-17,  -1.905197723309676e-18,
   4.103996477464106e-20,  -6.147833012101728e-22,   5.887481046451765e-02,  -1.730133938769615e-03,   5.079804908547619e-05,  -1.490019914974898e-06,   4.364979992040761e-08,
  -1.276026942891092e-09,   3.715609376017307e-11,  -1.073996928922662e-12,   3.064538343236228e-14,  -8.563238646866671e-16,   2.318387919227988e-17,  -5.997348706236348e-19,
   1.454106226010905e-20,  -3.202795465484651e-22,   5.887962267273236e-02,  -1.730557287957246e-03,   5.082290305297427e-05,  -1.491234412163030e-06,   4.370302990058758e-08,
  -1.278188855387581e-09,   3.723862837972212e-11,  -1.076970415481348e-12,   3.074617021021439e-14,  -8.595090199978885e-16,   2.327619598361155e-17,  -6.021137117871609e-19,
   1.459175226184451e-20,  -3.209602266423923e-22,   5.888811582047541e-02,  -1.731304575162165e-03,   5.086678284513742e-05,  -1.493379074087477e-06,   4.379705022671332e-08,
  -1.282008384692381e-09,   3.738447892294752e-11,  -1.082225987437911e-12,   3.092432875974128e-14,  -8.651392860129555e-16,   2.343934464827438e-17,  -6.063151338582529e-19,
   1.468112826456351e-20,  -3.221519364809443e-22,   5.889838911870642e-02,  -1.732208682063075e-03,   5.091988469211621e-05,  -1.495975259481550e-06,   4.391090308537499e-08,
  -1.286635195634381e-09,   3.756121327333240e-11,  -1.088596118677627e-12,   3.114030397803110e-14,  -8.719645416765420e-16,   2.363705899993788e-17,  -6.114021821806977e-19,
   1.478908536592824e-20,  -3.235768756736043e-22,   5.890836570913469e-02,  -1.733086875573654e-03,   5.097147899679836e-05,  -1.498498565724300e-06,   4.402159983135227e-08,
  -1.291135418050376e-09,   3.773317230952868e-11,  -1.094795902992132e-12,   3.135053940981941e-14,  -8.786082795145199e-16,   2.382945003777012e-17,  -6.163475078685237e-19,
   1.489376211785262e-20,  -3.249431696821172e-22,   5.891640519399356e-02,  -1.733794696895148e-03,   5.101307421549909e-05,  -1.500533441847899e-06,   4.411089790811769e-08,
  -1.294766905353203e-09,   3.787197897338217e-11,  -1.099801685586221e-12,   3.152031158551794e-14,  -8.839732218662882e-16,   2.398476236252789e-17,  -6.203363113485441e-19,
   1.497799564912400e-20,  -3.260315330183114e-22,   5.892171875387153e-02,  -1.734262589001418e-03,   5.104057503796652e-05,  -1.501879097245033e-06,   4.416996438986211e-08,
  -1.297169550363988e-09,   3.796383657370913e-11,  -1.103114965500997e-12,   3.163269460871218e-14,  -8.875245678019949e-16,   2.408754882177546e-17,  -6.229744329164485e-19,
   1.503360933551169e-20,  -3.267446320442562e-22,   5.892444789588431e-02,  -1.734502928555482e-03,   5.105470280438428e-05,  -1.502570479207136e-06,   4.420031639344240e-08,
  -1.298404359151979e-09,   3.801105213701199e-11,  -1.104818210489554e-12,   3.169047075002795e-14,  -8.893502992049283e-16,   2.414038368973387e-17,  -6.243299710034436e-19,
   1.506215509471057e-20,  -3.271089546089001e-22,   5.892539785842778e-02,  -1.734586589627632e-03,   5.105962086377091e-05,  -1.502811172554185e-06,   4.421088363885789e-08,
  -1.298834294676682e-09,   3.802749268211718e-11,  -1.105411314019245e-12,   3.171059015268065e-14,  -8.899860715144938e-16,   2.415878116481218e-17,  -6.248018954129874e-19,
   1.507208837646477e-20,  -3.272354589595935e-22,   5.892554860723338e-02,  -1.734599865900134e-03,   5.106040132818987e-05,  -1.502849369719827e-06,   4.421256065536496e-08,
  -1.298902526599012e-09,   3.803010189004354e-11,  -1.105505444368265e-12,   3.171378329427072e-14,  -8.900869745315685e-16,   2.416170096172024e-17,  -6.248767888644328e-19,
   1.507366454044430e-20,  -3.272555191286222e-22,   5.266834933153148e-02,  -1.385066294843129e-03,   3.639913684432660e-05,  -9.558774367426822e-07,   2.508248849043221e-08,
  -6.574978965544780e-10,   1.720729658870022e-11,  -4.490132895861880e-13,   1.165394900432375e-14,  -2.996465574747456e-16,   7.587432487015116e-18,  -1.876864961782746e-19,
   4.488099789603470e-21,  -1.022723568304473e-22,   5.267179034893173e-02,  -1.385337334430739e-03,   3.641338460157872e-05,  -9.565014279845475e-07,   2.510705712535556e-08,
  -6.583984504643698e-10,   1.723857118519272e-11,  -4.500507277610115e-13,   1.168688426371833e-14,  -3.006444497598504e-16,   7.616088876613477e-18,  -1.884574028545841e-19,
   4.507153352383266e-21,  -1.026891825758180e-22,   5.267786318097836e-02,  -1.385815732060705e-03,   3.643853631717653e-05,  -9.576031618846377e-07,   2.515044489465143e-08,
  -6.599891654885304e-10,   1.729382655579378e-11,  -4.518840641181752e-13,   1.174509811703945e-14,  -3.024085017483762e-16,   7.666749936304383e-18,  -1.898201647893419e-19,
   4.540824404449613e-21,  -1.034251948212980e-22,   5.268520839519614e-02,  -1.386394461251535e-03,   3.646896935980518e-05,  -9.589365702976126e-07,   2.520297133285685e-08,
  -6.619155315643690e-10,   1.736076289632109e-11,  -4.541056668486967e-13,   1.181566008032130e-14,  -3.045471700539069e-16,   7.728174391309568e-18,  -1.914722702079699e-19,
   4.581626219098511e-21,  -1.043160603195126e-22,   5.269234097236706e-02,  -1.386956538930671e-03,   3.649853347642884e-05,  -9.602322569229106e-07,   2.525402754664217e-08,
  -6.637886095655517e-10,   1.742587038702137e-11,  -4.562673033939121e-13,   1.188433783522418e-14,  -3.066291814135415e-16,   7.787976737118817e-18,  -1.930805472970808e-19,
   4.621326284199224e-21,  -1.051817979197554e-22,   5.269808829608084e-02,  -1.387409525923626e-03,   3.652236446051811e-05,  -9.612769321892718e-07,   2.529520400196499e-08,
  -6.652996856126239e-10,   1.747841115372382e-11,  -4.580122369188767e-13,   1.193979106883079e-14,  -3.083106057175170e-16,   7.836276515845711e-18,  -1.943793386998733e-19,
   4.653372799285327e-21,  -1.058798618028226e-22,   5.270188671692760e-02,  -1.387708942046864e-03,   3.653811866194141e-05,  -9.619676696003556e-07,   2.532243532759622e-08,
  -6.662992309490802e-10,   1.751317377470848e-11,  -4.591669969674619e-13,   1.197649600336666e-14,  -3.094237116642695e-16,   7.868252821545359e-18,  -1.952391167567447e-19,
   4.674580187300894e-21,  -1.063414383946645e-22,   5.270383760174861e-02,  -1.387862734514521e-03,   3.654621139841787e-05,  -9.623225307856221e-07,   2.533642692765679e-08,
  -6.668128712553709e-10,   1.753103985386219e-11,  -4.597605598037364e-13,   1.199536506687131e-14,  -3.099959795861951e-16,   7.884692961457908e-18,  -1.956811364735480e-19,
   4.685480967147041e-21,  -1.065785747025068e-22,   5.270451665914449e-02,  -1.387916267843598e-03,   3.654902849981865e-05,  -9.624460648854236e-07,   2.534129794879643e-08,
  -6.669917003804303e-10,   1.753726050589443e-11,  -4.599672405249044e-13,   1.200193569509743e-14,  -3.101952637807534e-16,   7.890418093216530e-18,  -1.958350623193050e-19,
   4.689276638301783e-21,  -1.066611271674419e-22,   5.270462441781849e-02,  -1.387924763057031e-03,   3.654947555164747e-05,  -9.624656690624636e-07,   2.534207096578327e-08,
  -6.670200805645920e-10,   1.753824774214086e-11,  -4.600000419801326e-13,   1.200297850945330e-14,  -3.102268922385603e-16,   7.891326734772143e-18,  -1.958594918790257e-19,
   4.689879032841087e-21,  -1.066742278175265e-22,   4.764648460832983e-02,  -1.133818283850486e-03,   2.696579515001380e-05,  -6.409702679636527e-07,   1.522681936362143e-08,
  -3.614931696042179e-10,   8.574982990529730e-12,  -2.031508033163690e-13,   4.802305389943122e-15,  -1.130137347303337e-16,   4.765034839777091e-02,  -1.134093765093916e-03,
   2.697890162020075e-05,  -6.414899139835136e-07,   1.524535573415436e-08,  -3.621097676607726e-10,   8.594479980896434e-12,  -2.037430430506413e-13,   4.819675418141768e-15,
  -1.135057976074741e-16,   4.765669279872791e-02,  -1.134546173729874e-03,   2.700042952664877e-05,  -6.423436352412743e-07,   1.527581646200172e-08,  -3.631233011225820e-10,
   8.626537833960092e-12,  -2.047171377092101e-13,   4.848253933312193e-15,  -1.143156097889388e-16,   4.766342655470628e-02,  -1.135026433985996e-03,   2.702328795887758e-05,
  -6.432503676073767e-07,   1.530817883894504e-08,  -3.642004911109501e-10,   8.660622275541809e-12,  -2.057532285840217e-13,   4.878663455147322e-15,  -1.151776218756097e-16,
   4.766872740053096e-02,  -1.135404560506988e-03,   2.704128901135637e-05,  -6.439645998723618e-07,   1.533367805657862e-08,  -3.650495159889986e-10,   8.687496644024444e-12,
  -2.065704516961793e-13,   4.902657940316812e-15,  -1.158580169517991e-16,   4.767178716142167e-02,  -1.135622848550339e-03,   2.705168232155204e-05,  -6.443770496550263e-07,
   1.534840613299141e-08,  -3.655400147759011e-10,   8.703026329318354e-12,  -2.070428154039175e-13,   4.916530532215203e-15,  -1.162514841032268e-16,   4.767293623398031e-02,
  -1.135704829949949e-03,   2.705558597335186e-05,  -6.445319763741908e-07,   1.535393893768056e-08,  -3.657242983973471e-10,   8.708861656638642e-12,  -2.072203304511800e-13,
   4.921744540543769e-15,  -1.163993858932966e-16,   4.767312671458161e-02,  -1.135718420177159e-03,   2.705623310491522e-05,  -6.445576602137086e-07,   1.535485619880302e-08,
  -3.657548511351945e-10,   8.709829144947421e-12,  -2.072497633826821e-13,   4.922609085758135e-15,  -1.164239106998774e-16,   4.349915426299179e-02,  -9.452021038084603e-04,
   2.052893715978849e-05,  -4.456617744352372e-07,   9.670283602880103e-09,  -2.097301536436051e-10,   4.546204169230500e-12,  -9.847937841871023e-14,   2.131136428323381e-15,
  -4.602081193713864e-17,   4.350209239885248e-02,  -9.453934304907447e-04,   2.053724969079941e-05,  -4.459627566915036e-07,   9.680090649174559e-09,  -2.100283051710430e-10,
   4.554831049798824e-12,  -9.871974050534020e-14,   2.137629423242320e-15,  -4.619134353837031e-17,   4.350691668850629e-02,  -9.457076176821454e-04,   2.055090214134498e-05,
  -4.464571760735884e-07,   9.696203885720972e-09,  -2.105182913634411e-10,   4.569012287797717e-12,  -9.911496991542599e-14,   2.148309079591455e-15,  -4.647191705154189e-17,
   4.351203680748696e-02,  -9.460411216741199e-04,   2.056539672202342e-05,  -4.469822125529896e-07,   9.713319479679443e-09,  -2.110389150703969e-10,   4.584085284258181e-12,
  -9.953520470980177e-14,   2.159668729486103e-15,  -4.677046907194250e-17,   4.351606721889888e-02,  -9.463036831335210e-04,   2.057681002847982e-05,  -4.473957228423321e-07,
   9.726802735371383e-09,  -2.114491636740316e-10,   4.595966377298914e-12,  -9.986655959292100e-14,   2.168628931777256e-15,  -4.700604179563422e-17,   4.351839358929945e-02,
  -9.464552494040519e-04,   2.058339927521757e-05,  -4.476344895799749e-07,   9.734589478585527e-09,  -2.116861328041211e-10,   4.602830638844753e-12,  -1.000580429939266e-13,
   2.173808107912157e-15,  -4.714224062141797e-17,   4.351926722901227e-02,  -9.465121710253381e-04,   2.058587405748903e-05,  -4.477241719069397e-07,   9.737514478964423e-09,
  -2.117751561492303e-10,   4.605409646522193e-12,  -1.001299945883652e-13,   2.175754466435403e-15,  -4.719343102745761e-17,   4.351941205070239e-02,  -9.465216069670717e-04,
   2.058628431205957e-05,  -4.477390392521570e-07,   9.737999392457579e-09,  -2.117899151051794e-10,   4.605837228326614e-12,  -1.001419241109760e-13,   2.176077183778413e-15,
  -4.720191901855580e-17,   4.001627507791339e-02,  -8.000164811973675e-04,   1.598785847894820e-05,  -3.193819353362605e-07,   6.377614977617879e-09,  -1.273010887728038e-10,
   2.539954503747668e-12,  -5.065508443570457e-14,   1.009671159400953e-15,  -2.010130452495602e-17,   4.001856128129717e-02,  -8.001534772323468e-04,   1.599333498600974e-05,
  -3.195643879406442e-07,   6.383085304212002e-09,  -1.274541456317505e-10,   2.544031957542863e-12,  -5.075977442246533e-14,   1.012281714340249e-15,  -2.016479103911924e-17,
   4.002231502256989e-02,  -8.003784350065397e-04,   1.600232895042441e-05,  -3.198640715597391e-07,   6.392072050904903e-09,  -1.277056404942421e-10,   2.550733316975060e-12,
  -5.093187658274249e-14,   1.016574406183957e-15,  -2.026921493103504e-17,   4.002629880491999e-02,  -8.006172095591879e-04,   1.601187685367957e-05,  -3.201822740992241e-07,
   6.401616279994558e-09,  -1.279728051274306e-10,   2.557854262019905e-12,  -5.111481225276245e-14,   1.021138870663722e-15,  -2.038028970337397e-17,   4.002943462220739e-02,
  -8.008051821351891e-04,   1.601939444455845e-05,  -3.204328569797476e-07,   6.409133867471297e-09,  -1.281832891508508e-10,   2.563465938461905e-12,  -5.125901702945561e-14,
   1.024738080242100e-15,  -2.046790411145351e-17,   4.003124458806737e-02,  -8.009136871382654e-04,   1.602373433299467e-05,  -3.205775357499863e-07,   6.413474912782952e-09,
  -1.283048534815386e-10,   2.566707538018909e-12,  -5.134233410793257e-14,   1.026818044832511e-15,  -2.051854757572203e-17,   4.003192429066300e-02,  -8.009544360718218e-04,
   1.602536425754925e-05,  -3.206318758821233e-07,   6.415105490920816e-09,  -1.283505190944448e-10,   2.567925356629319e-12,  -5.137363821896063e-14,   1.027599620060271e-15,
  -2.053757973584955e-17,   4.003203696333518e-02,  -8.009611910137876e-04,   1.602563445423844e-05,  -3.206408841602419e-07,   6.415375807515951e-09,  -1.283580897203601e-10,
   2.568127257349484e-12,  -5.137882825853941e-14,   1.027729205198125e-15,  -2.054073538235221e-17,   3.704996022781203e-02,  -6.858833683126886e-04,   1.269306008889621e-05,
  -2.348203226037063e-07,   4.342680653300719e-09,  -8.028459521856663e-11,   1.483736898140863e-12,  -2.741114288197873e-14,   5.062091896060723e-16,  -9.340834587645121e-18,
   3.705177403685560e-02,  -6.859840245308232e-04,   1.269678615555267e-05,  -2.349352723813117e-07,   4.345872124212791e-09,  -8.036728916531142e-11,   1.485777277458263e-12,
  -2.745967844915612e-14,   5.073312092451890e-16,  -9.366164474048065e-18,   3.705475208421113e-02,  -6.861493036430056e-04,   1.270290507453429e-05,  -2.351240664323664e-07,
   4.351114600883912e-09,  -8.050314994952288e-11,   1.489130136873273e-12,  -2.753945175841058e-14,   5.091757980167349e-16,  -9.407817003200596e-18,   3.705791254771352e-02,
  -6.863247260081167e-04,   1.270940040924290e-05,  -2.353245076218998e-07,   4.356681572214557e-09,  -8.064745194984614e-11,   1.492692196360741e-12,  -2.762422573749965e-14,
   5.111366036932339e-16,  -9.452108043549203e-18,   3.706040022937088e-02,  -6.864628194242924e-04,   1.271451421937747e-05,  -2.354823400054554e-07,   4.361065922252018e-09,
  -8.076112215756560e-11,   1.495498756845633e-12,  -2.769103633262565e-14,   5.126823451534768e-16,  -9.487033845386057e-18,   3.706183607156295e-02,  -6.865425299059489e-04,
   1.271746628017427e-05,  -2.355734618929886e-07,   4.363597465495021e-09,  -8.082676508462679e-11,   1.497119761959104e-12,  -2.772963136062925e-14,   5.135754569827510e-16,
  -9.507217710721981e-18,   3.706237527340451e-02,  -6.865724646444359e-04,   1.271857495600355e-05,  -2.356076854455433e-07,   4.364548321335276e-09,  -8.085142252798268e-11,
   1.497728708349573e-12,  -2.774413123703374e-14,   5.139110249722831e-16,  -9.514802155320032e-18,   3.706246465534826e-02,  -6.865774268961567e-04,   1.271875874268134e-05,
  -2.356133588257438e-07,   4.364705951762729e-09,  -8.085551026750163e-11,   1.497829662744738e-12,  -2.774653517162859e-14,   5.139666604928816e-16,  -9.516059660131267e-18,
   3.449319046978019e-02,  -5.945396906582295e-04,   1.024475145375306e-05,  -1.764797582540214e-07,   3.039212040621115e-09,  -5.232380631031425e-11,   9.005528319938647e-13,
  -1.549491133679594e-14,   2.665232888920519e-16,  -4.581517898307896e-18,   3.449465361393243e-02,  -5.946152982919402e-04,   1.024735743721462e-05,  -1.765546133956287e-07,
   3.041147126795081e-09,  -5.237049244278940e-11,   9.016254601872417e-13,  -1.551867243151783e-14,   2.670349383368384e-16,  -4.592282590084165e-18,   3.449705587174136e-02,
  -5.947394436539176e-04,   1.025163677925251e-05,  -1.766775484081080e-07,   3.044325544625734e-09,  -5.244718680088527e-11,   9.033878325199346e-13,  -1.555772016973900e-14,
   2.678759282851323e-16,  -4.609980264103722e-18,   3.449960521982116e-02,  -5.948712030105302e-04,   1.025617912125532e-05,  -1.768080574723692e-07,   3.047700349909155e-09,
  -5.252863550512010e-11,   9.052598582766898e-13,  -1.559920732984745e-14,   2.687696912838997e-16,  -4.628793824474852e-18,   3.450161183584374e-02,  -5.949749211536793e-04,
   1.025975514843336e-05,  -1.769108162493503e-07,   3.050357975477683e-09,  -5.259278682840848e-11,   9.067346107878380e-13,  -1.563189743792096e-14,   2.694741078921115e-16,
  -4.643625543072601e-18,   3.450276999970755e-02,  -5.950347880786516e-04,   1.026181941685648e-05,  -1.769701393799114e-07,   3.051892399309608e-09,  -5.262983017306860e-11,
   9.075863043270145e-13,  -1.565077938373054e-14,   2.698810499400758e-16,  -4.652195390189329e-18,   3.450320492189044e-02,  -5.950572704352046e-04,   1.026259465963579e-05,
  -1.769924194033011e-07,   3.052468714774490e-09,  -5.264374416736616e-11,   9.079062343471951e-13,  -1.565787273867500e-14,   2.700339381645763e-16,  -4.655415377058183e-18,
   3.450327701752992e-02,  -5.950609972989304e-04,   1.026272317194293e-05,  -1.769961128259199e-07,   3.052564253857602e-09,  -5.264605081422472e-11,   9.079592731647597e-13,
  -1.565904872190987e-14,   2.700592856626339e-16,  -4.655949237508506e-18,   3.226660626360814e-02,  -5.202986125690918e-04,   8.387663750410689e-06,  -1.351817858544199e-07,
   2.178130864664318e-09,  -3.508634350674120e-11,   5.650413483894610e-13,  -9.097241243474303e-15,   1.464283823816887e-16,  -2.355654384619646e-18,   3.226780364370616e-02,
  -5.203565019162227e-04,   8.389530411509382e-06,  -1.352319476639394e-07,   2.179344006556546e-09,  -3.511372539435045e-11,   5.656299164615966e-13,  -9.109439601195017e-15,
   1.466741520009541e-16,  -2.360493574346975e-18,   3.226976953009050e-02,  -5.204515521842796e-04,   8.392595588816671e-06,  -1.353143246409221e-07,   2.181336486178845e-09,
  -3.515870362939919e-11,   5.665968565568234e-13,  -9.129483175627047e-15,   1.470780577133201e-16,  -2.368448008793175e-18,   3.227185575006826e-02,  -5.205524289848063e-04,
   8.395848999856336e-06,  -1.354017713877237e-07,   2.183451899619271e-09,  -3.520646496223711e-11,   5.676238208549426e-13,  -9.150775436199860e-15,   1.475072248240834e-16,
  -2.376902049940601e-18,   3.227349780630814e-02,  -5.206318348522019e-04,   8.398410190932529e-06,  -1.354706202569773e-07,   2.185117638348276e-09,  -3.524407942729948e-11,
   5.684327472002305e-13,  -9.167550296919520e-15,   1.478454106304741e-16,  -2.383565407929195e-18,   3.227444554530857e-02,  -5.206776676633941e-04,   8.399888600891442e-06,
  -1.355103654412711e-07,   2.186079328554988e-09,  -3.526579791637041e-11,   5.688998752048198e-13,  -9.177238513406452e-15,   1.480407564020607e-16,  -2.387414967924632e-18,
   3.227480144513803e-02,  -5.206948794989892e-04,   8.400443814584624e-06,  -1.355252922621766e-07,   2.186440520817835e-09,  -3.527395540000338e-11,   5.690753395097377e-13,
  -9.180877880738587e-15,   1.481141432341149e-16,  -2.388861273603417e-18,   3.227486044138929e-02,  -5.206977326682640e-04,   8.400535852158726e-06,  -1.355277667076704e-07,
   2.186500397194626e-09,  -3.527530772388729e-11,   5.691044280313086e-13,  -9.181481228974415e-15,   1.481263098696910e-16,  -2.389101059451435e-18,   3.031011225499123e-02,
  -4.591425153852117e-04,   6.953596924381039e-06,  -1.052866831753350e-07,   1.593819548781987e-09,  -2.412161740999399e-11,   3.649849976022059e-13,  -5.521341002574338e-15,
   8.350539488569507e-17,  -1.262364261298565e-18,   3.031110454860191e-02,  -4.591875863880054e-04,   6.954962236598556e-06,  -1.053211502989971e-07,   1.594602636206100e-09,
  -2.413822214020058e-11,   3.653203019452336e-13,  -5.527869668787468e-15,   8.362897372295431e-17,  -1.264650519460308e-18,   3.031273370035515e-02,  -4.592615884042866e-04,
   6.957204102186214e-06,  -1.053777507852725e-07,   1.595888719688340e-09,  -2.416549563515432e-11,   3.658711153255483e-13,  -5.538596028945317e-15,   8.383204144110364e-17,
  -1.268408003195871e-18,   3.031446254821418e-02,  -4.593401247689253e-04,   6.959583553671060e-06,  -1.054378315578602e-07,   1.597254058984712e-09,  -2.419445415303369e-11,
   3.664560564447350e-13,  -5.549989084241968e-15,   8.404777459509628e-17,  -1.272400726268059e-18,   3.031582329955398e-02,  -4.594019438056552e-04,   6.961456671644404e-06,
  -1.054851323048918e-07,   1.598329099099925e-09,  -2.421725859115497e-11,   3.669167599741098e-13,  -5.558963853852136e-15,   8.421774803817429e-17,  -1.275547182515087e-18,
   3.031660867148244e-02,  -4.594376249923117e-04,   6.962537875966754e-06,  -1.055124372526806e-07,   1.598949730651101e-09,  -2.423042506574159e-11,   3.671827820861285e-13,
  -5.564146728333240e-15,   8.431591938376653e-17,  -1.277364733855386e-18,   3.031690359698409e-02,  -4.594510244288633e-04,   6.962943915106708e-06,  -1.055226918103816e-07,
   1.599182822703741e-09,  -2.423537026426906e-11,   3.672827027126737e-13,  -5.566093584475283e-15,   8.435279813784794e-17,  -1.278047558266201e-18,   3.031695248566317e-02,
  -4.594532456192711e-04,   6.963011223814137e-06,  -1.055243917175436e-07,   1.599221463091497e-09,  -2.423619005744661e-11,   3.672992673943901e-13,  -5.566416337265758e-15,
   8.435891208103176e-17,  -1.278160762850769e-18  };
  static constexpr double xi[2100] = {  -9.777465200114542e-02,   3.043239336827726e-03,   1.630967248375747e-03,  -7.733682634048168e-05,  -2.049398174224747e-05,
   1.332640292545828e-06,   2.195674355522178e-07,  -1.897189421130328e-08,  -2.105343519394364e-09,   2.409490867716361e-10,   1.830748801857376e-11,  -2.834839558826466e-12,
  -1.421741661215445e-13,   3.187315215607613e-14,  -9.297545837519232e-02,   2.889019436271878e-03,   1.548205237705598e-03,  -7.321195857482153e-05,  -1.940541632401683e-05,
   1.257047116806106e-06,   2.072618889466220e-07,  -1.781843777621059e-08,  -1.980479000295836e-09,   2.251717846013998e-10,   1.716308728562713e-11,  -2.634501433545403e-12,
  -1.329647551731546e-13,   2.944052947716321e-14,  -8.386460253131266e-02,   2.598232071570629e-03,   1.392197987998776e-03,  -6.551762978946188e-05,  -1.737306715577272e-05,
   1.117822001575250e-06,   1.845404965203822e-07,  -1.572369015470725e-08,  -1.752545308738190e-09,   1.969392440390750e-10,   1.509545253766658e-11,  -2.281334019676523e-12,
  -1.164309642081636e-13,   2.521584570544080e-14,  -7.135889645996975e-02,   2.202916462473460e-03,   1.180196283718646e-03,  -5.521730758854526e-05,  -1.464896024561453e-05,
   9.348569308351883e-07,   1.545713401607755e-07,  -1.302743115165314e-08,  -1.456938575165786e-09,   1.613971177301781e-10,   1.245528526087602e-11,  -1.846767726540915e-12,
  -9.553092333482815e-14,   2.013630371348886e-14,  -5.670082297118826e-02,   1.744364419444487e-03,   9.343900166114960e-04,  -4.346960529236242e-05,  -1.153779989912061e-05,
   7.304573373763148e-07,   1.209545934675227e-07,  -1.008608609704156e-08,  -1.131695827893003e-09,   1.236192954684643e-10,   9.602988243899196e-12,  -1.397335230188284e-12,
  -7.323457080390581e-14,   1.502954314343096e-14,  -4.132860024150332e-02,   1.267914524633762e-03,   6.790912540626833e-04,  -3.144851138357255e-05,  -8.350302595889351e-06,
   5.252575290172842e-07,   8.707975169055262e-08,  -7.198837311989228e-09,  -8.098733524412808e-10,   8.745973757146981e-11,   6.830273629391300e-12,  -9.787276361866788e-13,
  -5.183964152198746e-14,   1.040876108411422e-14,  -2.673683242567892e-02,   8.187500488811811e-04,   4.384847376660673e-04,  -2.024482007073127e-05,  -5.376807643837201e-06,
   3.367740586323985e-07,   5.587594118376195e-08,  -4.592782194463457e-09,  -5.175938602799467e-10,   5.547178738094936e-11,   4.347411596998854e-12,  -6.165930490150513e-13,
  -3.288763456969891e-14,   6.507608218357198e-15,  -1.433854464410968e-02,   4.386689746692320e-04,   2.349211083101401e-04,  -1.082947207233704e-05,  -2.876559913830046e-06,
   1.797765375482083e-07,   2.983969302806317e-08,  -2.445459244517952e-09,  -2.758438401091338e-10,   2.944685908784068e-11,   2.311976709045833e-12,  -3.261726667978393e-13,
  -1.745988393313715e-14,   3.428824157766975e-15,  -5.335272314659857e-03,   1.631721098201450e-04,   8.738256167358236e-05,  -4.026014475380339e-06,  -1.069450743108803e-06,
   6.678638059873174e-08,   1.108690107725853e-08,  -9.076708191973851e-10,  -1.024157731414422e-10,   1.091809573204473e-11,   8.577585330252847e-13,  -1.207882819834646e-13,
  -6.473837508967219e-15,   1.267997080725565e-15,  -6.026517009836771e-04,   1.843033003645705e-05,   9.869859237946547e-06,  -4.546992902985974e-07,  -1.207849419859384e-07,
   7.542010763256499e-09,   1.252042523131986e-09,  -1.024863856052133e-10,  -1.156448166934787e-11,   1.232570124373522e-12,   9.684411193137589e-14,  -1.363343268493995e-14,
  -7.308502883095127e-16,   1.430878010062796e-16,  -6.954962646071110e-02,   9.617759846516818e-03,  -4.367439667576611e-05,  -1.163798487656308e-04,   1.088039639459953e-05,
   2.927546617431219e-07,  -1.317117853593977e-07,   7.846604813806341e-09,   5.852167538037912e-10,  -1.163873588925308e-10,   3.971374066300720e-12,   6.972356666899147e-13,
  -8.812912871770887e-14,   9.972856938136045e-16,  -6.616533457100102e-02,   9.139760528660860e-03,  -3.974811407705453e-05,  -1.106187375367045e-04,   1.029439111034524e-05,
   2.828685639681436e-07,  -1.247957773412213e-07,   7.348202537772584e-09,   5.608385797805454e-10,  -1.095867833410075e-10,   3.624214712643228e-12,   6.636357225625737e-13,
  -8.212238034546911e-14,   7.941335389532398e-16,  -5.972853223901645e-02,   8.234707926954001e-03,  -3.302569393981896e-05,  -9.969966707983810e-05,   9.203146159953404e-06,
   2.621985937204352e-07,  -1.118440501236074e-07,   6.449320227666336e-09,   5.125425581896357e-10,  -9.711602299997574e-11,   3.031008783969212e-12,   5.991621750363809e-13,
  -7.141946909508115e-14,   4.789561006861086e-16,  -5.087006474164159e-02,   6.997053615237099e-03,  -2.520592644319400e-05,  -8.474846428328984e-05,   7.746235641892733e-06,
   2.302270709453719e-07,  -9.441564744672930e-08,   5.305725927039705e-09,   4.426006618285527e-10,  -8.085166157647440e-11,   2.340181214590911e-12,   5.097776068056015e-13,
  -5.806738537187593e-14,   1.748394151978401e-16,  -4.045770058362694e-02,   5.552263568326591e-03,  -1.780682808868542e-05,  -6.727289864417447e-05,   6.090083763650454e-06,
   1.883291442434280e-07,  -7.443703387014401e-08,   4.077304616993356e-09,   3.563888943721366e-10,  -6.286888228489130e-11,   1.680261659134550e-12,   4.045411141211059e-13,
  -4.408146536352818e-14,  -3.117251309448479e-17,  -2.951086442705883e-02,   4.042573695844893e-03,  -1.168089016870338e-05,  -4.899396524576258e-05,   4.400978211510794e-06,
   1.403844115489585e-07,  -5.391043035739944e-08,   2.891458406046973e-09,   2.623764427995779e-10,  -4.501769356562256e-11,   1.122095715297139e-12,   2.943119674682249e-13,
  -3.093631055700059e-14,  -1.177905374668668e-16,  -1.910080965152680e-02,   2.613387530875005e-03,  -7.003677980546109e-06,  -3.167814764901856e-05,   2.830929199861296e-06,
   9.213329523931298e-08,  -3.472772011381444e-08,   1.836480746371739e-09,   1.708070786578246e-10,  -2.877880957250424e-11,   6.828678312314495e-13,   1.900874589046763e-13,
  -1.950790234715074e-14,  -1.153454943530012e-16,  -1.024601290336391e-02,   1.400999011245236e-03,  -3.603961523366236e-06,  -1.698357319617625e-05,   1.513726176346408e-06,
   4.976873462736558e-08,  -1.858283848484239e-08,   9.755327533221888e-10,   9.188717915160785e-11,  -1.533876500013546e-11,   3.544893814332970e-13,   1.018424852641776e-13,
  -1.032326816021647e-14,  -7.239286577880814e-17,  -3.812799649349415e-03,   5.212346118868150e-04,  -1.321342085857220e-06,  -6.318828207627323e-06,   5.626701543656868e-07,
   1.856493943616624e-08,  -6.909214245609603e-09,   3.617817353421212e-10,   3.422715594934444e-11,  -5.695165285635244e-12,   1.303928915341188e-13,   3.788140596915114e-14,
  -3.823324288194734e-15,  -2.828681978178819e-17,  -4.306849951004614e-04,   5.887543636289416e-05,  -1.489012672545330e-07,  -7.137388626503754e-07,   6.354670549145849e-08,
   2.097853426726551e-09,  -7.803425028903420e-10,   4.084384079495128e-11,   3.866820170009820e-12,  -6.430836855197171e-13,   1.470165038791763e-14,   4.278691608011545e-15,
  -4.315474606694055e-16,  -3.219289549963529e-18,  -3.677425787597525e-02,   6.370768733839624e-03,  -5.404228239537103e-04,   1.130793070104987e-05,   3.111746715910068e-06,
  -4.347736917877848e-07,   2.463278348631711e-08,   3.775145347375281e-10,  -2.006841456408315e-10,   1.800350111439871e-11,  -5.630439725077825e-13,  -5.383594910216727e-14,
   8.755890900132556e-15,  -5.507601193875590e-16,  -3.500075998158599e-02,   6.061654259967555e-03,  -5.135561350204529e-04,   1.062965738351697e-05,   2.970721449272002e-06,
  -4.133033829833471e-07,   2.326418981325168e-08,   3.777289336568758e-10,  -1.915371567681645e-10,   1.702910095864980e-11,  -5.186044279335351e-13,  -5.235968885286389e-14,
   8.322054425229118e-15,  -5.141887179013569e-16,  -3.162115553328349e-02,   5.473358347942341e-03,  -4.626861874282373e-04,   9.391801573561313e-06,   2.698169259906401e-06,
  -3.725799973385215e-07,   2.072964931616909e-08,   3.704297226225603e-10,  -1.738573855633055e-10,   1.521338032869055e-11,  -4.410505080965042e-13,  -4.905480860015552e-14,
   7.496360053979915e-15,  -4.484558191754050e-16,  -2.695751306646394e-02,   4.663023203986008e-03,  -3.931248385924593e-04,   7.789277855605187e-06,   2.314788855074553e-06,
  -3.167685874806646e-07,   1.737493328116202e-08,   3.455908400353567e-10,  -1.490090748576495e-10,   1.278978275506516e-11,  -3.477953409061466e-13,  -4.357430264695821e-14,
   6.362648145059210e-15,  -3.655632041318280e-16,  -2.145990241997565e-02,   3.709661798050676e-03,  -3.119302734757592e-04,   6.033302554533610e-06,   1.853823278254238e-06,
  -2.514851742986496e-07,   1.360148650330567e-08,   2.979017617122952e-10,  -1.191947801463645e-10,   1.003994157059937e-11,  -2.551760616834131e-13,  -3.600135146753964e-14,
   5.039004653976140e-15,  -2.779343018321471e-16,  -1.566526517747529e-02,   2.706555573308810e-03,  -2.271010069239945e-04,   4.305981374862501e-06,   1.359703382386891e-06,
  -1.831683246502494e-07,   9.793388094034158e-09,   2.307392817281614e-10,  -8.732698803681998e-11,   7.244404473296504e-12,  -1.735769591984513e-13,  -2.703035966358439e-14,
   3.660798373792560e-15,  -1.951332653152675e-16,  -1.014436962252439e-02,   1.752078635433053e-03,  -1.468066073216825e-04,   2.746496818303410e-06,   8.832409287268090e-07,
  -1.184360661535257e-07,   6.283942999226668e-09,   1.550619040111833e-10,  -5.667984488397386e-11,   4.654688675524015e-12,  -1.069905848054773e-13,  -1.781800162229122e-14,
   2.362410732611897e-15,  -1.230269685099338e-16,  -5.443018783841898e-03,   9.399199248392046e-04,  -7.869897859765518e-05,   1.462109022287386e-06,   4.746579227277776e-07,
  -6.349791992430534e-08,   3.355706991024598e-09,   8.474734149329790e-11,  -3.044650022341988e-11,   2.487354923386543e-12,  -5.591832772380974e-14,  -9.645677072905740e-15,
   1.265186125195526e-15,  -6.508884413121386e-17,  -2.025665697213120e-03,   3.497774436146746e-04,  -2.927930455712953e-05,   5.426424424500957e-07,   1.767448921414213e-07,
  -2.362483591825722e-08,   1.246784920123075e-09,   3.173956917555349e-11,  -1.133534451350480e-11,   9.243723419637693e-13,  -2.061793120487842e-14,  -3.600703843109471e-15,
   4.705348808894320e-16,  -2.410377841106350e-17,  -2.288177419103433e-04,   3.951021890693364e-05,  -3.307204488696151e-06,   6.126972765859954e-08,   1.996671191941991e-08,
  -2.668528648117729e-09,   1.407988234060371e-10,   3.588864101392416e-12,  -1.280511280265442e-12,   1.043927909498072e-13,  -2.325536337320812e-15,  -4.069294197004048e-16,
   5.314560151406914e-17,  -2.720601009927414e-18,  -1.850870428792655e-02,   2.970260346454636e-03,  -2.974605218247706e-04,   2.003487072858531e-05,  -7.003671420817256e-07,
  -2.777733811056522e-08,   6.581964040612150e-09,  -5.648915820633422e-10,   2.827475461040905e-11,  -3.721658229271930e-13,  -8.450639358247120e-14,   9.971204917036811e-15,
  -6.343566770019213e-16,   2.170040003073452e-17,  -1.761745246795557e-02,   2.827554938302957e-03,  -2.831094815522685e-04,   1.905102055894294e-05,  -6.632786916163426e-07,
  -2.678017668150970e-08,   6.284638391346941e-09,  -5.376979117638721e-10,   2.677645808153546e-11,  -3.373473760007596e-13,  -8.161910445375718e-14,   9.530471153221372e-15,
  -6.017061725469153e-16,   2.020770082889243e-17,  -1.591852935109302e-02,   2.555392700000418e-03,  -2.557636322285195e-04,   1.718327904298535e-05,  -5.939469593311770e-07,
  -2.473977388129509e-08,   5.709664806196949e-09,  -4.858322960759787e-10,   2.397427808184571e-11,  -2.778203543685812e-13,  -7.562423501892754e-14,   8.672681780710517e-15,
  -5.401837035167053e-16,   1.753769998711963e-17,  -1.357305930138695e-02,   2.179398028122614e-03,  -2.180319259583956e-04,   1.461977954699229e-05,  -5.008887837769808e-07,
  -2.165261498484029e-08,   4.900149401156855e-09,  -4.141982524485867e-10,   2.021220355876023e-11,  -2.089759657282142e-13,  -6.640324339130205e-14,   7.455720362935431e-15,
  -4.567790558878081e-16,   1.419940035541161e-17,  -1.080679634140255e-02,   1.735625325319380e-03,  -1.735586143040535e-04,   1.161557446030212e-05,  -3.945117806220008e-07,
  -1.767026833514810e-08,   3.925780162540964e-09,  -3.297126519004512e-10,   1.591301756578402e-11,  -1.447523428577230e-13,  -5.434442540857993e-14,   5.981348550085035e-15,
  -3.605660596366690e-16,   1.071387134104999e-17,  -7.889780534289497e-03,   1.267371819337890e-03,  -1.266885615013213e-04,   8.465705361183783e-06,  -2.854946971400554e-07,
  -1.315346567090100e-08,   2.880287441106073e-09,  -2.406581244932602e-10,   1.151073796073290e-11,  -9.292652546322704e-14,  -4.053699233217323e-14,   4.392377816228507e-15,
  -2.613165433876512e-16,   7.469576330914668e-18,  -5.109645561053598e-03,   8.208854088704495e-04,  -8.203737014268080e-05,   5.476385258713108e-06,  -1.838110776166886e-07,
  -8.626622661955168e-09,   1.871379748907638e-09,  -1.558274881517535e-10,   7.408522729723434e-12,  -5.471481694565522e-14,  -2.661968076376277e-14,   2.855235524594032e-15,
  -1.683842944721835e-16,   4.685347642041855e-18,  -2.741734594590005e-03,   4.404981732745967e-04,  -4.401691971934287e-05,   2.936795294504806e-06,  -9.833064919384841e-08,
  -4.658631291712709e-09,   1.005798581147038e-09,  -8.360495841660836e-11,   3.962484587271286e-12,  -2.785090841564862e-14,  -1.438434699451977e-14,   1.534931999894217e-15,
  -9.011228690369801e-17,   2.471910604228964e-18,  -1.020376105590693e-03,   1.639412875703695e-04,  -1.638117972930383e-05,   1.092747160458520e-06,  -3.655646223074438e-08,
  -1.737630078799335e-09,   3.745362216984064e-10,  -3.111357808510518e-11,   1.473036409992881e-12,  -1.016969478144328e-14,  -5.366374711448514e-15,   5.716155698135186e-16,
  -3.350530108169478e-17,   9.144835694258258e-19,  -1.152612437484380e-04,   1.851880028403592e-05,  -1.850404656644891e-06,   1.234322376331251e-07,  -4.128708256549738e-09,
  -1.963510044779302e-10,   4.231127925152035e-11,  -3.514554299173419e-12,   1.663637907144544e-13,  -1.145260886986084e-15,  -6.064168726527489e-16,   6.457603538702384e-17,
  -3.784182008261614e-18,   1.032014823516679e-19,  -1.014348372797860e-02,   1.355140255457341e-03,  -1.256583507635207e-04,   9.157689408324260e-06,  -5.206376303317375e-07,
   2.058667454650877e-08,  -2.196028299139406e-10,  -4.945953240826481e-11,   5.501884130997853e-12,  -3.624715418429218e-13,   1.674512357024511e-14,  -4.508342398035730e-16,
  -8.049665631067016e-18,   2.011235047017309e-18,  -9.653974341535077e-03,   1.290054144906946e-03,  -1.196393535494505e-04,   8.718275756141961e-06,  -4.953935000747657e-07,
   1.955259994928723e-08,  -2.042141931019565e-10,  -4.744641806179181e-11,   5.256494770980920e-12,  -3.455290495749639e-13,   1.590985752188025e-14,  -4.238809216402627e-16,
  -8.101097036487324e-18,   1.939891146916026e-18,  -8.721301854157915e-03,   1.165917044729111e-03,  -1.081527279599789e-04,   7.880000467100641e-06,  -4.473408707477156e-07,
   1.759863354759707e-08,  -1.768309083941038e-10,  -4.345864507641134e-11,   4.780659201345662e-12,  -3.130109146257246e-13,   1.432830179056633e-14,  -3.745693590220713e-16,
  -8.022748774170781e-18,   1.793458222174983e-18,  -7.434539791730717e-03,   9.944048670749871e-04,  -9.226941377595621e-05,   6.721455998267874e-06,  -3.811362998331507e-07,
   1.493469525916647e-08,  -1.428261717500593e-10,  -3.766145705587464e-11,   4.108169235570223e-12,  -2.676996440878047e-13,   1.216666545413445e-14,  -3.105756091409572e-16,
  -7.569478122891479e-18,   1.571067728032933e-18,  -5.917995236834994e-03,   7.919535876587659e-04,  -7.350460638741356e-05,   5.353504266378812e-06,  -3.032293712019333e-07,
   1.183580492240570e-08,  -1.075548946708306e-10,  -3.045445694599218e-11,   3.295449293477130e-12,  -2.137498043985896e-13,   9.646597381826020e-15,  -2.403847678747100e-16,
  -6.593487850595327e-18,   1.283193360005515e-18,  -4.319796695890435e-03,   5.783119480665030e-04,  -5.368752386655927e-05,   3.909579104125320e-06,  -2.212438619686640e-07,
   8.608458704805687e-09,  -7.488962217089256e-11,  -2.250973147848609e-11,   2.420305962995715e-12,  -1.564031637657417e-13,   7.018219299254149e-15,  -1.713981078655449e-16,
  -5.148791399245194e-18,   9.558126325254674e-19,  -2.797286253917607e-03,   3.745850599128553e-04,  -3.477964049275683e-05,   2.532427523192939e-06,  -1.432248126611270e-07,
   5.561091005993887e-09,  -4.694277829258169e-11,  -1.469592816006639e-11,   1.573592860232644e-12,  -1.014380382080795e-13,   4.534464166815500e-15,  -1.092325941664920e-16,
  -3.478427304630853e-18,   6.271273384198831e-19,  -1.500875792709829e-03,   2.010097633366262e-04,  -1.866484042474250e-05,   1.358980195341401e-06,  -7.683525343042423e-08,
   2.980107613949576e-09,  -2.475880178689723e-11,  -7.918059321532015e-12,   8.460459069747640e-13,  -5.446967712594941e-14,   2.430106506396266e-15,  -5.812195948878296e-17,
  -1.906204257249219e-18,   3.387390982041334e-19,  -5.585606041525720e-04,   7.481060739366112e-05,  -6.946748984647083e-06,   5.057808642401430e-07,  -2.859322619567923e-08,
   1.108589091423497e-09,  -9.158647685800502e-12,  -2.951032109192444e-12,   3.150865538131607e-13,  -2.027683592076525e-14,   9.040086427653284e-16,  -2.156729857299249e-17,
  -7.145756033658956e-19,   1.263560663469701e-19,  -6.309454954145251e-05,   8.450608329103632e-06,  -7.847081998068043e-07,   5.713308811958651e-08,  -3.229840395258939e-09,
   1.252167618188944e-10,  -1.033558341428209e-12,  -3.334228133385796e-13,   3.559595396561182e-14,  -2.290554957880754e-15,   1.021094118836069e-16,  -2.435091416800847e-18,
  -8.081056862623212e-20,   1.427831405869146e-20,  -6.200095795471912e-03,   6.759578041311829e-04,  -5.377247592868207e-05,   3.605410345812321e-06,  -2.083802934947094e-07,
   1.020738697433834e-08,  -3.990786397001568e-10,   9.987733923297340e-12,   1.035930797233137e-13,  -3.262360573064431e-14,   2.515767233173518e-15,  -1.364685441243359e-16,
   5.751165692076018e-18,  -1.787122408186928e-19,  -5.900175136410444e-03,   6.434064296755514e-04,  -5.119457012035269e-05,   3.433095275192431e-06,  -1.984221620387402e-07,
   9.716959015951054e-09,  -3.795611919510625e-10,   9.465444377612193e-12,   1.020127260148563e-13,  -3.126380536621453e-14,   2.404744036244401e-15,  -1.302367098056342e-16,
   5.477042974509961e-18,  -1.694230507474302e-19,  -5.329021476624382e-03,   5.813573334600948e-04,  -4.627586127109260e-05,   3.104093970437435e-06,  -1.794084274869303e-07,
   8.781612759278834e-09,  -3.424758635294838e-10,   8.486477789086551e-12,   9.762218298290113e-14,  -2.858594981375411e-14,   2.188968072907514e-15,  -1.182159436461251e-16,
   4.953076744593591e-18,  -1.519756154257416e-19,  -4.541593944295095e-03,   4.956964020932889e-04,  -3.947624569599588e-05,   2.648858631882252e-06,  -1.530982656360836e-07,
   7.489409699666491e-09,  -2.915120079295328e-10,   7.167469353393672e-12,   8.887386933570663e-14,  -2.472215578986681e-14,   1.883050092229576e-15,  -1.013487451569956e-16,
   4.227210077116714e-18,  -1.284113066463518e-19,  -3.614266738030062e-03,   3.946691599200900e-04,  -3.144528858977074e-05,   2.110650580135192e-06,  -1.219917000861901e-07,
   5.964295005907388e-09,  -2.317074811805295e-10,   5.653379754690114e-12,   7.513300448782440e-14,  -1.995322866348247e-14,   1.512099332417553e-15,  -8.111563960494993e-17,
   3.368376960262763e-18,  -1.013109811905388e-19,  -2.637675876204958e-03,   2.881376028275229e-04,  -2.296598605117564e-05,   1.541900847017743e-06,  -8.911928224219922e-08,
   4.355109246963895e-09,  -1.689307913881713e-10,   4.095877306202937e-12,   5.743266356648149e-14,  -1.472618428978000e-14,   1.111483076213070e-15,  -5.946706240356137e-17,
   2.460575127582905e-18,  -7.340567040219981e-20,  -1.707800941838525e-03,   1.866057878825381e-04,  -1.487708047558340e-05,   9.989918143132186e-07,  -5.774011977942367e-08,
   2.820793564864959e-09,  -1.093038571347867e-10,   2.639067936480991e-12,   3.830173477193936e-14,  -9.605140462985563e-15,   7.230506025151884e-16,  -3.861743808465456e-17,
   1.594081713251245e-18,  -4.729641507457812e-20,  -9.162530262458629e-04,   1.001288970761224e-04,  -7.983754597563830e-06,   5.361530144076270e-07,  -3.098879329409592e-08,
   1.513663738277590e-09,  -5.862247074084698e-11,   1.412332618286749e-12,   2.085736163266830e-14,  -5.172692456522253e-15,   3.888622742982623e-16,  -2.075015288356990e-17,
   8.554928418875890e-19,  -2.531065257679758e-20,  -3.409813647774434e-04,   3.726440550274437e-05,  -2.971400090279333e-06,   1.995518215719300e-07,  -1.153377963571641e-08,
   5.633423295929095e-10,  -2.181358889821097e-11,   5.251351489672429e-13,   7.801955769116441e-15,  -1.927523611829671e-15,   1.448356662745710e-16,  -7.726193609320220e-18,
   3.184015971075947e-19,  -9.410920493797079e-21,  -3.851683109352289e-05,   4.209370978580213e-06,  -3.356504101945598e-07,   2.254155166050888e-08,  -1.302866046418203e-09,
   6.363509417655343e-11,  -2.463988828299251e-12,   5.931034625591662e-14,   8.820153037432230e-16,  -2.177758221792802e-16,   1.636263475251395e-17,  -8.728142231972538e-19,
   3.596681894847862e-20,  -1.062895484580806e-21,  -4.145864412158367e-03,   3.747594271768104e-04,  -2.520490713018740e-05,   1.477041814688668e-06,  -7.822178205448091e-08,
   3.750758193978615e-09,  -1.603066184876939e-10,   5.891401380247167e-12,  -1.701226338658402e-13,   2.569465869174726e-15,   1.035215748743785e-16,  -1.219058086304424e-17,
   7.313070615450481e-19,  -3.372178566755704e-20,  -3.944978351382258e-03,   3.566649074176450e-04,  -2.399306151385585e-05,   1.406324469949958e-06,  -7.448907610165893e-08,
   3.572010440271798e-09,  -1.526499941130342e-10,   5.607448298290955e-12,  -1.616972083386602e-13,   2.423782924109533e-15,   9.996067768305441e-17,  -1.167752631650669e-17,
   6.992633741619374e-19,  -3.220657797709702e-20,  -3.562557940967554e-03,   3.221928036489120e-04,  -2.168226936465191e-05,   1.271355772358119e-06,  -6.735985894602185e-08,
   3.230514239830021e-09,  -1.380288409524178e-10,   5.066246466795550e-12,  -1.457295245427569e-13,   2.154908676338023e-15,   9.259785432827923e-17,  -1.066956638950801e-17,
   6.368903237178339e-19,  -2.927365591379030e-20,  -3.035595049921822e-03,   2.746406346733019e-04,  -1.849061911606443e-05,   1.084701032045618e-06,  -5.749065347229887e-08,
   2.757578819323425e-09,  -1.177934561035601e-10,   4.319261445009866e-12,  -1.238679002772480e-13,   1.800974230158994e-15,   8.131113411272178e-17,  -9.219647465128651e-18,
   5.482721552363749e-19,  -2.513828541762476e-20,  -2.415344502105548e-03,   2.186060785315889e-04,  -1.472450780013054e-05,   8.641509687988829e-07,  -4.581682313046320e-08,
   2.197927558527630e-09,  -9.386497623901482e-11,   3.438536601044221e-12,  -9.831908649409198e-14,   1.405607938885750e-15,   6.656897757954962e-17,  -7.435333934595007e-18,
   4.405727346360855e-19,  -2.015212090516412e-20,  -1.762457047610156e-03,   1.595630624486223e-04,  -1.075141041113033e-05,   6.312004972987336e-07,  -3.347508508682727e-08,
   1.606038909543658e-09,  -6.857446736639648e-11,   2.510115457799388e-12,  -7.160020978819276e-14,   1.009459807742977e-15,   4.968048217502330e-17,  -5.484200945031541e-18,
   3.240308056146381e-19,  -1.479306525715582e-20,  -1.141020741165507e-03,   1.033222155898101e-04,  -6.963520592534695e-06,   4.089138300084443e-07,  -2.169025322417137e-08,
   1.040708537926666e-09,  -4.443034740621827e-11,   1.625496918935102e-12,  -4.629275688017256e-14,   6.465636543563257e-16,   3.263799564985248e-17,  -3.575668057333456e-18,
   2.108704875022603e-19,  -9.614796137896640e-21,  -6.121399791557961e-04,   5.543643096680384e-05,  -3.736653502005035e-06,   2.194510302280211e-07,  -1.164154684549766e-08,
   5.585866804594977e-10,  -2.384582720824766e-11,   8.721739166584523e-13,  -2.481832441038593e-14,   3.449471515803184e-16,   1.764084060199428e-17,  -1.925238325931389e-18,
   1.134298303061460e-19,  -5.168575412226135e-21,  -2.278025957962805e-04,   2.063092127897380e-05,  -1.390671095849123e-06,   8.167652848387938e-08,  -4.332956561400619e-09,
   2.079072169610169e-10,  -8.875265360940660e-12,   3.245874459245667e-13,  -9.233714322280476e-15,   1.281195246260117e-16,   6.581878762766025e-18,  -7.173613544596019e-19,
   4.225094277559291e-20,  -1.924785587830846e-21,  -2.573222941736767e-05,   2.330450150229332e-06,  -1.570899922720049e-07,   9.226228878379391e-09,  -4.894558343664626e-10,
   2.348548790597782e-11,  -1.002558620167462e-12,   3.666517356638716e-14,  -1.042986461366142e-15,   1.446770829323970e-17,   7.437835412329605e-19,  -8.104817697502145e-20,
   4.773300636746644e-21,  -2.174449145518239e-22,  -2.961790494572136e-03,   2.273226345277532e-04,  -1.306205497155565e-05,   6.628213287045740e-07,  -3.108937886595454e-08,
   1.364310988489791e-09,  -5.584237681255756e-11,   2.104651709116953e-12,  -7.132675004644876e-14,   2.074203838239754e-15,  -4.556084687296512e-17,   3.126580171595934e-19,
   3.904106225969540e-20,  -2.991987693892428e-21,  -2.818124622063385e-03,   2.163254910340083e-04,  -1.243231950391161e-05,   6.309911669537674e-07,  -2.960231294822662e-08,
   1.299274923397698e-09,  -5.318590492503817e-11,   2.004503675966873e-12,  -6.791767558481210e-14,   1.973755552838188e-15,  -4.326353134783096e-17,   2.902534686489053e-19,
   3.755310481837783e-20,  -2.865360608846234e-21,  -2.544694940092297e-03,   1.953833848645123e-04,  -1.123221874404193e-05,   5.702806375627637e-07,  -2.676356797698546e-08,
   1.175032580004988e-09,  -4.810879143438046e-11,   1.813107889046872e-12,  -6.140857296560464e-14,   1.782495372447824e-15,  -3.892565244988855e-17,   2.505008832398861e-19,
   3.455859802482541e-20,  -2.616925813641460e-21,  -2.168038954763346e-03,   1.665118890525967e-04,  -9.576008917704467e-06,   4.863974284211296e-07,  -2.283660071858185e-08,
   1.002985732582284e-09,  -4.107374677134197e-11,   1.547922909322204e-12,  -5.240190381563916e-14,   1.518884175097995e-15,  -3.301798772281069e-17,   2.013983726045333e-19,
   3.011580600337831e-20,  -2.260190164908764e-21,  -1.724857558065309e-03,   1.325116316467483e-04,  -7.623421652410370e-06,   3.873779177473942e-07,  -1.819509030602321e-08,
   7.994106090091523e-10,  -3.274395602810727e-11,   1.233961393212327e-12,  -4.175383406929348e-14,   1.208554859460341e-15,  -2.615447415243611e-17,   1.508728547710509e-19,
   2.448211679119650e-20,  -1.821930619419197e-21,  -1.258499735828877e-03,   9.670583423476112e-05,  -5.565123416920733e-06,   2.828806212528485e-07,  -1.329127720650728e-08,
   5.841237788002614e-10,  -2.392982743900111e-11,   9.017739126174256e-13,  -3.050197502119669e-14,   8.818722279974176e-16,  -1.901519735623043e-17,   1.045445984606634e-19,
   1.817148736310513e-20,  -1.343352598477772e-21,  -8.147079851546691e-04,   6.261332996989097e-05,  -3.603896440458009e-06,   1.832295323721887e-07,  -8.611011501355263e-09,
   3.785063145765384e-10,  -1.550801227626702e-11,   5.843940858029912e-13,  -1.976181906284180e-14,   5.709234989811676e-16,  -1.228055254302793e-17,   6.529871204064854e-20,
   1.189614968338801e-20,  -8.756578448774388e-22,  -4.370647133286686e-04,   3.359263732998311e-05,  -1.933714792872461e-06,   9.832506676128096e-08,  -4.621381253854847e-09,
   2.031571930889436e-10,  -8.324151316549789e-12,   3.136788439441708e-13,  -1.060596305925105e-14,   3.062900558926844e-16,  -6.580038536320341e-18,   3.437311306282636e-20,
   6.418513342189419e-21,  -4.714238482472127e-22,  -1.626480994643144e-04,   1.250141059725106e-05,  -7.196515090069680e-07,   3.659409453104727e-08,  -1.720028145072289e-09,
   7.561542150116494e-11,  -3.098323394597760e-12,   1.167536479015256e-13,  -3.947441896629935e-15,   1.139829560175635e-16,  -2.447628746344567e-18,   1.270623448695278e-20,
   2.393315562016643e-21,  -1.756498122613744e-22,  -1.837244674038653e-05,   1.412143643456704e-06,  -8.129137346497925e-08,   4.133671054388161e-09,  -1.942956864263675e-10,
   8.541620471534730e-12,  -3.499919091157241e-13,   1.318868423854301e-14,  -4.459063403542982e-16,   1.287533424023983e-17,  -2.764610707686648e-19,   1.433744844026069e-21,
   2.704298863027900e-22,  -1.984495960030050e-23,  -2.220816569508696e-03,   1.478693052609479e-04,  -7.382942489890187e-06,   3.270266567466787e-07,  -1.351468598929873e-08,
   5.307936720032719e-10,  -1.990047091329097e-11,   7.094357253762166e-13,  -2.380482055809342e-14,   7.393376208174482e-16,  -2.066251933689214e-17,   4.900869721406125e-19,
  -8.216716702307580e-21,  -1.083149124674431e-23,  -2.113018397618184e-03,   1.407063669314984e-04,  -7.026266375011341e-06,   3.112791521048203e-07,  -1.286627837106895e-08,
   5.054223721202759e-10,  -1.895248067590862e-11,   6.757253420871497e-13,  -2.267471831051712e-14,   7.041768467205491e-16,  -1.967331991295060e-17,   4.662006168274601e-19,
  -7.791326430642363e-21,  -1.200017714551903e-23,  -1.907883524301224e-03,   1.270696892638997e-04,  -6.346841593774228e-06,   2.812611063934692e-07,  -1.162930808515288e-08,
   4.569824356200980e-10,  -1.714120945493119e-11,   6.112817148231502e-13,  -2.051387733687525e-14,   6.369714378986235e-16,  -1.778524384518150e-17,   4.207801586416993e-19,
  -6.992334028753687e-21,  -1.354817400297901e-23,  -1.625363890611589e-03,   1.082772046476338e-04,  -5.409778658496820e-06,   2.398195440755278e-07,  -9.919722321105730e-09,
   3.899592327658718e-10,  -1.463249742451895e-11,   5.219558705820133e-13,  -1.751787620901790e-14,   5.438398553959676e-16,  -1.517398348469743e-17,   3.582970084957571e-19,
  -5.912592677993658e-21,  -1.435623607413058e-23,  -1.293019559203534e-03,   8.615590413765394e-05,  -4.305767538562184e-06,   1.909432060314396e-07,  -7.901049960276160e-09,
   3.107228996409621e-10,  -1.166339183058492e-11,   4.161517614687674e-13,  -1.396815025365335e-14,   4.335581815185004e-16,  -1.208848861847092e-17,   2.848935348042764e-19,
  -4.669036792724457e-21,  -1.361047167439295e-23,  -9.433643617211204e-04,   6.286874176021111e-05,  -3.142674892243040e-06,   1.394031988652000e-07,  -5.770144819842555e-09,
   2.269922163966328e-10,  -8.522854222596419e-12,   3.041595437361629e-13,  -1.020986464359212e-14,   3.168564242397700e-16,  -8.829599555120453e-18,   2.077668214728758e-19,
  -3.385930188870925e-21,  -1.122549082110922e-23,  -6.106768269666090e-04,   4.070207421328946e-05,  -2.034917234470121e-06,   9.028156688875234e-08,  -3.737671749421068e-09,
   1.470669443377200e-10,  -5.522935644196088e-12,   1.971266563432513e-13,  -6.617354622549539e-15,   2.053444883303989e-16,  -5.720029667665247e-18,   1.344574986690634e-19,
  -2.183009203903907e-21,  -7.823580587059036e-24,  -3.276020022674630e-04,   2.183620811228296e-05,  -1.091794951827555e-06,   4.844333287988466e-08,  -2.005770850213689e-09,
   7.892984454664449e-11,  -2.964405622133060e-12,   1.058140266675646e-13,  -3.552162007281543e-15,   1.102221227397805e-16,  -3.069728504957379e-18,   7.212000510583462e-20,
  -1.168646636562563e-21,  -4.350886126250478e-24,  -1.219120907612980e-04,   8.126178519632670e-06,  -4.063141322292800e-07,   1.802889003529948e-08,  -7.465038151647730e-10,
   2.937703617139856e-11,  -1.103363939012994e-12,   3.938536878594623e-14,  -1.322172358132802e-15,   4.102571753152365e-17,  -1.142504980633398e-18,   2.683696425381852e-20,
  -4.345768180871749e-22,  -1.639072677895903e-24,  -1.377096279278711e-05,   9.179209818246891e-07,  -4.589683359332033e-08,   2.036535704779849e-09,  -8.432523656123850e-11,
   3.318455939190666e-12,  -1.246376215164737e-13,   4.449046569747358e-15,  -1.493553159191428e-16,   4.634336273762042e-18,  -1.290579648548433e-19,   3.031428430380565e-21,
  -4.908329908939307e-23,  -1.855044641927528e-25,  -1.726916205320405e-03,   1.014934444814150e-04,  -4.474453881009389e-06,   1.752400446378744e-07,  -6.424198081250101e-09,
   2.252844578255773e-10,  -7.625520091527524e-12,   2.495465107578904e-13,  -7.867283420283277e-15,   2.370606490731219e-16,  -6.743791591711858e-18,   1.777386275664062e-19,
  -4.200399044935269e-21,   8.271953925906510e-23,  -1.643053157723027e-03,   9.657252918768874e-05,  -4.257969295674861e-06,   1.667837713459644e-07,  -6.115148864764501e-09,
   2.144835529312104e-10,  -7.261213433388617e-12,   2.376642209575241e-13,  -7.493705923879182e-15,   2.258224027008964e-16,  -6.424043328153998e-18,   1.692845990555891e-19,
  -3.998805078441307e-21,   7.865428443857214e-23,  -1.483481451950009e-03,   8.720599523719771e-05,  -3.845722830287643e-06,   1.506716301191497e-07,  -5.525913998111757e-09,
   1.938754198805693e-10,  -6.565588544096007e-12,   2.149592568631483e-13,  -6.779440207383663e-15,   2.043275514909721e-16,  -5.812491146997538e-18,   1.531262096841057e-19,
  -3.614225981232858e-21,   7.093739956574978e-23,  -1.263743713913957e-03,   7.430165587530232e-05,  -3.277405376113850e-06,   1.284420692673764e-07,  -4.712205871412705e-09,
   1.653872403280206e-10,  -5.602950961496055e-12,   1.835074355886483e-13,  -5.789189152195300e-15,   1.745123605461656e-16,  -4.964249772074967e-18,   1.307352448185815e-19,
  -3.082738350716953e-21,   6.034768701485814e-23,  -1.005292087448579e-03,   5.911597047531682e-05,  -2.608156280306950e-06,   1.022423325944441e-07,  -3.752215556713211e-09,
   1.317406752048902e-10,  -4.464713883658869e-12,   1.462783405335692e-13,  -4.616006296901925e-15,   1.391705994429776e-16,  -3.958827528972858e-18,   1.042223404468296e-19,
  -2.455234873369763e-21,   4.794075767175438e-23,  -7.334145572440559e-04,   4.313412198269102e-05,  -1.903390917047881e-06,   7.463143661559470e-08,  -2.739628268519196e-09,
   9.621615994293669e-11,  -3.261742396613304e-12,   1.068947338877027e-13,  -3.373967605554402e-15,   1.017372937370454e-16,  -2.893957064990024e-18,   7.616736906260600e-20,
  -1.792948514562131e-21,   3.493630851684463e-23,  -4.747557049001818e-04,   2.792418699620945e-05,  -1.232364765204705e-06,   4.832779247124020e-08,  -1.774358292173297e-09,
   6.232751100371204e-11,  -2.113322919513726e-12,   6.927106680490044e-14,  -2.186760607362759e-15,   6.594452953015619e-17,  -1.875796444827609e-18,   4.936108293542514e-20,
  -1.161348206927734e-21,   2.259809626525848e-23,  -2.546827266805809e-04,   1.498062108905856e-05,  -6.611729973197807e-07,   2.593018384618081e-08,  -9.521124112106660e-10,
   3.344789813549344e-11,  -1.134222489067129e-12,   3.718133597829452e-14,  -1.173836404209273e-15,   3.540011724603924e-17,  -1.006952568748334e-18,   2.649524089705769e-20,
  -6.232063288590752e-22,   1.211803474547890e-23,  -9.477585280850235e-05,   5.574873086071051e-06,  -2.460534826858696e-07,   9.650091275140979e-09,  -3.543458659277117e-10,
   1.244866104047943e-11,  -4.221503432375177e-13,   1.383910652260717e-14,  -4.369202672904891e-16,   1.317668391454257e-17,  -3.748085754119937e-19,   9.861759307325042e-21,
  -2.319416459014505e-22,   4.508907594540522e-24,  -1.070569596778087e-05,   6.297284195579555e-07,  -2.779388726158233e-08,   1.090066537314304e-09,  -4.002681837751908e-11,
   1.406205102194734e-12,  -4.768651310587392e-14,   1.563287017093469e-15,  -4.935540191815776e-17,   1.488468714193314e-18,  -4.233922989248502e-20,   1.114001088723742e-21,
  -2.620014277903370e-23,   5.093064238114794e-25,  -1.381299986447871e-03,   7.264980074568482e-05,  -2.866371193213968e-06,   1.005039067454381e-07,  -3.301950784369342e-09,
   1.040172315562729e-10,  -3.177389412192008e-12,   9.458285214622484e-14,  -2.745335567369469e-15,   7.747306753456598e-17,  -2.112688986096334e-18,   5.515924393134135e-20,
  -1.360430559349427e-21,   3.103557422013196e-23,  -1.314199189737524e-03,   6.912511420920336e-05,  -2.727542441771219e-06,   9.564647082476581e-08,  -3.142768584999563e-09,
   9.901724397970180e-11,  -3.025141801116257e-12,   9.006585479960887e-14,  -2.614649982571276e-15,   7.379564086771973e-17,  -2.012615610919436e-18,   5.254868861463146e-20,
  -1.295970589048458e-21,   2.955831280235581e-23,  -1.186530923813335e-03,   6.241709825203769e-05,  -2.463234006006682e-06,   8.639445996321339e-08,  -2.839407983073776e-09,
   8.948261419720091e-11,  -2.734617448029093e-12,   8.144019504582104e-14,  -2.364918508501976e-15,   6.676398326608900e-17,  -1.821176676471109e-18,   4.755379091627418e-20,
  -1.172665796324780e-21,   2.673520979157305e-23,  -1.010742809376741e-03,   5.317719874208047e-05,  -2.098978070615355e-06,   7.363566839607759e-08,  -2.420745695168158e-09,
   7.631254511526897e-11,  -2.332934281825638e-12,   6.950228452521728e-14,  -2.018952653110211e-15,   5.701426796536829e-17,  -1.555569318888814e-18,   4.062194004167345e-20,
  -1.001603328225663e-21,   2.282402451530586e-23,  -8.040055924732436e-04,   4.230604180789793e-05,  -1.670178339677365e-06,   5.860576812204302e-08,  -1.927155818330645e-09,
   6.077087401354996e-11,  -1.858430185105294e-12,   5.538504189891695e-14,  -1.609402180061768e-15,   4.546206654526161e-17,  -1.240645575206663e-18,   3.240079170381637e-20,
  -7.987992031623898e-22,   1.819392131651362e-23,  -5.865490929910008e-04,   3.086703029279828e-05,  -1.218759875075441e-06,   4.277341760087531e-08,  -1.406836016380270e-09,
   4.437397505568141e-11,  -1.357360461596775e-12,   4.046335334997341e-14,  -1.176117261128166e-15,   3.323054066440560e-17,  -9.070064355871813e-19,   2.368903545174499e-20,
  -5.839640766003674e-22,   1.329555989182124e-23,  -3.796794807072337e-04,   1.998199150966965e-05,  -7.890483206365598e-07,   2.769562278915338e-08,  -9.110498612874867e-10,
   2.874068818202002e-11,  -8.793073364582195e-13,   2.621723552156392e-14,  -7.621713852216790e-16,   2.153807224834937e-17,  -5.879343098857045e-19,   1.535623947457808e-20,
  -3.785252211937229e-22,   8.615962249643217e-24,  -2.036771758429849e-04,   1.071963534667318e-05,  -4.233174490071525e-07,   1.485936574617216e-08,  -4.888356338260876e-10,
   1.542246870653332e-11,  -4.718856774351428e-13,   1.407096276658060e-14,  -4.090996128277230e-16,   1.156159725330300e-17,  -3.156203062604016e-19,   8.243862549656360e-21,
  -2.032009912217314e-22,   4.624634205950838e-24,  -7.579475631601275e-05,   3.989168483232593e-06,  -1.575346023891260e-07,   5.529925876208720e-09,  -1.819252091670874e-10,
   5.739796062842651e-12,  -1.756277184840302e-13,   5.237141184350095e-15,  -1.522696270346582e-16,   4.303423444855491e-18,  -1.174816180283964e-19,   3.068591683806175e-21,
  -7.563607749466500e-23,   1.721315838021575e-24,  -8.561623809290532e-06,   4.506093962652376e-07,  -1.779487753563435e-08,   6.246544233997318e-10,  -2.055015663307151e-11,
   6.483667053606582e-13,  -1.983898625091902e-14,   5.915928992587974e-16,  -1.720062137086838e-17,   4.861237531072538e-19,  -1.327101273989374e-20,   3.466360972546427e-22,
  -8.544031825251028e-24,   1.944425238727394e-25,  -1.126093101300060e-03,   5.359356511523316e-05,  -1.913346048548272e-06,   6.071165517525408e-08,  -1.805590343570234e-09,
   5.152812586149031e-11,  -1.428350101562364e-12,   3.871096194052678e-14,  -1.028835237507777e-15,   2.680367872409249e-17,  -1.041290512342257e-03,   4.956160432941719e-05,
  -1.769591580663019e-06,   5.615779776750314e-08,  -1.670425888964907e-09,   4.767968949169342e-11,  -1.321949576318587e-12,   3.583548938150559e-14,  -9.526400110454447e-16,
   2.482447004793600e-17,  -8.845446678765760e-04,   4.210666391130392e-05,  -1.503679830890990e-06,   4.772966624350181e-08,  -1.420104929558515e-09,   4.054709252661410e-11,
  -1.124581037154584e-12,   3.049663112192284e-14,  -8.110306180427415e-16,   2.114251133151489e-17,  -6.796610358716455e-04,   3.235821720183654e-05,  -1.155768041118361e-06,
   3.669488793440136e-08,  -1.092092685672456e-09,   3.119176434301351e-11,  -8.654253005503791e-13,   2.347810986412570e-14,  -6.246381982711338e-16,   1.629018127667937e-17,
  -4.578120282997315e-04,   2.179854675209537e-05,  -7.787137195977816e-07,   2.472822116213726e-08,  -7.361100203507580e-10,   2.102975594875145e-11,  -5.836448230330651e-13,
   1.583863562190732e-14,  -4.215262946119676e-16,   1.099668827660809e-17,  -2.527965412086500e-04,   1.203758173735274e-05,  -4.300575545916881e-07,   1.365802477937308e-08,
  -4.066240884711420e-10,   1.161846322776445e-11,  -3.225039708730420e-13,   8.753513361701506e-15,  -2.330080295223773e-16,   6.079792301585879e-18,  -9.586425460147834e-05,
   4.564941884631096e-06,  -1.630934414656147e-07,   5.179826167165919e-09,  -1.542201696091350e-10,   4.406774446358543e-12,  -1.223303512217145e-13,   3.320556790657415e-15,
  -8.839547266164328e-17,   2.306631024428116e-18,  -1.092985172090629e-05,   5.204686229054522e-07,  -1.859508221025641e-08,   5.905812719967102e-10,  -1.758365310855079e-11,
   5.024498740363852e-13,  -1.394795767584140e-14,   3.786100835370875e-16,  -1.007897485577705e-17,   2.630083167759215e-19,  -9.383216714914386e-04,   4.077764988398229e-05,
  -1.329300151812484e-06,   3.851555913328488e-08,  -1.046063598287069e-09,   2.726839460790149e-11,  -6.908286879137828e-13,   1.713249372685020e-14,  -4.176501920153067e-16,
   1.002231577652914e-17,  -8.676477657172401e-04,   3.770883788084719e-05,  -1.229371182063541e-06,   3.562418641797961e-08,  -9.676656754156871e-10,   2.522870341920197e-11,
  -6.392682616596843e-13,   1.585693883947545e-14,  -3.866380187417120e-16,   9.280203782888052e-18,  -7.370239658122057e-04,   3.203533931774404e-05,  -1.044559702417592e-06,
   3.027438041893718e-08,  -8.225298611551369e-10,   2.145028509214456e-11,  -5.436862278944993e-13,   1.349042504458371e-14,  -3.290512623019585e-16,   7.900898819090350e-18,
  -5.662965540459341e-04,   2.461742360630890e-05,  -8.028132182113185e-07,   2.327241603993151e-08,  -6.324406339969175e-10,   1.649756167722315e-11,  -4.182825799509728e-13,
   1.038237448038488e-14,  -2.533357648611501e-16,   6.085257476817921e-18,  -3.814438703786929e-04,   1.658324173820887e-05,  -5.408724353232756e-07,   1.568153861865568e-08,
  -4.262330686706108e-10,   1.112091329096754e-11,  -2.820307631509812e-13,   7.002305667120427e-15,  -1.709102746084342e-16,   4.106613771479486e-18,  -2.106249868548188e-04,
   9.157392582396042e-06,  -2.986951209756642e-07,   8.660850482091696e-09,  -2.354318840614989e-10,   6.143451579187009e-12,  -1.558223076516685e-13,   3.869386347939776e-15,
  -9.445884204153022e-17,   2.270048454476134e-18,  -7.987184315401702e-05,   3.472676611211772e-06,  -1.132745206786968e-07,   3.284574647167764e-09,  -8.928967596180975e-11,
   2.330068170077566e-12,  -5.910289904858782e-14,   1.467731894321763e-15,  -3.583231054073217e-17,   8.611844074736963e-19,  -9.106489385398751e-06,   3.959342414959207e-07,
  -1.291495435464515e-08,   3.744916863180767e-10,  -1.018045459457631e-11,   2.656671783206673e-13,  -6.738789125041535e-15,   1.673493532299852e-16,  -4.085607928935844e-18,
   9.819351608594104e-20,  -7.939062356339369e-04,   3.174377396895413e-05,  -9.520680430422507e-07,   2.538028562395470e-08,  -6.342331803847275e-10,   1.521296575237022e-11,
  -3.547038403752082e-13,   8.099112500478320e-15,  -1.819430172541054e-16,   4.030631920508104e-18,  -7.341019560620171e-04,   2.935421549356025e-05,  -8.804666792196710e-07,
   2.347376325023483e-08,  -5.866576118010309e-10,   1.407367157875979e-11,  -3.281900000460385e-13,   7.494984558031377e-15,  -1.684030552970012e-16,   3.731429587854205e-18,
  -6.235726921205535e-04,   2.493686315740523e-05,  -7.480635164126093e-07,   1.994692864505916e-08,  -4.986081131962550e-10,   1.196401291777409e-11,  -2.790634823331471e-13,
   6.374844675610402e-15,  -1.432788740651532e-16,   3.175784562653069e-18,  -4.791168995167611e-04,   1.916193431222037e-05,  -5.749016026366421e-07,   1.533214729717897e-08,
  -3.833297858748049e-10,   9.200060889817832e-12,  -2.146503555558905e-13,   4.904861469975665e-15,  -1.102759134433181e-16,   2.445128777965987e-18,  -3.227171063984214e-04,
   1.290784630496705e-05,  -3.873051118015239e-07,   1.033045099042027e-08,  -2.583192438325424e-10,   6.200890421805465e-12,  -1.447055763949547e-13,   3.307360314986692e-15,
  -7.437836159073887e-17,   1.649633046520709e-18,  -1.781958743660228e-04,   7.127693776919065e-06,  -2.138821812135460e-07,   5.705232085143196e-09,  -1.426756884361567e-10,
   3.425255344600371e-12,  -7.994223133704773e-14,   1.827388311311256e-15,  -4.110172713440922e-17,   9.117375229682824e-19,  -6.757407525754152e-05,   2.702955249717461e-06,
  -8.110996956831712e-08,   2.163641055375102e-09,  -5.410988205287323e-11,   1.299082448795242e-12,  -3.032072571097242e-14,   6.931321912127788e-16,  -1.559083498637640e-17,
   3.458637449821607e-19,  -7.704370625095226e-06,   3.081748054856909e-07,  -9.247708672313811e-09,   2.466875023765164e-10,  -6.169372032954307e-12,   1.481166672738280e-13,
  -3.457084943905704e-15,   7.902966818697566e-17,  -1.777654902690331e-18,   3.943550564316215e-20,  -6.804517551421360e-04,   2.519343060532292e-05,  -6.996632116588429e-07,
   1.727086960828354e-08,  -3.996422114640287e-10,   8.876752600208728e-12,  -1.916682399449589e-13,   4.053450065219308e-15,  -8.436432377029678e-17,   1.732767148089075e-18,
  -6.291887455422237e-04,   2.329657804868050e-05,  -6.470266420979282e-07,   1.597286095897461e-08,  -3.696428628236133e-10,   8.211351391868280e-12,  -1.773239082310072e-13,
   3.750641839163975e-15,  -7.807465388509008e-17,   1.603866862167825e-18,  -5.344484297510021e-04,   1.979027489937622e-05,  -5.497032672586452e-07,   1.357209686588284e-08,
  -3.141349626457903e-10,   6.979590156199122e-12,  -1.507563126255760e-13,   3.189467820901257e-15,  -6.641074219231489e-17,   1.364654451038905e-18,  -4.106331454192524e-04,
   1.520677034480244e-05,  -4.224378081648702e-07,   1.043141072683548e-08,  -2.414828728751520e-10,   5.366439871986371e-12,  -1.159392345166393e-13,   2.453487764757496e-15,
  -5.110067414136643e-17,   1.050375782780909e-18,  -2.765856312371722e-04,   1.024334247354278e-05,  -2.845812544019876e-07,   7.028053518438173e-09,  -1.627183584907020e-10,
   3.616632551830953e-12,  -7.814948270774708e-14,   1.654118815980751e-15,  -3.445925525542463e-17,   7.084824678482466e-19,  -1.527222991219199e-04,   5.656285509527180e-06,
  -1.571514215977799e-07,   3.881280928198759e-09,  -8.986905255892485e-11,   1.997639777847965e-12,  -4.317015931074712e-14,   9.138491541209699e-16,  -1.904010514838744e-17,
   3.915193358322789e-19,  -5.791403989196063e-05,   2.144959200865710e-06,  -5.959563292743045e-08,   1.471911548038102e-09,  -3.408234049249832e-11,   7.576194878993384e-13,
  -1.637323198299879e-14,   3.466124449354938e-16,  -7.222039684084708e-18,   1.485136982376587e-19,  -6.602991542508052e-06,   2.445552335020017e-07,  -6.794754278807457e-09,
   1.678196358606246e-10,  -3.885908439716320e-12,   8.638070190023193e-14,  -1.866821491043977e-15,   3.951988361951652e-17,  -8.234454579741547e-19,   1.693344240029516e-20,
  -5.896975673338084e-04,   2.032846441695873e-05,  -5.256357131408466e-07,   1.208069334424745e-08,  -2.602773411806580e-10,   5.382867588731792e-12,  -1.082219105877129e-13,
   2.131159639010948e-15,  -4.130673669924625e-17,   7.903045487825025e-19,  -5.452681078096163e-04,   1.879765711837028e-05,  -4.860808829686106e-07,   1.117239289691281e-08,
  -2.407284971103946e-10,   4.979064895957825e-12,  -1.001148217610073e-13,   1.971761533161113e-15,  -3.822263374471960e-17,   7.314109159598489e-19,  -4.631591876201381e-04,
   1.596813148426522e-05,  -4.129516290405706e-07,   9.492643730366412e-09,  -2.045638561552150e-10,   4.231746863342619e-12,  -8.510417177772679e-14,   1.676476602592879e-15,
  -3.250606020189713e-17,   6.221791883831367e-19,  -3.558553671791266e-04,   1.226957086015926e-05,  -3.173344225371003e-07,   7.295559370688228e-09,  -1.572405007971572e-10,
   3.253344021404764e-12,  -6.544050409782995e-14,   1.289405207823934e-15,  -2.500707919764214e-17,   4.787745850596685e-19,  -2.396874138836817e-04,   8.264684829775703e-06,
  -2.137704817866872e-07,   4.915086721756753e-09,  -1.059467046960001e-10,   2.192360046748306e-12,  -4.410580793619445e-14,   8.691889584949936e-16,  -1.686054828091364e-17,
   3.228730632962392e-19,  -1.323475223507281e-04,   4.563640595581530e-06,  -1.180462736406505e-07,   2.714313406182594e-09,  -5.851205784243834e-11,   1.210887402555472e-12,
  -2.436275922821017e-14,   4.801628239638707e-16,  -9.315248696359676e-18,   1.784052573188236e-19,  -5.018759408712309e-05,   1.730603034190453e-06,  -4.476572231613648e-08,
   1.029348452488555e-09,  -2.219007286504284e-11,   4.592295966522141e-13,  -9.239897513382609e-15,   1.821149499104709e-16,  -3.533212052726843e-18,   6.767103556621966e-20,
  -5.722069344367747e-06,   1.973127304533361e-07,  -5.103926953408693e-09,   1.173607239543674e-10,  -2.530002231920534e-12,   5.235933955340294e-14,  -1.053498349548877e-15,
   2.076419124127196e-17,  -4.028488596156712e-19,   7.715757336992048e-21,  -5.159659514929761e-04,   1.663981252907998e-05,  -4.025088265268742e-07,   8.654295186000791e-09,
  -1.744334578388815e-10,   3.374937795861724e-12,  -6.347929083134632e-14,   1.169517030719402e-15,  -2.120808075106841e-17,   3.796801405453310e-19,  -4.770890989684310e-04,
   1.538661084139802e-05,  -3.722128906786150e-07,   8.003400230214493e-09,  -1.613261696818177e-10,   3.121608125154808e-12,  -5.872021445690660e-14,   1.081958131787077e-15,
  -1.962270997984425e-17,   3.513455936029765e-19,  -4.052433397892651e-04,   1.307030671574948e-05,  -3.162055232268013e-07,   6.799807570707721e-09,  -1.370817915618699e-10,
   2.652864173975356e-12,  -4.991082798280949e-14,   9.198074698942910e-16,  -1.668528420794095e-17,   2.988174599103493e-19,  -3.113544638252667e-04,   1.004275856023108e-05,
  -2.429819875569308e-07,   5.225742274049192e-09,  -1.053627807071001e-10,   2.039331885769573e-12,  -3.837447698888698e-14,   7.073409178303038e-16,  -1.283390875658500e-17,
   2.298973674211767e-19,  -2.097121711301478e-04,   6.764623415866176e-06,  -1.636794311215934e-07,   3.520503621406290e-09,  -7.098852809415376e-11,   1.374169658682521e-12,
  -2.586150361982594e-14,   4.767671175991616e-16,  -8.651870440103016e-18,   1.550121829690355e-19,  -1.157956895174445e-04,   3.735296789671364e-06,  -9.038421252679842e-08,
   1.944126385029012e-09,  -3.920426744921640e-11,   7.589536348071121e-13,  -1.428442044163670e-14,   2.633621454172102e-16,  -4.779687440614605e-18,   8.564498183061426e-20,
  -4.391089283500786e-05,   1.416477794634322e-06,  -3.427548521837701e-08,   7.372647984143197e-10,  -1.486763574836285e-11,   2.878292814704616e-13,  -5.417452415324871e-15,
   9.988497763507203e-17,  -1.812851602670074e-18,   3.248494785301261e-20,  -5.006438592434437e-06,   1.614980152106428e-07,  -3.907887809602838e-09,   8.405882121339413e-11,
  -1.695131112496284e-12,   3.281694927639023e-14,  -6.176756081045567e-16,   1.138853604162347e-17,  -2.066962604954092e-19,   3.703867469583813e-21,  -4.552499513628537e-04,
   1.379234447791409e-05,  -3.134161539908365e-07,   6.330472356893073e-09,  -1.198660323996710e-10,   2.178702960333670e-12,  -3.849768431172866e-14,   6.663225985891352e-16,
  -1.135173060651107e-17,   1.909368870893215e-19,  -4.209460669093204e-04,   1.275348400165425e-05,  -2.898218063568372e-07,   5.854225827594400e-09,  -1.108556663521636e-10,
   2.015083024108811e-12,  -3.560962731346967e-14,   6.163962887954862e-16,  -1.050231286157928e-17,   1.766708226798532e-19,  -3.575524234072450e-04,   1.083341602262114e-05,
  -2.462060527545360e-07,   4.973658936529154e-09,  -9.419135991090053e-11,   1.712381543689423e-12,  -3.026475994344390e-14,   5.239620390563658e-16,  -8.928994520730323e-18,
   1.502339071786661e-19,  -2.747107299015337e-04,   8.323884638837354e-06,  -1.891874589273387e-07,   3.822177536344510e-09,  -7.239280588234916e-11,   1.316262845201435e-12,
  -2.326726393042584e-14,   4.028859892352109e-16,  -6.867005793287897e-18,   1.155642547999969e-19,  -1.850297468428628e-04,   5.606753356959167e-06,  -1.274393961448258e-07,
   2.574866222516735e-09,  -4.877285400769934e-11,   8.868921698083982e-13,  -1.567925585118923e-14,   2.715318146631672e-16,  -4.628826354129257e-18,   7.791092295647524e-20,
  -1.021665682835957e-04,   3.095921487091586e-06,  -7.037155942392419e-08,   1.421892848172399e-09,  -2.693474354541374e-11,   4.898145901997361e-13,  -8.659968481750461e-15,
   1.499841270704551e-16,  -2.557012922269680e-18,   4.304290233213103e-20,  -3.874254223517578e-05,   1.174014515852904e-06,  -2.668617500977954e-08,   5.392163567620511e-10,
  -1.021450845966686e-11,   1.857574288293267e-13,  -3.284294081084172e-15,   5.688315607593970e-17,  -9.698071261397367e-19,   1.632561125877191e-20,  -4.417175425997507e-06,
   1.338537979465052e-07,  -3.042597430190565e-09,   6.147837616217265e-11,  -1.164603796604764e-12,   2.117915127490462e-14,  -3.744607166290277e-16,   6.485597749513922e-18,
  -1.105742562429841e-19,   1.861404110536803e-21  };
  static constexpr double wr[2100] = {   3.024144690149451e+00,  -6.266189624828302e-01,   1.015605621676995e-01,  -1.258256202306540e-02,   1.253392787780533e-03,
  -1.042389759731268e-04,   7.436832643841805e-06,  -4.644501158975023e-07,   2.578943991881156e-08,  -1.288992741891651e-09,   5.857428057755365e-11,  -2.440069807798834e-12,
   9.383268091889039e-14,  -3.347215027147579e-15,   3.035212477376047e+00,  -6.305335228362586e-01,   1.023300568910912e-01,  -1.268868705230605e-02,   1.264726339568559e-03,
  -1.052290927382282e-04,   7.510119215006419e-06,  -4.691598981905946e-07,   2.605702084846279e-08,  -1.302620374420246e-09,   5.920333502311503e-11,  -2.466625608491809e-12,
   9.486561502668938e-14,  -3.384428774220879e-15,   3.054808329835098e+00,  -6.374665834338372e-01,   1.036932350729814e-01,  -1.287672465354253e-02,   1.284810584060461e-03,
  -1.069838869535038e-04,   7.640018126147286e-06,  -4.775085528594378e-07,   2.653137221091437e-08,  -1.326780023196773e-09,   6.031860584305557e-11,  -2.513709322310434e-12,
   9.669708967695810e-14,  -3.450414013050286e-15,   3.078617667819402e+00,  -6.458941614951432e-01,   1.053508274460656e-01,  -1.310543295198163e-02,   1.309243793804961e-03,
  -1.091190045299807e-04,   7.798091630337296e-06,  -4.876691337185415e-07,   2.710872773538019e-08,  -1.356188270589637e-09,   6.167626133625460e-11,  -2.571029415681351e-12,
   9.892686397899875e-14,  -3.530753297459082e-15,   3.101850965798202e+00,  -6.541217988935821e-01,   1.069696830399655e-01,  -1.332885833001489e-02,   1.333117796210813e-03,
  -1.112056187432199e-04,   7.952596289276737e-06,  -4.976015058457312e-07,   2.767317302905421e-08,  -1.384941429249575e-09,   6.300377473761291e-11,  -2.627080637898727e-12,
   1.011074068262458e-13,  -3.609322865489754e-15,   3.120653394455704e+00,  -6.607831600504637e-01,   1.082807826834938e-01,  -1.350985324880041e-02,   1.352461620346376e-03,
  -1.128965507364866e-04,   8.077818244199899e-06,  -5.056522828222285e-07,   2.813073047976238e-08,  -1.408251458564461e-09,   6.408005471654649e-11,  -2.672526771739131e-12,
   1.028754751122675e-13,  -3.673033044222174e-15,   3.133119922504890e+00,  -6.652012124374974e-01,   1.091505571705475e-01,  -1.362994570744793e-02,   1.365298310360902e-03,
  -1.140187918365322e-04,   8.160933548341995e-06,  -5.109963531312444e-07,   2.843447518868364e-08,  -1.423726456245423e-09,   6.479460776651271e-11,  -2.702700221220335e-12,
   1.040494091041326e-13,  -3.715335759622882e-15,   3.139535162523364e+00,  -6.674751582086556e-01,   1.095982888194463e-01,  -1.369177210208915e-02,   1.371907497859090e-03,
  -1.145966360709694e-04,   8.203732182926357e-06,  -5.137483085415287e-07,   2.859089623560919e-08,  -1.431695970876200e-09,   6.516260844978421e-11,  -2.718240199022500e-12,
   1.046540243391085e-13,  -3.737123516583616e-15,   3.141770130360446e+00,  -6.682674330265067e-01,   1.097542950000123e-01,  -1.371331575868390e-02,   1.374210585086653e-03,
  -1.147980022880308e-04,   8.218646962384027e-06,  -5.147073504589195e-07,   2.864540913165093e-08,  -1.434473398187342e-09,   6.529086079915728e-11,  -2.723656119141625e-12,
   1.048647442126759e-13,  -3.744717033796618e-15,   3.142124887993047e+00,  -6.683931944657591e-01,   1.097790590630183e-01,  -1.371673559986322e-02,   1.374576181506692e-03,
  -1.148299678393096e-04,   8.221014602774806e-06,  -5.148595941366321e-07,   2.865406286052903e-08,  -1.434914306973430e-09,   6.531122058179897e-11,  -2.724515887777452e-12,
   1.048981957596470e-13,  -3.745922499618967e-15,   1.517704657618159e+00,  -1.892656099760022e-01,   2.452691573919226e-02,  -2.676308232401529e-03,   2.456661623597540e-04,
  -1.929975116808680e-05,   1.320413962996241e-06,  -7.985855187597683e-08,   4.323264843349384e-09,  -2.116920592415465e-10,   9.457958044985133e-12,  -3.884272642570143e-13,
   1.475697555083114e-14,  -5.209535279936400e-16,   1.520304628895340e+00,  -1.900874462296674e-01,   2.467649111080365e-02,  -2.695840392401560e-03,   2.476692694366128e-04,
  -1.946937478655119e-05,   1.332662849148956e-06,  -8.063010960290384e-08,   4.366379115306386e-09,  -2.138574224613297e-10,   9.556730672351842e-12,  -3.925544662876813e-13,
   1.491608287052068e-14,  -5.266409780812391e-16,   1.524905116234305e+00,  -1.915423105112211e-01,   2.494137026317005e-02,  -2.730438354707748e-03,   2.512181459119035e-04,
  -1.976994173393158e-05,   1.354370182815353e-06,  -8.199759758213680e-08,   4.442800329305013e-09,  -2.176958703986926e-10,   9.731831813516465e-12,  -3.998714470765813e-13,
   1.519817254123707e-14,  -5.367249812042687e-16,   1.530489950933446e+00,  -1.933096201128111e-01,   2.526329123991147e-02,  -2.772502301981337e-03,   2.555340495047043e-04,
  -2.013555145498925e-05,   1.380779680288648e-06,  -8.366154880208416e-08,   4.535800555055873e-09,  -2.223675240785248e-10,   9.944960786210638e-12,  -4.087781882336506e-13,
   1.554157493981675e-14,  -5.490014890184638e-16,   1.535934592144653e+00,  -1.950337749018989e-01,   2.557751551461801e-02,  -2.813576585088955e-03,   2.597496733100260e-04,
  -2.049275060935661e-05,   1.406586561762698e-06,  -8.528778626348456e-08,   4.626704803191676e-09,  -2.269343973060780e-10,   1.015332930329270e-11,  -4.174867058841430e-13,
   1.587735897765863e-14,  -5.610064055080342e-16,   1.540337240359849e+00,  -1.964288282205913e-01,   2.583187917062710e-02,  -2.846837583695686e-03,   2.631642922397874e-04,
  -2.078213927476062e-05,   1.427497799467053e-06,  -8.660570389317730e-08,   4.700382950623570e-09,  -2.306362234930981e-10,   1.032224331010678e-11,  -4.245467828437814e-13,
   1.614959959653992e-14,  -5.707400703697665e-16,   1.543254539088882e+00,  -1.973536477221238e-01,   2.600056143068190e-02,  -2.868900365979664e-03,   2.654297300251370e-04,
  -2.097416450837409e-05,   1.441375274012129e-06,  -8.748041225323634e-08,   4.749287665010875e-09,  -2.330935305129608e-10,   1.043437696215522e-11,  -4.292338703240067e-13,
   1.633034487042148e-14,  -5.772026867926741e-16,   1.544755223186459e+00,  -1.978295141544600e-01,   2.608737477751216e-02,  -2.880256847627667e-03,   2.665959665386927e-04,
  -2.107302731815152e-05,   1.448520524341935e-06,  -8.793081069677197e-08,   4.774470611861293e-09,  -2.343589486919985e-10,   1.049212360768692e-11,  -4.316477068217763e-13,
   1.642343078810153e-14,  -5.805310920143502e-16,   1.545277950271899e+00,  -1.979952916152294e-01,   2.611762075055619e-02,  -2.884213748814251e-03,   2.670023362325230e-04,
  -2.110747705913603e-05,   1.451010443442251e-06,  -8.808776629542192e-08,   4.783246612049541e-09,  -2.347999427518039e-10,   1.051224846471053e-11,  -4.324889475326660e-13,
   1.645587236878991e-14,  -5.816910950842730e-16,   1.545360918869954e+00,  -1.980216052343524e-01,   2.612242178493336e-02,  -2.884841852773813e-03,   2.670668428986089e-04,
  -2.111294564111939e-05,   1.451405699396226e-06,  -8.811268202598761e-08,   4.784639757531081e-09,  -2.348699487344492e-10,   1.051544321872050e-11,  -4.326224922804693e-13,
   1.646102240412021e-14,  -5.818752438497317e-16,   1.015888571864690e+00,  -7.572280209959800e-02,   7.279307983060724e-03,  -6.606435239855055e-04,   5.374779428660305e-05,
  -3.884613747085488e-06,   2.502221626188456e-07,  -1.446418358715203e-08,   7.561101586822294e-10,  -3.600911916307170e-11,   1.572970599242389e-12,  -6.340930331134749e-14,
   2.371727630393873e-15,  -8.262619008991378e-17,   1.016636059626866e+00,  -7.592240732003795e-02,   7.311685246081185e-03,  -6.645445594103733e-04,   5.412514185768629e-05,
  -3.915192154609743e-06,   2.523562301394601e-07,  -1.459501097649746e-08,   7.632614367807236e-10,  -3.636180104317691e-11,   1.588813999283996e-12,  -6.406276317262681e-14,
   2.396638759808357e-15,  -8.350806037428555e-17,   1.017957743732511e+00,  -7.627555178652479e-02,   7.368994094331400e-03,  -6.714519605121099e-04,   5.479347686033904e-05,
  -3.969362268821374e-06,   2.561374034237801e-07,  -1.482684478753008e-08,   7.759353572437477e-10,  -3.698690410574315e-11,   1.616897532837071e-12,  -6.522114616510413e-14,
   2.440801147818559e-15,  -8.507151902171850e-17,   1.019560603924138e+00,  -7.670418101616534e-02,   7.438598000433034e-03,  -6.798454363989361e-04,   5.560590857580975e-05,
  -4.035231391868821e-06,   2.607362816196868e-07,  -1.510886863264330e-08,   7.913555240161597e-10,  -3.774755866284405e-11,   1.651074736509456e-12,  -6.663101553847369e-14,
   2.494555736571716e-15,  -8.697470413520653e-17,   1.021121532037010e+00,  -7.712197071923713e-02,   7.506489148118413e-03,  -6.880367298037137e-04,   5.639909467761530e-05,
  -4.099560716704716e-06,   2.652287982314622e-07,  -1.538442686554469e-08,   8.064247396425038e-10,  -3.849100727577472e-11,   1.684482888892566e-12,  -6.800930281454987e-14,
   2.547110890012852e-15,  -8.883556843390891e-17,   1.022382515115738e+00,  -7.745974672061279e-02,   7.561412013247559e-03,  -6.946664793514192e-04,   5.704130442331362e-05,
  -4.151660227900937e-06,   2.688680510295592e-07,  -1.560768912051644e-08,   8.186359299471167e-10,  -3.909352944951373e-11,   1.711561157783272e-12,  -6.912654649296676e-14,
   2.589715622574410e-15,  -9.034421394864401e-17,   1.023217477423480e+00,  -7.768353699984105e-02,   7.597817286524942e-03,  -6.990624955278766e-04,   5.746725089378779e-05,
  -4.186222510636896e-06,   2.712826954587982e-07,  -1.575584360861757e-08,   8.267400479688391e-10,  -3.949343841729264e-11,   1.729535093558883e-12,  -6.986819730852885e-14,
   2.617999227256296e-15,  -9.134579525967199e-17,   1.023646805473248e+00,  -7.779864799773829e-02,   7.616548214388379e-03,  -7.013247685335333e-04,   5.768648615275738e-05,
  -4.204013996415783e-06,   2.725257962048721e-07,  -1.583212227548583e-08,   8.309128040802537e-10,  -3.969936035057512e-11,   1.738790706051250e-12,  -7.025012313888671e-14,
   2.632564865532764e-15,  -9.186161057386473e-17,   1.023796322270559e+00,  -7.783874275225673e-02,   7.623073275462289e-03,  -7.021129237423251e-04,   5.776287130482462e-05,
  -4.210213195968665e-06,   2.729589573737612e-07,  -1.585870272557897e-08,   8.323669080590220e-10,  -3.977112096126183e-11,   1.742016213498105e-12,  -7.038322371674191e-14,
   2.637641049742478e-15,  -9.204137681525800e-17,   1.023820052575105e+00,  -7.784510662995937e-02,   7.624108978283943e-03,  -7.022380287579974e-04,   5.777499629596201e-05,
  -4.211197242261122e-06,   2.730277172912502e-07,  -1.586292214753048e-08,   8.325977368855135e-10,  -3.978251254252891e-11,   1.742528247422616e-12,  -7.040435291541850e-14,
   2.638446878079916e-15,  -9.206991426169889e-17,   7.941363173314088e-01,  -3.889109117854037e-02,   2.720101543945838e-03,  -1.963826292715288e-04,   1.358491122408636e-05,
  -8.743201249328090e-07,   5.174853633653153e-08,  -2.808055518177962e-09,   1.398549777698645e-10,  -6.412844406291918e-12,   2.717769124654147e-13,  -1.068932385714708e-14,
   3.917614999066769e-16,  -1.341761045013699e-17,   7.944075610003745e-01,  -3.894939824866430e-02,   2.728182867767667e-03,  -1.972522927736714e-04,   1.366236843403518e-05,
  -8.802211335361409e-07,   5.214134913811531e-08,  -2.831260956280478e-09,   1.410864170836947e-10,  -6.472128889948077e-12,   2.743875324771151e-13,  -1.079521179747986e-14,
   3.957411751069986e-16,  -1.355678700723151e-17,   7.948868443661798e-01,  -3.905248968838523e-02,   2.742479032719161e-03,  -1.987914416484241e-04,   1.379950222082998e-05,
  -8.906714764983730e-07,   5.283715356361337e-08,  -2.872373080956370e-09,   1.432684307927959e-10,  -6.577189226967806e-12,   2.790143896970782e-13,  -1.098289561633846e-14,
   4.027955807182275e-16,  -1.380350846257666e-17,   7.954675428465643e-01,  -3.917750385636749e-02,   2.759828563227567e-03,  -2.006604842867500e-04,   1.396611117623685e-05,
  -9.033729847172142e-07,   5.368311092954983e-08,  -2.922369802059292e-09,   1.459225432571540e-10,  -6.705002336869163e-12,   2.846440916377341e-13,  -1.121128677908074e-14,
   4.113809391731374e-16,  -1.410380079316680e-17,   7.960324754767218e-01,  -3.929923805937427e-02,   2.776736778851944e-03,  -2.024832039637898e-04,   1.412867737038329e-05,
  -9.157715265826694e-07,   5.450916846948933e-08,  -2.971203731705995e-09,   1.485155058484946e-10,  -6.829893726332374e-12,   2.901459538285890e-13,  -1.143452090538679e-14,
   4.197733848556875e-16,  -1.439737404765551e-17,   7.964884399897370e-01,  -3.939757320949364e-02,   2.790404947525187e-03,  -2.039575179911976e-04,   1.426023169593650e-05,
  -9.258086176514576e-07,   5.517809308858795e-08,  -3.010757987673164e-09,   1.506161543356237e-10,  -6.931089066555635e-12,   2.946045398115325e-13,  -1.161544583016402e-14,
   4.265758997686480e-16,  -1.463535089009233e-17,   7.967901561124241e-01,  -3.946268265448281e-02,   2.799459760145682e-03,  -2.049346414370718e-04,   1.434745163548314e-05,
  -9.324650013851217e-07,   5.562180727590157e-08,  -3.036999965631013e-09,   1.520100165942746e-10,  -6.998244207043865e-12,   2.975636402724723e-13,  -1.173553341414954e-14,
   4.310913496140775e-16,  -1.479332782320462e-17,   7.969452327270395e-01,  -3.949616014375532e-02,   2.804117004481730e-03,  -2.054373466232769e-04,   1.439233346600280e-05,
  -9.358908258650252e-07,   5.585020275865772e-08,  -3.050509087504014e-09,   1.527276263088760e-10,  -7.032820552711253e-12,   2.990872924585890e-13,  -1.179737014631071e-14,
   4.334165936545621e-16,  -1.487468159187906e-17,   7.969992294248476e-01,  -3.950781877107173e-02,   2.805739142697791e-03,  -2.056124620712816e-04,   1.440796937584724e-05,
  -9.370844032485988e-07,   5.592978189375674e-08,  -3.055216258712362e-09,   1.529776830054555e-10,  -7.044869347278983e-12,   2.996182531329467e-13,  -1.181891944926779e-14,
   4.342269274541529e-16,  -1.490303339045921e-17,   7.970077989478163e-01,  -3.950966914242305e-02,   2.805996607912098e-03,  -2.056402573345920e-04,   1.441045126225586e-05,
  -9.372738639558845e-07,   5.594241399596877e-08,  -3.055963468824298e-09,   1.530173771465629e-10,  -7.046781998592403e-12,   2.997025396580953e-13,  -1.182234028376733e-14,
   4.343555643042046e-16,  -1.490753413441856e-17,   6.710584137501313e-01,  -2.385551770399041e-02,   1.253298495371580e-03,  -7.121183761133541e-05,   4.072229830950200e-06,
  -2.263206277759081e-07,   1.197866291398964e-08,  -5.968615813547081e-10,   2.783592521037379e-11,  -1.212511535218032e-12,   4.933646573241245e-14,  -1.877880132474859e-15,
   6.700451390603302e-17,  -2.244567319570921e-18,   6.711807136359772e-01,  -2.387633284740423e-02,   1.255689947486419e-03,  -7.143455208614250e-05,   4.090001127657057e-06,
  -2.275657565216078e-07,   1.205637404995459e-08,  -6.012271153172568e-10,   2.805853034086256e-11,  -1.222889428455853e-12,   4.978161428527460e-14,  -1.895546767663804e-15,
   6.765647304269339e-17,  -2.267017183670234e-18,   6.713967082552253e-01,  -2.391311428180470e-02,   1.259918050529867e-03,  -7.182850614463672e-05,   4.121449552369282e-06,
  -2.297699292870251e-07,   1.219398050100302e-08,  -6.089591603304514e-10,   2.845287450713749e-11,  -1.241276740842518e-12,   5.057042244916753e-14,  -1.926855722358323e-15,
   6.881198950939183e-17,  -2.306809993326898e-18,   6.716582234512852e-01,  -2.395768094888043e-02,   1.265044981384834e-03,  -7.230653879741589e-05,   4.159632346113774e-06,
  -2.324474169329667e-07,   1.236120313029165e-08,  -6.183584081631953e-10,   2.893237715455869e-11,  -1.263639758595020e-12,   5.152996460864346e-14,  -1.964947302985088e-15,
   7.021801804194888e-17,  -2.355235243502577e-18,   6.719124463567278e-01,  -2.400104011881380e-02,   1.270037090978163e-03,  -7.277234696528765e-05,   4.196862371846457e-06,
  -2.350594698888545e-07,   1.252440939039505e-08,  -6.275351343515455e-10,   2.940066303068462e-11,  -1.285484858417149e-12,   5.246747053854636e-14,  -2.002170323458847e-15,
   7.159218173286956e-17,  -2.402568788080079e-18,   6.721174951380778e-01,  -2.403603764093012e-02,   1.274069424615666e-03,  -7.314884777719796e-05,   4.226971411865296e-06,
  -2.371729019734263e-07,   1.265651125044942e-08,  -6.349652439261224e-10,   2.977991638339508e-11,  -1.303180406375807e-12,   5.322702751331288e-14,  -2.032332465783622e-15,
   7.270581861960115e-17,  -2.440932521038032e-18,   6.722531103567219e-01,  -2.405919670252882e-02,   1.276739195472942e-03,  -7.339824711179993e-05,   4.246924363767693e-06,
  -2.385739347274948e-07,   1.274410867327910e-08,  -6.398933209363569e-10,   3.003150647752643e-11,  -1.314921152669516e-12,   5.373104819375628e-14,  -2.052349399920367e-15,
   7.344494587651466e-17,  -2.466396771549251e-18,   6.723227932240976e-01,  -2.407110030640134e-02,   1.278111884670786e-03,  -7.352651587887263e-05,   4.257188951523621e-06,
  -2.392948307444306e-07,   1.278918922229586e-08,  -6.424298236617788e-10,   3.016101565000944e-11,  -1.320965414482499e-12,   5.399054363131864e-14,  -2.062655808812695e-15,
   7.382553219957692e-17,  -2.479509272157268e-18,   6.723470530313942e-01,  -2.407524510841832e-02,   1.278589922073351e-03,  -7.357119131637006e-05,   4.260764470518567e-06,
  -2.395459680977216e-07,   1.280489507324149e-08,  -6.433135850099080e-10,   3.020614121391965e-11,  -1.323071538351575e-12,   5.408096806667318e-14,  -2.066247313460858e-15,
   7.395815960352877e-17,  -2.484078839141971e-18,   6.723509030158462e-01,  -2.407590290946832e-02,   1.278665792389571e-03,  -7.357828213287055e-05,   4.261331990791819e-06,
  -2.395858307229535e-07,   1.280738809516930e-08,  -6.434538689068109e-10,   3.021330433299096e-11,  -1.323405863447609e-12,   5.409532215084771e-14,  -2.066817438346525e-15,
   7.397921338597245e-17,  -2.484804234430921e-18,   5.914876929892647e-01,  -1.640448871979255e-02,   6.788434534141444e-04,  -3.092730217983845e-05,   1.455256785509099e-06,
  -6.859758256087551e-08,   3.173781840325034e-09,  -1.420038333279695e-10,   6.080830936007553e-12,  -2.475440831626751e-13,   9.543416899173558e-15,  -3.478225976713097e-16,
   1.198048937524576e-17,  -3.898770432589416e-19,   5.915530314538792e-01,  -1.641342283713296e-02,   6.796884708541077e-04,  -3.099409655492305e-05,   1.459920638785585e-06,
  -6.889135655181594e-08,   3.190636619171719e-09,  -1.428896620223142e-10,   6.123667781755583e-12,  -2.494578240563190e-13,   9.622710828415745e-15,  -3.508812311035706e-16,
   1.209072377640508e-17,  -3.935982707828339e-19,   5.916683898169122e-01,  -1.642920293864118e-02,   6.811816981196446e-04,  -3.111218461617744e-05,   1.468169705844647e-06,
  -6.941116829397656e-08,   3.220470137853976e-09,  -1.444580610211798e-10,   6.199530618362963e-12,  -2.528476867785332e-13,   9.763190009757806e-15,  -3.563007515188258e-16,
   1.228606887396839e-17,  -4.001932859245561e-19,   5.918079977927163e-01,  -1.644831123145032e-02,   6.829910490492285e-04,  -3.125536805956923e-05,   1.478178101313209e-06,
  -7.004219642391815e-08,   3.256704122655324e-09,  -1.463637163207357e-10,   6.291737646694034e-12,  -2.569690391040872e-13,   9.934023158050691e-15,  -3.628925997231197e-16,
   1.252371007875404e-17,  -4.082173990745770e-19,   5.919436478126219e-01,  -1.646688937006279e-02,   6.847514439844289e-04,  -3.139477755510411e-05,   1.487929290873917e-06,
  -7.065737779146974e-08,   3.292046448211014e-09,  -1.482232865131140e-10,   6.381747535750562e-12,  -2.609934062494560e-13,   1.010087845763461e-14,  -3.693323269684860e-16,
   1.275590899128894e-17,  -4.160589501495743e-19,   5.920530125210757e-01,  -1.648187587166895e-02,   6.861724012684564e-04,  -3.150737812050468e-05,   1.495810018764353e-06,
  -7.115482111610632e-08,   3.320637790809164e-09,  -1.497282278234316e-10,   6.454615569894064e-12,  -2.642522303559594e-13,   1.023602366550300e-14,  -3.745491950650706e-16,
   1.294404489444557e-17,  -4.224133168106210e-19,   5.921253213245423e-01,  -1.649178858635849e-02,   6.871127207264797e-04,  -3.158192684198263e-05,   1.501029876154077e-06,
  -7.148443627137786e-08,   3.339589357481661e-09,  -1.507260516286399e-10,   6.502940871355852e-12,  -2.664138755287176e-13,   1.032568308802063e-14,  -3.780107038276281e-16,
   1.306889193116590e-17,  -4.266304972644564e-19,   5.921624685242296e-01,  -1.649688230464307e-02,   6.875960458531195e-04,  -3.162025585526606e-05,   1.503714367219126e-06,
  -7.165399238626878e-08,   3.349340146259023e-09,  -1.512395307955846e-10,   6.527812575295583e-12,  -2.675265471259008e-13,   1.037183839499423e-14,  -3.797927844168872e-16,
   1.313317117297999e-17,  -4.288019016885439e-19,   5.921754000446778e-01,  -1.649865570814570e-02,   6.877643394677534e-04,  -3.163360373743472e-05,   1.504649341486805e-06,
  -7.171305303383260e-08,   3.352736906253671e-09,  -1.514184190803519e-10,   6.536478061421968e-12,  -2.679142312111246e-13,   1.038792084845619e-14,  -3.804137600078557e-16,
   1.315557034212148e-17,  -4.295585843211683e-19,   5.921774521984653e-01,  -1.649893714603981e-02,   6.877910485698984e-04,  -3.163572220053146e-05,   1.504797738117431e-06,
  -7.172242728656178e-08,   3.353276063425271e-09,  -1.514468141264958e-10,   6.537853566119580e-12,  -2.679757707403943e-13,   1.039047375188490e-14,  -3.805123338205638e-16,
   1.315912602575271e-17,  -4.296787024400651e-19,   5.348293541947008e-01,  -1.214520753001980e-02,   4.126234331930576e-04,  -1.552090880247125e-05,   6.092983599587003e-07,
  -2.434159804233484e-08,   9.735582234442134e-10,  -3.847237833081325e-11,   1.485620300750465e-12,  -5.556078993360320e-14,   1.999061836588471e-15,  -6.887724219600183e-17,
   2.266041948148270e-18,  -7.101899944802202e-20,   5.348687419007195e-01,  -1.214965565467433e-02,   4.129741919871125e-04,  -1.554439559805814e-05,   6.107160299405894e-07,
  -2.442050325176554e-08,   9.776436443112745e-10,  -3.866980945055881e-11,   1.494538438208101e-12,  -5.593774773478038e-14,   2.013991218300212e-15,  -6.943216749309935e-17,
   2.285437608343927e-18,  -7.165721653201649e-20,   5.349382698337422e-01,  -1.215750992832927e-02,   4.135937712912709e-04,  -1.558589954329333e-05,   6.132222754670792e-07,
  -2.456005367206932e-08,   9.848717627130539e-10,  -3.901923027209145e-11,   1.510326643125635e-12,  -5.660525880193439e-14,   2.040433470496127e-15,  -7.041520049620377e-17,
   2.319801584445537e-18,  -7.278811275655166e-20,   5.350223910310293e-01,  -1.216701676684046e-02,   4.143440998962765e-04,  -1.563619095061961e-05,   6.162609595111484e-07,
  -2.472934792080153e-08,   9.936451151319620e-10,  -3.944354934683772e-11,   1.529506827498363e-12,  -5.741646077349945e-14,   2.072577224596792e-15,  -7.161049325413709e-17,
   2.361594359114834e-18,  -7.416373256192244e-20,   5.351041039887873e-01,  -1.217625566261694e-02,   4.150736877150772e-04,  -1.568512251551562e-05,   6.192193686518642e-07,
  -2.489427160508346e-08,   1.002196825385876e-09,  -3.985735711943661e-11,   1.548220033532739e-12,  -5.820820703403999e-14,   2.103959946292103e-15,  -7.277779790891280e-17,
   2.402417780805698e-18,  -7.550770428525676e-20,   5.351699664243050e-01,  -1.218370544288415e-02,   4.156622822962234e-04,  -1.572461978456524e-05,   6.216087338653984e-07,
  -2.502754556176249e-08,   1.009110897798822e-09,  -4.019207076077126e-11,   1.563362293016043e-12,  -5.884907946757259e-14,   2.129369522386607e-15,  -7.372315002487687e-17,
   2.435485612234053e-18,  -7.659653485454299e-20,   5.352135045627581e-01,  -1.218863157846531e-02,   4.160516309264961e-04,  -1.575075744108800e-05,   6.231905807025480e-07,
  -2.511581354433945e-08,   1.013691826121867e-09,  -4.041390889185216e-11,   1.573400989816151e-12,  -5.927405495640258e-14,   2.146222599029105e-15,  -7.435027061466103e-17,
   2.457425141455788e-18,  -7.731903240023611e-20,   5.352358688684715e-01,  -1.219116245358504e-02,   4.162517087909283e-04,  -1.576419231811894e-05,   6.240038627470703e-07,
  -2.516120622453920e-08,   1.016048140996638e-09,  -4.052803949307997e-11,   1.578566552954238e-12,  -5.949276447188131e-14,   2.154896944954144e-15,  -7.467308586974696e-17,
   2.468719687998396e-18,  -7.769100468302135e-20,   5.352436538279740e-01,  -1.219204351806894e-02,   4.163213682257218e-04,  -1.576887035211039e-05,   6.242870808566493e-07,
  -2.517701557610829e-08,   1.016868881714055e-09,  -4.056779653762021e-11,   1.580366101908455e-12,  -5.956896231146342e-14,   2.157919235865915e-15,  -7.478556561761073e-17,
   2.472655249180626e-18,  -7.782062210680948e-20,   5.352448892345724e-01,  -1.219218333895066e-02,   4.163324231921588e-04,  -1.576961278199629e-05,   6.243320306909900e-07,
  -2.517952477801115e-08,   1.016999150635119e-09,  -4.057410699287006e-11,   1.580651742834733e-12,  -5.958105737330448e-14,   2.158398979300790e-15,  -7.480342034876740e-17,
   2.473279977088104e-18,  -7.784119768696837e-20,   4.918646596996439e-01,  -9.453739954567643e-03,   2.721013737298294e-04,  -8.686097250406283e-06,   2.904076317838001e-07,
  -9.945210772651005e-09,   3.444193960703474e-10,  -1.194370456119134e-11,   4.110454252269775e-13,  -1.392303529495519e-14,   4.607376699531169e-16,  -1.480336537353565e-17,
   4.595811536246487e-19,  -1.372796431081167e-20,   4.918905028027382e-01,  -9.456216523690870e-03,   2.722675442202706e-04,  -8.695625963688912e-06,   2.909052996429456e-07,
  -9.969510778876910e-09,   3.455408492706242e-10,  -1.199281054133887e-11,   4.130868357375452e-13,  -1.400355777358290e-14,   4.637492019591911e-16,  -1.491011915921570e-17,
   4.631683500556728e-19,  -1.384219282990223e-20,   4.919361163702590e-01,  -9.460588683725903e-03,   2.725609854259970e-04,  -8.712458293736327e-06,   2.917847414012856e-07,
  -1.001246817239930e-08,   3.475240874597597e-10,  -1.207968286845817e-11,   4.166994146336916e-13,  -1.414609505537635e-14,   4.690814131933121e-16,  -1.509917792707303e-17,
   4.695223776946566e-19,  -1.404455870792510e-20,   4.919912949716472e-01,  -9.465879325879641e-03,   2.729162115480735e-04,  -8.732844166059372e-06,   2.928503901598950e-07,
  -1.006454877018172e-08,   3.499297860220046e-10,  -1.218511270438948e-11,   4.210856927991524e-13,  -1.431922893881089e-14,   4.755604943235725e-16,  -1.532896969389426e-17,
   4.772473981000356e-19,  -1.429064328748340e-20,   4.920448846541102e-01,  -9.471019351428708e-03,   2.732614719153024e-04,  -8.752668022807656e-06,   2.938872310752387e-07,
  -1.011525050954443e-08,   3.522731181600553e-10,  -1.228786422410264e-11,   4.253626255398636e-13,  -1.448811978410481e-14,   4.818831744774322e-16,  -1.555328737398991e-17,
   4.847904975476478e-19,  -1.453099001752938e-20,   4.920880724763185e-01,  -9.475162930446750e-03,   2.735399054613622e-04,  -8.768661979748680e-06,   2.947241674711858e-07,
  -1.015619770883200e-08,   3.541665658387872e-10,  -1.237092836501788e-11,   4.288215833421853e-13,  -1.462476213917932e-14,   4.870002928951098e-16,  -1.573488610144665e-17,
   4.908986005566447e-19,  -1.472565436315697e-20,   4.921166183870010e-01,  -9.477902325909799e-03,   2.737240346079740e-04,  -8.779242324659347e-06,   2.952780194960939e-07,
  -1.018330518436383e-08,   3.554205138533602e-10,  -1.242595741443579e-11,   4.311138349001743e-13,  -1.471534066745184e-14,   4.903932039758014e-16,  -1.585532093460911e-17,
   4.949501840817462e-19,  -1.485479784774217e-20,   4.921312806047496e-01,  -9.479309567359550e-03,   2.738186386776698e-04,  -8.784679497701159e-06,   2.955627026801360e-07,
  -1.019724174384772e-08,   3.560653406671273e-10,  -1.245426136745115e-11,   4.322930707261534e-13,  -1.476194620384863e-14,   4.921392233906035e-16,  -1.591730558417919e-17,
   4.970356560376181e-19,  -1.492127810264797e-20,   4.921363843262575e-01,  -9.479799439238710e-03,   2.738515736482828e-04,  -8.786572538488572e-06,   2.956618296780208e-07,
  -1.020209497208922e-08,   3.562899162832622e-10,  -1.246411981291696e-11,   4.327038420104759e-13,  -1.477818189080762e-14,   4.927475147103795e-16,  -1.593890151993266e-17,
   4.977622870608017e-19,  -1.494444248943913e-20,   4.921371942356737e-01,  -9.479877178416649e-03,   2.738568003143931e-04,  -8.786872965669075e-06,   2.956775616862060e-07,
  -1.020286523039149e-08,   3.563255598817040e-10,  -1.246568454465613e-11,   4.327690413075733e-13,  -1.478075894528068e-14,   4.928440693923544e-16,  -1.594232952391686e-17,
   4.978776296555221e-19,  -1.494811956145254e-20,   4.578378610413191e-01,  -7.627542827568060e-03,   1.903811961272418e-04,  -5.273541480359629e-06,   1.531710326713808e-07,
  -4.567490004246596e-09,   1.383148373358207e-10,  -4.222103831028847e-12,   1.290891282606246e-13,  -3.928630560190805e-15,   1.182682253321762e-16,  -3.500660357992127e-18,
   1.013229523659323e-19,  -2.852379721010530e-21,   4.578558844856793e-01,  -7.629041360334464e-03,   1.904684783007564e-04,  -5.277895450430191e-06,   1.533696896930643e-07,
  -4.576022179324307e-09,   1.386645075418855e-10,  -4.235859492069605e-12,   1.296094564702314e-13,  -3.947546459224856e-15,   1.189281530028916e-16,  -3.522719177587547e-18,
   1.020284599435368e-19,  -2.873933261305913e-21,   4.578876939249854e-01,  -7.631686553184009e-03,   1.906225809049257e-04,  -5.285584670591586e-06,   1.537206271940143e-07,
  -4.591099600348996e-09,   1.392826296415896e-10,  -4.260184116838759e-12,   1.305298764720324e-13,  -3.981017573331419e-15,   1.200962040054067e-16,  -3.561772382365967e-18,
   1.032777744554802e-19,  -2.912107634868798e-21,   4.579261698182749e-01,  -7.634886868769460e-03,   1.908090801365909e-04,  -5.294893774436676e-06,   1.541456744160646e-07,
  -4.609369398849352e-09,   1.400319885653502e-10,  -4.289687483314191e-12,   1.316467759235764e-13,  -4.021651366564341e-15,   1.215147744707399e-16,  -3.609218302672478e-18,
   1.047960423393894e-19,  -2.958512699650979e-21,   4.579635336816645e-01,  -7.637995482384943e-03,   1.909902946379886e-04,  -5.303942652317231e-06,   1.545590264377071e-07,
  -4.627145291371034e-09,   1.407614671974450e-10,  -4.318423074475493e-12,   1.327351561070014e-13,  -4.061266153781499e-15,   1.228983587909608e-16,  -3.655511592583827e-18,
   1.062779185255663e-19,  -3.003818553268430e-21,   4.579936422212842e-01,  -7.640501033621087e-03,   1.911363965023487e-04,  -5.311240747988818e-06,   1.548925366639546e-07,
  -4.641493951596883e-09,   1.413505717454316e-10,  -4.341639771564714e-12,   1.336148960584693e-13,  -4.093300169070085e-15,   1.240175992945066e-16,  -3.692972777211399e-18,
   1.074774266388135e-19,  -3.040500857236118e-21,   4.580135416680816e-01,  -7.642157290484252e-03,   1.912329957455149e-04,  -5.316067335023689e-06,   1.551131688248826e-07,
  -4.650989331054279e-09,   1.417405507944356e-10,  -4.357014153501978e-12,   1.341976625216744e-13,  -4.114526988548382e-15,   1.247594524329938e-16,  -3.717808889516382e-18,
   1.082728524163820e-19,  -3.064830460049757e-21,   4.580237623040523e-01,  -7.643008053549628e-03,   1.912826219437027e-04,  -5.318547298242768e-06,   1.552265527858411e-07,
  -4.655870009391670e-09,   1.419410433040041e-10,  -4.364919916164386e-12,   1.344973900678758e-13,  -4.125446348436425e-15,   1.251411355053165e-16,  -3.730588959233537e-18,
   1.086822129379342e-19,  -3.077352945400906e-21,   4.580273198998434e-01,  -7.643304200623115e-03,   1.912998976414202e-04,  -5.319410675984542e-06,   1.552660296613402e-07,
  -4.657569466578564e-09,   1.420108615433866e-10,  -4.367673227383864e-12,   1.346017845389966e-13,  -4.129249859173331e-15,   1.252740962955693e-16,  -3.735041249249856e-18,
   1.088248334777230e-19,  -3.081715984766021e-21,   4.580278844512621e-01,  -7.643351196566267e-03,   1.913026391918013e-04,  -5.319547691819768e-06,   1.552722946936899e-07,
  -4.657839179907251e-09,   1.420219423977684e-10,  -4.368110217747310e-12,   1.346183539019116e-13,  -4.129853562976887e-15,   1.252952006848009e-16,  -3.735747959642719e-18,
   1.088474719883319e-19,  -3.082408551501948e-21,   4.300239316899211e-01,  -6.321901929323278e-03,   1.392801056083815e-04,  -3.406440483204589e-06,   8.739767210126734e-08,
  -2.303955687986620e-09,   6.177462223176884e-11,  -1.674272578267397e-12,   4.565582429561725e-14,  -1.247250950605786e-15,   3.398351807861256e-17,  -9.191630033538505e-19,
   2.455977850845450e-20,  -6.448282935503647e-22,   4.300370888772508e-01,  -6.322867703112435e-03,   1.393297660908805e-04,  -3.408628803214510e-06,   8.748600108447774e-08,
  -2.307321212993977e-09,   6.189755153919682e-11,  -1.678611431252445e-12,   4.580433760730305e-14,  -1.252184715159958e-15,   3.414245948821388e-17,  -9.241196823232974e-19,
   2.470911859699085e-20,  -6.491640472642433e-22,   4.300603087866713e-01,  -6.324572331518694e-03,   1.394174335344835e-04,  -3.412492715002187e-06,   8.764200073058550e-08,
  -2.313266743802692e-09,   6.211478232670344e-11,  -1.686281087212376e-12,   4.606694300836261e-14,  -1.260911448310115e-15,   3.442367482460357e-17,  -9.328919552410764e-19,
   2.497348495952334e-20,  -6.568410409720110e-22,   4.300883931081436e-01,  -6.326634448496580e-03,   1.395235114556650e-04,  -3.417169412659700e-06,   8.783087914450696e-08,
  -2.320468109209527e-09,   6.237800670936077e-11,  -1.695578685251549e-12,   4.638543012284235e-14,  -1.271499837332878e-15,   3.476502346529570e-17,  -9.435441523151706e-19,
   2.529461850620289e-20,  -6.661694300855500e-22,   4.301156637525114e-01,  -6.328637219267382e-03,   1.396265629146668e-04,  -3.421714097059536e-06,   8.801449275618575e-08,
  -2.327471620120490e-09,   6.263411380894886e-11,  -1.704629154242639e-12,   4.669560050678017e-14,  -1.281816584384748e-15,   3.509776400628259e-17,  -9.539320388962390e-19,
   2.560790195695236e-20,  -6.752728480886519e-22,   4.301376375541596e-01,  -6.330251272940605e-03,   1.397096320666963e-04,  -3.425378554463186e-06,   8.816259150929791e-08,
  -2.333122563129383e-09,   6.284084194815243e-11,  -1.711937700071264e-12,   4.694617969350362e-14,  -1.290154717817449e-15,   3.536679628903975e-17,  -9.623341001362945e-19,
   2.586138049802907e-20,  -6.826406438874347e-22,   4.301521598631416e-01,  -6.331318128079480e-03,   1.397645482754182e-04,  -3.427801588931151e-06,   8.826054173878709e-08,
  -2.336861020544799e-09,   6.297764604172904e-11,  -1.716775691716376e-12,   4.711210622856738e-14,  -1.295677702477205e-15,   3.554504935193700e-17,  -9.679025799919231e-19,
   2.602941528207973e-20,  -6.875259422325176e-22,   4.301596185098678e-01,  -6.331866107377126e-03,   1.397927582945652e-04,  -3.429046436302390e-06,   8.831087147758219e-08,
  -2.338782263844674e-09,   6.304796396814302e-11,  -1.719262905396530e-12,   4.719742529040728e-14,  -1.298518136746247e-15,   3.563673991353862e-17,  -9.707673867829916e-19,
   2.611587668695312e-20,  -6.900399787098946e-22,   4.301622146789757e-01,  -6.332056852216250e-03,   1.398025783109872e-04,  -3.429479796971010e-06,   8.832839360124918e-08,
  -2.339451187828959e-09,   6.307244871868170e-11,  -1.720129028793240e-12,   4.722713855306602e-14,  -1.299507431923350e-15,   3.566867740825740e-17,  -9.717653258349739e-19,
   2.614599706352732e-20,  -6.909158411462974e-22,   4.301626266608987e-01,  -6.332087121537128e-03,   1.398041366722161e-04,  -3.429548569145853e-06,   8.833117432973999e-08,
  -2.339557347187819e-09,   6.307633458396460e-11,  -1.720266490872211e-12,   4.723185445456388e-14,  -1.299664450597092e-15,   3.567374657696640e-17,  -9.719237238107691e-19,
   2.615077802018824e-20,  -6.910548678257133e-22,   4.067354350178153e-01,  -5.350445389799180e-03,   1.054959213283765e-04,  -2.309577989587048e-06,   5.305318007991822e-08,
  -1.252573304906197e-09,   3.009541496264659e-11,  -7.317039942922063e-13,   1.793267187425821e-14,  -4.416546398537959e-16,   1.089810713535305e-17,  -2.685681160095328e-19,
   6.586405719638112e-21,  -1.600371063457031e-22,   4.067453856405221e-01,  -5.351099139758443e-03,   1.055260061037531e-04,  -2.310764615889225e-06,   5.309607151085748e-08,
  -1.254038235746235e-09,   3.014347016851596e-11,  -7.332321141826677e-13,   1.798001822102241e-14,  -4.430873306801466e-16,   1.094046582369578e-17,  -2.697906791570968e-19,
   6.620793816380889e-21,  -1.609772059053813e-22,   4.067629459932018e-01,  -5.352252965350481e-03,   1.055791109137298e-04,  -2.312859560805766e-06,   5.317180944574166e-08,
  -1.256625593796725e-09,   3.022836621538077e-11,  -7.359324723611029e-13,   1.806370830012614e-14,  -4.456205152167558e-16,   1.101538332981053e-17,  -2.719535704772836e-19,
   6.681647572580607e-21,  -1.626412318929923e-22,   4.067841841201841e-01,  -5.353648650110484e-03,   1.056433595111644e-04,  -2.315394708629226e-06,   5.326348698884148e-08,
  -1.259758461415941e-09,   3.033119735229606e-11,  -7.392045474904503e-13,   1.816515779661961e-14,  -4.486925160702317e-16,   1.110627326453504e-17,  -2.745786329026252e-19,
   6.755532397095942e-21,  -1.646622880439334e-22,   4.068048058753901e-01,  -5.355004045485443e-03,   1.057057662435825e-04,  -2.317857796469136e-06,   5.335258494225159e-08,
  -1.262804205796180e-09,   3.043120645365338e-11,  -7.423881267050903e-13,   1.826390612314973e-14,  -4.516840467778049e-16,   1.119482140831770e-17,  -2.771371528935833e-19,
   6.827573373207751e-21,  -1.666336409355887e-22,   4.068214214670258e-01,  -5.356096284735677e-03,   1.057560656081756e-04,  -2.319843469484056e-06,   5.342443208721532e-08,
  -1.265260982079464e-09,   3.051190337867369e-11,  -7.449578764992720e-13,   1.834364523945754e-14,  -4.541006527823976e-16,   1.126638000510101e-17,  -2.792055585226131e-19,
   6.885834888898062e-21,  -1.682284541173379e-22,   4.068324022104290e-01,  -5.356818188586461e-03,   1.057893149323068e-04,  -2.321156273099318e-06,   5.347194218972979e-08,
  -1.266885926963388e-09,   3.056529063685021e-11,  -7.466584219475508e-13,   1.839642799436846e-14,  -4.557007736711116e-16,   1.131377521742021e-17,  -2.805759038419449e-19,
   6.924444093952746e-21,  -1.692855751941675e-22,   4.068380417980774e-01,  -5.357188973842034e-03,   1.058063938873607e-04,  -2.321830679089400e-06,   5.349635166572001e-08,
  -1.267720893877012e-09,   3.059272740965638e-11,  -7.475325074882444e-13,   1.842356312411106e-14,  -4.565235250767695e-16,   1.133814916782818e-17,  -2.812807504616324e-19,
   6.944306161557098e-21,  -1.698294787965984e-22,   4.068400047799319e-01,  -5.357318037498438e-03,   1.058123389849192e-04,  -2.322065447067647e-06,   5.350484932174395e-08,
  -1.268011588199083e-09,   3.060228019312302e-11,  -7.478368642686155e-13,   1.843301232002084e-14,  -4.568100525853752e-16,   1.134663819993433e-17,  -2.815262554420792e-19,
   6.951224816487624e-21,  -1.700189521813664e-22,   4.068403162815229e-01,  -5.357338518524516e-03,   1.058132824190259e-04,  -2.322102703164642e-06,   5.350619786412127e-08,
  -1.268057721014022e-09,   3.060379623850479e-11,  -7.478851673529734e-13,   1.843451199407281e-14,  -4.568555282168508e-16,   1.134798555149054e-17,  -2.815652220909397e-19,
   6.952322972012471e-21,  -1.700490267277073e-22,   3.868647719758348e-01,  -4.604620279900462e-03,   8.215933213260977e-05,  -1.627906129385921e-06,   3.384889653492328e-08,
  -7.235097256996512e-10,   1.574171905520960e-11,  -3.467148591975285e-13,   7.703459632547230e-15,  -1.721369692472552e-16,   3.868765223638574e-01,  -4.605318939581516e-03,
   8.218842649067545e-05,  -1.628944620170646e-06,   3.388287063174741e-08,  -7.245602996202951e-10,   1.577294259313721e-11,  -3.476155935533406e-13,   7.728833008214032e-15,
  -1.728368666843951e-16,   3.868958155517494e-01,  -4.606466225096355e-03,   8.223621067525228e-05,  -1.630650557550059e-06,   3.393869306810987e-08,  -7.262869447412195e-10,
   1.582427467043475e-11,  -3.490969082307693e-13,   7.770576091492400e-15,  -1.739887412854892e-16,   3.869162912267723e-01,  -4.607684022300568e-03,   8.228694206431667e-05,
  -1.632462166982229e-06,   3.399799090926378e-08,  -7.281217128929038e-10,   1.587884212367470e-11,  -3.506722554171569e-13,   7.814989349447903e-15,  -1.752148915529648e-16,
   3.869324086684603e-01,  -4.608642752807496e-03,   8.232688870948569e-05,  -1.633888984135241e-06,   3.404470640054837e-08,  -7.295676165051358e-10,   1.592185961995624e-11,
  -3.519146425433223e-13,   7.850030331434522e-15,  -1.761827248268194e-16,   3.869417115532147e-01,  -4.609196182332118e-03,   8.234995103166106e-05,  -1.634712857818246e-06,
   3.407168599243194e-08,  -7.304028507786910e-10,   1.594671500608274e-11,  -3.526326844170190e-13,   7.870288307559888e-15,  -1.767424235977842e-16,   3.869452051046612e-01,
  -4.609404024707891e-03,   8.235861273833738e-05,  -1.635022311812753e-06,   3.408182072243078e-08,  -7.307166361382819e-10,   1.595605396434204e-11,  -3.529025122722824e-13,
   7.877902028062467e-15,  -1.769528124048730e-16,   3.869457842227278e-01,  -4.609438478827471e-03,   8.236004862332104e-05,  -1.635073612528098e-06,   3.408350089027482e-08,
  -7.307686582884258e-10,   1.595760232132333e-11,  -3.529472504454366e-13,   7.879164462157365e-15,  -1.769876987811491e-16,   3.696488175393644e-01,  -4.017259166281346e-03,
   6.545497549432024e-05,  -1.184421889605607e-06,   2.249338391273499e-08,  -4.391697012282497e-10,   8.729122291031974e-12,  -1.756692398033297e-13,   3.567285915602513e-15,
  -7.289748929244299e-17,   3.696581711020294e-01,  -4.017767046815598e-03,   6.547428796808739e-05,  -1.185051349765190e-06,   2.251218875029642e-08,  -4.397007688374141e-10,
   8.743540349799554e-12,  -1.760493671121859e-13,   3.577080979587359e-15,  -7.314504539858284e-17,   3.696735284930345e-01,  -4.018601010224683e-03,   6.550600418039540e-05,
  -1.186085259310526e-06,   2.254308228958587e-08,  -4.405734277364037e-10,   8.767238302529114e-12,  -1.766743308072911e-13,   3.593189895763853e-15,  -7.355230959394056e-17,
   3.696898265963226e-01,  -4.019486175406782e-03,   6.553967338913698e-05,  -1.187183063617027e-06,   2.257589312927164e-08,  -4.415005092664469e-10,   8.792422273018818e-12,
  -1.773387220618721e-13,   3.610321816064084e-15,  -7.398562045870709e-17,   3.697026552624069e-01,  -4.020182997396884e-03,   6.556618271972580e-05,  -1.188047582138658e-06,
   2.260173746697399e-08,  -4.422309412481666e-10,   8.812270181641476e-12,  -1.778625125791754e-13,   3.623833098198656e-15,  -7.432748873171469e-17,   3.697100597275758e-01,
  -4.020585224117443e-03,   6.558148637908267e-05,  -1.188546729569506e-06,   2.261666157841595e-08,  -4.426528143837974e-10,   8.823736030070269e-12,  -1.781651680040125e-13,
   3.631642112347635e-15,  -7.452512902772140e-17,   3.697128403274259e-01,  -4.020736278830903e-03,   6.558723392622474e-05,  -1.188734205401676e-06,   2.262226740203700e-08,
  -4.428112936978223e-10,   8.828043694596645e-12,  -1.782788872964980e-13,   3.634576629434377e-15,  -7.459940952609390e-17,   3.697133012595419e-01,  -4.020761319081064e-03,
   6.558818671038098e-05,  -1.188765284368076e-06,   2.262319673573324e-08,  -4.428375671713241e-10,   8.828757863758326e-12,  -1.782977415473841e-13,   3.635063181359731e-15,
  -7.461172599163223e-17,   3.545448858238568e-01,  -3.544954454506658e-03,   5.314422615281722e-05,  -8.848798916587361e-07,   1.546425221993114e-08,  -2.778657934729088e-10,
   5.083190212787982e-12,  -9.415971208615717e-14,   1.760219605475605e-15,  -3.312218107069765e-17,   3.545524753164577e-01,  -3.545333635195558e-03,   5.315749221162731e-05,
  -8.852777167127386e-07,   1.547518729749138e-08,  -2.781499432678755e-10,   5.090288991952404e-12,  -9.433196103568060e-14,   1.764305898846690e-15,  -3.321732929095503e-17,
   3.545649360717429e-01,  -3.545956245005318e-03,   5.317927737030945e-05,  -8.859311043657052e-07,   1.549314999547965e-08,  -2.786167948928367e-10,   5.101954614242154e-12,
  -9.461509002264695e-14,   1.771024383953764e-15,  -3.337381204399573e-17,   3.545781597652092e-01,  -3.546617049819329e-03,   5.320240232064426e-05,  -8.866247981939835e-07,
   1.551222476433918e-08,  -2.791126689321987e-10,   5.114348831835639e-12,  -9.491599407911995e-14,   1.778167061571799e-15,  -3.354023560959336e-17,   3.545885682350147e-01,
  -3.547137228129691e-03,   5.322060845170247e-05,  -8.871710279585906e-07,   1.552724754562638e-08,  -2.795032928239034e-10,   5.124114809096378e-12,  -9.515315681878286e-14,
   1.783798426269610e-15,  -3.367148981501831e-17,   3.545945757091480e-01,  -3.547437481900444e-03,   5.323111824204558e-05,  -8.874863837683824e-07,   1.553592183347822e-08,
  -2.797288772997584e-10,   5.129755624801930e-12,  -9.529016838636576e-14,   1.787052426455538e-15,  -3.374735077392383e-17,   3.545968316780067e-01,  -3.547550239382685e-03,
   5.323506527875496e-05,  -8.876048249296574e-07,   1.553917993676485e-08,  -2.798136144604713e-10,   5.131874692120386e-12,  -9.534164413084741e-14,   1.788275098098808e-15,
  -3.377585842919431e-17,   3.545972056425485e-01,  -3.547568931035028e-03,   5.323571958327931e-05,  -8.876244594039560e-07,   1.553972005738910e-08,  -2.798276623324081e-10,
   5.132226004556462e-12,  -9.535017837276292e-14,   1.788477813649636e-15,  -3.378058509526563e-17,   3.411535555053952e-01,  -3.158451924318469e-03,   4.384611430137924e-05,
  -6.760763867348111e-07,   1.094212337694866e-08,  -1.820933076532586e-10,   3.085368356119352e-12,  -5.293887962224902e-14,   9.167419598034054e-16,  -1.598211920363133e-17,
   3.411598139940814e-01,  -3.158741476751532e-03,   4.385549475481436e-05,  -6.763368670480506e-07,   1.094875333214349e-08,  -1.822528405600422e-10,   3.089059103679822e-12,
  -5.302181511299977e-14,   9.185642505945898e-16,  -1.602143129408094e-17,   3.411700892873615e-01,  -3.159216904640574e-03,   4.387089839339476e-05,  -6.767646522981612e-07,
   1.095964319149466e-08,  -1.825149194867513e-10,   3.095123333894521e-12,  -5.315811347069315e-14,   9.215597279030481e-16,  -1.608606836343357e-17,   3.411809934879466e-01,
  -3.159721480096264e-03,   4.388724842704942e-05,  -6.772187894020958e-07,   1.097120594551266e-08,  -1.827932500792688e-10,   3.101565120511612e-12,  -5.330293563897016e-14,
   9.247434568688599e-16,  -1.615478926646990e-17,   3.411895761072074e-01,  -3.160118663094817e-03,   4.390012003296782e-05,  -6.775763598735349e-07,   1.098031152408147e-08,
  -1.830124749499242e-10,   3.106640036345076e-12,  -5.341705574434239e-14,   9.272529077837573e-16,  -1.620897157827435e-17,   3.411945296879266e-01,  -3.160347917030262e-03,
   4.390755010979067e-05,  -6.777827858227566e-07,   1.098556878963642e-08,  -1.831390649981648e-10,   3.109570953895472e-12,  -5.348297458347443e-14,   9.287027016879407e-16,
  -1.624028082278677e-17,   3.411963898792026e-01,  -3.160434010185509e-03,   4.391034048403441e-05,  -6.778603131154107e-07,   1.098754337207512e-08,  -1.831866142619566e-10,
   3.110671936742391e-12,  -5.350773871209168e-14,   9.292474051228938e-16,  -1.625204524097416e-17,   3.411966982363557e-01,  -3.160448281676061e-03,   4.391080304467751e-05,
  -6.778731650226248e-07,   1.098787070990472e-08,  -1.831944969422905e-10,   3.110854461206966e-12,  -5.351184429864280e-14,   9.293377128918480e-16,  -1.625399575672037e-17,
   3.291737708312343e-01,  -2.837411342926505e-03,   3.667524556742147e-05,  -5.265644862071177e-07,   7.935807109153528e-09,  -1.229807215895990e-10,   1.940544791770852e-12,
  -3.100883987267893e-14,   5.001195222317046e-16,  -8.121191486137919e-18,   3.291790036622585e-01,  -2.837636766151696e-03,   3.668204512637154e-05,  -5.267402855133139e-07,
   7.939973326106808e-09,  -1.230740633380837e-10,   1.942555464731977e-12,  -3.105091056370678e-14,   5.009802940622030e-16,  -8.138485273606396e-18,   3.291875949047252e-01,
  -2.838006889302211e-03,   3.669321028196700e-05,  -5.270289848251615e-07,   7.946815957462837e-09,  -1.232273901066506e-10,   1.945858798102106e-12,  -3.112004073875513e-14,
   5.023949838468208e-16,  -8.166913936965769e-18,   3.291967118332246e-01,  -2.838399692582817e-03,   3.670506088136495e-05,  -5.273354480401886e-07,   7.954080749765357e-09,
  -1.233902056600076e-10,   1.949367274474543e-12,  -3.119348070162368e-14,   5.038982470466711e-16,  -8.197130806946860e-18,   3.292038875963337e-01,  -2.838708884428792e-03,
   3.671438990492931e-05,  -5.275767310404976e-07,   7.959801244941536e-09,  -1.235184321972144e-10,   1.952130916183102e-12,  -3.125134175519662e-14,   5.050828945603108e-16,
  -8.220949240608300e-18,   3.292080291471589e-01,  -2.838887346579062e-03,   3.671977488511331e-05,  -5.277160182080610e-07,   7.963103883907510e-09,  -1.235924702719303e-10,
   1.953726851542013e-12,  -3.128475994149594e-14,   5.057672083184193e-16,  -8.234710411932599e-18,   3.292095843931542e-01,  -2.838954364953428e-03,   3.672179719121521e-05,
  -5.277683291142011e-07,   7.964344290103863e-09,  -1.236202791181421e-10,   1.954326327144622e-12,  -3.129731361375202e-14,   5.060242941828581e-16,  -8.239880722240245e-18,
   3.292098422002079e-01,  -2.838965474422584e-03,   3.672213242755422e-05,  -5.277770007749864e-07,   7.964549917448785e-09,  -1.236248891919217e-10,   1.954425708621047e-12,
  -3.129939481847912e-14,   5.060669161370959e-16,  -8.240737925769800e-18,   3.183737304510803e-01,  -2.567297769068306e-03,   3.104460363095305e-05,  -4.170038202810534e-07,
   5.879914849919436e-09,  -8.525591663908842e-11,   1.258736690951254e-12,  -1.882074497228799e-14,   2.840415739488403e-16,  -4.316351472520272e-18,   3.183781584534471e-01,
  -2.567476227606660e-03,   3.104963946864303e-05,  -4.171256239353732e-07,   5.882615324813925e-09,  -8.531251883960662e-11,   1.259877367994571e-12,  -1.884307404420704e-14,
   2.844689963406895e-16,  -4.324386229069942e-18,   3.183854282566270e-01,  -2.567769233885959e-03,   3.105790828238137e-05,  -4.173256427217889e-07,   5.887050356190360e-09,
  -8.540548888738934e-11,   1.261751208988364e-12,  -1.887976069946901e-14,   2.851713716673958e-16,  -4.337592076624097e-18,   3.183931427874236e-01,  -2.568080187452164e-03,
   3.106668440473764e-05,  -4.175379574783951e-07,   5.891758666831150e-09,  -8.550420307554753e-11,   1.263741178715585e-12,  -1.891872870384788e-14,   2.859175879296893e-16,
  -4.351625582088551e-18,   3.183992146762165e-01,  -2.568324946663189e-03,   3.107359290455175e-05,  -4.177051077919920e-07,   5.895465870239838e-09,  -8.558193931648406e-11,
   1.265308512298367e-12,  -1.894942616861914e-14,   2.865055465851777e-16,  -4.362685305145814e-18,   3.184027190874396e-01,  -2.568466216872344e-03,   3.107758059460299e-05,
  -4.178015965562895e-07,   5.897606066846774e-09,  -8.562682153340433e-11,   1.266213539256928e-12,  -1.896715408525976e-14,   2.868451428400809e-16,  -4.369074218573154e-18,
   3.184040350675401e-01,  -2.568519268053892e-03,   3.107907813658258e-05,  -4.178378334042632e-07,   5.898409863732668e-09,  -8.564367886566734e-11,   1.266553478169316e-12,
  -1.897381332733128e-14,   2.869727163917240e-16,  -4.371474478606785e-18,   3.184042532121275e-01,  -2.568528062195014e-03,   3.107932638218076e-05,  -4.178438404103997e-07,
   5.898543111524553e-09,  -8.564647340043746e-11,   1.266609832779391e-12,  -1.897491730985281e-14,   2.869938662662980e-16,  -4.371872417250392e-18,   3.085716602080557e-01,
  -2.337477531911292e-03,   2.655362884725286e-05,  -3.350871075865874e-07,   4.438966644367255e-09,  -6.047025005945484e-11,   8.388258304899497e-13,  -1.178438002271056e-14,
   1.671084367285043e-16,  -2.386192829805822e-18,   3.085754466271543e-01,  -2.337620893119095e-03,   2.655742922682567e-05,  -3.351734603799258e-07,   4.440765181565554e-09,
  -6.050566439051867e-11,   8.394962992479748e-13,  -1.179670995575981e-14,   1.673301677131499e-16,  -2.390108849240435e-18,   3.085816630396326e-01,  -2.337856270467079e-03,
   2.656366927764423e-05,  -3.353152589786729e-07,   4.443718808446553e-09,  -6.056382944980497e-11,   8.405976226667272e-13,  -1.181696608786146e-14,   1.676944918500824e-16,
  -2.396544291420699e-18,   3.085882596675725e-01,  -2.338106060352238e-03,   2.657029196647269e-05,  -3.354657678915360e-07,   4.446854244770301e-09,  -6.062558338297351e-11,
   8.417670828597795e-13,  -1.183847920006233e-14,   1.680814988807579e-16,  -2.403381856398294e-18,   3.085934516350022e-01,  -2.338302672611478e-03,   2.657550515285321e-05,
  -3.355842551499045e-07,   4.449322870889808e-09,  -6.067421035591502e-11,   8.426880851496971e-13,  -1.185542447201182e-14,   1.683863877513384e-16,  -2.408769624833527e-18,
   3.085964481759085e-01,  -2.338416151937745e-03,   2.657851422386652e-05,  -3.356526508793852e-07,   4.450747972808206e-09,  -6.070228448093902e-11,   8.432198666367177e-13,
  -1.186520967136415e-14,   1.685624703575702e-16,  -2.411881646680505e-18,   3.085975734361104e-01,  -2.338458766546842e-03,   2.657964424298069e-05,  -3.356783368811203e-07,
   4.451283190168653e-09,  -6.071282858828376e-11,   8.434196037188462e-13,  -1.186888519854894e-14,   1.686286148165913e-16,  -2.413050740196461e-18,   3.085977599656411e-01,
  -2.338465830633455e-03,   2.657983156420401e-05,  -3.356825948473493e-07,   4.451371914191740e-09,  -6.071457653021989e-11,   8.434527155236592e-13,  -1.186949452717256e-14,
   1.686395804574370e-16,  -2.413244560478349e-18  };
  static constexpr double wi[2100] = {  -6.906815907228211e-01,   2.180794453331496e-01,  -4.031912415818258e-02,   5.350515334613277e-03,  -5.564330600186781e-04,
   4.767401187869151e-05,  -3.476555217397576e-06,   2.208042805553890e-07,  -1.242537613023482e-08,   6.278226035373683e-10,  -2.878794166794400e-11,   1.208401351470341e-12,
  -4.677247998558838e-14,   1.677885503263519e-15,  -6.584369136666083e-01,   2.079772536964716e-01,  -3.846113721867668e-02,   5.104872682102673e-03,  -5.309589060143147e-04,
   4.549622751758588e-05,  -3.318023497155504e-06,   2.107501363108089e-07,  -1.186028224788180e-08,   5.992992334559754e-10,  -2.748119944124616e-11,   1.153591808259737e-12,
  -4.465244997640117e-14,   1.601878281187956e-15,  -5.965598938006654e-01,   1.885582907136588e-01,  -3.488551906429085e-02,   4.631754804457808e-03,  -4.818642259284025e-04,
   4.129709193263137e-05,  -3.012228527843250e-06,   1.913502881816751e-07,  -1.076962015412848e-08,   5.442350324691748e-10,  -2.495804687822925e-11,   1.047743540161182e-12,
  -4.055763273524006e-14,   1.455051682859617e-15,  -5.103339803288222e-01,   1.614340307594374e-01,  -2.988320562199228e-02,   3.969108909921490e-03,  -4.130438317421167e-04,
   3.540686465985711e-05,  -2.583052900462002e-06,   1.641111018923852e-07,  -9.237665553311801e-09,   4.668671340068386e-10,  -2.141194055312422e-11,   8.989467615237326e-13,
  -3.480014010297331e-14,   1.248569640786791e-15,  -4.076207937594121e-01,   1.290429131902247e-01,  -2.389960780138009e-02,   3.175530589959780e-03,  -3.305514546089876e-04,
   2.834154625415772e-05,  -2.067968949292689e-06,   1.314043915977462e-07,  -7.397505149242667e-09,   3.739036476537278e-10,  -1.714982437438830e-11,   7.200621301344528e-13,
  -2.787695634545786e-14,   1.000235267435776e-15,  -2.983576260953730e-01,   9.451168248500499e-02,  -1.751145028864438e-02,   2.327424634139708e-03,  -2.423227929533075e-04,
   2.078037351269069e-05,  -1.516469270485520e-06,   9.637147465572158e-08,  -5.425813312702580e-09,   2.742672791650971e-10,  -1.258067096063480e-11,   5.282506080939473e-13,
  -2.045210927001956e-14,   7.338629411255974e-16,  -1.935520965498569e-01,   6.133726860246898e-02,  -1.136788251804396e-02,   1.511183961164563e-03,  -1.573617114081388e-04,
   1.349606795852556e-05,  -9.849787610577677e-07,   6.259995390276621e-08,  -3.524660540244362e-09,   1.781760370028831e-10,  -8.173324222331467e-12,   3.432037100347401e-13,
  -1.328816513633984e-14,   4.768206510149622e-16,  -1.039464756001871e-01,   3.294789437360719e-02,  -6.107219742626735e-03,   8.119409987654257e-04,  -8.455485149095166e-05,
   7.252235058739820e-06,  -5.293118735359333e-07,   3.364149654010734e-08,  -1.894228602326127e-09,   9.575822593292677e-11,  -4.392740783416631e-12,   1.844580247471478e-13,
  -7.141973767727511e-15,   2.562801944563039e-16,  -3.869687726021341e-02,   1.226663893145214e-02,  -2.273854037248794e-03,   3.023141790139034e-04,  -3.148355860308730e-05,
   2.700386332951689e-06,  -1.970936682456063e-07,   1.252685608101867e-08,  -7.053488593699499e-10,   3.565756957608505e-11,  -1.635741671774972e-12,   6.868781958995926e-14,
  -2.659518945332078e-15,   9.543380300153488e-17,  -4.371392202115665e-03,   1.385716776077296e-03,  -2.568708520367133e-04,   3.415176401128905e-05,  -3.556642566674473e-06,
   3.050588969133959e-07,  -2.226545519591373e-08,   1.415148140131523e-09,  -7.968279264753571e-11,   4.028217962487098e-12,  -1.847891618431425e-13,   7.759647443836755e-15,
  -3.004455457605762e-16,   1.078115486583340e-17,  -2.023830970669096e-01,   5.190200386768651e-02,  -8.495290327455265e-03,   1.041589971328235e-03,  -1.024882905580931e-04,
   8.429673155430859e-06,  -5.957591051646888e-07,   3.691159185694691e-08,  -2.035808925919565e-09,   1.011690935754273e-10,  -4.574629893922928e-12,   1.897525256152833e-13,
  -7.269585366401170e-15,   2.584673365791934e-16,  -1.928195385050544e-01,   4.947532501809445e-02,  -8.101024659010178e-03,   9.935054361236081e-04,  -9.777554636810345e-05,
   8.043217967351705e-06,  -5.685117205560858e-07,   3.522666128128667e-08,  -1.943025773925250e-09,   9.656435341218039e-11,  -4.366647975909803e-12,   1.811338906532879e-13,
  -6.939673977844517e-15,   2.467460352618314e-16,  -1.745154720242368e-01,   4.482007233141094e-02,  -7.343455056765718e-03,   9.010050493225630e-04,  -8.870178214605710e-05,
   7.298655096611818e-06,  -5.159880568592542e-07,   3.197731196125623e-08,  -1.764033109014357e-09,   8.767851832971150e-11,  -3.965202562614226e-12,   1.644947073900566e-13,
  -6.302627393444164e-15,   2.241089774590401e-16,  -1.491019372487943e-01,   3.833587531810257e-02,  -6.285884382048174e-03,   7.716665134213342e-04,  -7.599925750218867e-05,
   6.255373226230762e-06,  -4.423386724442716e-07,   2.741837172800725e-08,  -1.512780080163152e-09,   7.520040764379064e-11,  -3.401272631431833e-12,   1.411139926247378e-13,
  -5.407247625426862e-15,   1.922851446547735e-16,  -1.189465144469897e-01,   3.061552413815851e-02,  -5.023711533710659e-03,   6.170443399464816e-04,  -6.079454384955234e-05,
   5.005381783503124e-06,  -3.540300153854746e-07,   2.194867464561404e-08,  -1.211181816697174e-09,   6.021568241686218e-11,  -2.723818666984905e-12,   1.130179469642479e-13,
  -4.331005829549011e-15,   1.540241995855859e-16,  -8.697690468085809e-02,   2.240628178609926e-02,  -3.678842429259580e-03,   4.520495570968543e-04,  -4.455222355524454e-05,
   3.668978367602204e-06,  -2.595548247723812e-07,   1.609394782451282e-08,  -8.882132023273703e-10,   4.416337427538157e-11,  -1.997876946918106e-12,   8.290304145357309e-14,
  -3.177166609349662e-15,   1.129964455232515e-16,  -5.638739508935811e-02,   1.453435387164473e-02,  -2.387302124190497e-03,   2.934289017478601e-04,  -2.892512038700979e-05,
   2.382422866042884e-06,  -1.685606380836784e-07,   1.045279901338811e-08,  -5.769291749631698e-10,   2.868778206193251e-11,  -1.297861659844061e-12,   5.385816078346129e-14,
  -2.064142040488860e-15,   7.341428219768163e-17,  -3.027254506621718e-02,   7.805302833559786e-03,  -1.282297219489579e-03,   1.576325990355779e-04,  -1.554046122929197e-05,
   1.280095498879476e-06,  -9.057472563841717e-08,   5.617013444236045e-09,  -3.100369321020870e-10,   1.541711055243857e-11,  -6.975047880637642e-13,   2.894551384614929e-14,
  -1.109376132866334e-15,   3.945736560682002e-17,  -1.126846210749610e-02,   2.905692777476156e-03,  -4.773962404482291e-04,   5.868915164578652e-05,  -5.786174790518050e-06,
   4.766308100461264e-07,  -3.372533513754942e-08,   2.091521628377942e-09,  -1.154453934387483e-10,   5.740786664860336e-12,  -2.597287686101523e-13,   1.077849030650984e-14,
  -4.131034201264260e-16,   1.469301562087275e-17,  -1.272918210232158e-03,   3.282407989047670e-04,  -5.392953527828097e-05,   6.629929742817585e-06,  -6.536498374144363e-07,
   5.384404022400907e-08,  -3.809897656913660e-09,   2.362765435626266e-10,  -1.304174947995611e-11,   6.485321127570482e-13,  -2.934140043233741e-14,   1.217641163802352e-15,
  -4.666816236310215e-17,   1.659867062362099e-18,  -7.873271503782150e-02,   1.515073280452205e-02,  -2.072681555499496e-03,   2.258997686379969e-04,  -2.048964151441137e-05,
   1.588903635691775e-06,  -1.074377855976345e-07,   6.432519574649783e-09,  -3.452577391886575e-10,   1.678290453795433e-11,  -7.451641812216240e-13,   3.043924557939829e-14,
  -1.151067634697490e-15,   4.047065247413812e-17,  -7.497030191403802e-02,   1.443487570480583e-02,  -1.975640544764363e-03,   2.153969483183393e-04,  -1.954205575392894e-05,
   1.515721362900270e-06,  -1.025052178904397e-07,   6.137951972176556e-09,  -3.294800558007022e-10,   1.601727218906771e-11,  -7.112188824383542e-13,   2.905430563103076e-14,
  -1.098750646299331e-15,   3.863289405087853e-17,  -6.778663834560220e-02,   1.306472989287286e-02,  -1.789535793561991e-03,   1.952239939565163e-04,  -1.771989436823255e-05,
   1.374869067513297e-06,  -9.300491943177133e-08,   5.570284399098123e-09,  -2.990605845904948e-10,   1.454056813844468e-11,  -6.457264749178171e-13,   2.638154843003803e-14,
  -9.977621449779429e-16,   3.508472191159960e-17,  -5.784640354502604e-02,   1.116233424852134e-02,  -1.530421697747085e-03,   1.670777366521506e-04,  -1.517343703529127e-05,
   1.177784906709418e-06,  -7.969892764814938e-08,   4.774598872305781e-09,  -2.563954272199578e-10,   1.246831995060276e-11,  -5.537812622400419e-13,   2.262785536256490e-14,
  -8.558860024875994e-16,   3.009861413586718e-17,  -4.609389169156945e-02,   8.904885563052708e-03,  -1.222045105360494e-03,   1.335054396829688e-04,  -1.213092075282957e-05,
   9.420009686009758e-07,  -6.376389455316248e-08,   3.820922824192619e-09,  -2.052248791050586e-10,   9.981607181188460e-12,  -4.433958891379076e-13,   1.811958939915785e-14,
  -6.854330549604123e-16,   2.410647847957617e-17,  -3.367379520762217e-02,   6.511549769337406e-03,  -8.942663913222015e-04,   9.775137480836684e-05,  -8.885906136216813e-06,
   6.902399304356372e-07,  -4.673404514304109e-08,   2.801006838101187e-09,  -1.504688868332520e-10,   7.319400297552263e-12,  -3.251737256248783e-13,   1.328964653649812e-14,
  -5.027655302995823e-16,   1.768335964478279e-17,  -2.181743520583439e-02,   4.221481457468014e-03,  -5.800439268202893e-04,   6.342753244592227e-05,  -5.767371117300723e-06,
   4.480938229999727e-07,  -3.034411971929750e-08,   1.818916842749856e-09,  -9.772191698621635e-11,   4.753999722733288e-12,  -2.112181261477987e-13,   8.632892639650569e-15,
  -3.266116551518539e-16,   1.148817568690953e-17,  -1.170937783628728e-02,   2.266381512000800e-03,  -3.114859833821354e-04,   3.406732039584710e-05,  -3.098134019682673e-06,
   2.407347400726736e-07,  -1.630352058548966e-08,   9.773478477600177e-10,  -5.251122688781345e-11,   2.554694674929395e-12,  -1.135082616278075e-13,   4.639450501450184e-15,
  -1.755309914637543e-16,   6.174239819135581e-18,  -4.358147626192168e-03,   8.436244497423417e-04,  -1.159558695809217e-04,   1.268296838030178e-05,  -1.153465864359969e-06,
   8.963132837076438e-08,  -6.070372502387547e-09,   3.639094645501442e-10,  -1.955260625923964e-11,   9.512580135449288e-13,  -4.226613272464608e-14,   1.727573065524466e-15,
  -6.536237576078443e-17,   2.299117133792348e-18,  -4.923004532699084e-04,   9.529828300814755e-05,  -1.309889613719953e-05,   1.432740130452342e-06,  -1.303030828424046e-07,
   1.012540487284745e-08,  -6.857565274829280e-10,   4.111019948722718e-11,  -2.208829554859846e-12,   1.074625056876456e-13,  -4.774765567222888e-15,   1.951626618205758e-16,
  -7.383950816586764e-18,   2.597303087649466e-19,  -3.966937162580204e-02,   5.576832453596792e-03,  -6.084545869055197e-04,   5.651392138870078e-05,  -4.573418879779658e-06,
   3.263883071654639e-07,  -2.074294093870401e-08,   1.184391162254340e-09,  -6.125357914046541e-11,   2.890467561266803e-12,  -1.252750453698089e-13,   5.016168453384763e-15,
  -1.865361348517170e-16,   6.465955009700807e-18,  -3.775916377340414e-02,   5.310804814664409e-03,  -5.796980784516963e-04,   5.386442440846983e-05,  -4.360415998949501e-06,
   3.112670081579721e-07,  -1.978596760793278e-08,   1.129933211348284e-09,  -5.844483687989449e-11,   2.758223512835107e-12,  -1.195541319598262e-13,   4.787453327756833e-15,
  -1.780421794956281e-16,   6.171860721011038e-18,  -3.411791657125932e-02,   4.802676766932632e-03,  -5.246613778766658e-04,   4.878471554217350e-05,  -3.951452363356019e-06,
   2.822007626398535e-07,  -1.794477288941501e-08,   1.025079784284573e-09,  -5.303363039479261e-11,   2.503321905730182e-12,  -1.085224983207309e-13,   4.346270101191007e-15,
  -1.616528477558514e-16,   5.604254917079134e-18,  -2.909097791537717e-02,   4.099188168406709e-03,  -4.482510354860081e-04,   4.171509935178699e-05,  -3.381146565750755e-06,
   2.416026979325756e-07,  -1.536982141319036e-08,   8.782900879801519e-10,  -4.545192953159587e-11,   2.145933792599291e-12,  -9.304672679618179e-14,   3.727061108349588e-15,
  -1.386408521326949e-16,   4.807014041237192e-18,  -2.316216794524751e-02,   3.266964922408877e-03,  -3.575876334359823e-04,   3.330504853434066e-05,  -2.701274775266380e-06,
   1.931234341033034e-07,  -1.229087775011747e-08,   7.025809461062594e-10,  -3.636864932944881e-11,   1.717458960358275e-12,  -7.448176784754387e-14,   2.983880718993396e-15,
  -1.110100167451268e-16,   3.849410526119459e-18,  -1.691020964762094e-02,   2.387025875891576e-03,  -2.614740912325253e-04,   2.436924175661666e-05,  -1.977570346069662e-06,
   1.414429972682983e-07,  -9.004807783620376e-09,   5.148771429078325e-10,  -2.665801225255719e-11,   1.259108770890792e-12,  -5.461224321076244e-14,   2.188136585432822e-15,
  -8.141417016939366e-17,   2.823387072865785e-18,  -1.095156772311278e-02,   1.546717304223586e-03,  -1.695128542907188e-04,   1.580536347589483e-05,  -1.283059619408817e-06,
   9.179459590880602e-08,  -5.845284562740116e-09,   3.342804703073384e-10,  -1.730998160148851e-11,   8.176779900019556e-13,  -3.546913859482059e-14,   1.421248062360663e-15,
  -5.288408326917359e-17,   1.834089999323116e-18,  -5.876405375229762e-03,   8.301617344937176e-04,  -9.100544870190358e-05,   8.487229469076992e-06,  -6.891066753008698e-07,
   4.930814288795572e-08,  -3.140191705306760e-09,   1.795976075782637e-10,  -9.300742829189855e-12,   4.393686495670143e-13,  -1.905981558896541e-14,   7.637580185843792e-16,
  -2.842012610673446e-17,   9.856769322148466e-19,  -2.186990577725110e-03,   3.089856833522909e-04,  -3.387523823163030e-05,   3.159472264246666e-06,  -2.565442275291762e-07,
   1.835760275072547e-08,  -1.169150753340613e-09,   6.686956123178421e-11,  -3.463032047738175e-12,   1.635975837743925e-13,  -7.096985503439699e-15,   2.843918919959208e-16,
  -1.058260743183860e-17,   3.670335576784467e-19,  -2.470415372387583e-04,   3.490340929273541e-05,  -3.826644252417652e-06,   3.569074521527831e-07,  -2.898061712646165e-08,
   2.073789951953629e-09,  -1.320754240334634e-10,   7.554089515778122e-12,  -3.912117594254066e-13,   1.848135010739882e-14,  -8.017369541045343e-16,   3.212744422693731e-17,
  -1.195508003391835e-18,   4.146353145946163e-20,  -2.407272032901576e-02,   2.541496027914873e-03,  -2.181883653392086e-04,   1.676368390028577e-05,  -1.172855214423948e-06,
   7.494975263357839e-08,  -4.379322447118502e-09,   2.344032047938469e-10,  -1.152659522856013e-11,   5.226132292937838e-13,  -2.193316724982962e-14,   8.554350041216407e-16,
  -3.112527148167858e-17,   1.059381886831504e-18,  -2.290861706186968e-02,   2.419415665384317e-03,  -2.077896942811216e-04,   1.597103436014629e-05,  -1.117797577755422e-06,
   7.145320494742314e-08,  -4.176077404738802e-09,   2.235709154374624e-10,  -1.099579014764415e-11,   4.986159926598647e-13,  -2.092845027877518e-14,   8.163273657777814e-16,
  -2.970472354161821e-17,   1.011101196185762e-18,  -2.069160605191424e-02,   2.186582483615084e-03,  -1.879237386750303e-04,   1.445414480849547e-05,  -1.012268870529292e-06,
   6.474230228680977e-08,  -3.785547675684628e-09,   2.027374824314215e-10,  -9.974122159094835e-12,   4.523979633087479e-13,  -1.899237375441702e-14,   7.409342628377501e-16,
  -2.696512233398161e-17,   9.179599181522592e-19,  -1.763480103117305e-02,   1.864905186600618e-03,  -1.604123685409696e-04,   1.234846362070007e-05,  -8.654583615745587e-07,
   5.538856862069476e-08,  -3.240366336237413e-09,   1.736162366043906e-10,  -8.544503048754804e-12,   3.876685099000298e-13,  -1.627888519110148e-14,   6.352037408342842e-16,
  -2.312116833568691e-17,   7.872159234978746e-19,  -1.403452263094717e-02,   1.485214764034555e-03,  -1.278570853989955e-04,   9.850380414266650e-06,  -6.908847054080298e-07,
   4.424376569536561e-08,  -2.589713289799939e-09,   1.388137090789732e-10,  -6.834068604814909e-12,   3.101532908944474e-13,  -1.302693913518551e-14,   5.084118317549327e-16,
  -1.850903545569805e-17,   6.302726163742600e-19,  -1.024262275702289e-02,   1.084548279357676e-03,  -9.342644666487460e-05,   7.202480956157742e-06,  -5.054653123562235e-07,
   3.238595831072400e-08,  -1.896432777397161e-09,   1.016871541615643e-10,  -5.007647602946335e-12,   2.273158394554276e-13,  -9.549427227137336e-15,   3.727508169156940e-16,
  -1.357200332928304e-17,   4.622076431495861e-19,  -6.631857220851018e-03,   7.024825258577932e-04,  -6.054035817416720e-05,   4.669224978926003e-06,  -3.278108728890844e-07,
   2.101033916126395e-08,  -1.230645888676709e-09,   6.600232243107714e-11,  -3.250920610870242e-12,   1.475935593216742e-13,  -6.201100504742000e-15,   2.420777191767485e-16,
  -8.814908889112002e-18,   3.002222803574022e-19,  -3.558095064689218e-03,   3.769653570808766e-04,  -3.249433796480025e-05,   2.506708030499123e-06,  -1.760228994603011e-07,
   1.128373533967422e-08,  -6.610192707393117e-10,   3.545603736200826e-11,  -1.746538152352825e-12,   7.929987091058716e-14,  -3.331972278581641e-15,   1.300799510155321e-16,
  -4.736883077147036e-18,   1.613370500753295e-19,  -1.324141008595466e-03,   1.402966191846013e-04,  -1.209447842887210e-05,   9.330752998615059e-07,  -6.552579987367282e-08,
   4.200701254340799e-09,  -2.460958594918135e-10,   1.320072421362256e-11,  -6.502791110819015e-13,   2.952608099836368e-14,  -1.240635716527122e-15,   4.843521588625617e-17,
  -1.763803691416858e-18,   6.007549811656669e-20,  -1.495734024444197e-04,   1.584790856628084e-05,  -1.366209311043854e-06,   1.054027892085607e-07,  -7.402058896629023e-09,
   4.745326358782393e-10,  -2.780045941749976e-11,   1.491242184545823e-12,  -7.346026203007326e-14,   3.335495175208802e-15,  -1.401523256145874e-16,   5.471652824176246e-18,
  -1.992547140889762e-19,   6.786668562739549e-21,  -1.646000745185585e-02,   1.367109097576415e-03,  -9.396909437368673e-05,   5.935945090433570e-06,  -3.522410077813276e-07,
   1.968822206159971e-08,  -1.033931635584402e-09,   5.086360443423556e-11,  -2.339711292570478e-12,   1.005944608094231e-13,  -4.045390981745512e-15,   1.524012721506639e-16,
  -5.389392794851864e-18,   1.791461546378539e-19,  -1.566227515003461e-02,   1.301153324690939e-03,  -8.946238583833561e-05,   5.653171455586000e-06,  -3.355765627079076e-07,
   1.876285275595448e-08,  -9.856201117365181e-10,   4.849899337164119e-11,  -2.231407150115208e-12,   9.595478056505152e-14,  -3.859370087692286e-15,   1.454110793129184e-16,
  -5.142724589485571e-18,   1.709615835471252e-19,  -1.414372717932027e-02,   1.175478917702690e-03,  -8.086423129393578e-05,   5.112898139214885e-06,  -3.036896570891643e-07,
   1.698967483751516e-08,  -8.929281045157645e-10,   4.395714645730848e-11,  -2.023185071097640e-12,   8.702761377303590e-14,  -3.501211293298265e-15,   1.319448771224574e-16,
  -4.667309088242585e-18,   1.551807800205544e-19,  -1.205135203215221e-02,   1.002077424726026e-03,  -6.897958032880388e-05,   4.364597560982948e-06,  -2.594329409302384e-07,
   1.452376409489437e-08,  -7.637948822518144e-10,   3.761997167103612e-11,  -1.732276792111518e-12,   7.454176038527245e-14,  -2.999818478375641e-15,   1.130788103717046e-16,
  -4.000823408739932e-18,   1.330455145376232e-19,  -9.588735612914383e-03,   7.976919295191063e-04,  -5.494447169791704e-05,   3.478974802717951e-06,  -2.069381140516573e-07,
   1.159268751736918e-08,  -6.100131874401377e-10,   3.006090995242584e-11,  -1.384800419318893e-12,   5.961080270816997e-14,  -2.399660385393856e-15,   9.047825159025671e-17,
  -3.201866299310059e-18,   1.064953758189121e-19,  -6.996696390884376e-03,   5.822839062842778e-04,  -4.012737217442682e-05,   2.542215983028803e-06,  -1.513037413130485e-07,
   8.480590542734192e-09,  -4.464656720225753e-10,   2.201043054878979e-11,  -1.014292100178936e-12,   4.367425346366447e-14,  -1.758547574794148e-15,   6.631858380673603e-17,
  -2.347291583266450e-18,   7.808292286442070e-20,  -4.529631786912538e-03,   3.770644905875437e-04,  -2.599351682369034e-05,   1.647396793468304e-06,  -9.808422403059589e-08,
   5.499575502057195e-09,  -2.896193436479936e-10,   1.428186966052232e-11,  -6.582911710943388e-13,   2.835062175376127e-14,  -1.141719935510183e-15,   4.306235621161049e-17,
  -1.524324788549245e-18,   5.071156190759833e-20,  -2.430062679536811e-03,   2.023145945200885e-04,  -1.394923205860800e-05,   8.842322749190891e-07,  -5.265642078728995e-08,
   2.952977514016939e-09,  -1.555351333810032e-10,   7.670894632454873e-12,  -3.536140054973155e-13,   1.523056802989896e-14,  -6.134061597788246e-16,   2.313745505992345e-17,
  -8.190678264579331e-19,   2.725022346265076e-20,  -9.043248918002839e-04,   7.529290674158444e-05,  -5.191618781392185e-06,   3.291150217138512e-07,  -1.960026380064796e-08,
   1.099254203549750e-09,  -5.790163678032397e-11,   2.855809439674938e-12,  -1.316528361561244e-13,   5.670632438824782e-15,  -2.283892786101901e-16,   8.614961459236655e-18,
  -3.049763450796645e-19,   1.014667062435499e-20,  -1.021511090606209e-04,   8.505029286954197e-06,  -5.864467908134683e-07,   3.717732189299654e-08,  -2.214098575710566e-09,
   1.241759584214702e-10,  -6.540848468944529e-12,   3.226084834974177e-13,  -1.487234882997571e-14,   6.405944380225826e-16,  -2.580057061476744e-17,   9.732144547090418e-19,
  -3.445265709252583e-20,   1.146255076716744e-21,  -1.214844663951573e-02,   8.275458279422985e-04,  -4.689391177198339e-05,   2.467967599434306e-06,  -1.240078098985078e-07,
   5.990075111351169e-09,  -2.778962673440749e-10,   1.233522016606644e-11,  -5.216753836897975e-13,   2.094899706529938e-14,  -7.970274593072272e-16,   2.869934113875410e-17,
  -9.779398895014309e-19,   3.152582424613113e-20,  -1.155896937220243e-02,   7.875173123594734e-04,  -4.463540421798301e-05,   2.349729734081049e-06,  -1.181016461686081e-07,
   5.706524529473837e-09,  -2.648197777656249e-10,   1.175798088108163e-11,  -4.973831857680799e-13,   1.997767394431308e-14,  -7.602083747108522e-16,   2.737771434636297e-17,
  -9.330248641501550e-19,   3.008117255049075e-20,  -1.043713787731792e-02,   7.112879045693039e-04,  -4.033038355826807e-05,   2.124097628665566e-06,  -1.068166748330387e-07,
   5.164025427370036e-09,  -2.397690509115262e-10,   1.065083143008907e-11,  -4.507404521796251e-13,   1.811091358694618e-14,  -6.893896081616922e-16,   2.483391296783399e-17,
  -8.465240177913251e-19,   2.729756429120464e-20,  -8.891945495442284e-03,   6.061911432000057e-04,  -3.438738660678389e-05,   1.812122428825818e-06,  -9.118551398742134e-08,
   4.411204835729496e-09,  -2.049437695568944e-10,   9.109111040910006e-12,  -3.856928432695132e-13,   1.550415580127562e-14,  -5.903873087471022e-16,   2.127437955356140e-17,
  -7.253858213766697e-19,   2.339664560345673e-20,  -7.074038801526412e-03,   4.824193632520040e-04,  -2.737859039113228e-05,   1.443571979202491e-06,  -7.268457964138419e-08,
   3.518415009236552e-09,  -1.635643837693452e-10,   7.273992611791795e-12,  -3.081439988494031e-13,   1.239214720754433e-14,  -4.720569708429106e-16,   1.701566836580041e-17,
  -5.803301527777206e-19,   1.872216745405238e-20,  -5.161249356070529e-03,   3.520696432419015e-04,  -1.998819014392189e-05,   1.054370688413167e-06,  -5.311423311988319e-08,
   2.572383160833933e-09,  -1.196436720506446e-10,   5.323153133971192e-12,  -2.255914747937746e-13,   9.075385054034009e-15,  -3.458123023411322e-16,   1.246818012877033e-17,
  -4.253246582286399e-19,   1.372394172706245e-20,  -3.341145866659234e-03,   2.279534337862726e-04,  -1.294481362562587e-05,   6.830347995005720e-07,  -3.441926494720031e-08,
   1.667521865850516e-09,  -7.758285475883227e-11,   3.452817769085866e-12,  -1.463663813932286e-13,   5.889551805658244e-15,  -2.244613831518962e-16,   8.094227589707941e-18,
  -2.761551000080942e-19,   8.911735151648453e-21,  -1.792400153876363e-03,   1.222996474854015e-04,  -6.945902414900904e-06,   3.665565733214776e-07,  -1.847448099823245e-08,
   8.951930824092405e-10,  -4.165650621915769e-11,   1.854200731889845e-12,  -7.861091718960436e-14,   3.163547003745426e-15,  -1.205804064721352e-16,   4.348575205873853e-18,
  -1.483732032902006e-19,   4.788403694962488e-21,  -6.670167598852220e-04,   4.551355290672615e-05,  -2.585014243918520e-06,   1.364262696568089e-07,  -6.876294374714464e-09,
   3.332152456238071e-10,  -1.550657934854581e-11,   6.902602629597858e-13,  -2.926572680499447e-14,   1.177791219119214e-15,  -4.489373515242992e-17,   1.619081320651396e-18,
  -5.524435032050503e-20,   1.782921505718163e-21,  -7.534501377866776e-05,   5.141154943300225e-06,  -2.920020270929369e-07,   1.541077702949877e-08,  -7.767566774759919e-10,
   3.764085788641599e-11,  -1.751679408723381e-12,   7.797495531305471e-14,  -3.306014857611181e-15,   1.330505231409231e-16,  -5.071499539178883e-18,   1.829032086107145e-19,
  -6.240828284327920e-21,   2.014132441718021e-22,  -9.439004253777871e-03,   5.443481183079586e-04,  -2.614838741138071e-05,   1.170535607496987e-06,  -5.035797369909197e-08,
   2.104436053177698e-09,  -8.563732497723116e-11,   3.387813953792211e-12,  -1.298087018324441e-13,   4.796982063018817e-15,  -1.703010413363088e-16,   5.790474337096801e-18,
  -1.881652247123698e-19,   5.831815935574035e-21,  -8.980678736052176e-03,   5.179764614330882e-04,  -2.488559851484899e-05,   1.114232605372953e-06,  -4.794715459509823e-08,
   2.004215246858180e-09,  -8.158128042067548e-11,   3.228229878062942e-12,  -1.237256681359598e-13,   4.573255726021064e-15,  -1.623920674142278e-16,   5.522558275851691e-18,
  -1.794871787046419e-19,   5.563602349338098e-21,  -8.108570782214873e-03,   4.677717422244152e-04,  -2.247995157281332e-05,   1.006881855673064e-06,  -4.334588002080686e-08,
   1.812718843949307e-09,  -7.382203633048251e-11,   2.922583681833234e-12,  -1.120619023319308e-13,   4.143832338661489e-15,  -1.471973845916123e-16,   5.007419516255063e-18,
  -1.627895528644734e-19,   5.047211844552082e-21,  -6.907594355994376e-03,   3.985877185053415e-04,  -1.916171835081638e-05,   8.586288341745070e-07,  -3.698240759582990e-08,
   1.547464821032664e-09,  -6.305640976634421e-11,   2.497813381620818e-12,  -9.582681050720400e-14,   3.545246104924221e-15,  -1.259897969899226e-16,   4.287616266453956e-18,
  -1.394351365859068e-19,   4.324345630550414e-21,  -5.494972880282190e-03,   3.171516310796531e-04,  -1.525184248235390e-05,   6.837159445437032e-07,  -2.946315849190810e-08,
   1.233504053293681e-09,  -5.029145161762003e-11,   1.993273630794444e-12,  -7.651074770857428e-14,   2.831978660866042e-15,  -1.006847551687543e-16,   3.427719816007173e-18,
  -1.115065859952612e-19,   3.459136032676166e-21,  -4.008918521250602e-03,   2.314262818276119e-04,  -1.113229555579304e-05,   4.992120334408547e-07,  -2.152092242611353e-08,
   9.013882048764213e-10,  -3.676737987370420e-11,   1.457907666135561e-12,  -5.598467369242235e-14,   2.073021851790639e-15,  -7.372689357967390e-17,   2.510711272728442e-18,
  -8.169648697445117e-20,   2.534929515892850e-21,  -2.595080392948250e-03,   1.498275976295311e-04,  -7.208434920591851e-06,   3.233243257708403e-07,  -1.394209391138676e-08,
   5.841229603444601e-10,  -2.383336057002756e-11,   9.453247353534649e-13,  -3.631125476977377e-14,   1.344888317215459e-15,  -4.784163635752161e-17,   1.629528699059150e-18,
  -5.303248818544776e-20,   1.645763113933682e-21,  -1.392135845220991e-03,   8.038058215344657e-05,  -3.867585460585026e-06,   1.734950838632506e-07,  -7.482301813538477e-09,
   3.135276258590542e-10,  -1.279450952567402e-11,   5.075575182290672e-13,  -1.949878830009578e-14,   7.222858782292634e-16,  -2.569680027797587e-17,   8.753438597578166e-19,
  -2.849025212640540e-20,   8.842067077663244e-22,  -5.180603428927050e-04,   2.991298899125653e-05,  -1.439336598535294e-06,   6.456943338718614e-08,  -2.784808647501824e-09,
   1.166966350097620e-10,  -4.762438859884009e-12,   1.889356706304004e-13,  -7.258684672971640e-15,   2.688927518682951e-16,  -9.566794683065332e-18,   3.258976851005547e-19,
  -1.060747357464695e-20,   3.292157965344907e-22,  -5.851909973588666e-05,   3.378925954062226e-06,  -1.625861022707840e-07,   7.293748435006865e-09,  -3.145736854247405e-10,
   1.318223095838953e-11,  -5.379769717058568e-13,   2.134282332487687e-14,  -8.199724659066630e-16,   3.037550834251613e-17,  -1.080721217987330e-18,   3.681551743546167e-20,
  -1.198294778107561e-21,   3.719068261050524e-23,  -7.606898018574803e-03,   3.802543208078353e-04,  -1.583765122875050e-05,   6.153173026359350e-07,  -2.302593635833415e-08,
   8.405544881461166e-10,  -3.008525051750253e-11,   1.056832128174467e-12,  -3.637743088885832e-14,   1.223121785154741e-15,  -4.001819464411640e-17,   1.269205773511228e-18,
  -3.888922487708137e-20,   1.147236099971415e-21,  -7.237372943318554e-03,   3.618139896133918e-04,  -1.507144311662050e-05,   5.856400130890397e-07,  -2.191948100309621e-08,
   8.003356975791405e-10,  -2.865248684775135e-11,   1.006751032574217e-12,  -3.466219192490703e-14,   1.165730041612748e-15,  -3.814900512021707e-17,   1.210169948743287e-18,
  -3.708707265607102e-20,   1.094246924431901e-21,  -6.534300802053629e-03,   3.267159243962345e-04,  -1.361234919706859e-05,   5.290883287977924e-07,  -1.980939622047979e-08,
   7.235654532655184e-10,  -2.591483721409631e-11,   9.109563181925831e-13,  -3.137774064473511e-14,   1.055716569713096e-15,  -3.456241922691199e-17,   1.096789374236931e-18,
  -3.362314500826412e-20,   9.923227615996499e-22,  -5.566229312687223e-03,   2.783639811933166e-04,  -1.160081896723300e-05,   4.510533266622138e-07,  -1.689446640288485e-08,
   6.173764858842509e-10,  -2.212273695937007e-11,   7.780661595126643e-13,  -2.681452936691204e-14,   9.026459666772744e-16,  -2.956521826344910e-17,   9.386163554582274e-19,
  -2.878528472244732e-20,   8.498295840777214e-22,  -4.427717143212466e-03,   2.214676197151920e-04,  -9.231991650352567e-06,   3.590662445070626e-07,  -1.345425334176231e-08,
   4.918790381174262e-10,  -1.763431632316076e-11,   6.205230286112180e-13,  -2.139606635095471e-14,   7.206025028378006e-16,  -2.361345713369805e-17,   7.499777174952571e-19,
  -2.300872288714118e-20,   6.795095760309165e-22,  -3.230170634742828e-03,   1.615916903751470e-04,  -6.737401964702641e-06,   2.621104707153533e-07,  -9.824377864123270e-09,
   3.593016974417298e-10,  -1.288634798135542e-11,   4.536359090827560e-13,  -1.564812419978173e-14,   5.272256903252110e-16,  -1.728308107335281e-17,   5.491056224978566e-19,
  -1.685116203273945e-20,   4.977905498188817e-22,  -2.090924841391844e-03,   1.046101303246185e-04,  -4.362199382392468e-06,   1.697352010273022e-07,  -6.363297701562008e-09,
   2.327765186767801e-10,  -8.350686890420733e-12,   2.940474871053035e-13,  -1.014589446591733e-14,   3.419309215371918e-16,  -1.121163647472665e-17,   3.562869609542295e-19,
  -1.093602344702055e-20,   3.231105550962381e-22,  -1.121666533426724e-03,   5.612037076508393e-05,  -2.340357806452760e-06,   9.107243001940331e-08,  -3.414627048339797e-09,
   1.249260309678676e-10,  -4.482225463304449e-12,   1.578517429883700e-13,  -5.447318954442971e-15,   1.836069855273877e-16,  -6.021077446225460e-18,   1.913614546935142e-19,
  -5.874323015323715e-21,   1.735753066106915e-22,  -4.174078327834406e-04,   2.088453593482205e-05,  -8.709575447306873e-07,   3.389338669993412e-08,  -1.270829648441445e-09,
   4.649597499134210e-11,  -1.668307889574990e-12,   5.875609278307191e-14,  -2.027717271612250e-15,   6.834930432811443e-17,  -2.241496312893548e-18,   7.124189077535823e-20,
  -2.187026523570357e-21,   6.462454872454233e-23,  -4.714955307832339e-05,   2.359081800568919e-06,  -9.838226370664501e-08,   3.828572761874355e-09,  -1.435528500116312e-10,
   5.252218104248142e-12,  -1.884546181791172e-13,   6.637229340718746e-15,  -2.290575756443643e-16,   7.721018256437464e-18,  -2.532103834777088e-19,   8.047882769468178e-21,
  -2.470601349293683e-22,   7.300427065230490e-24,  -6.299946342046558e-03,   2.778899145039459e-04,  -1.021390161342785e-05,   3.502849706310273e-07,  -1.157857711583288e-08,
   3.739069600972835e-10,  -1.187227601853691e-11,   3.716881318578551e-13,  -1.147858213674439e-14,   3.492251620044012e-16,  -1.044096595194287e-17,   3.057653675137944e-19,
  -8.740532355225526e-21,   2.429090390473043e-22,  -5.993821595781695e-03,   2.644047143654077e-04,  -9.719172495212832e-06,   3.333588763057292e-07,  -1.102072267554362e-08,
   3.559538377612074e-10,  -1.130444076206770e-11,   3.539863504011459e-13,  -1.093437057569037e-14,   3.327441953670595e-16,  -9.950465531369598e-18,   2.914635174616582e-19,
  -8.333362738523044e-21,   2.316351991846929e-22,  -5.411413148417976e-03,   2.387415679212056e-04,  -8.777298358015439e-06,   3.011181549921672e-07,  -9.957459574620643e-09,
   3.217102578027599e-10,  -1.022045377163818e-11,   3.201629854580889e-13,  -9.893516007400742e-15,   3.011913970304127e-16,  -9.010475136811446e-18,   2.640295899572052e-19,
  -7.551634304295107e-21,   2.099729402771597e-22,  -4.609555056313872e-03,   2.033945002070946e-04,  -7.479283151601546e-06,   2.566545310651984e-07,  -8.489807723317785e-09,
   2.743940500011982e-10,  -8.720895436495359e-12,   2.733125415380883e-13,  -8.449813689523230e-15,   2.573656091822917e-16,  -7.703062385319504e-18,   2.258219797253586e-19,
  -6.461570380860214e-21,   1.797325946165464e-22,  -3.666608310355204e-03,   1.618101430582671e-04,  -5.951300841501450e-06,   2.042727590172168e-07,  -6.759158913082831e-09,
   2.185371297823506e-10,  -6.948440569585691e-12,   2.178599547800779e-13,  -6.738553012806529e-15,   2.053406502926763e-16,  -6.148781213380024e-18,   1.803363871342719e-19,
  -5.162175499784738e-21,   1.436423198970917e-22,  -2.674849958776612e-03,   1.180564767310497e-04,  -4.342749523671980e-06,   1.490910659233527e-07,  -4.934477639220491e-09,
   1.595876181647532e-10,  -5.075780001468640e-12,   1.592014626425765e-13,  -4.926046978734721e-15,   1.501660020266962e-16,  -4.498290096349026e-18,   1.319762145384812e-19,
  -3.779093522524903e-21,   1.051880563143901e-22,  -1.731431519887516e-03,   7.642372553457686e-05,  -2.811568279226254e-06,   9.653700363169402e-08,  -3.195614034705002e-09,
   1.033701610189540e-10,  -3.288457579819074e-12,   1.031664140866809e-13,  -3.192985502241549e-15,   9.735959644869616e-17,  -2.917167086017967e-18,   8.560733854152414e-20,
  -2.451867288285953e-21,   6.825914809818614e-23,  -9.288103172605704e-04,   4.099837135023975e-05,  -1.508378679841440e-06,   5.179472446519560e-08,  -1.714677549552124e-09,
   5.547098588687386e-11,  -1.764862671615308e-12,   5.537443173642006e-14,  -1.714047573508053e-15,   5.227096230893969e-17,  -1.566382334882379e-18,   4.597264824471226e-20,
  -1.316842056641545e-21,   3.666411732009384e-23,  -3.456388887281393e-04,   1.525695912656336e-05,  -5.613321162194685e-07,   1.927549151821279e-08,  -6.381386881474197e-10,
   2.064492489999332e-11,  -6.568633620506858e-13,   2.061064556166664e-14,  -6.380053414492253e-16,   1.945724535796498e-17,  -5.830928033778679e-19,   1.711423672451873e-20,
  -4.902396888349449e-22,   1.364995414195694e-23,  -3.904265883223169e-05,   1.723398418720182e-06,  -6.340724559776291e-08,   2.177339308815765e-09,  -7.208381099022921e-11,
   2.332052490348808e-12,  -7.419979452298565e-14,   2.328209972602698e-15,  -7.207056064904434e-17,   2.197951080295630e-18,  -6.586843876138970e-20,   1.933303763475140e-21,
  -5.538009413078810e-23,   1.541980288693782e-24,  -5.328992688172390e-03,   2.103257409759452e-04,  -6.917248604272405e-06,   2.122879886902146e-07,  -6.280744498853816e-09,
   1.816254981932223e-10,  -5.169408359853792e-12,   1.453461715875334e-13,  -4.043961920626626e-15,   1.113672510579088e-16,  -3.032760035338008e-18,   8.150938660908680e-20,
  -2.156362078996276e-21,   5.594999885899233e-23,  -5.069996035239042e-03,   2.001144658550173e-04,  -6.581917379081222e-06,   2.020165091327579e-07,  -5.977565300326445e-09,
   1.728824844833979e-10,  -4.921356453368041e-12,   1.383966068379925e-13,  -3.851354631576316e-15,   1.060848532422680e-16,  -2.889520301716259e-18,   7.767600609997414e-20,
  -2.055368620468397e-21,   5.333986782952113e-23,  -4.577270913836087e-03,   1.806837351301962e-04,  -5.943622394774099e-06,   1.824569708015171e-07,  -5.399944050915655e-09,
   1.562152762156183e-10,  -4.448160670911427e-12,   1.251291277203696e-13,  -3.483338470332273e-15,   9.598275150379210e-17,  -2.615335376248148e-18,   7.033149293528681e-20,
  -1.861697093579730e-21,   4.833022387607153e-23,  -3.898929635826482e-03,   1.539246316101868e-04,  -5.064197880706087e-06,   1.554928370461646e-07,  -4.603091653620431e-09,
   1.332029732930797e-10,  -3.794195689970039e-12,   1.067735382702584e-13,  -2.973590276044794e-15,   8.197266031194141e-17,  -2.234593664367349e-18,   6.011953970953997e-20,
  -1.592074527350150e-21,   4.134767332998572e-23,  -3.101284803459183e-03,   1.224484233884251e-04,  -4.029248816637010e-06,   1.237404352299823e-07,  -3.664022033022134e-09,
   1.060592625083907e-10,  -3.022030506258924e-12,   8.507535126501008e-14,  -2.370260259964536e-15,   6.536849661482835e-17,  -1.782737138009178e-18,   4.798360829792026e-20,
  -1.271227225075410e-21,   3.302805460662542e-23,  -2.262398469329999e-03,   8.933465812244984e-05,  -2.939990539146625e-06,   9.030342959271315e-08,  -2.674465738043017e-09,
   7.743356155876296e-11,  -2.206966736486221e-12,   6.214845179326927e-14,  -1.732061391087735e-15,   4.778419081169575e-17,  -1.303632810488078e-18,   3.510042848757441e-20,
  -9.302279380430637e-22,   2.417616671657343e-23,  -1.464434868546776e-03,   5.782916702390044e-05,  -1.903308897596733e-06,   5.846747622032013e-08,  -1.731825790003539e-09,
   5.014914948506046e-11,  -1.429575049346179e-12,   4.026494392043147e-14,  -1.122413713029583e-15,   3.097219249031879e-17,  -8.451688177565986e-19,   2.276148460391464e-20,
  -6.033569063253585e-22,   1.568424105729933e-23,  -7.855778688691255e-04,   3.102269091730686e-05,  -1.021081705042065e-06,   3.136819852016492e-08,  -9.291990044443871e-10,
   2.690931226826276e-11,  -7.671590956002255e-13,   2.160973948831492e-14,  -6.024528810160564e-16,   1.662617650579487e-17,  -4.537487696574263e-19,   1.222148219362764e-20,
  -3.240016401121837e-22,   8.423317700117345e-24,  -2.923370955795277e-04,   1.154459762000437e-05,  -3.799848958392290e-07,   1.167357223404551e-08,  -3.458064838698900e-10,
   1.001472434893285e-11,  -2.855193660782467e-13,   8.042942433687425e-15,  -2.242358824092408e-16,   6.188592966649431e-18,  -1.689012766929534e-19,   4.549453168702553e-21,
  -1.206145753549714e-22,   3.135826511719683e-24,  -3.302178713893718e-05,   1.304055825447680e-06,  -4.292247430642577e-08,   1.318631713981545e-09,  -3.906200147571020e-11,
   1.131259567272381e-12,  -3.225232404947859e-14,   9.085374455223967e-16,  -2.533002477269009e-17,   6.990773029869949e-19,  -1.907959103112115e-20,   5.139231245901559e-22,
  -1.362515627641343e-23,   3.542389466327681e-25,  -4.568417743112731e-03,   1.631398191212810e-04,  -4.854601789760061e-06,   1.348086303514423e-07,  -3.609179620776755e-09,
   9.445957551747403e-11,  -2.434033075394028e-12,   6.200194331606980e-14,  -1.564907068789357e-15,   3.915669961630370e-17,  -4.224255350508107e-03,   1.508598226507714e-04,
  -4.489605688067487e-06,   1.246880874601604e-07,  -3.338721110428772e-09,   8.739642478292090e-11,  -2.252483797184765e-12,   5.739038385939828e-14,  -1.448876363220615e-15,
   3.626324019851240e-17,  -3.588196753711927e-03,   1.281585911739211e-04,  -3.814605222616411e-06,   1.059626591069699e-07,  -2.838008639698564e-09,   7.431081676499217e-11,
  -1.915859619898531e-12,   4.883182693271529e-14,  -1.233314668798955e-15,   3.088177762767891e-17,  -2.756930058854004e-03,   9.848003899558048e-05,  -2.931713122663203e-06,
   8.145476457304688e-08,  -2.182174581288657e-09,   5.715578697684842e-11,  -1.474090726042400e-12,   3.758677943907629e-14,  -9.497198341839451e-16,   2.379186846150031e-17,
  -1.856959313771829e-03,   6.633839878737143e-05,  -1.975124290483198e-06,   5.488601260485560e-08,  -1.470696055933731e-09,   3.852989460384558e-11,  -9.939892532381807e-13,
   2.535289593627888e-14,  -6.408213212476449e-16,   1.605945727260562e-17,  -1.025358699751576e-03,   3.663208013876453e-05,  -1.090745562025624e-06,   3.031324236515926e-08,
  -8.123525835513942e-10,   2.128529014575513e-11,  -5.492026206625525e-13,   1.401058781456946e-14,  -3.542025378247735e-16,   8.878474355398257e-18,  -3.888279279492687e-04,
   1.389158848683188e-05,  -4.136432687453769e-07,   1.149610051981051e-08,  -3.080930135224777e-10,   8.073083253533496e-12,  -2.083139836116878e-13,   5.314610179793937e-15,
  -1.343689694106388e-16,   3.368375362340017e-18,  -4.433169820300154e-05,   1.583836213382599e-06,  -4.716136202033580e-08,   1.310730861206981e-09,  -3.512756067557989e-11,
   9.204693148657083e-13,  -2.375158586875961e-14,   6.059690585785020e-16,  -1.532086787354629e-17,   3.840702200703406e-19,  -3.984506102719664e-03,   1.299176475071054e-04,
  -3.529918012902673e-06,   8.950416678881705e-08,  -2.188086791258564e-09,   5.229469162899832e-11,  -1.230671503918411e-12,   2.863695016389312e-14,  -6.605762389325918e-16,
   1.512114058482103e-17,  -3.684301514301520e-03,   1.201360095367723e-04,  -3.264403357817959e-06,   8.278017764624306e-08,  -2.023957139414710e-09,   4.837910182171585e-11,
  -1.138716190972293e-12,   2.650225888639704e-14,  -6.114644507210280e-16,   1.400018152913839e-17,  -3.129501759667771e-03,   1.020547622174853e-04,  -2.773447470910111e-06,
   7.034197513285592e-08,  -1.720194743355415e-09,   4.112805964742439e-11,  -9.683134951224919e-13,   2.254338982518922e-14,  -5.203058570038418e-16,   1.191753956413222e-17,
  -2.404463993408989e-03,   7.841855601459662e-05,  -2.131400170484832e-06,   5.406747543975909e-08,  -1.322490699850967e-09,   3.162741431190099e-11,  -7.448499890303336e-13,
   1.734667007349318e-14,  -4.005123412619491e-16,   9.177389292952798e-18,  -1.619533227547844e-03,   5.282309793610261e-05,  -1.435875689909416e-06,   3.642907401253378e-08,
  -8.912062669160460e-10,   2.131749699985101e-11,  -5.021593421303789e-13,   1.169774579106335e-14,  -2.701643435542419e-16,   6.192544950538678e-18,  -8.942529409825383e-04,
   2.916847231673632e-05,  -7.929278666612428e-07,   2.011869053571648e-08,  -4.922347438759971e-10,   1.177552829501847e-11,  -2.774236985793441e-13,   6.463527105555697e-15,
  -1.493028669435810e-16,   3.422857439562572e-18,  -3.391102458985626e-04,   1.106118017667613e-05,  -3.006987420787090e-07,   7.629756645889700e-09,  -1.866805975580132e-10,
   4.466076434665693e-12,  -1.052230821440305e-13,   2.451667581757585e-15,  -5.663533305548165e-17,   1.298488107488140e-18,  -3.866318674788122e-05,   1.261128683527522e-06,
  -3.428397978081028e-08,   8.699062831136158e-10,  -2.128450754443011e-11,   5.092062170766979e-13,  -1.199726255738508e-14,   2.795353896603411e-16,  -6.457541379552496e-18,
   1.480548584796750e-19,  -3.515258978864360e-03,   1.054496043017556e-04,  -2.635954347958428e-06,   6.149240992657190e-08,  -1.383114406882638e-09,   3.041440124720703e-11,
  -6.585840451168590e-13,   1.410194150140571e-14,  -2.993853718230901e-16,   6.309950091648801e-18,  -3.250387680030593e-03,   9.750871331713659e-05,  -2.437615742090791e-06,
   5.687036599000349e-08,  -1.279287117104081e-09,   2.813473790748707e-11,  -6.093078287372809e-13,   1.304892274027855e-14,  -2.770796950347095e-16,   5.840988286161070e-18,
  -2.760899194349009e-03,   8.283095905003382e-05,  -2.070913412737234e-06,   4.832186688419085e-08,  -1.087177002059004e-09,   2.391460554543197e-11,  -5.180346239353018e-13,
   1.109716118710996e-14,  -2.357059463314100e-16,   4.970427435363927e-18,  -2.121234560235727e-03,   6.364536540233073e-05,  -1.591425700694465e-06,   3.713922568830618e-08,
  -8.357348197791034e-10,   1.838759584424881e-11,  -3.984083021472213e-13,   8.536968486017159e-15,  -1.813838855777244e-16,   3.826238083508232e-18,  -1.428750500508241e-03,
   4.287091779670204e-05,  -1.072067126197793e-06,   2.502184840050741e-08,  -5.631411851097483e-10,   1.239216848716913e-11,  -2.685564640205975e-13,   5.755817806365996e-15,
  -1.223233407694836e-16,   2.581075194201582e-18,  -7.889049269500729e-04,   2.367267768578972e-05,  -5.920105504889382e-07,   1.381835197279526e-08,  -3.110212607667777e-10,
   6.844828162747765e-12,  -1.483541920282034e-13,   3.179997034954905e-15,  -6.759131503125932e-17,   1.426429475521744e-18,  -2.991605763588182e-04,   8.977041039062611e-06,
  -2.245038834889857e-07,   5.240366962281154e-09,  -1.179530070117527e-10,   2.595956615758754e-12,  -5.626691328895378e-14,   1.206148575180293e-15,  -2.563824087245090e-17,
   5.410945901773326e-19,  -3.410836934280798e-05,   1.023507013602156e-06,  -2.559663605728245e-08,   5.974788898288463e-10,  -1.344844646549114e-11,   2.959805508421571e-13,
  -6.415372572513258e-15,   1.375222761904906e-16,  -2.923238961598414e-18,   6.169550500734305e-20,  -3.131438873625401e-03,   8.697864421281041e-05,  -2.013207608650956e-06,
   4.348723560632366e-08,  -9.057235680057625e-10,   1.844261817291518e-11,  -3.698030206704224e-13,   7.332785336191577e-15,  -1.441709886165854e-16,   2.814550908181729e-18,
  -2.895473223663651e-03,   8.042775287101922e-05,  -1.861686831503103e-06,   4.021718839897073e-08,  -8.376922473354190e-10,   1.705915103265934e-11,  -3.421041953224891e-13,
   6.784488639628974e-15,  -1.334115130429982e-16,   2.604946432838624e-18,  -2.459412017324897e-03,   6.831981942838958e-05,  -1.581568680338606e-06,   3.417003374190408e-08,
  -7.118395198631814e-10,   1.449874938469330e-11,  -2.908162681329007e-13,   5.768676991977075e-15,  -1.134652379582256e-16,   2.216104084224508e-18,  -1.889581213052530e-03,
   5.249425722456151e-05,  -1.215335773751139e-06,   2.626086943899924e-08,  -5.471590494734198e-10,   1.114659361282805e-11,  -2.236262566743781e-13,   4.436956011897023e-15,
  -8.729489189509329e-17,   1.705474971030656e-18,  -1.272712223965932e-03,   3.535905913583711e-05,  -8.186893504157206e-07,   1.769194637421214e-08,  -3.686663135985011e-10,
   7.511472765197669e-12,  -1.507226374406373e-13,   2.991047220577822e-15,  -5.885984251124449e-17,   1.150210232909790e-18,  -7.027433244111743e-04,   1.952455800583788e-05,
  -4.520841158964835e-07,   9.770142899351487e-09,  -2.036055209611681e-10,   4.148753014163416e-12,  -8.325550425134252e-14,   1.652362446085200e-15,  -3.252028092748916e-17,
   6.355811921064453e-19,  -2.664868363010771e-04,   7.403984478293988e-06,  -1.714395016178745e-07,   3.705117829722943e-09,  -7.721509693047808e-11,   1.573417282460299e-12,
  -3.157585041470943e-14,   6.267080595658746e-16,  -1.233485947587766e-17,   2.410865385096775e-19,  -3.038311149122854e-05,   8.441562830246423e-07,  -1.954652111520101e-08,
   4.224372138995110e-10,  -8.803680712385249e-12,   1.793941363380126e-13,  -3.600161611515812e-15,   7.145542087108184e-17,  -1.406395329096067e-18,   2.748842255994315e-20,
  -2.812744992342504e-03,   7.273922589263470e-05,  -1.567529652797685e-06,   3.152575043670294e-08,  -6.113385361928320e-10,   1.159037671889874e-11,  -2.163920003417728e-13,
   3.995247167426674e-15,  -7.314220159514169e-17,   1.329707113697098e-18,  -2.600783480282578e-03,   6.726015146393032e-05,  -1.449527276076137e-06,   2.915436957187600e-08,
  -5.653972948239499e-10,   1.072036025621837e-11,  -2.001700292497759e-13,   3.696184831721979e-15,  -6.767626625215726e-17,   1.230520316126580e-18,  -2.209088010178321e-03,
   5.713363118937289e-05,  -1.231389967962888e-06,   2.476955337946847e-08,  -4.804228142480849e-10,   9.110552861171416e-12,  -1.701413788842195e-13,   3.142318579842692e-15,
  -5.754779068828746e-17,   1.046614591233473e-18,  -1.697243657385165e-03,   4.389850268707447e-05,  -9.462172884847262e-07,   1.903537837574914e-08,  -3.692544325757748e-10,
   7.003518393619742e-12,  -1.308162307923216e-13,   2.416533041470989e-15,  -4.426624827153249e-17,   8.052726886474978e-19,  -1.143158396829825e-03,   2.956874839014286e-05,
  -6.373874953813092e-07,   1.282366034908132e-08,  -2.487840025292541e-10,   4.719192110685539e-12,  -8.816091251624479e-14,   1.628840860927443e-15,  -2.984272734841931e-17,
   5.429964139635102e-19,  -6.312065803123967e-04,   1.632714235338282e-05,  -3.519636066788079e-07,   7.081545687351331e-09,  -1.373931849945689e-10,   2.606405213053556e-12,
  -4.869526626717600e-14,   8.997680426503640e-16,  -1.648680518892513e-17,   3.000169815945721e-19,  -2.393591432906026e-04,   6.191462381957752e-06,  -1.334710865780690e-07,
   2.685503341659299e-09,  -5.210421386661544e-11,   9.884653146300943e-13,  -1.846800177707134e-14,   3.412551479836183e-16,  -6.253201988585139e-18,   1.137970204735615e-19,
  -2.729018127856856e-05,   7.059117201046726e-07,  -1.521757346530377e-08,   3.061859563241867e-10,  -5.940651542964150e-12,   1.127001849381330e-13,  -2.105646034937091e-15,
   3.890874631383150e-17,  -7.129734396901788e-19,   1.297492785267743e-20,  -2.544686233067593e-03,   6.156189600214394e-05,  -1.241079950895207e-06,   2.335040341119387e-08,
  -4.236045122854221e-10,   7.513310294359032e-12,  -1.312306381898996e-13,   2.266749892255505e-15,  -3.882401794437225e-17,   6.603703143236656e-19,  -2.352917150268057e-03,
   5.692431250683944e-05,  -1.147636481220683e-06,   2.159350383950360e-08,  -3.917588555488818e-10,   6.949034342683147e-12,  -1.213860110946712e-13,   2.096923822929258e-15,
  -3.591952368594274e-17,   6.110461723117053e-19,  -1.998541114773763e-03,   4.835331632512020e-05,  -9.749080247007746e-07,   1.834518335111088e-08,  -3.328635286120562e-10,
   5.905125324547902e-12,  -1.031666662556234e-13,   1.782495073274352e-15,  -3.053936619545606e-17,   5.196321638741329e-19,  -1.535471462608555e-03,   3.715166600982998e-05,
  -7.491148159410281e-07,   1.409771928528617e-08,  -2.558258494899611e-10,   4.539082692906050e-12,  -7.931375177458034e-14,   1.370619538510259e-15,  -2.348753547831609e-17,
   3.997344735105836e-19,  -1.034193936319510e-03,   2.502401097826747e-05,  -5.046064081992005e-07,   9.496997772431222e-09,  -1.723543947959447e-10,   3.058396930866430e-12,
  -5.344774978925151e-14,   9.237626301793942e-16,  -1.583254827014112e-17,   2.695021187837091e-19,  -5.710392394159845e-04,   1.381756451000657e-05,  -2.786391906197211e-07,
   5.244388773684325e-09,  -9.518187467310725e-11,   1.689092123115662e-12,  -2.952029912164806e-14,   5.102556284620391e-16,  -8.746183138807769e-18,   1.488930664072727e-19,
  -2.165429392393312e-04,   5.239786139746747e-06,  -1.056646796793857e-07,   1.988793509312146e-09,  -3.609589686557402e-11,   6.405710118214277e-13,  -1.119558146214976e-14,
   1.935206233485367e-16,  -3.317211484486123e-18,   5.647364137423940e-20,  -2.468882123290369e-05,   5.974073343549264e-07,  -1.204724532331895e-08,   2.267507835465327e-10,
  -4.115460076643831e-12,   7.303475133194794e-14,  -1.276470874100069e-15,   2.206448299158533e-17,  -3.782179808211725e-19,   6.438987398791488e-21,  -2.316670186099194e-03,
   5.264926154760590e-05,  -9.970832355431127e-07,   1.762304382204054e-08,  -3.003350457463298e-10,   5.004259920040988e-12,  -8.211285724567867e-14,   1.332451223355043e-15,
  -2.143999372002416e-17,   3.426163124413568e-19,  -2.142078672100133e-03,   4.868277502718224e-05,  -9.220002204738800e-07,   1.629678123613413e-08,  -2.777492970262297e-10,
   4.628258385043106e-12,  -7.594941421187495e-14,   1.232550889665714e-15,  -1.983458978888351e-17,   3.169978858763310e-19,  -1.819449136709868e-03,   4.135226069244907e-05,
  -7.832170935296608e-07,   1.384484004804552e-08,  -2.359836020280906e-10,   3.932755839906053e-12,  -6.454492971902692e-14,   1.047631793658726e-15,  -1.686168368060714e-17,
   2.695353562086456e-19,  -1.397869123965252e-03,   3.177213995210562e-05,  -6.018083805245292e-07,   1.063900781986048e-08,  -1.813595260368087e-10,   3.022798122476449e-12,
  -4.961764642062756e-14,   8.054764105225509e-16,  -1.296652155552940e-17,   2.073122191129478e-19,  -9.415103998781120e-04,   2.140037100620501e-05,  -4.053739008413064e-07,
   7.166842963494514e-09,  -1.221807625011856e-10,   2.036637769744746e-12,  -3.343408899686353e-14,   5.428268735526594e-16,  -8.739642681356531e-18,   1.397536714307696e-19,
  -5.198620879281212e-04,   1.181663150745241e-05,  -2.238418492914861e-07,   3.957584951945197e-09,  -6.747234289323148e-11,   1.124763206451894e-12,  -1.846566259704516e-14,
   2.998255109183704e-16,  -4.827658115432417e-18,   7.720498919727640e-20,  -1.971359676491926e-04,   4.480999872226283e-06,  -8.488431482308151e-08,   1.500799713571749e-09,
  -2.558739179586837e-11,   4.265505165465549e-13,  -7.003011122550893e-15,   1.137104709495314e-16,  -1.830972175224631e-18,   2.928231201154841e-20,  -2.247616119582210e-05,
   5.108951544276729e-07,  -9.677988810895949e-09,   1.711123893452666e-10,  -2.917333096552424e-12,   4.863310382116471e-14,  -7.984506525754839e-16,   1.296479649228127e-17,
  -2.087609214846512e-19,   3.338683655393680e-21  };
  int offset = -1;
  for (int i = 1; i <= n; ++i) {
    complex<double> t = ta[i-1];
    offset += 1;
    if (std::isnan(t.real())) {
      fill_n(rr+offset, 1, 0.5);
      fill_n(ww+offset, 1, 0.0);
    } else if (t.real() < -2) {
      throw runtime_error ("ERROR!  Invalid T value!  Real part is too small.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else if (t.real() >= 34) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 1; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else if ( fabs(t.imag()) > 5.000000000000000e-01){
      throw runtime_error ("ERROR!  Invalid T value!  Magnitude of imaginary part is too large.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else {
      const complex<double> torig = t;
      if (torig.imag() < 0) t = conj(torig);
      int itr = static_cast<int>((t.real()-(-2))*   0.500000000000000) ;
      int iti = static_cast<int>((t.imag()-(0))*   2.000000000000000) ;
      double tr = (t.real()-itr*2.000000000000000-   1.000000000000000) *   1.000000000000000 - (-2) ;
      double ti = (t.imag()-iti*0.500000000000000-   0.250000000000000) *   4.000000000000000 - (0) ;
      const double tr2 = tr * 2.0;
      const double ti2 = ti * 2.0;
      if (itr < 11) {
        for (int j=1; j <=1; ++j) {
          vector<double> xrval(10);
          vector<double> xival(10);
          vector<double> wrval(10);
          vector<double> wival(10);
          for (int k=1; k<= 10; k++){
            const int boxof = iti*2100 + itr*140 + (j-1)*140 + (k-1)*14;
            double dr = xr[boxof+13];
            double di = xi[boxof+13];
            double er = wr[boxof+13];
            double ei = wi[boxof+13];
            double fr = tr2*dr + xr[boxof+12];
            double fi = tr2*di + xi[boxof+12];
            double gr = tr2*er + wr[boxof+12];
            double gi = tr2*ei + wi[boxof+12];
            dr = tr2*fr - dr + xr[boxof+11];
            di = tr2*fi - di + xi[boxof+11];
            er = tr2*gr - er + wr[boxof+11];
            ei = tr2*gi - ei + wi[boxof+11];
            fr = tr2*dr - fr + xr[boxof+10];
            fi = tr2*di - fi + xi[boxof+10];
            gr = tr2*er - gr + wr[boxof+10];
            gi = tr2*ei - gi + wi[boxof+10];
            dr = tr2*fr - dr + xr[boxof+9];
            di = tr2*fi - di + xi[boxof+9];
            er = tr2*gr - er + wr[boxof+9];
            ei = tr2*gi - ei + wi[boxof+9];
            fr = tr2*dr - fr + xr[boxof+8];
            fi = tr2*di - fi + xi[boxof+8];
            gr = tr2*er - gr + wr[boxof+8];
            gi = tr2*ei - gi + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 10;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          vector<double> tcxr(10);
          vector<double> tcxi(10);
          vector<double> tcwr(10);
          vector<double> tcwi(10);
          for (int b = 0; b != 10; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 10;
            for (int k = 0; k !=10; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[9];
          double di = tcxi[9];
          double er = tcwr[9];
          double ei = tcwi[9];
          double fr = ti2*dr + tcxr[8];
          double fi = ti2*di + tcxi[8];
          double gr = ti2*er + tcwr[8];
          double gi = ti2*ei + tcwi[8];
          dr = ti2*fr - dr + tcxr[7];
          di = ti2*fi - di + tcxi[7];
          er = ti2*gr - er + tcwr[7];
          ei = ti2*gi - ei + tcwi[7];
          fr = ti2*dr - fr + tcxr[6];
          fi = ti2*di - fi + tcxi[6];
          gr = ti2*er - gr + tcwr[6];
          gi = ti2*ei - gi + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      } else {
        for (int j=1; j <=1; ++j) {
          vector<double> xrval(8);
          vector<double> xival(8);
          vector<double> wrval(8);
          vector<double> wival(8);
          for (int k=1; k<= 8; k++){
            const int boxof = iti*2100 + itr*80 + 660 + (j-1)*80 + (k-1)*10;
            double dr = xr[boxof+9];
            double di = xi[boxof+9];
            double er = wr[boxof+9];
            double ei = wi[boxof+9];
            double fr = tr2*dr + xr[boxof+8];
            double fi = tr2*di + xi[boxof+8];
            double gr = tr2*er + wr[boxof+8];
            double gi = tr2*ei + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 8;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          vector<double> tcxr(8);
          vector<double> tcxi(8);
          vector<double> tcwr(8);
          vector<double> tcwi(8);
          for (int b = 0; b != 8; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 8;
            for (int k = 0; k !=8; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[7];
          double di = tcxi[7];
          double er = tcwr[7];
          double ei = tcwi[7];
          double fr = ti2*dr + tcxr[6];
          double fi = ti2*di + tcxi[6];
          double gr = ti2*er + tcwr[6];
          double gi = ti2*ei + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      }
    }
  }
}
