// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//
// This program is free software;  you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
// MA  02111-1307  USA

#include "Puma/ACAspectInfo.h"
#include "Puma/ACIntroductionInfo.h"
#include "Puma/ACAdviceInfo.h"
#include "Puma/CFunctionInfo.h"
#include "Puma/CClassInfo.h"

namespace Puma {


ACAspectInfo::~ACAspectInfo () {
  for (int i = _intro_nodes.length () - 1; i >= 0; i--) {
    delete _intro_nodes[i];
    _intro_nodes.remove (i);
  }
}

void ACAspectInfo::pure_virtual_functions (CClassInfo *cls,
                                           set<CFunctionInfo*> &res) {
  // find the pure virtual functions of base classes
  for (int c = cls->BaseClasses () - 1; c >= 0; c--) {
    CClassInfo *ci = cls->BaseClass (c)->Class ();
    set<CFunctionInfo*> base_fcts;
    pure_virtual_functions (ci, base_fcts);
    for (set<CFunctionInfo*>::const_iterator iter = base_fcts.begin ();
         iter != base_fcts.end (); ++iter) {
      // add the function to the set of this class
      // if it is not redefined and not a destructor (implicitly defd)
      if ((cls->Functions ((*iter)->Name ()) == 0) &&
          !(*iter)->isDestructor())
        res.insert (*iter);
    }
  }
  // find new pure virtual functions on this level
  for (int f = cls->Functions () - 1; f >= 0; f--) {
    CFunctionInfo *fi = cls->Function (f);
    if (fi->isPureVirtual ())
      res.insert (fi);
  }
}

bool ACAspectInfo::is_abstract () const {
  set<CFunctionInfo*> pure_fcts;
  pure_virtual_functions (_class, pure_fcts);
  return (pure_fcts.size () > 0);
}


} // namespace Puma
