# -*- coding: utf-8 -*-
# Copyright 2020 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

from __future__ import absolute_import, division, print_function


__metaclass__ = type

from ansible_collections.junipernetworks.junos.plugins.modules import junos_l2_interfaces
from ansible_collections.junipernetworks.junos.tests.unit.compat.mock import patch
from ansible_collections.junipernetworks.junos.tests.unit.modules.utils import set_module_args

from .junos_module import TestJunosModule, load_fixture


class TestJunosL2InterfacesModule(TestJunosModule):
    module = junos_l2_interfaces

    def setUp(self):
        super(TestJunosL2InterfacesModule, self).setUp()
        self.mock_lock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.lock_configuration",
        )
        self.lock_configuration = self.mock_lock_configuration.start()
        self.mock_unlock_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.junos.unlock_configuration",
        )
        self.unlock_configuration = self.mock_unlock_configuration.start()
        self.mock_load_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.l2_interfaces.l2_interfaces.load_config",
        )
        self.load_config = self.mock_load_config.start()
        self.mock_commit_configuration = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.l2_interfaces.l2_interfaces.commit_configuration",
        )
        self.mock_commit_configuration = self.mock_commit_configuration.start()
        self.mock_execute_show_command = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.facts.l2_interfaces.l2_interfaces."
            "L2_interfacesFacts.get_device_data",
        )
        self.mock_get_res_config = patch(
            "ansible_collections.junipernetworks.junos.plugins.module_utils.network.junos.config.l2_interfaces.l2_interfaces."
            "L2_interfaces.get_res_config",
        )
        self.get_res_config = self.mock_get_res_config.start()
        self.execute_show_command = self.mock_execute_show_command.start()

    def tearDown(self):
        super(TestJunosL2InterfacesModule, self).tearDown()
        self.mock_load_config.stop()
        self.mock_get_res_config.stop()
        self.mock_lock_configuration.stop()
        self.mock_unlock_configuration.stop()
        self.mock_commit_configuration.stop()
        self.mock_execute_show_command.stop()

    def load_fixtures(
        self,
        commands=None,
        format="text",
        changed=False,
        filename=None,
    ):
        def load_from_file(*args, **kwargs):
            if filename:
                output = load_fixture(filename)
            else:
                output = load_fixture("junos_l2_interfaces_config.cfg")
            return output

        self.execute_show_command.side_effect = load_from_file

    def test_junos_l2_interfaces_merged(self):
        set_module_args(
            dict(
                config=[dict(name="ge-0/0/1", access=dict(vlan="vlan100"))],
                state="merged",
            ),
        )
        commands = [
            '<nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:interface>'
            "<nc:name>ge-0/0/1</nc:name><nc:unit><nc:name>0</nc:name>"
            "<nc:family><nc:ethernet-switching><nc:interface-mode>access</nc:interface-mode>"
            "<nc:vlan><nc:members>vlan100</nc:members>"
            "</nc:vlan></nc:ethernet-switching></nc:family></nc:unit>"
            "</nc:interface></nc:interfaces>",
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_l2_interfaces_gathered(self):
        """
        :return:
        """
        set_module_args(dict(state="gathered"))
        result = self.execute_module(changed=False)
        with open("gathered_outout.py", "w") as file:
            file.write(str(result["gathered"]))
        gather_list = [
            {"access": {"vlan": "vlan100"}, "name": "ge-0/0/1", "unit": 0, "enhanced_layer": True},
            {
                "name": "ge-0/0/2",
                "trunk": {"allowed_vlans": ["vlan200", "vlan300"], "native_vlan": "400"},
                "unit": 0,
                "enhanced_layer": True,
            },
        ]
        self.assertEqual(gather_list, result["gathered"])

    def test_junos_l2_interfaces_merged_idempotent(self):
        set_module_args(
            dict(
                config=[
                    dict(name="ge-0/0/1", access=dict(vlan="vlan100"), unit=0, enhanced_layer=True),
                    dict(
                        name="ge-0/0/2",
                        trunk=dict(allowed_vlans=["vlan200", "vlan300"], native_vlan="400"),
                        unit=0,
                        enhanced_layer=True,
                    ),
                ],
                state="merged",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_l2_interfaces_replaced(self):
        set_module_args(
            dict(
                config=[dict(name="ge-0/0/1", access=dict(vlan="vlan100"), enhanced_layer=False)],
                state="replaced",
            ),
        )
        commands = [
            '<nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:interface>'
            "<nc:name>ge-0/0/1</nc:name><nc:unit><nc:name>0</nc:name>"
            "<nc:family><nc:ethernet-switching><nc:port-mode>access</nc:port-mode>"
            "<nc:vlan><nc:members>vlan100</nc:members></nc:vlan></nc:ethernet-switching></nc:family>"
            "</nc:unit></nc:interface></nc:interfaces>",
        ]
        result = self.execute_module(changed=True)

        self.assertEqual(sorted(result["commands"]), sorted(commands))

    def test_junos_l2_interfaces_replaced_idempotent(self):
        set_module_args(
            dict(
                config=[
                    dict(name="ge-0/0/1", access=dict(vlan="vlan100"), unit=0, enhanced_layer=True),
                    dict(
                        name="ge-0/0/2",
                        trunk=dict(allowed_vlans=["vlan200", "vlan300"], native_vlan="400"),
                        unit=0,
                        enhanced_layer=True,
                    ),
                ],
                state="replaced",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_l2_interfaces_overridden(self):
        set_module_args(
            dict(
                config=[dict(name="ge-0/0/1", access=dict(vlan="vlan100"), enhanced_layer=False)],
                state="overridden",
            ),
        )
        commands = [
            '<nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:interface>'
            "<nc:name>ge-0/0/1</nc:name><nc:unit><nc:name>0</nc:name>"
            "<nc:family><nc:ethernet-switching><nc:port-mode>access</nc:port-mode>"
            "<nc:vlan><nc:members>vlan100</nc:members></nc:vlan></nc:ethernet-switching></nc:family>"
            "</nc:unit></nc:interface></nc:interfaces>",
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_l2_interfaces_overridden_idempotent(self):
        set_module_args(
            dict(
                config=[
                    dict(name="ge-0/0/1", access=dict(vlan="vlan100"), unit=0, enhanced_layer=True),
                    dict(
                        name="ge-0/0/2",
                        trunk=dict(allowed_vlans=["vlan200", "vlan300"], native_vlan="400"),
                        unit=0,
                        enhanced_layer=True,
                    ),
                ],
                state="overridden",
            ),
        )
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_l2_interfaces_delete(self):
        self.get_res_config.return_value = load_fixture(
            "junos_interfaces_config.xml",
        )
        src = load_fixture("junos_l2_interfaces.cfg", content="str")
        set_module_args(dict(src=src))
        set_module_args(dict(config=[dict(name="ge-0/0/1")], state="deleted"))
        commands = [
            '<nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:interface>'
            "<nc:name>ge-0/0/1</nc:name><nc:unit><nc:name>0</nc:name>"
            '<nc:family><nc:ethernet-switching><nc:interface-mode delete="delete"/>'
            '<nc:vlan delete="delete"/></nc:ethernet-switching></nc:family></nc:unit>'
            '<nc:native-vlan-id delete="delete"/></nc:interface></nc:interfaces>',
        ]
        result = self.execute_module(changed=True)
        self.assertEqual(sorted(result["commands"]), commands)

    def test_junos_l2_interfaces_delete_idempotent(self):
        set_module_args(dict(config=[dict(name="ge-0/0/3")], state="deleted"))
        result = self.execute_module(changed=True)
        self.assertEqual(result["before"], result["after"])

    def test_junos_l2_interfaces_parsed(self):
        parsed_str = """
            <rpc-reply message-id="urn:uuid:0cadb4e8-5bba-47f4-986e-72906227007f">
                <configuration changed-seconds="1590139550" changed-localtime="2020-05-22 09:25:50 UTC">
                    <interfaces>
                        <interface>
                            <name>ge-0/0/6</name>
                            <unit>
                                <name>0</name>
                                <family>
                                    <ethernet-switching>
                                        <interface-mode>trunk</interface-mode>
                                        <vlan>
                                            <members>vlan02</members>
                                        </vlan>
                                    </ethernet-switching>
                                </family>
                            </unit>
                        </interface>

                        <interface>
                            <name>ge-0/0/37</name>
                            <unit>
                            <name>0</name>
                                <family>
                                    <ethernet-switching>
                                        <vlan>
                                            <members>vlan31</members>
                                        </vlan>
                                    </ethernet-switching>
                                </family>
                            </unit>
                        </interface>
                    </interfaces>
                </configuration>
            </rpc-reply>
        """
        set_module_args(dict(running_config=parsed_str, state="parsed"))
        result = self.execute_module(changed=False)
        parsed_list = [
            {
                "name": "ge-0/0/6",
                "trunk": {
                    "allowed_vlans": ["vlan02"],
                },
                "unit": 0,
                "enhanced_layer": True,
            },
            {
                "access": {
                    "vlan": "vlan31",
                },
                "name": "ge-0/0/37",
                "unit": 0,
                "enhanced_layer": False,
            },
        ]
        self.assertEqual(result["parsed"], parsed_list)

    def test_junos_l2_interfaces_rendered(self):
        set_module_args(
            dict(
                config=[dict(name="ge-0/0/4", access=dict(vlan="vlan100"))],
                state="rendered",
            ),
        )
        rendered = (
            '<nc:interfaces xmlns:nc="urn:ietf:params:xml:ns:netconf:base:1.0"><nc:interface>'
            "<nc:name>ge-0/0/4</nc:name><nc:unit><nc:name>0</nc:name><nc:family>"
            "<nc:ethernet-switching><nc:interface-mode>access</nc:interface-mode><nc:vlan>"
            "<nc:members>vlan100</nc:members></nc:vlan></nc:ethernet-switching></nc:family>"
            "</nc:unit></nc:interface></nc:interfaces>"
        )
        result = self.execute_module(changed=False)
        self.assertEqual(sorted(result["rendered"]), sorted(rendered))
