# Copyright 2019 Fortinet, Inc.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ansible.  If not, see <https://www.gnu.org/licenses/>.

# Make coding more python3-ish
from __future__ import (absolute_import, division, print_function)
__metaclass__ = type

import os
import json
import pytest
from mock import ANY
from ansible.module_utils.network.fortios.fortios import FortiOSHandler

try:
    from ansible.modules.network.fortios import fortios_system_settings
except ImportError:
    pytest.skip("Could not load required modules for testing", allow_module_level=True)


@pytest.fixture(autouse=True)
def connection_mock(mocker):
    connection_class_mock = mocker.patch('ansible.modules.network.fortios.fortios_system_settings.Connection')
    return connection_class_mock


fos_instance = FortiOSHandler(connection_mock)


def test_system_settings_creation(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_settings': {
            'allow_linkdown_path': 'enable',
            'allow_subnet_overlap': 'enable',
            'asymroute': 'enable',
            'asymroute_icmp': 'enable',
            'asymroute6': 'enable',
            'asymroute6_icmp': 'enable',
            'bfd': 'enable',
            'bfd_desired_min_tx': '10',
            'bfd_detect_mult': '11',
            'bfd_dont_enforce_src_port': 'enable',
            'bfd_required_min_rx': '13',
            'block_land_attack': 'disable',
            'central_nat': 'enable',
            'comments': 'test_value_16',
            'compliance_check': 'enable',
            'default_voip_alg_mode': 'proxy-based',
            'deny_tcp_with_icmp': 'enable',
            'device': 'test_value_20',
            'dhcp_proxy': 'enable',
            'dhcp_server_ip': 'test_value_22',
            'dhcp6_server_ip': 'test_value_23',
            'discovered_device_timeout': '24',
            'ecmp_max_paths': '25',
            'email_portal_check_dns': 'disable',
            'firewall_session_dirty': 'check-all',
            'fw_session_hairpin': 'enable',
            'gateway': 'test_value_29',
            'gateway6': 'test_value_30',
            'gui_advanced_policy': 'enable',
            'gui_allow_unnamed_policy': 'enable',
            'gui_antivirus': 'enable',
            'gui_ap_profile': 'enable',
            'gui_application_control': 'enable',
            'gui_dhcp_advanced': 'enable',
            'gui_dlp': 'enable',
            'gui_dns_database': 'enable',
            'gui_dnsfilter': 'enable',
            'gui_domain_ip_reputation': 'enable',
            'gui_dos_policy': 'enable',
            'gui_dynamic_profile_display': 'enable',
            'gui_dynamic_routing': 'enable',
            'gui_email_collection': 'enable',
            'gui_endpoint_control': 'enable',
            'gui_endpoint_control_advanced': 'enable',
            'gui_explicit_proxy': 'enable',
            'gui_fortiap_split_tunneling': 'enable',
            'gui_fortiextender_controller': 'enable',
            'gui_icap': 'enable',
            'gui_implicit_policy': 'enable',
            'gui_ips': 'enable',
            'gui_load_balance': 'enable',
            'gui_local_in_policy': 'enable',
            'gui_local_reports': 'enable',
            'gui_multicast_policy': 'enable',
            'gui_multiple_interface_policy': 'enable',
            'gui_multiple_utm_profiles': 'enable',
            'gui_nat46_64': 'enable',
            'gui_object_colors': 'enable',
            'gui_policy_based_ipsec': 'enable',
            'gui_policy_learning': 'enable',
            'gui_replacement_message_groups': 'enable',
            'gui_spamfilter': 'enable',
            'gui_sslvpn_personal_bookmarks': 'enable',
            'gui_sslvpn_realms': 'enable',
            'gui_switch_controller': 'enable',
            'gui_threat_weight': 'enable',
            'gui_traffic_shaping': 'enable',
            'gui_voip_profile': 'enable',
            'gui_vpn': 'enable',
            'gui_waf_profile': 'enable',
            'gui_wan_load_balancing': 'enable',
            'gui_wanopt_cache': 'enable',
            'gui_webfilter': 'enable',
            'gui_webfilter_advanced': 'enable',
            'gui_wireless_controller': 'enable',
            'http_external_dest': 'fortiweb',
            'ike_dn_format': 'with-space',
            'ike_quick_crash_detect': 'enable',
            'ike_session_resume': 'enable',
            'implicit_allow_dns': 'enable',
            'inspection_mode': 'proxy',
            'ip': 'test_value_84',
            'ip6': 'test_value_85',
            'link_down_access': 'enable',
            'lldp_transmission': 'enable',
            'mac_ttl': '88',
            'manageip': 'test_value_89',
            'manageip6': 'test_value_90',
            'multicast_forward': 'enable',
            'multicast_skip_policy': 'enable',
            'multicast_ttl_notchange': 'enable',
            'ngfw_mode': 'profile-based',
            'opmode': 'nat',
            'prp_trailer_action': 'enable',
            'sccp_port': '97',
            'ses_denied_traffic': 'enable',
            'sip_helper': 'enable',
            'sip_nat_trace': 'enable',
            'sip_ssl_port': '101',
            'sip_tcp_port': '102',
            'sip_udp_port': '103',
            'snat_hairpin_traffic': 'enable',
            'ssl_ssh_profile': 'test_value_105',
            'status': 'enable',
            'strict_src_check': 'enable',
            'tcp_session_without_syn': 'enable',
            'utf8_spam_tagging': 'enable',
            'v4_ecmp_mode': 'source-ip-based',
            'vpn_stats_log': 'ipsec',
            'vpn_stats_period': '112',
            'wccp_cache_engine': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_settings.fortios_system(input_data, fos_instance)

    expected_data = {
        'allow-linkdown-path': 'enable',
        'allow-subnet-overlap': 'enable',
        'asymroute': 'enable',
        'asymroute-icmp': 'enable',
        'asymroute6': 'enable',
        'asymroute6-icmp': 'enable',
        'bfd': 'enable',
        'bfd-desired-min-tx': '10',
        'bfd-detect-mult': '11',
        'bfd-dont-enforce-src-port': 'enable',
        'bfd-required-min-rx': '13',
        'block-land-attack': 'disable',
        'central-nat': 'enable',
        'comments': 'test_value_16',
        'compliance-check': 'enable',
        'default-voip-alg-mode': 'proxy-based',
        'deny-tcp-with-icmp': 'enable',
        'device': 'test_value_20',
        'dhcp-proxy': 'enable',
        'dhcp-server-ip': 'test_value_22',
        'dhcp6-server-ip': 'test_value_23',
        'discovered-device-timeout': '24',
        'ecmp-max-paths': '25',
        'email-portal-check-dns': 'disable',
        'firewall-session-dirty': 'check-all',
        'fw-session-hairpin': 'enable',
        'gateway': 'test_value_29',
        'gateway6': 'test_value_30',
        'gui-advanced-policy': 'enable',
        'gui-allow-unnamed-policy': 'enable',
        'gui-antivirus': 'enable',
        'gui-ap-profile': 'enable',
        'gui-application-control': 'enable',
        'gui-dhcp-advanced': 'enable',
        'gui-dlp': 'enable',
        'gui-dns-database': 'enable',
        'gui-dnsfilter': 'enable',
        'gui-domain-ip-reputation': 'enable',
        'gui-dos-policy': 'enable',
        'gui-dynamic-profile-display': 'enable',
        'gui-dynamic-routing': 'enable',
        'gui-email-collection': 'enable',
        'gui-endpoint-control': 'enable',
        'gui-endpoint-control-advanced': 'enable',
        'gui-explicit-proxy': 'enable',
        'gui-fortiap-split-tunneling': 'enable',
        'gui-fortiextender-controller': 'enable',
        'gui-icap': 'enable',
        'gui-implicit-policy': 'enable',
        'gui-ips': 'enable',
        'gui-load-balance': 'enable',
        'gui-local-in-policy': 'enable',
        'gui-local-reports': 'enable',
        'gui-multicast-policy': 'enable',
        'gui-multiple-interface-policy': 'enable',
        'gui-multiple-utm-profiles': 'enable',
        'gui-nat46-64': 'enable',
        'gui-object-colors': 'enable',
        'gui-policy-based-ipsec': 'enable',
        'gui-policy-learning': 'enable',
        'gui-replacement-message-groups': 'enable',
        'gui-spamfilter': 'enable',
        'gui-sslvpn-personal-bookmarks': 'enable',
        'gui-sslvpn-realms': 'enable',
        'gui-switch-controller': 'enable',
        'gui-threat-weight': 'enable',
        'gui-traffic-shaping': 'enable',
        'gui-voip-profile': 'enable',
        'gui-vpn': 'enable',
        'gui-waf-profile': 'enable',
        'gui-wan-load-balancing': 'enable',
        'gui-wanopt-cache': 'enable',
        'gui-webfilter': 'enable',
        'gui-webfilter-advanced': 'enable',
        'gui-wireless-controller': 'enable',
        'http-external-dest': 'fortiweb',
        'ike-dn-format': 'with-space',
        'ike-quick-crash-detect': 'enable',
        'ike-session-resume': 'enable',
        'implicit-allow-dns': 'enable',
        'inspection-mode': 'proxy',
        'ip': 'test_value_84',
        'ip6': 'test_value_85',
        'link-down-access': 'enable',
        'lldp-transmission': 'enable',
        'mac-ttl': '88',
        'manageip': 'test_value_89',
        'manageip6': 'test_value_90',
        'multicast-forward': 'enable',
        'multicast-skip-policy': 'enable',
        'multicast-ttl-notchange': 'enable',
        'ngfw-mode': 'profile-based',
        'opmode': 'nat',
        'prp-trailer-action': 'enable',
        'sccp-port': '97',
        'ses-denied-traffic': 'enable',
        'sip-helper': 'enable',
        'sip-nat-trace': 'enable',
        'sip-ssl-port': '101',
        'sip-tcp-port': '102',
        'sip-udp-port': '103',
        'snat-hairpin-traffic': 'enable',
        'ssl-ssh-profile': 'test_value_105',
        'status': 'enable',
        'strict-src-check': 'enable',
        'tcp-session-without-syn': 'enable',
        'utf8-spam-tagging': 'enable',
        'v4-ecmp-mode': 'source-ip-based',
        'vpn-stats-log': 'ipsec',
        'vpn-stats-period': '112',
        'wccp-cache-engine': 'enable'
    }

    set_method_mock.assert_called_with('system', 'settings', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200


def test_system_settings_creation_fails(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'POST', 'http_status': 500}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_settings': {
            'allow_linkdown_path': 'enable',
            'allow_subnet_overlap': 'enable',
            'asymroute': 'enable',
            'asymroute_icmp': 'enable',
            'asymroute6': 'enable',
            'asymroute6_icmp': 'enable',
            'bfd': 'enable',
            'bfd_desired_min_tx': '10',
            'bfd_detect_mult': '11',
            'bfd_dont_enforce_src_port': 'enable',
            'bfd_required_min_rx': '13',
            'block_land_attack': 'disable',
            'central_nat': 'enable',
            'comments': 'test_value_16',
            'compliance_check': 'enable',
            'default_voip_alg_mode': 'proxy-based',
            'deny_tcp_with_icmp': 'enable',
            'device': 'test_value_20',
            'dhcp_proxy': 'enable',
            'dhcp_server_ip': 'test_value_22',
            'dhcp6_server_ip': 'test_value_23',
            'discovered_device_timeout': '24',
            'ecmp_max_paths': '25',
            'email_portal_check_dns': 'disable',
            'firewall_session_dirty': 'check-all',
            'fw_session_hairpin': 'enable',
            'gateway': 'test_value_29',
            'gateway6': 'test_value_30',
            'gui_advanced_policy': 'enable',
            'gui_allow_unnamed_policy': 'enable',
            'gui_antivirus': 'enable',
            'gui_ap_profile': 'enable',
            'gui_application_control': 'enable',
            'gui_dhcp_advanced': 'enable',
            'gui_dlp': 'enable',
            'gui_dns_database': 'enable',
            'gui_dnsfilter': 'enable',
            'gui_domain_ip_reputation': 'enable',
            'gui_dos_policy': 'enable',
            'gui_dynamic_profile_display': 'enable',
            'gui_dynamic_routing': 'enable',
            'gui_email_collection': 'enable',
            'gui_endpoint_control': 'enable',
            'gui_endpoint_control_advanced': 'enable',
            'gui_explicit_proxy': 'enable',
            'gui_fortiap_split_tunneling': 'enable',
            'gui_fortiextender_controller': 'enable',
            'gui_icap': 'enable',
            'gui_implicit_policy': 'enable',
            'gui_ips': 'enable',
            'gui_load_balance': 'enable',
            'gui_local_in_policy': 'enable',
            'gui_local_reports': 'enable',
            'gui_multicast_policy': 'enable',
            'gui_multiple_interface_policy': 'enable',
            'gui_multiple_utm_profiles': 'enable',
            'gui_nat46_64': 'enable',
            'gui_object_colors': 'enable',
            'gui_policy_based_ipsec': 'enable',
            'gui_policy_learning': 'enable',
            'gui_replacement_message_groups': 'enable',
            'gui_spamfilter': 'enable',
            'gui_sslvpn_personal_bookmarks': 'enable',
            'gui_sslvpn_realms': 'enable',
            'gui_switch_controller': 'enable',
            'gui_threat_weight': 'enable',
            'gui_traffic_shaping': 'enable',
            'gui_voip_profile': 'enable',
            'gui_vpn': 'enable',
            'gui_waf_profile': 'enable',
            'gui_wan_load_balancing': 'enable',
            'gui_wanopt_cache': 'enable',
            'gui_webfilter': 'enable',
            'gui_webfilter_advanced': 'enable',
            'gui_wireless_controller': 'enable',
            'http_external_dest': 'fortiweb',
            'ike_dn_format': 'with-space',
            'ike_quick_crash_detect': 'enable',
            'ike_session_resume': 'enable',
            'implicit_allow_dns': 'enable',
            'inspection_mode': 'proxy',
            'ip': 'test_value_84',
            'ip6': 'test_value_85',
            'link_down_access': 'enable',
            'lldp_transmission': 'enable',
            'mac_ttl': '88',
            'manageip': 'test_value_89',
            'manageip6': 'test_value_90',
            'multicast_forward': 'enable',
            'multicast_skip_policy': 'enable',
            'multicast_ttl_notchange': 'enable',
            'ngfw_mode': 'profile-based',
            'opmode': 'nat',
            'prp_trailer_action': 'enable',
            'sccp_port': '97',
            'ses_denied_traffic': 'enable',
            'sip_helper': 'enable',
            'sip_nat_trace': 'enable',
            'sip_ssl_port': '101',
            'sip_tcp_port': '102',
            'sip_udp_port': '103',
            'snat_hairpin_traffic': 'enable',
            'ssl_ssh_profile': 'test_value_105',
            'status': 'enable',
            'strict_src_check': 'enable',
            'tcp_session_without_syn': 'enable',
            'utf8_spam_tagging': 'enable',
            'v4_ecmp_mode': 'source-ip-based',
            'vpn_stats_log': 'ipsec',
            'vpn_stats_period': '112',
            'wccp_cache_engine': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_settings.fortios_system(input_data, fos_instance)

    expected_data = {
        'allow-linkdown-path': 'enable',
        'allow-subnet-overlap': 'enable',
        'asymroute': 'enable',
        'asymroute-icmp': 'enable',
        'asymroute6': 'enable',
        'asymroute6-icmp': 'enable',
        'bfd': 'enable',
        'bfd-desired-min-tx': '10',
        'bfd-detect-mult': '11',
        'bfd-dont-enforce-src-port': 'enable',
        'bfd-required-min-rx': '13',
        'block-land-attack': 'disable',
        'central-nat': 'enable',
        'comments': 'test_value_16',
        'compliance-check': 'enable',
        'default-voip-alg-mode': 'proxy-based',
        'deny-tcp-with-icmp': 'enable',
        'device': 'test_value_20',
        'dhcp-proxy': 'enable',
        'dhcp-server-ip': 'test_value_22',
        'dhcp6-server-ip': 'test_value_23',
        'discovered-device-timeout': '24',
        'ecmp-max-paths': '25',
        'email-portal-check-dns': 'disable',
        'firewall-session-dirty': 'check-all',
        'fw-session-hairpin': 'enable',
        'gateway': 'test_value_29',
        'gateway6': 'test_value_30',
        'gui-advanced-policy': 'enable',
        'gui-allow-unnamed-policy': 'enable',
        'gui-antivirus': 'enable',
        'gui-ap-profile': 'enable',
        'gui-application-control': 'enable',
        'gui-dhcp-advanced': 'enable',
        'gui-dlp': 'enable',
        'gui-dns-database': 'enable',
        'gui-dnsfilter': 'enable',
        'gui-domain-ip-reputation': 'enable',
        'gui-dos-policy': 'enable',
        'gui-dynamic-profile-display': 'enable',
        'gui-dynamic-routing': 'enable',
        'gui-email-collection': 'enable',
        'gui-endpoint-control': 'enable',
        'gui-endpoint-control-advanced': 'enable',
        'gui-explicit-proxy': 'enable',
        'gui-fortiap-split-tunneling': 'enable',
        'gui-fortiextender-controller': 'enable',
        'gui-icap': 'enable',
        'gui-implicit-policy': 'enable',
        'gui-ips': 'enable',
        'gui-load-balance': 'enable',
        'gui-local-in-policy': 'enable',
        'gui-local-reports': 'enable',
        'gui-multicast-policy': 'enable',
        'gui-multiple-interface-policy': 'enable',
        'gui-multiple-utm-profiles': 'enable',
        'gui-nat46-64': 'enable',
        'gui-object-colors': 'enable',
        'gui-policy-based-ipsec': 'enable',
        'gui-policy-learning': 'enable',
        'gui-replacement-message-groups': 'enable',
        'gui-spamfilter': 'enable',
        'gui-sslvpn-personal-bookmarks': 'enable',
        'gui-sslvpn-realms': 'enable',
        'gui-switch-controller': 'enable',
        'gui-threat-weight': 'enable',
        'gui-traffic-shaping': 'enable',
        'gui-voip-profile': 'enable',
        'gui-vpn': 'enable',
        'gui-waf-profile': 'enable',
        'gui-wan-load-balancing': 'enable',
        'gui-wanopt-cache': 'enable',
        'gui-webfilter': 'enable',
        'gui-webfilter-advanced': 'enable',
        'gui-wireless-controller': 'enable',
        'http-external-dest': 'fortiweb',
        'ike-dn-format': 'with-space',
        'ike-quick-crash-detect': 'enable',
        'ike-session-resume': 'enable',
        'implicit-allow-dns': 'enable',
        'inspection-mode': 'proxy',
        'ip': 'test_value_84',
        'ip6': 'test_value_85',
        'link-down-access': 'enable',
        'lldp-transmission': 'enable',
        'mac-ttl': '88',
        'manageip': 'test_value_89',
        'manageip6': 'test_value_90',
        'multicast-forward': 'enable',
        'multicast-skip-policy': 'enable',
        'multicast-ttl-notchange': 'enable',
        'ngfw-mode': 'profile-based',
        'opmode': 'nat',
        'prp-trailer-action': 'enable',
        'sccp-port': '97',
        'ses-denied-traffic': 'enable',
        'sip-helper': 'enable',
        'sip-nat-trace': 'enable',
        'sip-ssl-port': '101',
        'sip-tcp-port': '102',
        'sip-udp-port': '103',
        'snat-hairpin-traffic': 'enable',
        'ssl-ssh-profile': 'test_value_105',
        'status': 'enable',
        'strict-src-check': 'enable',
        'tcp-session-without-syn': 'enable',
        'utf8-spam-tagging': 'enable',
        'v4-ecmp-mode': 'source-ip-based',
        'vpn-stats-log': 'ipsec',
        'vpn-stats-period': '112',
        'wccp-cache-engine': 'enable'
    }

    set_method_mock.assert_called_with('system', 'settings', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 500


def test_system_settings_idempotent(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'error', 'http_method': 'DELETE', 'http_status': 404}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_settings': {
            'allow_linkdown_path': 'enable',
            'allow_subnet_overlap': 'enable',
            'asymroute': 'enable',
            'asymroute_icmp': 'enable',
            'asymroute6': 'enable',
            'asymroute6_icmp': 'enable',
            'bfd': 'enable',
            'bfd_desired_min_tx': '10',
            'bfd_detect_mult': '11',
            'bfd_dont_enforce_src_port': 'enable',
            'bfd_required_min_rx': '13',
            'block_land_attack': 'disable',
            'central_nat': 'enable',
            'comments': 'test_value_16',
            'compliance_check': 'enable',
            'default_voip_alg_mode': 'proxy-based',
            'deny_tcp_with_icmp': 'enable',
            'device': 'test_value_20',
            'dhcp_proxy': 'enable',
            'dhcp_server_ip': 'test_value_22',
            'dhcp6_server_ip': 'test_value_23',
            'discovered_device_timeout': '24',
            'ecmp_max_paths': '25',
            'email_portal_check_dns': 'disable',
            'firewall_session_dirty': 'check-all',
            'fw_session_hairpin': 'enable',
            'gateway': 'test_value_29',
            'gateway6': 'test_value_30',
            'gui_advanced_policy': 'enable',
            'gui_allow_unnamed_policy': 'enable',
            'gui_antivirus': 'enable',
            'gui_ap_profile': 'enable',
            'gui_application_control': 'enable',
            'gui_dhcp_advanced': 'enable',
            'gui_dlp': 'enable',
            'gui_dns_database': 'enable',
            'gui_dnsfilter': 'enable',
            'gui_domain_ip_reputation': 'enable',
            'gui_dos_policy': 'enable',
            'gui_dynamic_profile_display': 'enable',
            'gui_dynamic_routing': 'enable',
            'gui_email_collection': 'enable',
            'gui_endpoint_control': 'enable',
            'gui_endpoint_control_advanced': 'enable',
            'gui_explicit_proxy': 'enable',
            'gui_fortiap_split_tunneling': 'enable',
            'gui_fortiextender_controller': 'enable',
            'gui_icap': 'enable',
            'gui_implicit_policy': 'enable',
            'gui_ips': 'enable',
            'gui_load_balance': 'enable',
            'gui_local_in_policy': 'enable',
            'gui_local_reports': 'enable',
            'gui_multicast_policy': 'enable',
            'gui_multiple_interface_policy': 'enable',
            'gui_multiple_utm_profiles': 'enable',
            'gui_nat46_64': 'enable',
            'gui_object_colors': 'enable',
            'gui_policy_based_ipsec': 'enable',
            'gui_policy_learning': 'enable',
            'gui_replacement_message_groups': 'enable',
            'gui_spamfilter': 'enable',
            'gui_sslvpn_personal_bookmarks': 'enable',
            'gui_sslvpn_realms': 'enable',
            'gui_switch_controller': 'enable',
            'gui_threat_weight': 'enable',
            'gui_traffic_shaping': 'enable',
            'gui_voip_profile': 'enable',
            'gui_vpn': 'enable',
            'gui_waf_profile': 'enable',
            'gui_wan_load_balancing': 'enable',
            'gui_wanopt_cache': 'enable',
            'gui_webfilter': 'enable',
            'gui_webfilter_advanced': 'enable',
            'gui_wireless_controller': 'enable',
            'http_external_dest': 'fortiweb',
            'ike_dn_format': 'with-space',
            'ike_quick_crash_detect': 'enable',
            'ike_session_resume': 'enable',
            'implicit_allow_dns': 'enable',
            'inspection_mode': 'proxy',
            'ip': 'test_value_84',
            'ip6': 'test_value_85',
            'link_down_access': 'enable',
            'lldp_transmission': 'enable',
            'mac_ttl': '88',
            'manageip': 'test_value_89',
            'manageip6': 'test_value_90',
            'multicast_forward': 'enable',
            'multicast_skip_policy': 'enable',
            'multicast_ttl_notchange': 'enable',
            'ngfw_mode': 'profile-based',
            'opmode': 'nat',
            'prp_trailer_action': 'enable',
            'sccp_port': '97',
            'ses_denied_traffic': 'enable',
            'sip_helper': 'enable',
            'sip_nat_trace': 'enable',
            'sip_ssl_port': '101',
            'sip_tcp_port': '102',
            'sip_udp_port': '103',
            'snat_hairpin_traffic': 'enable',
            'ssl_ssh_profile': 'test_value_105',
            'status': 'enable',
            'strict_src_check': 'enable',
            'tcp_session_without_syn': 'enable',
            'utf8_spam_tagging': 'enable',
            'v4_ecmp_mode': 'source-ip-based',
            'vpn_stats_log': 'ipsec',
            'vpn_stats_period': '112',
            'wccp_cache_engine': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_settings.fortios_system(input_data, fos_instance)

    expected_data = {
        'allow-linkdown-path': 'enable',
        'allow-subnet-overlap': 'enable',
        'asymroute': 'enable',
        'asymroute-icmp': 'enable',
        'asymroute6': 'enable',
        'asymroute6-icmp': 'enable',
        'bfd': 'enable',
        'bfd-desired-min-tx': '10',
        'bfd-detect-mult': '11',
        'bfd-dont-enforce-src-port': 'enable',
        'bfd-required-min-rx': '13',
        'block-land-attack': 'disable',
        'central-nat': 'enable',
        'comments': 'test_value_16',
        'compliance-check': 'enable',
        'default-voip-alg-mode': 'proxy-based',
        'deny-tcp-with-icmp': 'enable',
        'device': 'test_value_20',
        'dhcp-proxy': 'enable',
        'dhcp-server-ip': 'test_value_22',
        'dhcp6-server-ip': 'test_value_23',
        'discovered-device-timeout': '24',
        'ecmp-max-paths': '25',
        'email-portal-check-dns': 'disable',
        'firewall-session-dirty': 'check-all',
        'fw-session-hairpin': 'enable',
        'gateway': 'test_value_29',
        'gateway6': 'test_value_30',
        'gui-advanced-policy': 'enable',
        'gui-allow-unnamed-policy': 'enable',
        'gui-antivirus': 'enable',
        'gui-ap-profile': 'enable',
        'gui-application-control': 'enable',
        'gui-dhcp-advanced': 'enable',
        'gui-dlp': 'enable',
        'gui-dns-database': 'enable',
        'gui-dnsfilter': 'enable',
        'gui-domain-ip-reputation': 'enable',
        'gui-dos-policy': 'enable',
        'gui-dynamic-profile-display': 'enable',
        'gui-dynamic-routing': 'enable',
        'gui-email-collection': 'enable',
        'gui-endpoint-control': 'enable',
        'gui-endpoint-control-advanced': 'enable',
        'gui-explicit-proxy': 'enable',
        'gui-fortiap-split-tunneling': 'enable',
        'gui-fortiextender-controller': 'enable',
        'gui-icap': 'enable',
        'gui-implicit-policy': 'enable',
        'gui-ips': 'enable',
        'gui-load-balance': 'enable',
        'gui-local-in-policy': 'enable',
        'gui-local-reports': 'enable',
        'gui-multicast-policy': 'enable',
        'gui-multiple-interface-policy': 'enable',
        'gui-multiple-utm-profiles': 'enable',
        'gui-nat46-64': 'enable',
        'gui-object-colors': 'enable',
        'gui-policy-based-ipsec': 'enable',
        'gui-policy-learning': 'enable',
        'gui-replacement-message-groups': 'enable',
        'gui-spamfilter': 'enable',
        'gui-sslvpn-personal-bookmarks': 'enable',
        'gui-sslvpn-realms': 'enable',
        'gui-switch-controller': 'enable',
        'gui-threat-weight': 'enable',
        'gui-traffic-shaping': 'enable',
        'gui-voip-profile': 'enable',
        'gui-vpn': 'enable',
        'gui-waf-profile': 'enable',
        'gui-wan-load-balancing': 'enable',
        'gui-wanopt-cache': 'enable',
        'gui-webfilter': 'enable',
        'gui-webfilter-advanced': 'enable',
        'gui-wireless-controller': 'enable',
        'http-external-dest': 'fortiweb',
        'ike-dn-format': 'with-space',
        'ike-quick-crash-detect': 'enable',
        'ike-session-resume': 'enable',
        'implicit-allow-dns': 'enable',
        'inspection-mode': 'proxy',
        'ip': 'test_value_84',
        'ip6': 'test_value_85',
        'link-down-access': 'enable',
        'lldp-transmission': 'enable',
        'mac-ttl': '88',
        'manageip': 'test_value_89',
        'manageip6': 'test_value_90',
        'multicast-forward': 'enable',
        'multicast-skip-policy': 'enable',
        'multicast-ttl-notchange': 'enable',
        'ngfw-mode': 'profile-based',
        'opmode': 'nat',
        'prp-trailer-action': 'enable',
        'sccp-port': '97',
        'ses-denied-traffic': 'enable',
        'sip-helper': 'enable',
        'sip-nat-trace': 'enable',
        'sip-ssl-port': '101',
        'sip-tcp-port': '102',
        'sip-udp-port': '103',
        'snat-hairpin-traffic': 'enable',
        'ssl-ssh-profile': 'test_value_105',
        'status': 'enable',
        'strict-src-check': 'enable',
        'tcp-session-without-syn': 'enable',
        'utf8-spam-tagging': 'enable',
        'v4-ecmp-mode': 'source-ip-based',
        'vpn-stats-log': 'ipsec',
        'vpn-stats-period': '112',
        'wccp-cache-engine': 'enable'
    }

    set_method_mock.assert_called_with('system', 'settings', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert not changed
    assert response['status'] == 'error'
    assert response['http_status'] == 404


def test_system_settings_filter_foreign_attributes(mocker):
    schema_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.schema')

    set_method_result = {'status': 'success', 'http_method': 'POST', 'http_status': 200}
    set_method_mock = mocker.patch('ansible.module_utils.network.fortios.fortios.FortiOSHandler.set', return_value=set_method_result)

    input_data = {
        'username': 'admin',
        'state': 'present',
        'system_settings': {
            'random_attribute_not_valid': 'tag',
            'allow_linkdown_path': 'enable',
            'allow_subnet_overlap': 'enable',
            'asymroute': 'enable',
            'asymroute_icmp': 'enable',
            'asymroute6': 'enable',
            'asymroute6_icmp': 'enable',
            'bfd': 'enable',
            'bfd_desired_min_tx': '10',
            'bfd_detect_mult': '11',
            'bfd_dont_enforce_src_port': 'enable',
            'bfd_required_min_rx': '13',
            'block_land_attack': 'disable',
            'central_nat': 'enable',
            'comments': 'test_value_16',
            'compliance_check': 'enable',
            'default_voip_alg_mode': 'proxy-based',
            'deny_tcp_with_icmp': 'enable',
            'device': 'test_value_20',
            'dhcp_proxy': 'enable',
            'dhcp_server_ip': 'test_value_22',
            'dhcp6_server_ip': 'test_value_23',
            'discovered_device_timeout': '24',
            'ecmp_max_paths': '25',
            'email_portal_check_dns': 'disable',
            'firewall_session_dirty': 'check-all',
            'fw_session_hairpin': 'enable',
            'gateway': 'test_value_29',
            'gateway6': 'test_value_30',
            'gui_advanced_policy': 'enable',
            'gui_allow_unnamed_policy': 'enable',
            'gui_antivirus': 'enable',
            'gui_ap_profile': 'enable',
            'gui_application_control': 'enable',
            'gui_dhcp_advanced': 'enable',
            'gui_dlp': 'enable',
            'gui_dns_database': 'enable',
            'gui_dnsfilter': 'enable',
            'gui_domain_ip_reputation': 'enable',
            'gui_dos_policy': 'enable',
            'gui_dynamic_profile_display': 'enable',
            'gui_dynamic_routing': 'enable',
            'gui_email_collection': 'enable',
            'gui_endpoint_control': 'enable',
            'gui_endpoint_control_advanced': 'enable',
            'gui_explicit_proxy': 'enable',
            'gui_fortiap_split_tunneling': 'enable',
            'gui_fortiextender_controller': 'enable',
            'gui_icap': 'enable',
            'gui_implicit_policy': 'enable',
            'gui_ips': 'enable',
            'gui_load_balance': 'enable',
            'gui_local_in_policy': 'enable',
            'gui_local_reports': 'enable',
            'gui_multicast_policy': 'enable',
            'gui_multiple_interface_policy': 'enable',
            'gui_multiple_utm_profiles': 'enable',
            'gui_nat46_64': 'enable',
            'gui_object_colors': 'enable',
            'gui_policy_based_ipsec': 'enable',
            'gui_policy_learning': 'enable',
            'gui_replacement_message_groups': 'enable',
            'gui_spamfilter': 'enable',
            'gui_sslvpn_personal_bookmarks': 'enable',
            'gui_sslvpn_realms': 'enable',
            'gui_switch_controller': 'enable',
            'gui_threat_weight': 'enable',
            'gui_traffic_shaping': 'enable',
            'gui_voip_profile': 'enable',
            'gui_vpn': 'enable',
            'gui_waf_profile': 'enable',
            'gui_wan_load_balancing': 'enable',
            'gui_wanopt_cache': 'enable',
            'gui_webfilter': 'enable',
            'gui_webfilter_advanced': 'enable',
            'gui_wireless_controller': 'enable',
            'http_external_dest': 'fortiweb',
            'ike_dn_format': 'with-space',
            'ike_quick_crash_detect': 'enable',
            'ike_session_resume': 'enable',
            'implicit_allow_dns': 'enable',
            'inspection_mode': 'proxy',
            'ip': 'test_value_84',
            'ip6': 'test_value_85',
            'link_down_access': 'enable',
            'lldp_transmission': 'enable',
            'mac_ttl': '88',
            'manageip': 'test_value_89',
            'manageip6': 'test_value_90',
            'multicast_forward': 'enable',
            'multicast_skip_policy': 'enable',
            'multicast_ttl_notchange': 'enable',
            'ngfw_mode': 'profile-based',
            'opmode': 'nat',
            'prp_trailer_action': 'enable',
            'sccp_port': '97',
            'ses_denied_traffic': 'enable',
            'sip_helper': 'enable',
            'sip_nat_trace': 'enable',
            'sip_ssl_port': '101',
            'sip_tcp_port': '102',
            'sip_udp_port': '103',
            'snat_hairpin_traffic': 'enable',
            'ssl_ssh_profile': 'test_value_105',
            'status': 'enable',
            'strict_src_check': 'enable',
            'tcp_session_without_syn': 'enable',
            'utf8_spam_tagging': 'enable',
            'v4_ecmp_mode': 'source-ip-based',
            'vpn_stats_log': 'ipsec',
            'vpn_stats_period': '112',
            'wccp_cache_engine': 'enable'
        },
        'vdom': 'root'}

    is_error, changed, response = fortios_system_settings.fortios_system(input_data, fos_instance)

    expected_data = {
        'allow-linkdown-path': 'enable',
        'allow-subnet-overlap': 'enable',
        'asymroute': 'enable',
        'asymroute-icmp': 'enable',
        'asymroute6': 'enable',
        'asymroute6-icmp': 'enable',
        'bfd': 'enable',
        'bfd-desired-min-tx': '10',
        'bfd-detect-mult': '11',
        'bfd-dont-enforce-src-port': 'enable',
        'bfd-required-min-rx': '13',
        'block-land-attack': 'disable',
        'central-nat': 'enable',
        'comments': 'test_value_16',
        'compliance-check': 'enable',
        'default-voip-alg-mode': 'proxy-based',
        'deny-tcp-with-icmp': 'enable',
        'device': 'test_value_20',
        'dhcp-proxy': 'enable',
        'dhcp-server-ip': 'test_value_22',
        'dhcp6-server-ip': 'test_value_23',
        'discovered-device-timeout': '24',
        'ecmp-max-paths': '25',
        'email-portal-check-dns': 'disable',
        'firewall-session-dirty': 'check-all',
        'fw-session-hairpin': 'enable',
        'gateway': 'test_value_29',
        'gateway6': 'test_value_30',
        'gui-advanced-policy': 'enable',
        'gui-allow-unnamed-policy': 'enable',
        'gui-antivirus': 'enable',
        'gui-ap-profile': 'enable',
        'gui-application-control': 'enable',
        'gui-dhcp-advanced': 'enable',
        'gui-dlp': 'enable',
        'gui-dns-database': 'enable',
        'gui-dnsfilter': 'enable',
        'gui-domain-ip-reputation': 'enable',
        'gui-dos-policy': 'enable',
        'gui-dynamic-profile-display': 'enable',
        'gui-dynamic-routing': 'enable',
        'gui-email-collection': 'enable',
        'gui-endpoint-control': 'enable',
        'gui-endpoint-control-advanced': 'enable',
        'gui-explicit-proxy': 'enable',
        'gui-fortiap-split-tunneling': 'enable',
        'gui-fortiextender-controller': 'enable',
        'gui-icap': 'enable',
        'gui-implicit-policy': 'enable',
        'gui-ips': 'enable',
        'gui-load-balance': 'enable',
        'gui-local-in-policy': 'enable',
        'gui-local-reports': 'enable',
        'gui-multicast-policy': 'enable',
        'gui-multiple-interface-policy': 'enable',
        'gui-multiple-utm-profiles': 'enable',
        'gui-nat46-64': 'enable',
        'gui-object-colors': 'enable',
        'gui-policy-based-ipsec': 'enable',
        'gui-policy-learning': 'enable',
        'gui-replacement-message-groups': 'enable',
        'gui-spamfilter': 'enable',
        'gui-sslvpn-personal-bookmarks': 'enable',
        'gui-sslvpn-realms': 'enable',
        'gui-switch-controller': 'enable',
        'gui-threat-weight': 'enable',
        'gui-traffic-shaping': 'enable',
        'gui-voip-profile': 'enable',
        'gui-vpn': 'enable',
        'gui-waf-profile': 'enable',
        'gui-wan-load-balancing': 'enable',
        'gui-wanopt-cache': 'enable',
        'gui-webfilter': 'enable',
        'gui-webfilter-advanced': 'enable',
        'gui-wireless-controller': 'enable',
        'http-external-dest': 'fortiweb',
        'ike-dn-format': 'with-space',
        'ike-quick-crash-detect': 'enable',
        'ike-session-resume': 'enable',
        'implicit-allow-dns': 'enable',
        'inspection-mode': 'proxy',
        'ip': 'test_value_84',
        'ip6': 'test_value_85',
        'link-down-access': 'enable',
        'lldp-transmission': 'enable',
        'mac-ttl': '88',
        'manageip': 'test_value_89',
        'manageip6': 'test_value_90',
        'multicast-forward': 'enable',
        'multicast-skip-policy': 'enable',
        'multicast-ttl-notchange': 'enable',
        'ngfw-mode': 'profile-based',
        'opmode': 'nat',
        'prp-trailer-action': 'enable',
        'sccp-port': '97',
        'ses-denied-traffic': 'enable',
        'sip-helper': 'enable',
        'sip-nat-trace': 'enable',
        'sip-ssl-port': '101',
        'sip-tcp-port': '102',
        'sip-udp-port': '103',
        'snat-hairpin-traffic': 'enable',
        'ssl-ssh-profile': 'test_value_105',
        'status': 'enable',
        'strict-src-check': 'enable',
        'tcp-session-without-syn': 'enable',
        'utf8-spam-tagging': 'enable',
        'v4-ecmp-mode': 'source-ip-based',
        'vpn-stats-log': 'ipsec',
        'vpn-stats-period': '112',
        'wccp-cache-engine': 'enable'
    }

    set_method_mock.assert_called_with('system', 'settings', data=expected_data, vdom='root')
    schema_method_mock.assert_not_called()
    assert not is_error
    assert changed
    assert response['status'] == 'success'
    assert response['http_status'] == 200
