/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.android.tools.rpclib.binary;

import junit.framework.TestCase;

import java.io.ByteArrayInputStream;
import java.io.IOException;

public class ObjectTypeIDTest extends TestCase {
  static final byte[] idBytes = {
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
    0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x10, 0x11, 0x12, 0x13
  };
  static final ObjectTypeID id = new ObjectTypeID(idBytes);

  public void testDecodeObjectTypeID() throws IOException {
    ByteArrayInputStream input = new ByteArrayInputStream(idBytes);
    Decoder d = new Decoder(input);

    ObjectTypeID idFromDecoder = new ObjectTypeID(d);
    assertEquals(id, idFromDecoder);
  }

  public void testRegisterAndLookupObjectTypeID() {
    BinaryObjectCreator dummyObjectCreator = new BinaryObjectCreator() {
      @Override public BinaryObject create() { return null; }
    };
    ObjectTypeID.register(id, dummyObjectCreator);
    assertEquals(ObjectTypeID.lookup(id), dummyObjectCreator);
  }
}
