#!/bin/sh

# FILE : build-tree.sh
# DESC : This script replaces Makefile in app/ and/or lib/
#        when multiple apps or libs are in the package

set -e

usage()
{
	echo "This script requires a target to build, from this list"
	echo "all app|lib clean install uninstall"
	echo "native|cross can specify build environment, default is cross"
	exit 1
}

# check for at least one command-line argument
if [ "$#" -eq 0 ]
then
	usage
fi

# parse first command-line argument
target=none
for i; do
	case "$1" in
		all ) target=all; shift;;
		app ) target=app; shift;;
		lib ) target=lib; shift;;
		clean ) target=clean; shift;;
		install ) target=install; shift;;
		uninstall ) target=uninstall; shift;;
	esac
        if [ $# -eq 0 ]
        then
                break
        fi
done


if [ "$target" = "none" ]
then
	usage
fi

architecture=`dpkg-architecture -qDEB_HOST_ARCH`

# iterate through the directories under this node
# following the dependency order
cwd=`pwd`

make ARCH=$architecture -C $cwd/liblog $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/utils $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/libcutils $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/binder $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/audio_utils $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/libmedia $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/waudio $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/wctlplugin $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

make ARCH=$architecture -C $cwd/wpcmplugin $target
ret_value=$?
if [ $ret_value -ne 0 ]
then
	exit $ret_value
fi

#for d in *
#do
#	if [ -d $d -a "$d" != "include" ]
#	then
#		echo "***********************************************"
#		echo "build-tree.sh make ARCH=$architecture -C $cwd/$d $target"
#		echo "***********************************************"
#		make ARCH=$architecture -C $cwd/$d $target
#		ret_value=$?
#		if [ $ret_value -ne 0 ]
#		then
#			exit $ret_value
#		fi
#	fi
#done

