/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.messages;

import amazon.fws.clicommando.util.StringUtils;

public class CoralMessageParser {
    public static final String CORAL_CODE_TAG = "<Code";
    public static final String CORAL_MESSAGE_TAG = "<Message";
    public static final String CORAL_CODE_END_TAG = "</Code>";
    public static final String CORAL_MESSAGE_END_TAG = "</Message>";
    public static final String CORAL_REQUESTID_TAG = "<RequestId";
    public static final String CORAL_REQUESTID_END_TAG = "</RequestId>";
    public static final String XFIRE_CODE_TAG = "<faultcode";
    public static final String XFIRE_MESSAGE_TAG = "<faultstring";
    public static final String XFIRE_CODE_END_TAG = "</faultcode>";
    public static final String XFIRE_MESSAGE_END_TAG = "</faultstring>";
    public static final String XFIRE_REQUESTID_TAG = "<aws:RequestId";
    public static final String XFIRE_REQUESTID_END_TAG = "</aws:RequestId>";

    public static String[] parse(String message) {
        String[] retVal = CoralMessageParser.tryCoral(message);
        if (retVal == null) {
            retVal = CoralMessageParser.tryXFire(message);
        }
        return retVal;
    }

    public static String[] tryCoral(String coralMessage) {
        String message = null;
        if (coralMessage == null) {
            return null;
        }
        String code = CoralMessageParser.getTagValue(coralMessage, CORAL_CODE_TAG, CORAL_CODE_END_TAG);
        message = CoralMessageParser.getTagValue(coralMessage, CORAL_MESSAGE_TAG, CORAL_MESSAGE_END_TAG);
        String requestId = CoralMessageParser.getTagValue(coralMessage, CORAL_REQUESTID_TAG, CORAL_REQUESTID_END_TAG);
        if (StringUtils.isEmpty(code) && StringUtils.isEmpty(message) && StringUtils.isEmpty(requestId)) {
            return null;
        }
        return new String[]{code, message, requestId};
    }

    public static String[] tryXFire(String xfireMessage) {
        String message = null;
        if (xfireMessage == null) {
            return null;
        }
        String code = CoralMessageParser.getTagValue(xfireMessage, XFIRE_CODE_TAG, XFIRE_CODE_END_TAG);
        message = CoralMessageParser.getTagValue(xfireMessage, XFIRE_MESSAGE_TAG, XFIRE_MESSAGE_END_TAG);
        String requestId = CoralMessageParser.getTagValue(xfireMessage, XFIRE_REQUESTID_TAG, XFIRE_REQUESTID_END_TAG);
        if (StringUtils.isEmpty(code) && StringUtils.isEmpty(message) && StringUtils.isEmpty(requestId)) {
            return null;
        }
        return new String[]{code, message, requestId};
    }

    private static String getTagValue(String string, String startTag, String endTag) {
        int tagClose;
        String tagValue = null;
        int tagStartLocation = string.indexOf(startTag);
        int tagEndLocation = string.indexOf(endTag);
        int n = tagClose = tagStartLocation != -1 ? string.indexOf(">", tagStartLocation) : -1;
        if (tagClose != -1) {
            ++tagClose;
        }
        if (CoralMessageParser.legalTag(tagClose, tagEndLocation)) {
            tagValue = string.substring(tagClose, tagEndLocation);
        }
        return tagValue;
    }

    private static boolean legalTag(int start, int end) {
        return start > -1 && start < end && end > -1;
    }
}

