# Print the path to a file listing the deprecation warnings already shown.
# USAGE: deprecation_warnings_shown_file
# RETURN: the path to the file listing the warnings,
#         or an empty string if such a path can not be computed yet
deprecation_warnings_shown_file() {
	# The list of shown warnings can only be used when PLAYIT_WORKDIR is already set.
	if [ -z "${PLAYIT_WORKDIR:-}" ]; then
		return 0
	fi

	printf '%s/warnings-shown/deprecation' "$PLAYIT_WORKDIR"
}

# Add a warning to the list of already shown ones.
# USAGE: deprecation_warnings_shown_add $warning
deprecation_warnings_shown_add() {
	local warnings_file
	warnings_file=$(deprecation_warnings_shown_file)
	# The list of shown warnings can only be used when PLAYIT_WORKDIR is already set.
	if [ -z "$warnings_file" ]; then
		return 0
	fi
	local warnings_directory
	warnings_directory=$(dirname "$warnings_file")
	mkdir --parents "$warnings_directory"

	local warning
	warning="$1"

	printf '%s\n' "$warning" >> "$warnings_file"
}

# Check if a deprecation warning has already been shown.
# USAGE: deprecation_warning_has_been_shown_already $warning
# RETURN: 0 if the given warning has already been shown,
#         1 if there is no warnings list yet,
#         1 otherwise
deprecation_warning_has_been_shown_already() {
	local warnings_file
	warnings_file=$(deprecation_warnings_shown_file)
	# The list of shown warnings can only be used when PLAYIT_WORKDIR is already set.
	if [ ! -e "$warnings_file" ]; then
		return 1
	fi

	local warning
	warning="$1"

	grep --quiet --fixed-strings --line-regexp --regexp="$warning" "$warnings_file"
}

