#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Super Meat Boy
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220707.1

GAME_ID='super-meat-boy'
GAME_NAME='Super Meat Boy'

ARCHIVE_BASE_0='supermeatboy-linux-11112013-bin'
ARCHIVE_BASE_0_MD5='fc024d757395eebfdee342571671332b'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='260000'
ARCHIVE_BASE_0_VERSION='1.0-humble131111'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/super-meat-boy'

CONTENT_PATH_DEFAULT='data'
ARCHIVE_DOC_DATA_FILES='
README-licenses.txt
README-linux.txt'
ARCHIVE_GAME_BIN32_FILES='
x86'
ARCHIVE_GAME_BIN64_FILES='
amd64'
ARCHIVE_GAME_DATA_FILES='
buttonmap.cfg
gameaudio.dat
gamedata.dat
Levels
resources
supermeatboy.png
locdb.txt
steam_appid.txt'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32='x86/SuperMeatBoy'
APP_MAIN_EXE_BIN64='amd64/SuperMeatBoy'
APP_MAIN_ICON='supermeatboy.png'

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libSDL2-2.0.so.0 libopenal.so.1"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Use persistent storage for user data

DATA_FILES='*.cfg'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
