#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Neon Drive
# build native packages from the original installers
# send your bug reports to contatct@dotslashplay.it
###

script_version=20220630.2

GAME_ID='neon-drive'
GAME_NAME='neon Drive'

ARCHIVE_BASE_1='NeonDrive_V1.5_Linux.zip'
ARCHIVE_BASE_1_MD5='1fcbd5dc69cc08899b792b9f4c0d7075'
ARCHIVE_BASE_1_SIZE='500000'
ARCHIVE_BASE_1_VERSION='1.5-humble170831'
ARCHIVE_BASE_1_URL='https://www.humblebundle.com/store/neon-drive'

ARCHIVE_BASE_0='NeonDrive_V1.4__Linux.rar'
ARCHIVE_BASE_0_MD5='86627f5639234614b036666de4223a15'
ARCHIVE_BASE_0_SIZE='490000'
ARCHIVE_BASE_0_VERSION='1.4-humble1'

UNITY3D_NAME='Neon Drive'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_BIN32_FILES='
Neon?Drive.x86
Neon?Drive_Data/Mono/x86
Neon?Drive_Data/Plugins/x86'
ARCHIVE_GAME_BIN64_FILES='
Neon?Drive.x86_64
Neon?Drive_Data/Mono/x86_64
Neon?Drive_Data/Plugins/x86_64'
ARCHIVE_GAME_DATA_FILES='
Neon?Drive_Data'

APP_MAIN_TYPE='native'
APP_MAIN_EXE_BIN32="${UNITY3D_NAME}.x86"
APP_MAIN_EXE_BIN64="${UNITY3D_NAME}.x86_64"
APP_MAIN_ICON="${UNITY3D_NAME}_Data/Resources/UnityPlayer.png"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libGL.so.1 xcursor libxrandr"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Use a dedicated log file for the current game session

APP_MAIN_PRERUN="$APP_MAIN_PRERUN"'
# Use a dedicated log file for the current game session
mkdir --parents logs
APP_OPTIONS="${APP_OPTIONS} -logFile ./logs/$(date +%F-%R).log"'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
