/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#ifndef DHCP_COMMON_H_
#define DHCP_COMMON_H_

#include <Common.h>
#include <map>
#include <list>

struct dhcp_lease
{
	// the name / value pairs for options for this lease
	string interface;
	string address;
	map<string, list<string> > options;
	string renew;
	string rebind;
	string expire;
	dhcp_lease() {}
};

int get_dhcp_lease_path(string &path, string &errorMessage);
int get_dhcp_leases(dhcp_lease &lease,string key,string &option,string &errorMessage);
int dhcp_ethernet_names(vector<string> &names,string &errorMessage);

#endif /*DHCP_COMMON_H_*/
