/*###############################################################################
# Linux Management Providers (LMP), Boot provider package
# Copyright (C) 2009 Nodir Nazarov <nazarov.nodir@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef CMPIOPENDRIM_BOOTSERVICE_H_
#define CMPIOPENDRIM_BOOTSERVICE_H_

#include "OpenDRIM_BootService.h"

CMPIObjectPath* Boot_OpenDRIM_BootService_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BootService& instance);

CMPIInstance* Boot_OpenDRIM_BootService_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BootService& instance);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BootService& instance);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BootService& instance);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootService_RequestStateChange_In& args);

void Boot_OpenDRIM_BootService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootService_RequestStateChange_Out& args);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootService_CreateBootConfigSetting_In& args);

void Boot_OpenDRIM_BootService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootService_CreateBootConfigSetting_Out& args);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootService_SetBootConfigRole_In& args);

void Boot_OpenDRIM_BootService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootService_SetBootConfigRole_Out& args);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootService_SetBootConfigUsage_In& args);

void Boot_OpenDRIM_BootService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootService_SetBootConfigUsage_Out& args);

void Boot_OpenDRIM_BootService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BootService_ApplyBootConfigSetting_In& args);

void Boot_OpenDRIM_BootService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BootService_ApplyBootConfigSetting_Out& args);


#endif /*CMPIOPENDRIM_BOOTSERVICE_H_*/
