/*###############################################################################
# Linux Management Providers (LMP), Base_Server provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_ComputerSystemAccess.h"

static string name;
const string creationClassName = "OpenDRIM_ComputerSystem";

int Base_Server_OpenDRIM_ComputerSystem_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	CF_assert(CF_getSystemName(name, errorMessage));
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_unload(string& errorMessage) {
	_E_;
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ComputerSystem>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_ComputerSystem instance;
	instance.setCreationClassName(creationClassName);
	instance.setName(name);
	if (discriminant == "ei")
	{
		CF_assert(Base_Server_OpenDRIM_ComputerSystem_populate(instance, errorMessage));
	}
	result.push_back(instance);
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ComputerSystem& instance, const char** properties, string& errorMessage) {
	_E_;

	if (!CF_strCmpNoCase(instance.Name, name) || !CF_strCmpNoCase(instance.CreationClassName, creationClassName))
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}

	CF_assert(Base_Server_OpenDRIM_ComputerSystem_populate(instance, errorMessage));

	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& newInstance, const OpenDRIM_ComputerSystem& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	vector<unsigned short> Dedicated;
	if (newInstance.getDedicated(Dedicated) == OK)
	{
		CF_assert(Base_Server_OpenDRIM_ComputerSystem_setDedicated(newInstance, Dedicated, errorMessage));
	}
	else
		oldInstance.getDedicated(Dedicated);
	bool other_found_in_dedicated = false;
	for (size_t i = 0; i < Dedicated.size(); i++) {
		if (Dedicated[i] == D_OTHER) {
			other_found_in_dedicated = true;
			break;
		}
	}
	if (other_found_in_dedicated) {
		vector<string> OtherDedicatedDescriptions;
		if (newInstance.getOtherDedicatedDescriptions(OtherDedicatedDescriptions) == OK) {
			CF_assert(Base_Server_OpenDRIM_ComputerSystem_setOtherDedicatedDescriptions(newInstance, OtherDedicatedDescriptions, errorMessage));
		}
	}
	_L_;
	return NOT_SUPPORTED; // TODO check
}

int Base_Server_OpenDRIM_ComputerSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, string& errorMessage) {
	_E_;
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystem_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, unsigned int& returnValue, const OpenDRIM_ComputerSystem_RequestStateChange_In& in, OpenDRIM_ComputerSystem_RequestStateChange_Out& out, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystem_SetPowerState(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ComputerSystem& instance, unsigned int& returnValue, const OpenDRIM_ComputerSystem_SetPowerState_In& in, string& errorMessage) {
	_E_;
	errorMessage="Not Supported";
	_L_;
	return NOT_SUPPORTED;
}

int Base_Server_OpenDRIM_ComputerSystem_getDedicated(const OpenDRIM_ComputerSystem& instance, vector<unsigned short>& Dedicated, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_getProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", keys, "Dedicated", Dedicated, errorMessage));
	_L_
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_setDedicated(const OpenDRIM_ComputerSystem& instance, const vector<unsigned short>& Dedicated, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_setProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", keys, "Dedicated", Dedicated, errorMessage));
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_getOtherDedicatedDescriptions(const OpenDRIM_ComputerSystem& instance, vector<string>& OtherDedicatedDescriptions, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_getProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", keys, "OtherDedicatedDescriptions", OtherDedicatedDescriptions, errorMessage));
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_setOtherDedicatedDescriptions(const OpenDRIM_ComputerSystem& instance, const vector<string>& OtherDedicatedDescriptions, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_setProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", keys, "OtherDedicatedDescriptions", OtherDedicatedDescriptions, errorMessage));
	_L_;
	return OK;
}


int Base_Server_OpenDRIM_ComputerSystem_getOtherIdentifyingInfo(const OpenDRIM_ComputerSystem& instance, vector<string>& OtherIdentifyingInfo, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_getProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", "ComputerSystemPhysicalPackage", "OtherIdentifyingInfo", OtherIdentifyingInfo, errorMessage));
	_L_;
	return OK;
}

int Base_Server_OpenDRIM_ComputerSystem_setOtherIdentifyingInfo(const OpenDRIM_ComputerSystem& instance, const vector<string>& OtherIdentifyingInfo, string& errorMessage) {
	_E_;
	string keys = instance.getKeys();
	CF_assert(DS_setProperty(_NAMESPACE, "OpenDRIM_ComputerSystem", "ComputerSystemPhysicalPackage", "OtherIdentifyingInfo", OtherIdentifyingInfo, errorMessage));
	_L_;
	return OK;
}


int Base_Server_OpenDRIM_ComputerSystem_populate(OpenDRIM_ComputerSystem& instance, string& errorMessage) {
	_E_;

	/*
	 * Properties to fill from profile
	 * + Mandatory (from Base Server):
	 * [X] EnabledState
	 * [X] RequestedState
	 * [X] Dedicated
	 * + Mandatory (from Computer System):
	 * [X] Name					[Key]
	 * [X] CreationClassName	[Key]
	 * [X] OperationalStatus
	 * [X] HealthState
	 * [X] ElementName
	 * + Conditional:
	 * [X] OtherIdentifyingInfo
	 * + Others:
	 * [X] NameFormat
	 */

	vector<unsigned short> operationalStatus;
	vector<string> otherIdentifyingInfos;
	string otherIdentifyingInfo;
	string err;

	instance.setEnabledState(ES_NOT_APPLICABLE);
	instance.setRequestedState(RS_NOT_APPLICABLE);

	instance.setElementName(instance.Name+ " Base Server");
	instance.setNameFormat("computer-name");

	instance.setHealthState(HS_OK);
	operationalStatus.push_back(OS_OK);
	operationalStatus.push_back(OS_IN_SERVICE);
	instance.setOperationalStatus(operationalStatus);

	vector<unsigned short> Dedicated;

	if (Base_Server_OpenDRIM_ComputerSystem_getDedicated(instance, Dedicated, errorMessage) == OK)
	{
		for (size_t i = 0; i < Dedicated.size(); i++)
		{
			if (Dedicated[i] == D_OTHER)
			{
				vector<string> OtherDedicatedDescriptions;
				if (Base_Server_OpenDRIM_ComputerSystem_getOtherDedicatedDescriptions(instance, OtherDedicatedDescriptions, errorMessage) == OK)
					instance.setOtherDedicatedDescriptions(OtherDedicatedDescriptions);
				break;
			}
		}
	}
	else
		Dedicated.push_back(D_UNKNOWN);

	instance.setDedicated(Dedicated);

	Base_Server_OpenDRIM_ComputerSystem_getOtherIdentifyingInfo(instance,otherIdentifyingInfos,errorMessage);

	if(otherIdentifyingInfos.empty())
	{
		CF_assert(CF_getComputerSystemOtherIdentifyingInfo(otherIdentifyingInfo,errorMessage));
		otherIdentifyingInfos.push_back(otherIdentifyingInfo);
		Base_Server_OpenDRIM_ComputerSystem_setOtherIdentifyingInfo(instance,otherIdentifyingInfos,errorMessage);
	}

	instance.setOtherIdentifyingInfo(otherIdentifyingInfos);

	_L_;
	return OK;
}

