########################################################################
#
#    Vision Macro - Python source code - file generated by vision
#    Monday 06 March 2006 12:05:47 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header$
#
# $Id$
#

from NetworkEditor.macros import MacroNode
class MapPotOnGeom(MacroNode):

    def __init__(self, constrkw={}, name='Map Pot On Geom', **kw):
        kw['name'] = name
        apply( MacroNode.__init__, (self,), kw)

    def beforeAddingToNetwork(self, net):
        MacroNode.beforeAddingToNetwork(self, net)
        ## loading libraries ##
        from Volume.VisionInterface.VolumeNodes import vollib
        net.editor.addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

        from Vision.StandardNodes import stdlib
        net.editor.addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

        from DejaVu.VisionInterface.DejaVuNodes import vizlib
        net.editor.addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")


    def afterAddingToNetwork(self):
        from NetworkEditor.macros import MacroNode
        MacroNode.afterAddingToNetwork(self)
        ## loading libraries ##
        from Volume.VisionInterface.VolumeNodes import vollib
        from Vision.StandardNodes import stdlib
        from DejaVu.VisionInterface.DejaVuNodes import vizlib
        ## building macro network ##
        Map_Pot_On_Geom_0 = self
        from traceback import print_exc

        ## loading libraries ##
        from Volume.VisionInterface.VolumeNodes import vollib
        self.macroNetwork.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

        from Vision.StandardNodes import stdlib
        self.macroNetwork.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

        from DejaVu.VisionInterface.DejaVuNodes import vizlib
        self.macroNetwork.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

        try:

            ## saving node input Ports ##
            input_Ports_1 = self.macroNetwork.ipNode
        except:
            print "WARNING: failed to restore MacroInputNode named input Ports in network self.macroNetwork"
            print_exc()
            input_Ports_1=None
        try:

            ## saving node output Ports ##
            output_Ports_2 = self.macroNetwork.opNode
            output_Ports_2.move(230, 578)
        except:
            print "WARNING: failed to restore MacroOutputNode named output Ports in network self.macroNetwork"
            print_exc()
            output_Ports_2=None
        try:

            ## saving node getSurfaceVFN ##
            from DejaVu.VisionInterface.DejaVuNodes import getSurfaceVFN
            getSurfaceVFN_3 = getSurfaceVFN(constrkw = {}, name='getSurfaceVFN', library=vizlib)
            self.macroNetwork.addNode(getSurfaceVFN_3,55,83)
            apply(getSurfaceVFN_3.inputPortByName['geometry'].configure, (), {'color': 'red', 'cast': True, 'shape': 'rect'})
            apply(getSurfaceVFN_3.outputPortByName['geom'].configure, (), {'color': 'red', 'shape': 'rect'})
            apply(getSurfaceVFN_3.outputPortByName['vertices'].configure, (), {'color': 'green', 'shape': 'rect'})
            apply(getSurfaceVFN_3.outputPortByName['faces'].configure, (), {'color': 'purple', 'shape': 'rect'})
            apply(getSurfaceVFN_3.outputPortByName['normals'].configure, (), {'color': 'blue', 'shape': 'rect'})
        except:
            print "WARNING: failed to restore getSurfaceVFN named getSurfaceVFN in network self.macroNetwork"
            print_exc()
            getSurfaceVFN_3=None
        try:

            ## saving node mul ##
            from Vision.StandardNodes import Operator2
            mul_4 = Operator2(constrkw = {}, name='mul', library=stdlib)
            self.macroNetwork.addNode(mul_4,309,139)
            apply(mul_4.inputPortByName['data1'].configure, (), {'datatype': 'normals3D', 'cast': True, 'shape': 'rect', 'color': 'blue'})
            apply(mul_4.inputPortByName['data2'].configure, (), {'datatype': 'float', 'cast': True, 'shape': 'circle', 'color': 'green'})
            apply(mul_4.inputPortByName['operation'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(mul_4.inputPortByName['applyToElements'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(mul_4.outputPortByName['result'].configure, (), {'color': 'white', 'shape': 'diamond'})
            mul_4.inputPortByName['operation'].widget.set("mul", run=False)
            mul_4.inputPortByName['applyToElements'].widget.set(1, run=False)
            apply(mul_4.configure, (), {'expanded': False})
        except:
            print "WARNING: failed to restore Operator2 named mul in network self.macroNetwork"
            print_exc()
            mul_4=None
        try:

            ## saving node Offset ##
            from Vision.StandardNodes import DialNE
            Offset_5 = DialNE(constrkw = {}, name='Offset', library=stdlib)
            self.macroNetwork.addNode(Offset_5,390,20)
            apply(Offset_5.inputPortByName['dial'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Offset_5.inputPortByName['mini'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Offset_5.inputPortByName['maxi'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Offset_5.outputPortByName['value'].configure, (), {'color': 'green', 'shape': 'circle'})
            Offset_5.inputPortByName['dial'].widget.set(1.01, run=False)
        except:
            print "WARNING: failed to restore DialNE named Offset in network self.macroNetwork"
            print_exc()
            Offset_5=None
        try:

            ## saving node add ##
            from Vision.StandardNodes import Operator2
            add_6 = Operator2(constrkw = {}, name='add', library=stdlib)
            self.macroNetwork.addNode(add_6,253,183)
            apply(add_6.inputPortByName['data1'].configure, (), {'datatype': 'coordinates3D', 'cast': True, 'shape': 'rect', 'color': 'green'})
            apply(add_6.inputPortByName['data2'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(add_6.inputPortByName['operation'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(add_6.inputPortByName['applyToElements'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(add_6.outputPortByName['result'].configure, (), {'color': 'white', 'shape': 'diamond'})
            add_6.inputPortByName['operation'].widget.set("add", run=False)
            add_6.inputPortByName['applyToElements'].widget.set(1, run=False)
            apply(add_6.configure, (), {'expanded': False})
        except:
            print "WARNING: failed to restore Operator2 named add in network self.macroNetwork"
            print_exc()
            add_6=None
        try:

            ## saving node triInterp ##
            from Volume.VisionInterface.VolumeNodes import TriInterp
            triInterp_7 = TriInterp(constrkw = {}, name='triInterp', library=vollib)
            self.macroNetwork.addNode(triInterp_7,189,270)
            apply(triInterp_7.inputPortByName['grid'].configure, (), {'color': '#995699', 'cast': True, 'shape': 'diamond'})
            apply(triInterp_7.inputPortByName['points'].configure, (), {'datatype': 'list', 'cast': True, 'shape': 'oval', 'color': 'cyan'})
            apply(triInterp_7.outputPortByName['data'].configure, (), {'color': 'cyan', 'shape': 'oval'})
        except:
            print "WARNING: failed to restore TriInterp named triInterp in network self.macroNetwork"
            print_exc()
            triInterp_7=None
        try:

            ## saving node Color Map ##
            from DejaVu.VisionInterface.DejaVuNodes import ColorMapNE
            Color_Map_9 = ColorMapNE(constrkw = {}, name='Color Map', library=vizlib)
            self.macroNetwork.addNode(Color_Map_9,213,433)
            apply(Color_Map_9.inputPortByName['colorMap'].configure, (), {'color': 'magenta', 'cast': True, 'shape': 'rect'})
            apply(Color_Map_9.inputPortByName['values'].configure, (), {'color': 'cyan', 'cast': True, 'shape': 'oval'})
            apply(Color_Map_9.inputPortByName['mini'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Color_Map_9.inputPortByName['maxi'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Color_Map_9.inputPortByName['filename'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Color_Map_9.outputPortByName['mappedColors'].configure, (), {'color': 'orange', 'shape': 'rect'})
            apply(Color_Map_9.outputPortByName['colorMap'].configure, (), {'color': 'magenta', 'shape': 'rect'})
            apply(Color_Map_9.outputPortByName['legend'].configure, (), {'color': 'red', 'shape': 'rect'})
            Color_Map_9.inputPortByName['colorMap'].widget.set({'mini': None, 'maxi': None, 'ramp': [[1.0, 0.0, 0.0, 1.0], [1.0, 0.0060000000000000053, 0.0060000000000000053, 1.0], [1.0, 0.01100000000000001, 0.01100000000000001, 1.0], [1.0, 0.02300000000000002, 0.02300000000000002, 1.0], [1.0, 0.029000000000000026, 0.029000000000000026, 1.0], [1.0, 0.03400000000000003, 0.03400000000000003, 1.0], [1.0, 0.046000000000000041, 0.046000000000000041, 1.0], [1.0, 0.051000000000000045, 0.051000000000000045, 1.0], [1.0, 0.057000000000000051, 0.057000000000000051, 1.0], [1.0, 0.06899999999999995, 0.06899999999999995, 1.0], [1.0, 0.073999999999999955, 0.073999999999999955, 1.0], [1.0, 0.085999999999999965, 0.085999999999999965, 1.0], [1.0, 0.09099999999999997, 0.09099999999999997, 1.0], [1.0, 0.096999999999999975, 0.096999999999999975, 1.0], [1.0, 0.10899999999999999, 0.10899999999999999, 1.0], [1.0, 0.11399999999999999, 0.11399999999999999, 1.0], [1.0, 0.12, 0.12, 1.0], [1.0, 0.13100000000000001, 0.13100000000000001, 1.0], [1.0, 0.13700000000000001, 0.13700000000000001, 1.0], [1.0, 0.14300000000000002, 0.14300000000000002, 1.0], [1.0, 0.15400000000000003, 0.15400000000000003, 1.0], [1.0, 0.16000000000000003, 0.16000000000000003, 1.0], [1.0, 0.17100000000000004, 0.17100000000000004, 1.0], [1.0, 0.17700000000000005, 0.17700000000000005, 1.0], [1.0, 0.18300000000000005, 0.18300000000000005, 1.0], [1.0, 0.19399999999999995, 0.19399999999999995, 1.0], [1.0, 0.19999999999999996, 0.19999999999999996, 1.0], [1.0, 0.20599999999999996, 0.20599999999999996, 1.0], [1.0, 0.21699999999999997, 0.21699999999999997, 1.0], [1.0, 0.22299999999999998, 0.22299999999999998, 1.0], [1.0, 0.23399999999999999, 0.23399999999999999, 1.0], [1.0, 0.23999999999999999, 0.23999999999999999, 1.0], [1.0, 0.246, 0.246, 1.0], [1.0, 0.25700000000000001, 0.25700000000000001, 1.0], [1.0, 0.26300000000000001, 0.26300000000000001, 1.0], [1.0, 0.26900000000000002, 0.26900000000000002, 1.0], [1.0, 0.28000000000000003, 0.28000000000000003, 1.0], [1.0, 0.28600000000000003, 0.28600000000000003, 1.0], [1.0, 0.29100000000000004, 0.29100000000000004, 1.0], [1.0, 0.30300000000000005, 0.30300000000000005, 1.0], [1.0, 0.30900000000000005, 0.30900000000000005, 1.0], [1.0, 0.31999999999999995, 0.31999999999999995, 1.0], [1.0, 0.32599999999999996, 0.32599999999999996, 1.0], [1.0, 0.33099999999999996, 0.33099999999999996, 1.0], [1.0, 0.34299999999999997, 0.34299999999999997, 1.0], [1.0, 0.34899999999999998, 0.34899999999999998, 1.0], [1.0, 0.35399999999999998, 0.35399999999999998, 1.0], [1.0, 0.36599999999999999, 0.36599999999999999, 1.0], [1.0, 0.371, 0.371, 1.0], [1.0, 0.377, 0.377, 1.0], [1.0, 0.38900000000000001, 0.38900000000000001, 1.0], [1.0, 0.39400000000000002, 0.39400000000000002, 1.0], [1.0, 0.40600000000000003, 0.40600000000000003, 1.0], [1.0, 0.41100000000000003, 0.41100000000000003, 1.0], [1.0, 0.41700000000000004, 0.41700000000000004, 1.0], [1.0, 0.42900000000000005, 0.42900000000000005, 1.0], [1.0, 0.43400000000000005, 0.43400000000000005, 1.0], [1.0, 0.43999999999999995, 0.43999999999999995, 1.0], [1.0, 0.45099999999999996, 0.45099999999999996, 1.0], [1.0, 0.45699999999999996, 0.45699999999999996, 1.0], [1.0, 0.46899999999999997, 0.46899999999999997, 1.0], [1.0, 0.47399999999999998, 0.47399999999999998, 1.0], [1.0, 0.47999999999999998, 0.47999999999999998, 1.0], [1.0, 0.49099999999999999, 0.49099999999999999, 1.0], [1.0, 0.497, 0.497, 1.0], [1.0, 0.503, 0.503, 1.0], [1.0, 0.51400000000000001, 0.51400000000000001, 1.0], [1.0, 0.52000000000000002, 0.52000000000000002, 1.0], [1.0, 0.52600000000000002, 0.52600000000000002, 1.0], [1.0, 0.53699999999999992, 0.53699999999999992, 1.0], [1.0, 0.54299999999999993, 0.54299999999999993, 1.0], [1.0, 0.55400000000000005, 0.55400000000000005, 1.0], [1.0, 0.56000000000000005, 0.56000000000000005, 1.0], [1.0, 0.56600000000000006, 0.56600000000000006, 1.0], [1.0, 0.57699999999999996, 0.57699999999999996, 1.0], [1.0, 0.58299999999999996, 0.58299999999999996, 1.0], [1.0, 0.58899999999999997, 0.58899999999999997, 1.0], [1.0, 0.59999999999999998, 0.59999999999999998, 1.0], [1.0, 0.60599999999999998, 0.60599999999999998, 1.0], [1.0, 0.61699999999999999, 0.61699999999999999, 1.0], [1.0, 0.623, 0.623, 1.0], [1.0, 0.629, 0.629, 1.0], [1.0, 0.64000000000000001, 0.64000000000000001, 1.0], [1.0, 0.64600000000000002, 0.64600000000000002, 1.0], [1.0, 0.65100000000000002, 0.65100000000000002, 1.0], [1.0, 0.66300000000000003, 0.66300000000000003, 1.0], [1.0, 0.66900000000000004, 0.66900000000000004, 1.0], [1.0, 0.67399999999999993, 0.67399999999999993, 1.0], [1.0, 0.68599999999999994, 0.68599999999999994, 1.0], [1.0, 0.69100000000000006, 0.69100000000000006, 1.0], [1.0, 0.70300000000000007, 0.70300000000000007, 1.0], [1.0, 0.70900000000000007, 0.70900000000000007, 1.0], [1.0, 0.71399999999999997, 0.71399999999999997, 1.0], [1.0, 0.72599999999999998, 0.72599999999999998, 1.0], [1.0, 0.73099999999999998, 0.73099999999999998, 1.0], [1.0, 0.73699999999999999, 0.73699999999999999, 1.0], [1.0, 0.749, 0.749, 1.0], [1.0, 0.754, 0.754, 1.0], [1.0, 0.76000000000000001, 0.76000000000000001, 1.0], [1.0, 0.77100000000000002, 0.77100000000000002, 1.0], [1.0, 0.77700000000000002, 0.77700000000000002, 1.0], [1.0, 0.78900000000000003, 0.78900000000000003, 1.0], [1.0, 0.79400000000000004, 0.79400000000000004, 1.0], [1.0, 0.80000000000000004, 0.80000000000000004, 1.0], [1.0, 0.81099999999999994, 0.81099999999999994, 1.0], [1.0, 0.81699999999999995, 0.81699999999999995, 1.0], [1.0, 0.82299999999999995, 0.82299999999999995, 1.0], [1.0, 0.83399999999999996, 0.83399999999999996, 1.0], [1.0, 0.83999999999999997, 0.83999999999999997, 1.0], [1.0, 0.85099999999999998, 0.85099999999999998, 1.0], [1.0, 0.85699999999999998, 0.85699999999999998, 1.0], [1.0, 0.86299999999999999, 0.86299999999999999, 1.0], [1.0, 0.874, 0.874, 1.0], [1.0, 0.88, 0.88, 1.0], [1.0, 0.88600000000000001, 0.88600000000000001, 1.0], [1.0, 0.89700000000000002, 0.89700000000000002, 1.0], [1.0, 0.90300000000000002, 0.90300000000000002, 1.0], [1.0, 0.90900000000000003, 0.90900000000000003, 1.0], [1.0, 0.92000000000000004, 0.92000000000000004, 1.0], [1.0, 0.92600000000000005, 0.92600000000000005, 1.0], [1.0, 0.93700000000000006, 0.93700000000000006, 1.0], [1.0, 0.94299999999999995, 0.94299999999999995, 1.0], [1.0, 0.94899999999999995, 0.94899999999999995, 1.0], [1.0, 0.95999999999999996, 0.95999999999999996, 1.0], [1.0, 0.96599999999999997, 0.96599999999999997, 1.0], [1.0, 0.97099999999999997, 0.97099999999999997, 1.0], [1.0, 0.98299999999999998, 0.98299999999999998, 1.0], [1.0, 0.98899999999999999, 0.98899999999999999, 1.0], [1.0, 1.0, 1.0, 1.0], [1.0, 1.0, 1.0, 1.0], [0.98902199999999996, 0.98899999999999999, 1.0, 1.0], [1.0, 1.0, 1.0, 1.0], [0.97105799999999998, 0.97099999999999997, 1.0, 1.0], [0.96606800000000004, 0.96599999999999997, 1.0, 1.0], [0.95409199999999994, 0.95399999999999996, 1.0, 1.0], [0.949102, 0.94899999999999995, 1.0, 1.0], [0.93712600000000013, 0.93700000000000006, 1.0, 1.0], [0.93113800000000013, 0.93100000000000005, 1.0, 1.0], [0.92614800000000008, 0.92600000000000005, 1.0, 1.0], [0.9141720000000001, 0.91400000000000003, 1.0, 1.0], [0.90918200000000005, 0.90900000000000003, 1.0, 1.0], [0.90319400000000005, 0.90300000000000002, 1.0, 1.0], [0.89121800000000007, 0.89100000000000001, 1.0, 1.0], [0.88622800000000013, 0.88600000000000001, 1.0, 1.0], [0.87425200000000003, 0.874, 1.0, 1.0], [0.86926200000000009, 0.86899999999999999, 1.0, 1.0], [0.8632740000000001, 0.86299999999999999, 1.0, 1.0], [0.85129800000000011, 0.85099999999999998, 1.0, 1.0], [0.84630800000000006, 0.84599999999999997, 1.0, 1.0], [0.84032000000000007, 0.83999999999999997, 1.0, 1.0], [0.82934200000000002, 0.82899999999999996, 1.0, 1.0], [0.82335400000000014, 0.82299999999999995, 1.0, 1.0], [0.81137800000000004, 0.81099999999999994, 1.0, 1.0], [0.80638800000000022, 0.80600000000000005, 1.0, 1.0], [0.80040000000000022, 0.80000000000000004, 1.0, 1.0], [0.78942200000000018, 0.78900000000000003, 1.0, 1.0], [0.78343400000000019, 0.78300000000000003, 1.0, 1.0], [0.77744600000000019, 0.77700000000000002, 1.0, 1.0], [0.76646800000000015, 0.76600000000000001, 1.0, 1.0], [0.76048000000000016, 0.76000000000000001, 1.0, 1.0], [0.74950200000000011, 0.749, 1.0, 1.0], [0.74351400000000023, 0.74299999999999999, 1.0, 1.0], [0.73752600000000013, 0.73699999999999999, 1.0, 1.0], [0.72654800000000019, 0.72599999999999998, 1.0, 1.0], [0.72056000000000009, 0.71999999999999997, 1.0, 1.0], [0.71457200000000021, 0.71399999999999997, 1.0, 1.0], [0.70359400000000027, 0.70300000000000007, 1.0, 1.0], [0.69760600000000028, 0.69700000000000006, 1.0, 1.0], [0.68662800000000013, 0.68599999999999994, 1.0, 1.0], [0.68064000000000013, 0.67999999999999994, 1.0, 1.0], [0.67465200000000014, 0.67399999999999993, 1.0, 1.0], [0.66367400000000032, 0.66300000000000003, 1.0, 1.0], [0.65768600000000021, 0.65700000000000003, 1.0, 1.0], [0.64670800000000028, 0.64600000000000002, 1.0, 1.0], [0.64072000000000018, 0.64000000000000001, 1.0, 1.0], [0.6347320000000003, 0.63400000000000001, 1.0, 1.0], [0.62375400000000025, 0.623, 1.0, 1.0], [0.61776600000000026, 0.61699999999999999, 1.0, 1.0], [0.61177800000000027, 0.61099999999999999, 1.0, 1.0], [0.60080000000000022, 0.59999999999999998, 1.0, 1.0], [0.59481200000000023, 0.59399999999999997, 1.0, 1.0], [0.58383400000000019, 0.58299999999999996, 1.0, 1.0], [0.5778460000000003, 0.57699999999999996, 1.0, 1.0], [0.5718580000000002, 0.57099999999999995, 1.0, 1.0], [0.56088000000000027, 0.56000000000000005, 1.0, 1.0], [0.55489200000000038, 0.55400000000000005, 1.0, 1.0], [0.54990200000000022, 0.54899999999999993, 1.0, 1.0], [0.53792600000000024, 0.53699999999999992, 1.0, 1.0], [0.53193800000000035, 0.53100000000000003, 1.0, 1.0], [0.52096000000000031, 0.52000000000000002, 1.0, 1.0], [0.51497200000000032, 0.51400000000000001, 1.0, 1.0], [0.50998200000000038, 0.50900000000000001, 1.0, 1.0], [0.49800600000000028, 0.497, 1.0, 1.0], [0.49201800000000029, 0.49099999999999999, 1.0, 1.0], [0.48702800000000035, 0.48599999999999999, 1.0, 1.0], [0.47505200000000036, 0.47399999999999998, 1.0, 1.0], [0.47006200000000031, 0.46899999999999997, 1.0, 1.0], [0.45808600000000033, 0.45699999999999996, 1.0, 1.0], [0.45209800000000033, 0.45099999999999996, 1.0, 1.0], [0.44710800000000028, 0.44599999999999995, 1.0, 1.0], [0.43513200000000041, 0.43400000000000005, 1.0, 1.0], [0.43014200000000047, 0.42900000000000005, 1.0, 1.0], [0.42415400000000048, 0.42300000000000004, 1.0, 1.0], [0.41217800000000038, 0.41100000000000003, 1.0, 1.0], [0.40718800000000044, 0.40600000000000003, 1.0, 1.0], [0.39521200000000045, 0.39400000000000002, 1.0, 1.0], [0.3902220000000004, 0.38900000000000001, 1.0, 1.0], [0.38423400000000041, 0.38300000000000001, 1.0, 1.0], [0.37225800000000042, 0.371, 1.0, 1.0], [0.36726800000000037, 0.36599999999999999, 1.0, 1.0], [0.36128000000000038, 0.35999999999999999, 1.0, 1.0], [0.35030200000000045, 0.34899999999999998, 1.0, 1.0], [0.34431400000000045, 0.34299999999999997, 1.0, 1.0], [0.33233800000000036, 0.33099999999999996, 1.0, 1.0], [0.32734800000000042, 0.32599999999999996, 1.0, 1.0], [0.32136000000000042, 0.31999999999999995, 1.0, 1.0], [0.31038200000000049, 0.30900000000000005, 1.0, 1.0], [0.3043940000000005, 0.30300000000000005, 1.0, 1.0], [0.29241800000000051, 0.29100000000000004, 1.0, 1.0], [0.28742800000000046, 0.28600000000000003, 1.0, 1.0], [0.28144000000000047, 0.28000000000000003, 1.0, 1.0], [0.27046200000000054, 0.26900000000000002, 1.0, 1.0], [0.26447400000000054, 0.26300000000000001, 1.0, 1.0], [0.25848600000000055, 0.25700000000000001, 1.0, 1.0], [0.24750800000000051, 0.246, 1.0, 1.0], [0.24152000000000051, 0.23999999999999999, 1.0, 1.0], [0.23054200000000047, 0.22899999999999998, 1.0, 1.0], [0.22455400000000048, 0.22299999999999998, 1.0, 1.0], [0.21856600000000048, 0.21699999999999997, 1.0, 1.0], [0.20758800000000044, 0.20599999999999996, 1.0, 1.0], [0.20160000000000045, 0.19999999999999996, 1.0, 1.0], [0.19561200000000045, 0.19399999999999995, 1.0, 1.0], [0.18463400000000063, 0.18300000000000005, 1.0, 1.0], [0.17864600000000064, 0.17700000000000005, 1.0, 1.0], [0.16766800000000059, 0.16600000000000004, 1.0, 1.0], [0.1616800000000006, 0.16000000000000003, 1.0, 1.0], [0.15569200000000061, 0.15400000000000003, 1.0, 1.0], [0.14471400000000056, 0.14300000000000002, 1.0, 1.0], [0.13872600000000057, 0.13700000000000001, 1.0, 1.0], [0.13273800000000058, 0.13100000000000001, 1.0, 1.0], [0.12176000000000053, 0.12, 1.0, 1.0], [0.11577200000000054, 0.11399999999999999, 1.0, 1.0], [0.10479400000000061, 0.10299999999999998, 1.0, 1.0], [0.098806000000000616, 0.096999999999999975, 1.0, 1.0], [0.092818000000000622, 0.09099999999999997, 1.0, 1.0], [0.081840000000000579, 0.07999999999999996, 1.0, 1.0], [0.075852000000000586, 0.073999999999999955, 1.0, 1.0], [0.070862000000000536, 0.06899999999999995, 1.0, 1.0], [0.05888600000000066, 0.057000000000000051, 1.0, 1.0], [0.052898000000000667, 0.051000000000000045, 1.0, 1.0], [0.041920000000000623, 0.040000000000000036, 1.0, 1.0], [0.03593200000000063, 0.03400000000000003, 1.0, 1.0], [0.030942000000000691, 0.029000000000000026, 1.0, 1.0], [0.018966000000000705, 0.017000000000000015, 1.0, 1.0], [0.012978000000000711, 0.01100000000000001, 1.0, 1.0], [0.0020000000000006679, 0.0, 1.0, 1.0]], 'name': 'cmap'}, run=False)
        except:
            print "WARNING: failed to restore ColorMap named Color Map in network self.macroNetwork"
            print_exc()
            Color_Map_9=None
        try:

            ## saving node call method ##
            from Vision.StandardNodes import CallMethod
            call_method_10 = CallMethod(constrkw = {}, name='call method', library=stdlib)
            self.macroNetwork.addNode(call_method_10,179,501)
            apply(call_method_10.inputPortByName['objects'].configure, (), {'datatype': 'geom', 'cast': True, 'shape': 'rect', 'color': 'red'})
            apply(call_method_10.inputPortByName['signature'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(call_method_10.addInputPort, (), {'name': 'materials', 'cast': True, 'datatype': 'colorfloat3or4(0)', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'orange'})
            apply(call_method_10.addInputPort, (), {'name': 'inheritMaterial', 'cast': True, 'datatype': 'int', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'yellow'})
            apply(call_method_10.outputPortByName['objects'].configure, (), {'color': 'white', 'shape': 'diamond'})
            apply(call_method_10.outputPortByName['results'].configure, (), {'color': 'white', 'shape': 'diamond'})
            call_method_10.inputPortByName['signature'].widget.set("Set materials inheritMaterial", run=False)
        except:
            print "WARNING: failed to restore CallMethod named call method in network self.macroNetwork"
            print_exc()
            call_method_10=None
        try:

            ## saving node Checkbutton ##
            from Vision.StandardNodes import CheckButtonNE
            Checkbutton_11 = CheckButtonNE(constrkw = {}, name='Checkbutton', library=stdlib)
            self.macroNetwork.addNode(Checkbutton_11,346,478)
            apply(Checkbutton_11.inputPortByName['button'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(Checkbutton_11.outputPortByName['value'].configure, (), {'color': 'yellow', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore CheckButtonNE named Checkbutton in network self.macroNetwork"
            print_exc()
            Checkbutton_11=None
        try:

            ## saving node Redraw ##
            from DejaVu.VisionInterface.DejaVuNodes import Redraw
            Redraw_12 = Redraw(constrkw = {}, name='Redraw', library=vizlib)
            self.macroNetwork.addNode(Redraw_12,41,518)
            apply(Redraw_12.inputPortByName['viewer'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'rect'})
            apply(Redraw_12.inputPortByName['trigger'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
        except:
            print "WARNING: failed to restore Redraw named Redraw in network self.macroNetwork"
            print_exc()
            Redraw_12=None
        try:

            ## saving node neg ##
            from Vision.StandardNodes import Operator1
            neg_13 = Operator1(constrkw = {}, name='neg', library=stdlib)
            self.macroNetwork.addNode(neg_13,288,321)
            apply(neg_13.inputPortByName['data'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(neg_13.inputPortByName['operation'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(neg_13.inputPortByName['applyToElements'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(neg_13.outputPortByName['result'].configure, (), {'color': 'white', 'shape': 'diamond'})
            neg_13.inputPortByName['operation'].widget.set("neg", run=False)
            apply(neg_13.configure, (), {'expanded': False})
        except:
            print "WARNING: failed to restore Operator1 named neg in network self.macroNetwork"
            print_exc()
            neg_13=None
        try:

            ## saving node Get viewer ##
            from Vision.StandardNodes import GetAttr
            Get_viewer_14 = GetAttr(constrkw = {}, name='Get viewer', library=stdlib)
            self.macroNetwork.addNode(Get_viewer_14,18,324)
            apply(Get_viewer_14.inputPortByName['objects'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(Get_viewer_14.inputPortByName['attr'].configure, (), {'color': 'white', 'cast': True, 'shape': 'oval'})
            apply(Get_viewer_14.outputPortByName['attrs'].configure, (), {'color': 'cyan', 'shape': 'oval'})
            apply(Get_viewer_14.inputPortByName['attr'].widget.configure, (), {'choices': ('viewer',)})
            Get_viewer_14.inputPortByName['attr'].widget.set("viewer", run=False)
        except:
            print "WARNING: failed to restore GetAttr named Get viewer in network self.macroNetwork"
            print_exc()
            Get_viewer_14=None
        try:

            ## saving node Slice Data ##
            from Vision.StandardNodes import SliceData
            Slice_Data_15 = SliceData(constrkw = {}, name='Slice Data', library=stdlib)
            self.macroNetwork.addNode(Slice_Data_15,29,421)
            apply(Slice_Data_15.inputPortByName['data'].configure, (), {'datatype': 'list', 'cast': True, 'shape': 'oval', 'color': 'cyan'})
            apply(Slice_Data_15.inputPortByName['_slice'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(Slice_Data_15.outputPortByName['data'].configure, (), {'color': 'white', 'shape': 'diamond'})
            Slice_Data_15.inputPortByName['_slice'].widget.set("[0]", run=False)
        except:
            print "WARNING: failed to restore SliceData named Slice Data in network self.macroNetwork"
            print_exc()
            Slice_Data_15=None
        try:

            ## saving node stddev ##
            from Vision.StandardNodes import StdDev
            stddev_16 = StdDev(constrkw = {}, name='stddev', library=stdlib)
            self.macroNetwork.addNode(stddev_16,339,230)
            apply(stddev_16.inputPortByName['values'].configure, (), {'color': 'cyan', 'cast': True, 'shape': 'oval'})
            apply(stddev_16.outputPortByName['stddev'].configure, (), {'color': 'green', 'shape': 'circle'})
        except:
            print "WARNING: failed to restore StdDev named stddev in network self.macroNetwork"
            print_exc()
            stddev_16=None
        try:

            ## saving node Dial ##
            from Vision.StandardNodes import DialNE
            Dial_17 = DialNE(constrkw = {}, name='Dial', library=stdlib)
            self.macroNetwork.addNode(Dial_17,412,152)
            apply(Dial_17.inputPortByName['dial'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_17.inputPortByName['mini'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_17.inputPortByName['maxi'].configure, (), {'color': 'green', 'cast': True, 'shape': 'circle'})
            apply(Dial_17.outputPortByName['value'].configure, (), {'color': 'green', 'shape': 'circle'})
            Dial_17.inputPortByName['dial'].widget.set(5.0, run=False)
        except:
            print "WARNING: failed to restore DialNE named Dial in network self.macroNetwork"
            print_exc()
            Dial_17=None
        try:

            ## saving node mul ##
            from Vision.StandardNodes import Operator2
            mul_18 = Operator2(constrkw = {}, name='mul', library=stdlib)
            self.macroNetwork.addNode(mul_18,369,347)
            apply(mul_18.inputPortByName['data1'].configure, (), {'datatype': 'float', 'cast': True, 'shape': 'circle', 'color': 'green'})
            apply(mul_18.inputPortByName['data2'].configure, (), {'datatype': 'float', 'cast': True, 'shape': 'circle', 'color': 'green'})
            apply(mul_18.inputPortByName['operation'].configure, (), {'color': 'white', 'cast': True, 'shape': 'diamond'})
            apply(mul_18.inputPortByName['applyToElements'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
            apply(mul_18.outputPortByName['result'].configure, (), {'color': 'white', 'shape': 'diamond'})
            mul_18.inputPortByName['operation'].widget.set("mul", run=False)
            apply(mul_18.configure, (), {'expanded': False})
        except:
            print "WARNING: failed to restore Operator2 named mul in network self.macroNetwork"
            print_exc()
            mul_18=None
        self.macroNetwork.freeze()

        ## saving connections for network Map Pot On Geom ##
        if Offset_5 is not None and mul_4 is not None:
            self.macroNetwork.connectNodes(
                Offset_5, mul_4, "value", "data2", blocking=True)
        if getSurfaceVFN_3 is not None and mul_4 is not None:
            self.macroNetwork.connectNodes(
                getSurfaceVFN_3, mul_4, "normals", "data1", blocking=True)
        if mul_4 is not None and add_6 is not None:
            self.macroNetwork.connectNodes(
                mul_4, add_6, "result", "data2", blocking=True)
        if getSurfaceVFN_3 is not None and add_6 is not None:
            self.macroNetwork.connectNodes(
                getSurfaceVFN_3, add_6, "vertices", "data1", blocking=True)
        if add_6 is not None and triInterp_7 is not None:
            self.macroNetwork.connectNodes(
                add_6, triInterp_7, "result", "points", blocking=True)
        if getSurfaceVFN_3 is not None and call_method_10 is not None:
            self.macroNetwork.connectNodes(
                getSurfaceVFN_3, call_method_10, "geom", "objects", blocking=True)
        if Checkbutton_11 is not None and call_method_10 is not None:
            self.macroNetwork.connectNodes(
                Checkbutton_11, call_method_10, "value", "inheritMaterial", blocking=True)
        if call_method_10 is not None and Redraw_12 is not None:
            self.macroNetwork.connectNodes(
                call_method_10, Redraw_12, "objects", "trigger", blocking=True)
        input_Ports_1 = self.macroNetwork.ipNode
        if input_Ports_1 is not None and getSurfaceVFN_3 is not None:
            self.macroNetwork.connectNodes(
                input_Ports_1, getSurfaceVFN_3, "new", "geometry", blocking=True)
        if getSurfaceVFN_3 is not None and Get_viewer_14 is not None:
            self.macroNetwork.connectNodes(
                getSurfaceVFN_3, Get_viewer_14, "geom", "objects", blocking=True)
        if Get_viewer_14 is not None and Slice_Data_15 is not None:
            self.macroNetwork.connectNodes(
                Get_viewer_14, Slice_Data_15, "attrs", "data", blocking=True)
        if Slice_Data_15 is not None and Redraw_12 is not None:
            self.macroNetwork.connectNodes(
                Slice_Data_15, Redraw_12, "data", "viewer", blocking=True)
        if input_Ports_1 is not None and triInterp_7 is not None:
            self.macroNetwork.connectNodes(
                input_Ports_1, triInterp_7, "new", "grid", blocking=True)
        if triInterp_7 is not None and stddev_16 is not None:
            self.macroNetwork.connectNodes(
                triInterp_7, stddev_16, "data", "values", blocking=True)
        if neg_13 is not None and Color_Map_9 is not None:
            self.macroNetwork.connectNodes(
                neg_13, Color_Map_9, "result", "mini", blocking=True)
        if mul_18 is not None and neg_13 is not None:
            self.macroNetwork.connectNodes(
                mul_18, neg_13, "result", "data", blocking=True)
        if mul_18 is not None and Color_Map_9 is not None:
            self.macroNetwork.connectNodes(
                mul_18, Color_Map_9, "result", "maxi", blocking=True)
        if Dial_17 is not None and mul_18 is not None:
            self.macroNetwork.connectNodes(
                Dial_17, mul_18, "value", "data2", blocking=True)
        if stddev_16 is not None and mul_18 is not None:
            self.macroNetwork.connectNodes(
                stddev_16, mul_18, "stddev", "data1", blocking=True)
        if triInterp_7 is not None and Color_Map_9 is not None:
            self.macroNetwork.connectNodes(
                triInterp_7, Color_Map_9, "data", "values", blocking=True)
        if Color_Map_9 is not None and call_method_10 is not None:
            self.macroNetwork.connectNodes(
                Color_Map_9, call_method_10, "mappedColors", "materials", blocking=True)
        output_Ports_2 = self.macroNetwork.opNode
        if Color_Map_9 is not None and output_Ports_2 is not None:
            self.macroNetwork.connectNodes(
                Color_Map_9, output_Ports_2, "legend", "new", blocking=True)
        self.macroNetwork.unfreeze()

        Map_Pot_On_Geom_0.shrink()

        ## reset modifications ##
        Map_Pot_On_Geom_0.resetTags()
        Map_Pot_On_Geom_0.buildOriginalList()
