#!/bin/bash
# from martian.spec

function usage {
	echo "Usage: "
	echo "$0 [-u <user>] [-g <group>] [-m <mode>] [-c <country>] [-d <level>] [--smp] [--hide-pty]"
	#echo -e "$0 [-u <user>] [--group <name>] [--mode 0###] [--country <country>] [--debug <level>] "
	exit 0
}

function to_num {
	echo -n `echo $1 | grep -e '^\([^0][[:digit:]]*\|0[0-7]*\|0x[[:xdigit:]]*\)$'`
}

tty=
options=

while [ $# -gt 0 ]; do
	arg=$1
	shift
	case "$arg" in
		-c | --country)
			country=$1
			shift
			fullname=`/usr/sbin/martian_modem --info countries |
				awk --assign country=$country \
					'BEGIN { FS = "\t"}; 
					{ 
						if (tolower (country) == tolower($1) || 
						    tolower (country) == tolower($2)) 
							{ print $2; exit; } 
					} '`

			if [ "$fullname" != "" ]; then
				options="$options --country \"$fullname\""
			else
				echo "Country $country is not supported"
			fi
			;;
			
		--hide-pty | --smp | --realtime)
			options="$options $arg"
			;;
			
		-d | --debug)
			raw=$1
			level=$(to_num $1)
			shift
			if [ "$level" == "" ]; then
				echo "Bad argument \`$raw' for option $arg"
				continue
			elif [ $level -gt 0 -a 6 -gt $level ]; then
					options="$options --debug $level"
			else
				echo "debug level should be in the range [0..6]"
			fi
			;;

		-m | --mode)
			# local mode
			# to_num $1
			mode=$(to_num $1)
			#echo $mode
			shift
			if [ "$mode" != "" ]; then
				if (( $mode < 01000 )); then
					options="$options --mode $(printf "0%o" $mode)"
				fi
			fi
			;;

		-u | --user)
			user=$1
			shift
			if [ "$user" != "" ]; then
				options="$options --user $user"
			fi
			;;

		-g | --group)
			group=$1
			shift
			if [ "$group" != "" ]; then
				options="$options --group $group"
			fi
			;;


		-h | --help | --usage)
			usage
			;;

		-*)
			echo "Unknown option $arg ignored"
			;;
			
		*)
			if [ "$tty" == "" ]; then 
				tty=$arg
			else
				echo "unbound argument $arg ignored" 
			fi
			;;
	esac
done

if [ "$tty" != "" ]; then
	echo "Modem access name $tty"
	#options="$options $tty"
fi

if [ "$options" != "" ]; then
	echo "Options: $options $tty"
fi

echo "Module:"

# modload=/etc/modprobe.preload
result="none"
for modload in /etc/modprobe{,.preload}; do
	if [ -f $modload ]; then
		if ! grep -q -s "martian-dev" $modload; then
			echo -e "# martian configuration" \
				"\nmartian-dev" >>$modload;
		fi
		[ $? == "0" ] && echo -e "\tAdded to $modload"
		result="success" 
		#echo "result: $result"
		break;
	fi
done

#last resort
if [ "success" != $result ]; then
	rc=/etc/rc.local
	if ! grep -q -s "/sbin/modprobe martian_dev" $rc; then
		echo -e "\n\n# martian configuration" \
			"\n/sbin/modprobe martian_dev" >> $rc;
	fi
	[ $? == "0" ] && echo -e "\tAdded to $rc"
fi

echo -ne "Daemon:\n\t" 

service=martian
sed -e "s/%Options%/$options/" -e "s/%TTY%/$tty/" martian.in > martian
install -m 744 -D $service /etc/init.d/$service
/sbin/chkconfig --add $service
/sbin/chkconfig $service on
