/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.PdfObject;
import edu.harvard.hul.ois.jhove.module.pdf.PdfSimpleObject;
import java.util.Vector;

public class PdfArray
extends PdfObject {
    private Vector _content = new Vector();

    public PdfArray(int n, int n2) {
        super(n, n2);
    }

    public PdfArray() {
    }

    public void add(PdfObject pdfObject) {
        this._content.add(pdfObject);
    }

    public Vector getContent() {
        return this._content;
    }

    public boolean isPdfACompliant() {
        return this._content.size() <= 8191;
    }

    public String toPipeline() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._content.size(); ++i) {
            PdfObject pdfObject = (PdfObject)this._content.elementAt(i);
            if (!(pdfObject instanceof PdfSimpleObject)) continue;
            String string = ((PdfSimpleObject)pdfObject).getStringValue();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public double[] toRectangle() {
        if (this._content.size() != 4) {
            return null;
        }
        double[] dArray = new double[4];
        try {
            for (int i = 0; i < 4; ++i) {
                double d;
                PdfObject pdfObject = (PdfObject)this._content.elementAt(i);
                if (!(pdfObject instanceof PdfSimpleObject)) {
                    return null;
                }
                dArray[i] = d = ((PdfSimpleObject)pdfObject).getDoubleValue();
            }
            return dArray;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

