/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.validation;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xmlunit.XMLUnitException;
import org.xmlunit.validation.ValidationHandler;
import org.xmlunit.validation.ValidationResult;
import org.xmlunit.validation.Validator;

public class JAXPValidator
extends Validator {
    private final String language;
    private final SchemaFactory factory;

    public JAXPValidator(String language) {
        this(language, null);
    }

    public JAXPValidator(String language, SchemaFactory factory) {
        this.language = language;
        this.factory = factory;
    }

    private SchemaFactory getFactory() {
        return this.factory == null ? SchemaFactory.newInstance(this.language) : this.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidationResult validateSchema() {
        ValidationHandler v;
        block6: {
            v = new ValidationHandler();
            SchemaFactory f = this.getFactory();
            f.setErrorHandler(v);
            try {
                f.newSchema(this.getSchemaSources());
            }
            catch (SAXException e) {
                if (e instanceof SAXParseException) {
                    v.error((SAXParseException)e);
                    break block6;
                }
                throw new XMLUnitException(e);
            }
            finally {
                f.setErrorHandler(null);
            }
        }
        return v.getResult();
    }

    @Override
    public ValidationResult validateInstance(Source s) {
        Schema schema;
        try {
            schema = this.createSchema();
        }
        catch (SAXException e) {
            throw new XMLUnitException("The schema is invalid", e);
        }
        ValidationHandler v = new ValidationHandler();
        javax.xml.validation.Validator val = schema.newValidator();
        val.setErrorHandler(v);
        try {
            val.validate(s);
        }
        catch (SAXException e) {
            if (e instanceof SAXParseException) {
                v.error((SAXParseException)e);
            }
            throw new XMLUnitException(e);
        }
        catch (IOException e) {
            throw new XMLUnitException(e);
        }
        return v.getResult();
    }

    private Schema createSchema() throws SAXException {
        Source[] sources = this.getSchemaSources();
        return sources.length > 0 ? this.getFactory().newSchema(sources) : this.getFactory().newSchema();
    }
}

