/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.HeaderBoxUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.HeaderBox;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;

public class BasicHeaderBoxUI
extends HeaderBoxUI {
    private static HeaderBoxUI _headerBoxUI;
    protected ThemePainter _painter;

    public static ComponentUI createUI(JComponent jComponent) {
        if (_headerBoxUI == null) {
            _headerBoxUI = new BasicHeaderBoxUI();
        }
        return _headerBoxUI;
    }

    @Override
    public void installUI(JComponent jComponent) {
        HeaderBox headerBox = (HeaderBox)jComponent;
        super.installUI(headerBox);
        this.installDefaults(headerBox);
        this.installListeners(headerBox);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        HeaderBox headerBox = (HeaderBox)jComponent;
        this.uninstallDefaults(headerBox);
        this.uninstallListeners(headerBox);
        super.uninstallUI(jComponent);
    }

    protected void installListeners(JComponent jComponent) {
        RolloverMouseInputAdapter rolloverMouseInputAdapter = this.createHeaderBoxMouseListener();
        jComponent.addMouseListener(rolloverMouseInputAdapter);
    }

    private RolloverMouseInputAdapter getMouseListener(HeaderBox headerBox) {
        MouseMotionListener[] mouseMotionListenerArray = headerBox.getMouseMotionListeners();
        if (mouseMotionListenerArray != null) {
            for (MouseMotionListener mouseMotionListener : mouseMotionListenerArray) {
                if (!(mouseMotionListener instanceof RolloverMouseInputAdapter)) continue;
                return (RolloverMouseInputAdapter)mouseMotionListener;
            }
        }
        return null;
    }

    private RolloverMouseInputAdapter createHeaderBoxMouseListener() {
        return new RolloverMouseInputAdapter();
    }

    protected void uninstallListeners(JComponent jComponent) {
        HeaderBox headerBox = (HeaderBox)jComponent;
        RolloverMouseInputAdapter rolloverMouseInputAdapter = this.getMouseListener(headerBox);
        if (rolloverMouseInputAdapter != null) {
            headerBox.removeMouseListener(rolloverMouseInputAdapter);
        }
    }

    protected void installDefaults(HeaderBox headerBox) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColorsAndFont(headerBox, "Panel.background", "Panel.foreground", "Panel.font");
        LookAndFeel.installBorder(headerBox, "Panel.border");
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintBackground(graphics, jComponent);
        this.paintBorder(graphics, jComponent);
    }

    protected void paintBorder(Graphics graphics, JComponent jComponent) {
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        HeaderBox headerBox = (HeaderBox)jComponent;
        Rectangle rectangle = new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (headerBox.getModel().isPressed()) {
            this._painter.paintHeaderBoxBackground(jComponent, graphics, rectangle, 0, 1);
        } else if (headerBox.getModel().isSelected()) {
            this._painter.paintHeaderBoxBackground(jComponent, graphics, rectangle, 0, 3);
        } else if (headerBox.getModel().isRollover()) {
            this._painter.paintHeaderBoxBackground(jComponent, graphics, rectangle, 0, 2);
        } else {
            this._painter.paintHeaderBoxBackground(jComponent, graphics, rectangle, 0, 0);
        }
    }

    protected void uninstallDefaults(HeaderBox headerBox) {
        LookAndFeel.uninstallBorder(headerBox);
        this._painter = null;
    }

    protected class RolloverMouseInputAdapter
    extends MouseInputAdapter {
        private long lastPressedTimestamp = -1L;
        private boolean shouldDiscardRelease = false;

        protected RolloverMouseInputAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && (abstractButton = (AbstractButton)mouseEvent.getSource()).contains(mouseEvent.getX(), mouseEvent.getY())) {
                long l = abstractButton.getMultiClickThreshhold();
                long l2 = this.lastPressedTimestamp;
                long l3 = this.lastPressedTimestamp = mouseEvent.getWhen();
                if (l2 != -1L && l3 - l2 < l) {
                    this.shouldDiscardRelease = true;
                    return;
                }
                ButtonModel buttonModel = abstractButton.getModel();
                if (!buttonModel.isEnabled()) {
                    return;
                }
                if (!buttonModel.isArmed()) {
                    buttonModel.setArmed(true);
                }
                buttonModel.setPressed(true);
                if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                    abstractButton.requestFocus();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (this.shouldDiscardRelease) {
                    this.shouldDiscardRelease = false;
                    return;
                }
                AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                ButtonModel buttonModel = abstractButton.getModel();
                buttonModel.setPressed(false);
                buttonModel.setArmed(false);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                buttonModel.setRollover(true);
            }
            if (buttonModel.isPressed()) {
                buttonModel.setArmed(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
            ButtonModel buttonModel = abstractButton.getModel();
            if (abstractButton.isRolloverEnabled()) {
                buttonModel.setRollover(false);
            }
            buttonModel.setArmed(false);
        }
    }
}

