/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComparableAssert<T extends Comparable<T>>
extends GenericAssert<T> {
    protected ComparableAssert(T actual) {
        super(actual);
    }

    protected abstract ComparableAssert<T> isEqualByComparingTo(T var1);

    protected abstract ComparableAssert<T> isNotEqualByComparingTo(T var1);

    protected abstract ComparableAssert<T> isLessThan(T var1);

    protected abstract ComparableAssert<T> isGreaterThan(T var1);

    protected abstract ComparableAssert<T> isLessThanOrEqualTo(T var1);

    protected abstract ComparableAssert<T> isGreaterThanOrEqualTo(T var1);

    protected final void assertIsEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) == 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    protected final void assertIsNotEqualByComparingTo(T expected) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(expected) == 0) {
            this.fail(ErrorMessages.unexpectedEqual(this.actual, expected));
        }
    }

    protected final void assertIsLessThan(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) < 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    protected final void assertIsGreaterThan(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) > 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    protected final void assertIsLessThanOrEqualTo(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) <= 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    protected final void assertIsGreaterThanOrEqualTo(T other) {
        this.isNotNull();
        if (((Comparable)this.actual).compareTo(other) >= 0) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedLessThan(this.actual, other));
    }
}

