/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.instrumentation;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Sizeof {
    private static Instrumentation instrumentation;

    public static void premain(String args, Instrumentation inst) {
        instrumentation = inst;
    }

    public static boolean isEnabled() {
        return instrumentation != null;
    }

    public static long getObjectSize(Object o) {
        if (!Sizeof.isEnabled()) {
            throw new ReviewedStingException("Sizeof operator is currently disabled!  To enable, review the documentation in Sizeof.java");
        }
        return instrumentation.getObjectSize(o);
    }

    public static long getObjectGraphSize(Object o) {
        if (!Sizeof.isEnabled()) {
            throw new ReviewedStingException("Sizeof operator is currently disabled!  To enable, review the documentation in Sizeof.java");
        }
        IdentityHashMap<Object, Object> objectsSeen = new IdentityHashMap<Object, Object>();
        return Sizeof.getObjectGraphSize(o, objectsSeen);
    }

    private static long getObjectGraphSize(Object o, IdentityHashMap<Object, Object> objectsSeen) {
        if (o == null) {
            return 0L;
        }
        if (objectsSeen.containsKey(o)) {
            return 0L;
        }
        objectsSeen.put(o, o);
        long totalSize = instrumentation.getObjectSize(o);
        Class<?> classToInspect = o.getClass();
        if (classToInspect.isArray() && !classToInspect.getComponentType().isPrimitive()) {
            for (int i = 0; i < Array.getLength(o); ++i) {
                totalSize += Sizeof.getObjectGraphSize(Array.get(o, i), objectsSeen);
            }
        }
        while (classToInspect != null) {
            for (Field field : classToInspect.getDeclaredFields()) {
                Object fieldValue;
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) continue;
                field.setAccessible(true);
                try {
                    fieldValue = field.get(o);
                }
                catch (IllegalAccessException ex) {
                    throw new ReviewedStingException("Unable to access field " + field.getName(), ex);
                }
                totalSize += Sizeof.getObjectGraphSize(fieldValue, objectsSeen);
            }
            classToInspect = classToInspect.getSuperclass();
        }
        return totalSize;
    }
}

