#!/usr/bin/perl
#
# fbx-playlist.pl
# Copyright (C) 2005 Freebox S.A.
# written by Clement Vasseur <cvasseur@freebox.fr>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use strict;
use warnings;
use Cwd 'abs_path';

my @opt_jpg = (
  "sout=#transcode:std",
  "fake-width=720",
  "fake-height=576",
  "fake-aspect-ratio=4:3",
  "fake-keep-ar",
  "fake-deinterlace",
  "deinterlace-mode=blend",
  "sout-transcode-vb=9000",
  "sout-transcode-vcodec=mp2v",
  "sout-transcode-vt=1000000",
  "sout-ffmpeg-keyint=8",
  "sout-ffmpeg-interlace",
  "no-sout-ffmpeg-interlace-me",
);

my @opt_dvd = (
  "sout=#transcode:std",
  "sout-transcode-ab=256",
  "sout-transcode-acodec=mpga",
  "sout-transcode-channels=2",
  "file-caching=1000",
  "dvd-caching=500"
);

my @opt_avi = (
  "sout=#transcode:std",
  "sout-transcode-ab=256",
  "sout-transcode-acodec=mpga",
  "sout-transcode-channels=2",
  "sout-transcode-vb=9000",
  "sout-transcode-vcodec=mp2v",
  "sout-transcode-vt=1000000",
  "sout-transcode-fps=25.0",
  "sout-transcode-soverlay",
  "sout-ffmpeg-keyint=24",
  "sout-ffmpeg-interlace",
  "no-sout-ffmpeg-interlace-me",
  "file-caching=1000"
);


if (@ARGV == 0 or $ARGV[0] eq '-h') {
  print "usage: $0 files...\n";
  exit 1;
}

print "#EXTM3U\n";

foreach my $filename (@ARGV) {
  my $name = $filename;
  my $ext = '';

  $filename = abs_path($filename) unless $filename =~ m/^http:\/\//;

  if ($filename =~ m/([^\/]+)\.([^\.\/]+)$/) {
    $name = $1;
    $ext = $2;
  }

  print "#EXTINF:0,$name\n";

  if ($ext =~ m/^vob$/i) {
    print "#EXTVLCOPT:$_\n" foreach @opt_dvd;
    print "$filename\n";

  } elsif ($ext =~ m/^(avi|ogg|mp3|mkv|mp4|mov|aac|au|aif|aiff|mjpeg|wmv|wma|wav|asf|ogm|divx)$/i) {
    print "#EXTVLCOPT:$_\n" foreach @opt_avi;
    print "$filename\n";

  } elsif ($ext =~ m/^(jpg|jpeg|ljpg|png|pgm|pgmyuv|pbm|pam|tga|bmp|pnm|xpm|xcf|pcx|gif|tif|tiff|lbm)$/i) {
    print "#EXTVLCOPT:$_\n" foreach @opt_jpg;
    print "#EXTVLCOPT:fake-file=$filename\n";
    print "fake:\n";

  } elsif ($name =~ m/^\/dev\//i) {
    print "#EXTVLCOPT:$_\n" foreach @opt_dvd;
    print "dvdsimple:$filename\n";

  } elsif ($name =~ m/^http:\/\//i) {
    print "#EXTVLCOPT:$_\n" foreach @opt_avi;
    print "$filename\n";

  } else {
    print "$filename\n";
  }
}
