/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartInstancesRequest
extends AmazonWebServiceRequest {
    private Boolean dryRun;
    private List<String> instanceIds;

    public StartInstancesRequest() {
    }

    public StartInstancesRequest(List<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public StartInstancesRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getInstanceIds() {
        if (this.instanceIds == null) {
            this.instanceIds = new ArrayList<String>();
        }
        return this.instanceIds;
    }

    public void setInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
            return;
        }
        ArrayList<String> instanceIdsCopy = new ArrayList<String>(instanceIds.size());
        instanceIdsCopy.addAll(instanceIds);
        this.instanceIds = instanceIdsCopy;
    }

    public StartInstancesRequest withInstanceIds(String ... instanceIds) {
        if (this.getInstanceIds() == null) {
            this.setInstanceIds(new ArrayList<String>(instanceIds.length));
        }
        for (String value : instanceIds) {
            this.getInstanceIds().add(value);
        }
        return this;
    }

    public StartInstancesRequest withInstanceIds(Collection<String> instanceIds) {
        if (instanceIds == null) {
            this.instanceIds = null;
        } else {
            ArrayList<String> instanceIdsCopy = new ArrayList<String>(instanceIds.size());
            instanceIdsCopy.addAll(instanceIds);
            this.instanceIds = instanceIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dryRun != null) {
            sb.append("DryRun: " + this.dryRun + ", ");
        }
        if (this.instanceIds != null) {
            sb.append("InstanceIds: " + this.instanceIds + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceIds() == null ? 0 : ((Object)this.getInstanceIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartInstancesRequest)) {
            return false;
        }
        StartInstancesRequest other = (StartInstancesRequest)((Object)obj);
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getInstanceIds() == null ^ this.getInstanceIds() == null) {
            return false;
        }
        return other.getInstanceIds() == null || ((Object)other.getInstanceIds()).equals(this.getInstanceIds());
    }
}

