/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.i18n.shared.DirectionEstimator;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DirectionalTextHelper;

public class RadioButton
extends CheckBox {
    public static final DirectionEstimator DEFAULT_DIRECTION_ESTIMATOR = DirectionalTextHelper.DEFAULT_DIRECTION_ESTIMATOR;
    private Boolean oldValue;

    @UiConstructor
    public RadioButton(String name) {
        super(DOM.createInputRadio(name));
        this.setStyleName("gwt-RadioButton");
        this.sinkEvents(1);
        this.sinkEvents(8);
        this.sinkEvents(4096);
        this.sinkEvents(128);
    }

    public RadioButton(String name, SafeHtml label) {
        this(name, label.asString(), true);
    }

    public RadioButton(String name, SafeHtml label, HasDirection.Direction dir) {
        this(name);
        this.setHTML(label, dir);
    }

    public RadioButton(String name, SafeHtml label, DirectionEstimator directionEstimator) {
        this(name);
        this.setDirectionEstimator(directionEstimator);
        this.setHTML(label.asString());
    }

    public RadioButton(String name, String label) {
        this(name);
        this.setText(label);
    }

    public RadioButton(String name, String label, HasDirection.Direction dir) {
        this(name);
        this.setText(label, dir);
    }

    public RadioButton(String name, String label, DirectionEstimator directionEstimator) {
        this(name);
        this.setDirectionEstimator(directionEstimator);
        this.setText(label);
    }

    public RadioButton(String name, String label, boolean asHTML) {
        this(name);
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 8: 
            case 128: 
            case 4096: {
                this.oldValue = this.getValue();
                break;
            }
            case 1: {
                EventTarget target = event.getEventTarget();
                if (Element.is(target) && this.labelElem.isOrHasChild(Element.as(target))) {
                    this.oldValue = this.getValue();
                    return;
                }
                super.onBrowserEvent(event);
                ValueChangeEvent.fireIfNotEqual(this, this.oldValue, this.getValue());
                return;
            }
        }
        super.onBrowserEvent(event);
    }

    public void setName(String name) {
        this.replaceInputElement(DOM.createInputRadio(name));
    }

    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            Event.sinkEvents(this.inputElem, eventBitsToAdd | Event.getEventsSunk(this.inputElem));
            Event.sinkEvents(this.labelElem, eventBitsToAdd | Event.getEventsSunk(this.labelElem));
        } else {
            super.sinkEvents(eventBitsToAdd);
        }
    }

    protected void ensureDomEventHandlers() {
    }
}

