/****************************************************************************
**
** Copyright (C) 2012 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt3D examples of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** You may use this file under the terms of the BSD license as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of Digia Plc and its Subsidiary(-ies) nor the names
**     of its contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef BASKET_DATA_H
#define BASKET_DATA_H

#include "qglbezierpatches.h"

// Generated from basket_data.txt by meshcvt, depth = 4

#define BasketBezierVertexCount 306
#define BasketPatchCount 24
#define BasketDepth 4
static float const BasketBezierVertexData[] = {
    0.700000f, 0.450000f, -0.000000f,
    0.700000f, 0.450000f, 0.392000f,
    0.392000f, 0.450000f, 0.700000f,
    0.000000f, 0.450000f, 0.700000f,
    0.668750f, 0.515625f, -0.000000f,
    0.668750f, 0.515625f, 0.374500f,
    0.374500f, 0.515625f, 0.668750f,
    0.000000f, 0.515625f, 0.668750f,
    0.718750f, 0.515625f, -0.000000f,
    0.718750f, 0.515625f, 0.402500f,
    0.402500f, 0.515625f, 0.718750f,
    0.000000f, 0.515625f, 0.718750f,
    0.750000f, 0.450000f, -0.000000f,
    0.750000f, 0.450000f, 0.420000f,
    0.420000f, 0.450000f, 0.750000f,
    0.000000f, 0.450000f, 0.750000f,
    -0.392000f, 0.450000f, 0.700000f,
    -0.700000f, 0.450000f, 0.392000f,
    -0.700000f, 0.450000f, -0.000000f,
    -0.374500f, 0.515625f, 0.668750f,
    -0.668750f, 0.515625f, 0.374500f,
    -0.668750f, 0.515625f, -0.000000f,
    -0.402500f, 0.515625f, 0.718750f,
    -0.718750f, 0.515625f, 0.402500f,
    -0.718750f, 0.515625f, -0.000000f,
    -0.420000f, 0.450000f, 0.750000f,
    -0.750000f, 0.450000f, 0.420000f,
    -0.750000f, 0.450000f, -0.000000f,
    -0.700000f, 0.450000f, -0.392000f,
    -0.392000f, 0.450000f, -0.700000f,
    0.000000f, 0.450000f, -0.700000f,
    -0.668750f, 0.515625f, -0.374500f,
    -0.374500f, 0.515625f, -0.668750f,
    0.000000f, 0.515625f, -0.668750f,
    -0.718750f, 0.515625f, -0.402500f,
    -0.402500f, 0.515625f, -0.718750f,
    0.000000f, 0.515625f, -0.718750f,
    -0.750000f, 0.450000f, -0.420000f,
    -0.420000f, 0.450000f, -0.750000f,
    0.000000f, 0.450000f, -0.750000f,
    0.392000f, 0.450000f, -0.700000f,
    0.700000f, 0.450000f, -0.392000f,
    0.374500f, 0.515625f, -0.668750f,
    0.668750f, 0.515625f, -0.374500f,
    0.402500f, 0.515625f, -0.718750f,
    0.718750f, 0.515625f, -0.402500f,
    0.420000f, 0.450000f, -0.750000f,
    0.750000f, 0.450000f, -0.420000f,
    0.875000f, 0.187500f, -0.000000f,
    0.875000f, 0.187500f, 0.490000f,
    0.490000f, 0.187500f, 0.875000f,
    0.000000f, 0.187500f, 0.875000f,
    1.000000f, -0.075000f, -0.000000f,
    1.000000f, -0.075000f, 0.560000f,
    0.560000f, -0.075000f, 1.000000f,
    0.000000f, -0.075000f, 1.000000f,
    1.000000f, -0.300000f, -0.000000f,
    1.000000f, -0.300000f, 0.560000f,
    0.560000f, -0.300000f, 1.000000f,
    0.000000f, -0.300000f, 1.000000f,
    -0.490000f, 0.187500f, 0.875000f,
    -0.875000f, 0.187500f, 0.490000f,
    -0.875000f, 0.187500f, -0.000000f,
    -0.560000f, -0.075000f, 1.000000f,
    -1.000000f, -0.075000f, 0.560000f,
    -1.000000f, -0.075000f, -0.000000f,
    -0.560000f, -0.300000f, 1.000000f,
    -1.000000f, -0.300000f, 0.560000f,
    -1.000000f, -0.300000f, -0.000000f,
    -0.875000f, 0.187500f, -0.490000f,
    -0.490000f, 0.187500f, -0.875000f,
    0.000000f, 0.187500f, -0.875000f,
    -1.000000f, -0.075000f, -0.560000f,
    -0.560000f, -0.075000f, -1.000000f,
    0.000000f, -0.075000f, -1.000000f,
    -1.000000f, -0.300000f, -0.560000f,
    -0.560000f, -0.300000f, -1.000000f,
    0.000000f, -0.300000f, -1.000000f,
    0.490000f, 0.187500f, -0.875000f,
    0.875000f, 0.187500f, -0.490000f,
    0.560000f, -0.075000f, -1.000000f,
    1.000000f, -0.075000f, -0.560000f,
    0.560000f, -0.300000f, -1.000000f,
    1.000000f, -0.300000f, -0.560000f,
    1.000000f, -0.525000f, -0.000000f,
    1.000000f, -0.525000f, 0.560000f,
    0.560000f, -0.525000f, 1.000000f,
    0.000000f, -0.525000f, 1.000000f,
    0.750000f, -0.637500f, -0.000000f,
    0.750000f, -0.637500f, 0.420000f,
    0.420000f, -0.637500f, 0.750000f,
    0.000000f, -0.637500f, 0.750000f,
    0.750000f, -0.675000f, -0.000000f,
    0.750000f, -0.675000f, 0.420000f,
    0.420000f, -0.675000f, 0.750000f,
    0.000000f, -0.675000f, 0.750000f,
    -0.560000f, -0.525000f, 1.000000f,
    -1.000000f, -0.525000f, 0.560000f,
    -1.000000f, -0.525000f, -0.000000f,
    -0.420000f, -0.637500f, 0.750000f,
    -0.750000f, -0.637500f, 0.420000f,
    -0.750000f, -0.637500f, -0.000000f,
    -0.420000f, -0.675000f, 0.750000f,
    -0.750000f, -0.675000f, 0.420000f,
    -0.750000f, -0.675000f, -0.000000f,
    -1.000000f, -0.525000f, -0.560000f,
    -0.560000f, -0.525000f, -1.000000f,
    0.000000f, -0.525000f, -1.000000f,
    -0.750000f, -0.637500f, -0.420000f,
    -0.420000f, -0.637500f, -0.750000f,
    0.000000f, -0.637500f, -0.750000f,
    -0.750000f, -0.675000f, -0.420000f,
    -0.420000f, -0.675000f, -0.750000f,
    0.000000f, -0.675000f, -0.750000f,
    0.560000f, -0.525000f, -1.000000f,
    1.000000f, -0.525000f, -0.560000f,
    0.420000f, -0.637500f, -0.750000f,
    0.750000f, -0.637500f, -0.420000f,
    0.420000f, -0.675000f, -0.750000f,
    0.750000f, -0.675000f, -0.420000f,
    -0.800000f, 0.262500f, -0.000000f,
    -0.800000f, 0.262500f, 0.150000f,
    -0.750000f, 0.375000f, 0.150000f,
    -0.750000f, 0.375000f, -0.000000f,
    -1.150000f, 0.262500f, -0.000000f,
    -1.150000f, 0.262500f, 0.150000f,
    -1.250000f, 0.375000f, 0.150000f,
    -1.250000f, 0.375000f, -0.000000f,
    -1.350000f, 0.262500f, -0.000000f,
    -1.350000f, 0.262500f, 0.150000f,
    -1.500000f, 0.375000f, 0.150000f,
    -1.500000f, 0.375000f, -0.000000f,
    -1.350000f, 0.150000f, -0.000000f,
    -1.350000f, 0.150000f, 0.150000f,
    -1.500000f, 0.150000f, 0.150000f,
    -1.500000f, 0.150000f, -0.000000f,
    -0.750000f, 0.375000f, -0.150000f,
    -0.800000f, 0.262500f, -0.150000f,
    -1.250000f, 0.375000f, -0.150000f,
    -1.150000f, 0.262500f, -0.150000f,
    -1.500000f, 0.375000f, -0.150000f,
    -1.350000f, 0.262500f, -0.150000f,
    -1.500000f, 0.150000f, -0.150000f,
    -1.350000f, 0.150000f, -0.150000f,
    -1.350000f, 0.037500f, -0.000000f,
    -1.350000f, 0.037500f, 0.150000f,
    -1.500000f, -0.075000f, 0.150000f,
    -1.500000f, -0.075000f, -0.000000f,
    -1.250000f, -0.187500f, -0.000000f,
    -1.250000f, -0.187500f, 0.150000f,
    -1.325000f, -0.281250f, 0.150000f,
    -1.325000f, -0.281250f, -0.000000f,
    -1.000000f, -0.300000f, 0.150000f,
    -0.950000f, -0.450000f, 0.150000f,
    -0.950000f, -0.450000f, -0.000000f,
    -1.500000f, -0.075000f, -0.150000f,
    -1.350000f, 0.037500f, -0.150000f,
    -1.325000f, -0.281250f, -0.150000f,
    -1.250000f, -0.187500f, -0.150000f,
    -0.950000f, -0.450000f, -0.150000f,
    -1.000000f, -0.300000f, -0.150000f,
    0.850000f, -0.037500f, -0.000000f,
    0.850000f, -0.037500f, 0.330000f,
    0.850000f, -0.450000f, 0.330000f,
    0.850000f, -0.450000f, -0.000000f,
    1.300000f, -0.037500f, -0.000000f,
    1.300000f, -0.037500f, 0.330000f,
    1.550000f, -0.337500f, 0.330000f,
    1.550000f, -0.337500f, -0.000000f,
    1.150000f, 0.300000f, -0.000000f,
    1.150000f, 0.300000f, 0.125000f,
    1.200000f, 0.262500f, 0.125000f,
    1.200000f, 0.262500f, -0.000000f,
    1.350000f, 0.450000f, -0.000000f,
    1.350000f, 0.450000f, 0.125000f,
    1.650000f, 0.450000f, 0.125000f,
    1.650000f, 0.450000f, -0.000000f,
    0.850000f, -0.450000f, -0.330000f,
    0.850000f, -0.037500f, -0.330000f,
    1.550000f, -0.337500f, -0.330000f,
    1.300000f, -0.037500f, -0.330000f,
    1.200000f, 0.262500f, -0.125000f,
    1.150000f, 0.300000f, -0.125000f,
    1.650000f, 0.450000f, -0.125000f,
    1.350000f, 0.450000f, -0.125000f,
    1.400000f, 0.487500f, -0.000000f,
    1.400000f, 0.487500f, 0.125000f,
    1.762500f, 0.496875f, 0.125000f,
    1.762500f, 0.496875f, -0.000000f,
    1.450000f, 0.487500f, -0.000000f,
    1.450000f, 0.487500f, 0.075000f,
    1.725000f, 0.506250f, 0.075000f,
    1.725000f, 0.506250f, -0.000000f,
    1.400000f, 0.450000f, -0.000000f,
    1.400000f, 0.450000f, 0.075000f,
    1.600000f, 0.450000f, 0.075000f,
    1.600000f, 0.450000f, -0.000000f,
    1.762500f, 0.496875f, -0.125000f,
    1.400000f, 0.487500f, -0.125000f,
    1.725000f, 0.506250f, -0.075000f,
    1.450000f, 0.487500f, -0.075000f,
    1.600000f, 0.450000f, -0.075000f,
    1.400000f, 0.450000f, -0.075000f,
    0.000000f, 0.825000f, -0.000000f,
    0.000000f, 0.825000f, 0.001000f,
    0.001000f, 0.825000f, -0.000000f,
    0.400000f, 0.825000f, -0.000000f,
    0.400000f, 0.825000f, 0.225000f,
    0.225000f, 0.825000f, 0.400000f,
    0.000000f, 0.825000f, 0.400000f,
    0.000000f, 0.675000f, -0.000000f,
    0.100000f, 0.600000f, -0.000000f,
    0.100000f, 0.600000f, 0.056000f,
    0.056000f, 0.600000f, 0.100000f,
    0.000000f, 0.600000f, 0.100000f,
    -0.001000f, 0.825000f, -0.000000f,
    -0.225000f, 0.825000f, 0.400000f,
    -0.400000f, 0.825000f, 0.225000f,
    -0.400000f, 0.825000f, -0.000000f,
    -0.056000f, 0.600000f, 0.100000f,
    -0.100000f, 0.600000f, 0.056000f,
    -0.100000f, 0.600000f, -0.000000f,
    0.000000f, 0.825000f, -0.001000f,
    -0.400000f, 0.825000f, -0.225000f,
    -0.225000f, 0.825000f, -0.400000f,
    0.000000f, 0.825000f, -0.400000f,
    -0.100000f, 0.600000f, -0.056000f,
    -0.056000f, 0.600000f, -0.100000f,
    0.000000f, 0.600000f, -0.100000f,
    0.225000f, 0.825000f, -0.400000f,
    0.400000f, 0.825000f, -0.225000f,
    0.056000f, 0.600000f, -0.100000f,
    0.100000f, 0.600000f, -0.056000f,
    0.200000f, 0.525000f, -0.000000f,
    0.200000f, 0.525000f, 0.112000f,
    0.112000f, 0.525000f, 0.200000f,
    0.000000f, 0.525000f, 0.200000f,
    0.650000f, 0.525000f, -0.000000f,
    0.650000f, 0.525000f, 0.364000f,
    0.364000f, 0.525000f, 0.650000f,
    0.000000f, 0.525000f, 0.650000f,
    0.650000f, 0.450000f, -0.000000f,
    0.650000f, 0.450000f, 0.364000f,
    0.364000f, 0.450000f, 0.650000f,
    0.000000f, 0.450000f, 0.650000f,
    -0.112000f, 0.525000f, 0.200000f,
    -0.200000f, 0.525000f, 0.112000f,
    -0.200000f, 0.525000f, -0.000000f,
    -0.364000f, 0.525000f, 0.650000f,
    -0.650000f, 0.525000f, 0.364000f,
    -0.650000f, 0.525000f, -0.000000f,
    -0.364000f, 0.450000f, 0.650000f,
    -0.650000f, 0.450000f, 0.364000f,
    -0.650000f, 0.450000f, -0.000000f,
    -0.200000f, 0.525000f, -0.112000f,
    -0.112000f, 0.525000f, -0.200000f,
    0.000000f, 0.525000f, -0.200000f,
    -0.650000f, 0.525000f, -0.364000f,
    -0.364000f, 0.525000f, -0.650000f,
    0.000000f, 0.525000f, -0.650000f,
    -0.650000f, 0.450000f, -0.364000f,
    -0.364000f, 0.450000f, -0.650000f,
    0.000000f, 0.450000f, -0.650000f,
    0.112000f, 0.525000f, -0.200000f,
    0.200000f, 0.525000f, -0.112000f,
    0.364000f, 0.525000f, -0.650000f,
    0.650000f, 0.525000f, -0.364000f,
    0.364000f, 0.450000f, -0.650000f,
    0.650000f, 0.450000f, -0.364000f,
    0.000000f, -0.750000f, -0.000000f,
    0.750000f, -0.675000f, -0.000000f,
    0.750000f, -0.675000f, -0.420000f,
    0.420000f, -0.675000f, -0.750000f,
    0.000000f, -0.675000f, -0.750000f,
    0.750000f, -0.712500f, -0.000000f,
    0.750000f, -0.712500f, -0.420000f,
    0.420000f, -0.712500f, -0.750000f,
    0.000000f, -0.712500f, -0.750000f,
    0.712500f, -0.750000f, -0.000000f,
    0.712500f, -0.750000f, -0.399000f,
    0.399000f, -0.750000f, -0.712500f,
    0.000000f, -0.750000f, -0.712500f,
    -0.420000f, -0.675000f, -0.750000f,
    -0.750000f, -0.675000f, -0.420000f,
    -0.750000f, -0.675000f, -0.000000f,
    -0.420000f, -0.712500f, -0.750000f,
    -0.750000f, -0.712500f, -0.420000f,
    -0.750000f, -0.712500f, -0.000000f,
    -0.399000f, -0.750000f, -0.712500f,
    -0.712500f, -0.750000f, -0.399000f,
    -0.712500f, -0.750000f, -0.000000f,
    -0.750000f, -0.675000f, 0.420000f,
    -0.420000f, -0.675000f, 0.750000f,
    0.000000f, -0.675000f, 0.750000f,
    -0.750000f, -0.712500f, 0.420000f,
    -0.420000f, -0.712500f, 0.750000f,
    0.000000f, -0.712500f, 0.750000f,
    -0.712500f, -0.750000f, 0.399000f,
    -0.399000f, -0.750000f, 0.712500f,
    0.000000f, -0.750000f, 0.712500f,
    0.420000f, -0.675000f, 0.750000f,
    0.750000f, -0.675000f, 0.420000f,
    0.420000f, -0.712500f, 0.750000f,
    0.750000f, -0.712500f, 0.420000f,
    0.399000f, -0.750000f, 0.712500f,
    0.712500f, -0.750000f, 0.399000f
};

static ushort const BasketPatchData[] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
    3, 16, 17, 18, 7, 19, 20, 21, 11, 22, 23, 24, 15, 25, 26, 27,
    18, 28, 29, 30, 21, 31, 32, 33, 24, 34, 35, 36, 27, 37, 38, 39,
    30, 40, 41, 0, 33, 42, 43, 4, 36, 44, 45, 8, 39, 46, 47, 12,
    12, 13, 14, 15, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
    15, 25, 26, 27, 51, 60, 61, 62, 55, 63, 64, 65, 59, 66, 67, 68,
    27, 37, 38, 39, 62, 69, 70, 71, 65, 72, 73, 74, 68, 75, 76, 77,
    39, 46, 47, 12, 71, 78, 79, 48, 74, 80, 81, 52, 77, 82, 83, 56,
    56, 57, 58, 59, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95,
    59, 66, 67, 68, 87, 96, 97, 98, 91, 99, 100, 101, 95, 102, 103, 104,
    68, 75, 76, 77, 98, 105, 106, 107, 101, 108, 109, 110, 104, 111, 112, 113,
    77, 82, 83, 56, 107, 114, 115, 84, 110, 116, 117, 88, 113, 118, 119, 92,
    203, 203, 203, 203, 206, 207, 208, 209, 210, 210, 210, 210, 211, 212, 213, 214,
    203, 203, 203, 203, 209, 216, 217, 218, 210, 210, 210, 210, 214, 219, 220, 221,
    203, 203, 203, 203, 218, 223, 224, 225, 210, 210, 210, 210, 221, 226, 227, 228,
    203, 203, 203, 203, 225, 229, 230, 206, 210, 210, 210, 210, 228, 231, 232, 211,
    211, 212, 213, 214, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244,
    214, 219, 220, 221, 236, 245, 246, 247, 240, 248, 249, 250, 244, 251, 252, 253,
    221, 226, 227, 228, 247, 254, 255, 256, 250, 257, 258, 259, 253, 260, 261, 262,
    228, 231, 232, 211, 256, 263, 264, 233, 259, 265, 266, 237, 262, 267, 268, 241,
    269, 269, 269, 269, 278, 279, 280, 281, 274, 275, 276, 277, 270, 271, 272, 273,
    269, 269, 269, 269, 281, 288, 289, 290, 277, 285, 286, 287, 273, 282, 283, 284,
    269, 269, 269, 269, 290, 297, 298, 299, 287, 294, 295, 296, 284, 291, 292, 293,
    269, 269, 269, 269, 299, 304, 305, 278, 296, 302, 303, 274, 293, 300, 301, 270
};

class BasketPatches : public QGLBezierPatches
{
public:
    BasketPatches()
    {
        QVector3DArray positions;
        for (int pindex = 0; pindex < BasketPatchCount * 16; ++pindex) {
            int vindex = BasketPatchData[pindex];
            positions.append(BasketBezierVertexData[vindex * 3],
                             BasketBezierVertexData[vindex * 3 + 1],
                             BasketBezierVertexData[vindex * 3 + 2]);
        }
        setPositions(positions);
        setSubdivisionDepth(BasketDepth);
    }
};

#endif
