/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JInternalFrame;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.jhotdraw.contrib.CommandMenuItem;
import org.jhotdraw.contrib.MDIDesktopPane;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Command;
import org.jhotdraw.util.CommandMenu;

public class WindowMenu
extends CommandMenu {
    private MDIDesktopPane desktop;
    private Command cascadeCommand;
    private Command tileCommand;

    public WindowMenu(String string, MDIDesktopPane mDIDesktopPane, DrawingEditor drawingEditor) {
        super(string);
        this.desktop = mDIDesktopPane;
        this.cascadeCommand = new AbstractCommand("Cascade", drawingEditor){

            public void execute() {
                WindowMenu.this.desktop.cascadeFrames();
            }

            public boolean isExecutable() {
                return super.isExecutable() && WindowMenu.this.desktop.getAllFrames().length > 0;
            }
        };
        this.tileCommand = new AbstractCommand("Tile", drawingEditor){

            public void execute() {
                WindowMenu.this.desktop.tileFramesHorizontally();
            }

            public boolean isExecutable() {
                return super.isExecutable() && WindowMenu.this.desktop.getAllFrames().length > 0;
            }
        };
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
                WindowMenu.this.removeAll();
            }

            public void menuSelected(MenuEvent menuEvent) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private void buildChildMenus() {
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        this.add(new CommandMenuItem(this.cascadeCommand));
        this.add(new CommandMenuItem(this.tileCommand));
        if (jInternalFrameArray.length > 0) {
            this.addSeparator();
        }
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            ChildMenuItem childMenuItem = new ChildMenuItem(jInternalFrameArray[i]);
            childMenuItem.setState(i == 0);
            childMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JInternalFrame jInternalFrame = ((ChildMenuItem)actionEvent.getSource()).getFrame();
                    jInternalFrame.moveToFront();
                    try {
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        propertyVetoException.printStackTrace();
                    }
                }
            });
            childMenuItem.setIcon(jInternalFrameArray[i].getFrameIcon());
            this.add(childMenuItem);
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private JInternalFrame frame;

        public ChildMenuItem(JInternalFrame jInternalFrame) {
            super(jInternalFrame.getTitle());
            this.frame = jInternalFrame;
        }

        public JInternalFrame getFrame() {
            return this.frame;
        }
    }
}

