/*
 * Copyright(C) 2012 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 * Authored by Alberto Mardegan <alberto.mardegan@canonical.com>
 */

    internal class FriendsAccounts : Object
    {
        private Ag.Manager manager;

        internal signal void created(FriendsAccount account);

        internal FriendsAccounts()
        {
            manager = new Ag.Manager.for_service_type("microblogging");
            manager.account_created.connect(on_account_created);
        }

        internal GLib.List<FriendsAccount> list()
        {
            GLib.List<FriendsAccount> accounts = null;
            foreach (var account_service in manager.get_account_services()) {
                var account = new FriendsAccount (account_service);
                accounts.append(account);
            }
            return accounts;
        }

        internal void on_account_created(uint account_id)
        {
            var account = manager.get_account(account_id);
            if (!account.supports_service("microblogging")) return;

            var services = account.list_services();
            foreach (var service in services) {
                var account_service = new Ag.AccountService(account, service);
                created(new FriendsAccount(account_service));
            }
        }
    }
