/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util;

import java.util.Stack;

public class Benchmark {
    private final Stack beginTimes = new Stack();
    private final boolean reportingEnabled;
    private final Reporter reporter;
    private static final String PAD = "                       ";

    public Benchmark() {
        this.reportingEnabled = false;
        this.reporter = null;
    }

    public Benchmark(boolean bl) {
        this.reportingEnabled = bl;
        this.reporter = new Reporter(){

            public void report(String string) {
                System.out.println(string);
            }
        };
    }

    public Benchmark(boolean bl, Reporter reporter) {
        this.reportingEnabled = bl;
        this.reporter = reporter;
    }

    public void begin() {
        this.beginTimes.push(new Long(System.currentTimeMillis()));
    }

    public void beginReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("Beginning...");
        this.begin();
    }

    public void beginReporting(String string) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented(String.valueOf(string) + "...");
        this.begin();
    }

    public long end() {
        return System.currentTimeMillis() - (Long)this.beginTimes.pop();
    }

    public void endReporting() {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms");
    }

    public void endReporting(String string) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented("... took " + this.end() + " ms: " + string);
    }

    public void report(String string) {
        if (!this.reportingEnabled) {
            return;
        }
        this.reportIndented(string);
    }

    public void report(String string, Object object) {
        String string2;
        if (!this.reportingEnabled) {
            return;
        }
        String string3 = string == null ? "" : (string2 = String.valueOf(string) + ": " + (string.length() < PAD.length() ? PAD.substring(string.length()) : ""));
        if (object == null) {
            this.reportIndented(String.valueOf(string2) + "(undefined)");
        } else if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length == 0) {
                this.reportIndented(String.valueOf(string2) + "(empty)");
            } else if (objectArray.length == 1) {
                this.reportIndented(String.valueOf(string2) + objectArray[0].toString());
            } else {
                this.reportIndented(string == null ? "Array:" : String.valueOf(string) + ':');
                this.begin();
                try {
                    int n = 0;
                    while (n < objectArray.length) {
                        this.report(null, objectArray[n]);
                        ++n;
                    }
                }
                finally {
                    Object var6_6 = null;
                    this.end();
                }
            }
        } else {
            this.reportIndented(String.valueOf(string2) + object.toString());
        }
    }

    private void reportIndented(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.beginTimes.size();
        while (n > 0) {
            stringBuffer.append("  ");
            --n;
        }
        stringBuffer.append(string);
        this.reporter.report(stringBuffer.toString());
    }

    public static interface Reporter {
        public void report(String var1);
    }
}

