// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/workflow_templates.proto

package dataproc

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf2 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf5 "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The operation state.
type WorkflowMetadata_State int32

const (
	// Unused.
	WorkflowMetadata_UNKNOWN WorkflowMetadata_State = 0
	// The operation has been created.
	WorkflowMetadata_PENDING WorkflowMetadata_State = 1
	// The operation is running.
	WorkflowMetadata_RUNNING WorkflowMetadata_State = 2
	// The operation is done; either cancelled or completed.
	WorkflowMetadata_DONE WorkflowMetadata_State = 3
)

var WorkflowMetadata_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "PENDING",
	2: "RUNNING",
	3: "DONE",
}
var WorkflowMetadata_State_value = map[string]int32{
	"UNKNOWN": 0,
	"PENDING": 1,
	"RUNNING": 2,
	"DONE":    3,
}

func (x WorkflowMetadata_State) String() string {
	return proto.EnumName(WorkflowMetadata_State_name, int32(x))
}
func (WorkflowMetadata_State) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{5, 0} }

type WorkflowNode_NodeState int32

const (
	WorkflowNode_NODE_STATUS_UNSPECIFIED WorkflowNode_NodeState = 0
	// The node is awaiting prerequisite node to finish.
	WorkflowNode_BLOCKED WorkflowNode_NodeState = 1
	// The node is runnable but not running.
	WorkflowNode_RUNNABLE WorkflowNode_NodeState = 2
	// The node is running.
	WorkflowNode_RUNNING WorkflowNode_NodeState = 3
	// The node completed successfully.
	WorkflowNode_COMPLETED WorkflowNode_NodeState = 4
	// The node failed. A node can be marked FAILED because
	// its ancestor or peer failed.
	WorkflowNode_FAILED WorkflowNode_NodeState = 5
)

var WorkflowNode_NodeState_name = map[int32]string{
	0: "NODE_STATUS_UNSPECIFIED",
	1: "BLOCKED",
	2: "RUNNABLE",
	3: "RUNNING",
	4: "COMPLETED",
	5: "FAILED",
}
var WorkflowNode_NodeState_value = map[string]int32{
	"NODE_STATUS_UNSPECIFIED": 0,
	"BLOCKED":                 1,
	"RUNNABLE":                2,
	"RUNNING":                 3,
	"COMPLETED":               4,
	"FAILED":                  5,
}

func (x WorkflowNode_NodeState) String() string {
	return proto.EnumName(WorkflowNode_NodeState_name, int32(x))
}
func (WorkflowNode_NodeState) EnumDescriptor() ([]byte, []int) { return fileDescriptor3, []int{8, 0} }

// A Cloud Dataproc workflow template resource.
type WorkflowTemplate struct {
	// Required. The template id.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Output only. The "resource name" of the template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. Used to perform a consistent read-modify-write.
	//
	// This field should be left blank for a `CreateWorkflowTemplate` request. It
	// is required for an `UpdateWorkflowTemplate` request, and must match the
	// current server version. A typical update template flow would fetch the
	// current template with a `GetWorkflowTemplate` request, which will return
	// the current template with the `version` field filled in with the
	// current server version. The user updates other fields in the template,
	// then returns it as part of the `UpdateWorkflowTemplate` request.
	Version int32 `protobuf:"varint,3,opt,name=version" json:"version,omitempty"`
	// Output only. The time template was created.
	CreateTime *google_protobuf5.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime" json:"create_time,omitempty"`
	// Output only. The time template was last updated.
	UpdateTime *google_protobuf5.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime" json:"update_time,omitempty"`
	// Optional. The labels to associate with this template. These labels
	// will be propagated to all jobs and clusters created by the workflow
	// instance.
	//
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	//
	// No more than 32 labels can be associated with a template.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Required. WorkflowTemplate scheduling information.
	Placement *WorkflowTemplatePlacement `protobuf:"bytes,7,opt,name=placement" json:"placement,omitempty"`
	// Required. The Directed Acyclic Graph of Jobs to submit.
	Jobs []*OrderedJob `protobuf:"bytes,8,rep,name=jobs" json:"jobs,omitempty"`
}

func (m *WorkflowTemplate) Reset()                    { *m = WorkflowTemplate{} }
func (m *WorkflowTemplate) String() string            { return proto.CompactTextString(m) }
func (*WorkflowTemplate) ProtoMessage()               {}
func (*WorkflowTemplate) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{0} }

func (m *WorkflowTemplate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *WorkflowTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WorkflowTemplate) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowTemplate) GetCreateTime() *google_protobuf5.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetUpdateTime() *google_protobuf5.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *WorkflowTemplate) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WorkflowTemplate) GetPlacement() *WorkflowTemplatePlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplate) GetJobs() []*OrderedJob {
	if m != nil {
		return m.Jobs
	}
	return nil
}

// Specifies workflow execution target.
//
// Either `managed_cluster` or `cluster_selector` is required.
type WorkflowTemplatePlacement struct {
	// Types that are valid to be assigned to Placement:
	//	*WorkflowTemplatePlacement_ManagedCluster
	//	*WorkflowTemplatePlacement_ClusterSelector
	Placement isWorkflowTemplatePlacement_Placement `protobuf_oneof:"placement"`
}

func (m *WorkflowTemplatePlacement) Reset()                    { *m = WorkflowTemplatePlacement{} }
func (m *WorkflowTemplatePlacement) String() string            { return proto.CompactTextString(m) }
func (*WorkflowTemplatePlacement) ProtoMessage()               {}
func (*WorkflowTemplatePlacement) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{1} }

type isWorkflowTemplatePlacement_Placement interface {
	isWorkflowTemplatePlacement_Placement()
}

type WorkflowTemplatePlacement_ManagedCluster struct {
	ManagedCluster *ManagedCluster `protobuf:"bytes,1,opt,name=managed_cluster,json=managedCluster,oneof"`
}
type WorkflowTemplatePlacement_ClusterSelector struct {
	ClusterSelector *ClusterSelector `protobuf:"bytes,2,opt,name=cluster_selector,json=clusterSelector,oneof"`
}

func (*WorkflowTemplatePlacement_ManagedCluster) isWorkflowTemplatePlacement_Placement()  {}
func (*WorkflowTemplatePlacement_ClusterSelector) isWorkflowTemplatePlacement_Placement() {}

func (m *WorkflowTemplatePlacement) GetPlacement() isWorkflowTemplatePlacement_Placement {
	if m != nil {
		return m.Placement
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetManagedCluster() *ManagedCluster {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ManagedCluster); ok {
		return x.ManagedCluster
	}
	return nil
}

func (m *WorkflowTemplatePlacement) GetClusterSelector() *ClusterSelector {
	if x, ok := m.GetPlacement().(*WorkflowTemplatePlacement_ClusterSelector); ok {
		return x.ClusterSelector
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*WorkflowTemplatePlacement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _WorkflowTemplatePlacement_OneofMarshaler, _WorkflowTemplatePlacement_OneofUnmarshaler, _WorkflowTemplatePlacement_OneofSizer, []interface{}{
		(*WorkflowTemplatePlacement_ManagedCluster)(nil),
		(*WorkflowTemplatePlacement_ClusterSelector)(nil),
	}
}

func _WorkflowTemplatePlacement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManagedCluster); err != nil {
			return err
		}
	case *WorkflowTemplatePlacement_ClusterSelector:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ClusterSelector); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("WorkflowTemplatePlacement.Placement has unexpected type %T", x)
	}
	return nil
}

func _WorkflowTemplatePlacement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*WorkflowTemplatePlacement)
	switch tag {
	case 1: // placement.managed_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ManagedCluster)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ManagedCluster{msg}
		return true, err
	case 2: // placement.cluster_selector
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ClusterSelector)
		err := b.DecodeMessage(msg)
		m.Placement = &WorkflowTemplatePlacement_ClusterSelector{msg}
		return true, err
	default:
		return false, nil
	}
}

func _WorkflowTemplatePlacement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*WorkflowTemplatePlacement)
	// placement
	switch x := m.Placement.(type) {
	case *WorkflowTemplatePlacement_ManagedCluster:
		s := proto.Size(x.ManagedCluster)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *WorkflowTemplatePlacement_ClusterSelector:
		s := proto.Size(x.ClusterSelector)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Cluster that is managed by the workflow.
type ManagedCluster struct {
	// Required. The cluster name. Cluster names within a project must be
	// unique. Names from deleted clusters can be reused.
	ClusterName string `protobuf:"bytes,2,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
	// Required. The cluster configuration.
	Config *ClusterConfig `protobuf:"bytes,3,opt,name=config" json:"config,omitempty"`
	// Optional. The labels to associate with this cluster.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following PCRE regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 64 labels can be associated with a given cluster.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ManagedCluster) Reset()                    { *m = ManagedCluster{} }
func (m *ManagedCluster) String() string            { return proto.CompactTextString(m) }
func (*ManagedCluster) ProtoMessage()               {}
func (*ManagedCluster) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{2} }

func (m *ManagedCluster) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ManagedCluster) GetConfig() *ClusterConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ManagedCluster) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A selector that chooses target cluster for jobs based on metadata.
type ClusterSelector struct {
	// Optional. The zone where workflow process executes. This parameter does not
	// affect the selection of the cluster.
	//
	// If unspecified, the zone of the first cluster matching the selector
	// is used.
	Zone string `protobuf:"bytes,1,opt,name=zone" json:"zone,omitempty"`
	// Required. The cluster labels. Cluster must have all labels
	// to match.
	ClusterLabels map[string]string `protobuf:"bytes,2,rep,name=cluster_labels,json=clusterLabels" json:"cluster_labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ClusterSelector) Reset()                    { *m = ClusterSelector{} }
func (m *ClusterSelector) String() string            { return proto.CompactTextString(m) }
func (*ClusterSelector) ProtoMessage()               {}
func (*ClusterSelector) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{3} }

func (m *ClusterSelector) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *ClusterSelector) GetClusterLabels() map[string]string {
	if m != nil {
		return m.ClusterLabels
	}
	return nil
}

type OrderedJob struct {
	// Required. The step id. The id must be unique among all jobs
	// within the template.
	//
	// The step id is used as prefix for job id, as job `workflow-step-id` label,
	// and in prerequisite_step_ids field from other steps.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId" json:"step_id,omitempty"`
	// Required. The job definition.
	//
	// Types that are valid to be assigned to JobType:
	//	*OrderedJob_HadoopJob
	//	*OrderedJob_SparkJob
	//	*OrderedJob_PysparkJob
	//	*OrderedJob_HiveJob
	//	*OrderedJob_PigJob
	//	*OrderedJob_SparkSqlJob
	JobType isOrderedJob_JobType `protobuf_oneof:"job_type"`
	// Optional. The labels to associate with this job.
	//
	// Label keys must be between 1 and 63 characters long, and must conform to
	// the following regular expression:
	// [\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}
	//
	// Label values must be between 1 and 63 characters long, and must conform to
	// the following regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63}
	//
	// No more than 64 labels can be associated with a given job.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Optional. Job scheduling configuration.
	Scheduling *JobScheduling `protobuf:"bytes,9,opt,name=scheduling" json:"scheduling,omitempty"`
	// Optional. The optional list of prerequisite job step_ids.
	// If not specified, the job will start at the beginning of workflow.
	PrerequisiteStepIds []string `protobuf:"bytes,10,rep,name=prerequisite_step_ids,json=prerequisiteStepIds" json:"prerequisite_step_ids,omitempty"`
}

func (m *OrderedJob) Reset()                    { *m = OrderedJob{} }
func (m *OrderedJob) String() string            { return proto.CompactTextString(m) }
func (*OrderedJob) ProtoMessage()               {}
func (*OrderedJob) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{4} }

type isOrderedJob_JobType interface {
	isOrderedJob_JobType()
}

type OrderedJob_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,2,opt,name=hadoop_job,json=hadoopJob,oneof"`
}
type OrderedJob_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,3,opt,name=spark_job,json=sparkJob,oneof"`
}
type OrderedJob_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,4,opt,name=pyspark_job,json=pysparkJob,oneof"`
}
type OrderedJob_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,5,opt,name=hive_job,json=hiveJob,oneof"`
}
type OrderedJob_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,6,opt,name=pig_job,json=pigJob,oneof"`
}
type OrderedJob_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,7,opt,name=spark_sql_job,json=sparkSqlJob,oneof"`
}

func (*OrderedJob_HadoopJob) isOrderedJob_JobType()   {}
func (*OrderedJob_SparkJob) isOrderedJob_JobType()    {}
func (*OrderedJob_PysparkJob) isOrderedJob_JobType()  {}
func (*OrderedJob_HiveJob) isOrderedJob_JobType()     {}
func (*OrderedJob_PigJob) isOrderedJob_JobType()      {}
func (*OrderedJob_SparkSqlJob) isOrderedJob_JobType() {}

func (m *OrderedJob) GetJobType() isOrderedJob_JobType {
	if m != nil {
		return m.JobType
	}
	return nil
}

func (m *OrderedJob) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

func (m *OrderedJob) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetJobType().(*OrderedJob_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *OrderedJob) GetSparkJob() *SparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *OrderedJob) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetJobType().(*OrderedJob_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *OrderedJob) GetHiveJob() *HiveJob {
	if x, ok := m.GetJobType().(*OrderedJob_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *OrderedJob) GetPigJob() *PigJob {
	if x, ok := m.GetJobType().(*OrderedJob_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *OrderedJob) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetJobType().(*OrderedJob_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *OrderedJob) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *OrderedJob) GetScheduling() *JobScheduling {
	if m != nil {
		return m.Scheduling
	}
	return nil
}

func (m *OrderedJob) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OrderedJob) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OrderedJob_OneofMarshaler, _OrderedJob_OneofUnmarshaler, _OrderedJob_OneofSizer, []interface{}{
		(*OrderedJob_HadoopJob)(nil),
		(*OrderedJob_SparkJob)(nil),
		(*OrderedJob_PysparkJob)(nil),
		(*OrderedJob_HiveJob)(nil),
		(*OrderedJob_PigJob)(nil),
		(*OrderedJob_SparkSqlJob)(nil),
	}
}

func _OrderedJob_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HadoopJob); err != nil {
			return err
		}
	case *OrderedJob_SparkJob:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkJob); err != nil {
			return err
		}
	case *OrderedJob_PysparkJob:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PysparkJob); err != nil {
			return err
		}
	case *OrderedJob_HiveJob:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HiveJob); err != nil {
			return err
		}
	case *OrderedJob_PigJob:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PigJob); err != nil {
			return err
		}
	case *OrderedJob_SparkSqlJob:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SparkSqlJob); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OrderedJob.JobType has unexpected type %T", x)
	}
	return nil
}

func _OrderedJob_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OrderedJob)
	switch tag {
	case 2: // job_type.hadoop_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HadoopJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HadoopJob{msg}
		return true, err
	case 3: // job_type.spark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkJob{msg}
		return true, err
	case 4: // job_type.pyspark_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PySparkJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PysparkJob{msg}
		return true, err
	case 5: // job_type.hive_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HiveJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_HiveJob{msg}
		return true, err
	case 6: // job_type.pig_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(PigJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_PigJob{msg}
		return true, err
	case 7: // job_type.spark_sql_job
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SparkSqlJob)
		err := b.DecodeMessage(msg)
		m.JobType = &OrderedJob_SparkSqlJob{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OrderedJob_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OrderedJob)
	// job_type
	switch x := m.JobType.(type) {
	case *OrderedJob_HadoopJob:
		s := proto.Size(x.HadoopJob)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkJob:
		s := proto.Size(x.SparkJob)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PysparkJob:
		s := proto.Size(x.PysparkJob)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_HiveJob:
		s := proto.Size(x.HiveJob)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_PigJob:
		s := proto.Size(x.PigJob)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OrderedJob_SparkSqlJob:
		s := proto.Size(x.SparkSqlJob)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A Cloud Dataproc workflow template resource.
type WorkflowMetadata struct {
	// Output only. The "resource name" of the template.
	Template string `protobuf:"bytes,1,opt,name=template" json:"template,omitempty"`
	// Output only. The version of template at the time of
	// workflow instantiation.
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
	// Output only. The create cluster operation metadata.
	CreateCluster *ClusterOperation `protobuf:"bytes,3,opt,name=create_cluster,json=createCluster" json:"create_cluster,omitempty"`
	// Output only. The workflow graph.
	Graph *WorkflowGraph `protobuf:"bytes,4,opt,name=graph" json:"graph,omitempty"`
	// Output only. The delete cluster operation metadata.
	DeleteCluster *ClusterOperation `protobuf:"bytes,5,opt,name=delete_cluster,json=deleteCluster" json:"delete_cluster,omitempty"`
	// Output only. The workflow state.
	State WorkflowMetadata_State `protobuf:"varint,6,opt,name=state,enum=google.cloud.dataproc.v1beta2.WorkflowMetadata_State" json:"state,omitempty"`
	// Output only. The name of the managed cluster.
	ClusterName string `protobuf:"bytes,7,opt,name=cluster_name,json=clusterName" json:"cluster_name,omitempty"`
}

func (m *WorkflowMetadata) Reset()                    { *m = WorkflowMetadata{} }
func (m *WorkflowMetadata) String() string            { return proto.CompactTextString(m) }
func (*WorkflowMetadata) ProtoMessage()               {}
func (*WorkflowMetadata) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{5} }

func (m *WorkflowMetadata) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *WorkflowMetadata) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *WorkflowMetadata) GetCreateCluster() *ClusterOperation {
	if m != nil {
		return m.CreateCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetGraph() *WorkflowGraph {
	if m != nil {
		return m.Graph
	}
	return nil
}

func (m *WorkflowMetadata) GetDeleteCluster() *ClusterOperation {
	if m != nil {
		return m.DeleteCluster
	}
	return nil
}

func (m *WorkflowMetadata) GetState() WorkflowMetadata_State {
	if m != nil {
		return m.State
	}
	return WorkflowMetadata_UNKNOWN
}

func (m *WorkflowMetadata) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type ClusterOperation struct {
	// Output only. The id of the cluster operation.
	OperationId string `protobuf:"bytes,1,opt,name=operation_id,json=operationId" json:"operation_id,omitempty"`
	// Output only. Error, if operation failed.
	Error string `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
	// Output only. Indicates the operation is done.
	Done bool `protobuf:"varint,3,opt,name=done" json:"done,omitempty"`
}

func (m *ClusterOperation) Reset()                    { *m = ClusterOperation{} }
func (m *ClusterOperation) String() string            { return proto.CompactTextString(m) }
func (*ClusterOperation) ProtoMessage()               {}
func (*ClusterOperation) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{6} }

func (m *ClusterOperation) GetOperationId() string {
	if m != nil {
		return m.OperationId
	}
	return ""
}

func (m *ClusterOperation) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

func (m *ClusterOperation) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

// The workflow graph.
type WorkflowGraph struct {
	// Output only. The workflow nodes.
	Nodes []*WorkflowNode `protobuf:"bytes,1,rep,name=nodes" json:"nodes,omitempty"`
}

func (m *WorkflowGraph) Reset()                    { *m = WorkflowGraph{} }
func (m *WorkflowGraph) String() string            { return proto.CompactTextString(m) }
func (*WorkflowGraph) ProtoMessage()               {}
func (*WorkflowGraph) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{7} }

func (m *WorkflowGraph) GetNodes() []*WorkflowNode {
	if m != nil {
		return m.Nodes
	}
	return nil
}

// The workflow node.
type WorkflowNode struct {
	// Output only. The name of the node.
	StepId string `protobuf:"bytes,1,opt,name=step_id,json=stepId" json:"step_id,omitempty"`
	// Output only. Node's prerequisite nodes.
	PrerequisiteStepIds []string `protobuf:"bytes,2,rep,name=prerequisite_step_ids,json=prerequisiteStepIds" json:"prerequisite_step_ids,omitempty"`
	// Output only. The job id; populated after the node enters RUNNING state.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId" json:"job_id,omitempty"`
	// Output only. The node state.
	State WorkflowNode_NodeState `protobuf:"varint,5,opt,name=state,enum=google.cloud.dataproc.v1beta2.WorkflowNode_NodeState" json:"state,omitempty"`
	// Output only. The error detail.
	Error string `protobuf:"bytes,6,opt,name=error" json:"error,omitempty"`
}

func (m *WorkflowNode) Reset()                    { *m = WorkflowNode{} }
func (m *WorkflowNode) String() string            { return proto.CompactTextString(m) }
func (*WorkflowNode) ProtoMessage()               {}
func (*WorkflowNode) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{8} }

func (m *WorkflowNode) GetStepId() string {
	if m != nil {
		return m.StepId
	}
	return ""
}

func (m *WorkflowNode) GetPrerequisiteStepIds() []string {
	if m != nil {
		return m.PrerequisiteStepIds
	}
	return nil
}

func (m *WorkflowNode) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *WorkflowNode) GetState() WorkflowNode_NodeState {
	if m != nil {
		return m.State
	}
	return WorkflowNode_NODE_STATUS_UNSPECIFIED
}

func (m *WorkflowNode) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// A request to create a workflow template.
type CreateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Required. The Dataproc workflow template to create.
	Template *WorkflowTemplate `protobuf:"bytes,2,opt,name=template" json:"template,omitempty"`
}

func (m *CreateWorkflowTemplateRequest) Reset()                    { *m = CreateWorkflowTemplateRequest{} }
func (m *CreateWorkflowTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateWorkflowTemplateRequest) ProtoMessage()               {}
func (*CreateWorkflowTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{9} }

func (m *CreateWorkflowTemplateRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to fetch a workflow template.
type GetWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The version of workflow template to retrieve. Only previously
	// instatiated versions can be retrieved.
	//
	// If unspecified, retrieves the current version.
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
}

func (m *GetWorkflowTemplateRequest) Reset()                    { *m = GetWorkflowTemplateRequest{} }
func (m *GetWorkflowTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*GetWorkflowTemplateRequest) ProtoMessage()               {}
func (*GetWorkflowTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{10} }

func (m *GetWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

// A request to instantiate a workflow template.
type InstantiateWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The version of workflow template to instantiate. If specified,
	// the workflow will be instantiated only if the current version of
	// the workflow template has the supplied version.
	//
	// This option cannot be used to instantiate a previous version of
	// workflow template.
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
	// Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of
	// concurrent instances started due to retries.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The tag must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	InstanceId string `protobuf:"bytes,3,opt,name=instance_id,json=instanceId" json:"instance_id,omitempty"`
}

func (m *InstantiateWorkflowTemplateRequest) Reset()         { *m = InstantiateWorkflowTemplateRequest{} }
func (m *InstantiateWorkflowTemplateRequest) String() string { return proto.CompactTextString(m) }
func (*InstantiateWorkflowTemplateRequest) ProtoMessage()    {}
func (*InstantiateWorkflowTemplateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor3, []int{11}
}

func (m *InstantiateWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *InstantiateWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *InstantiateWorkflowTemplateRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

// A request to update a workflow template.
type UpdateWorkflowTemplateRequest struct {
	// Required. The updated workflow template.
	//
	// The `template.version` field must match the current version.
	Template *WorkflowTemplate `protobuf:"bytes,1,opt,name=template" json:"template,omitempty"`
}

func (m *UpdateWorkflowTemplateRequest) Reset()                    { *m = UpdateWorkflowTemplateRequest{} }
func (m *UpdateWorkflowTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateWorkflowTemplateRequest) ProtoMessage()               {}
func (*UpdateWorkflowTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{12} }

func (m *UpdateWorkflowTemplateRequest) GetTemplate() *WorkflowTemplate {
	if m != nil {
		return m.Template
	}
	return nil
}

// A request to list workflow templates in a project.
type ListWorkflowTemplatesRequest struct {
	// Required. The "resource name" of the region, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Optional. The maximum number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListWorkflowTemplatesRequest) Reset()                    { *m = ListWorkflowTemplatesRequest{} }
func (m *ListWorkflowTemplatesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesRequest) ProtoMessage()               {}
func (*ListWorkflowTemplatesRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{13} }

func (m *ListWorkflowTemplatesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListWorkflowTemplatesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListWorkflowTemplatesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response to a request to list workflow templates in a project.
type ListWorkflowTemplatesResponse struct {
	// Output only. WorkflowTemplates list.
	Templates []*WorkflowTemplate `protobuf:"bytes,1,rep,name=templates" json:"templates,omitempty"`
	// Output only. This token is included in the response if there are more results
	// to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent <code>ListWorkflowTemplatesRequest</code>.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListWorkflowTemplatesResponse) Reset()                    { *m = ListWorkflowTemplatesResponse{} }
func (m *ListWorkflowTemplatesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListWorkflowTemplatesResponse) ProtoMessage()               {}
func (*ListWorkflowTemplatesResponse) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{14} }

func (m *ListWorkflowTemplatesResponse) GetTemplates() []*WorkflowTemplate {
	if m != nil {
		return m.Templates
	}
	return nil
}

func (m *ListWorkflowTemplatesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to delete a workflow template.
//
// Currently started workflows will remain running.
type DeleteWorkflowTemplateRequest struct {
	// Required. The "resource name" of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names of the form
	// `projects/{project_id}/regions/{region}/workflowTemplates/{template_id}`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional. The version of workflow template to delete. If specified,
	// will only delete the template if the current server version matches
	// specified version.
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
}

func (m *DeleteWorkflowTemplateRequest) Reset()                    { *m = DeleteWorkflowTemplateRequest{} }
func (m *DeleteWorkflowTemplateRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteWorkflowTemplateRequest) ProtoMessage()               {}
func (*DeleteWorkflowTemplateRequest) Descriptor() ([]byte, []int) { return fileDescriptor3, []int{15} }

func (m *DeleteWorkflowTemplateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteWorkflowTemplateRequest) GetVersion() int32 {
	if m != nil {
		return m.Version
	}
	return 0
}

func init() {
	proto.RegisterType((*WorkflowTemplate)(nil), "google.cloud.dataproc.v1beta2.WorkflowTemplate")
	proto.RegisterType((*WorkflowTemplatePlacement)(nil), "google.cloud.dataproc.v1beta2.WorkflowTemplatePlacement")
	proto.RegisterType((*ManagedCluster)(nil), "google.cloud.dataproc.v1beta2.ManagedCluster")
	proto.RegisterType((*ClusterSelector)(nil), "google.cloud.dataproc.v1beta2.ClusterSelector")
	proto.RegisterType((*OrderedJob)(nil), "google.cloud.dataproc.v1beta2.OrderedJob")
	proto.RegisterType((*WorkflowMetadata)(nil), "google.cloud.dataproc.v1beta2.WorkflowMetadata")
	proto.RegisterType((*ClusterOperation)(nil), "google.cloud.dataproc.v1beta2.ClusterOperation")
	proto.RegisterType((*WorkflowGraph)(nil), "google.cloud.dataproc.v1beta2.WorkflowGraph")
	proto.RegisterType((*WorkflowNode)(nil), "google.cloud.dataproc.v1beta2.WorkflowNode")
	proto.RegisterType((*CreateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.CreateWorkflowTemplateRequest")
	proto.RegisterType((*GetWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.GetWorkflowTemplateRequest")
	proto.RegisterType((*InstantiateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.InstantiateWorkflowTemplateRequest")
	proto.RegisterType((*UpdateWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateWorkflowTemplateRequest")
	proto.RegisterType((*ListWorkflowTemplatesRequest)(nil), "google.cloud.dataproc.v1beta2.ListWorkflowTemplatesRequest")
	proto.RegisterType((*ListWorkflowTemplatesResponse)(nil), "google.cloud.dataproc.v1beta2.ListWorkflowTemplatesResponse")
	proto.RegisterType((*DeleteWorkflowTemplateRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteWorkflowTemplateRequest")
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.WorkflowMetadata_State", WorkflowMetadata_State_name, WorkflowMetadata_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.WorkflowNode_NodeState", WorkflowNode_NodeState_name, WorkflowNode_NodeState_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for WorkflowTemplateService service

type WorkflowTemplateServiceClient interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [google.cloud.dataproc.v1beta2.OperationService.GetOperation][].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [google.cloud.dataproc.v1beta2.OperationService.CancelOperation][].
	//
	// The [google.cloud.dataproc.v1beta2.Operation.metadata][] will always be
	// [google.cloud.dataproc.v1beta2.WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// The [google.cloud.dataproc.v1beta2.Operation.result][] will always be
	// [google.protobuf.Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error)
}

type workflowTemplateServiceClient struct {
	cc *grpc.ClientConn
}

func NewWorkflowTemplateServiceClient(cc *grpc.ClientConn) WorkflowTemplateServiceClient {
	return &workflowTemplateServiceClient{cc}
}

func (c *workflowTemplateServiceClient) CreateWorkflowTemplate(ctx context.Context, in *CreateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/CreateWorkflowTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) GetWorkflowTemplate(ctx context.Context, in *GetWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/GetWorkflowTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) InstantiateWorkflowTemplate(ctx context.Context, in *InstantiateWorkflowTemplateRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateWorkflowTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) UpdateWorkflowTemplate(ctx context.Context, in *UpdateWorkflowTemplateRequest, opts ...grpc.CallOption) (*WorkflowTemplate, error) {
	out := new(WorkflowTemplate)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/UpdateWorkflowTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) ListWorkflowTemplates(ctx context.Context, in *ListWorkflowTemplatesRequest, opts ...grpc.CallOption) (*ListWorkflowTemplatesResponse, error) {
	out := new(ListWorkflowTemplatesResponse)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/ListWorkflowTemplates", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workflowTemplateServiceClient) DeleteWorkflowTemplate(ctx context.Context, in *DeleteWorkflowTemplateRequest, opts ...grpc.CallOption) (*google_protobuf2.Empty, error) {
	out := new(google_protobuf2.Empty)
	err := grpc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/DeleteWorkflowTemplate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for WorkflowTemplateService service

type WorkflowTemplateServiceServer interface {
	// Creates new workflow template.
	CreateWorkflowTemplate(context.Context, *CreateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Retrieves the latest workflow template.
	//
	// Can retrieve previously instantiated template by specifying optional
	// version parameter.
	GetWorkflowTemplate(context.Context, *GetWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Instantiates a template and begins execution.
	//
	// The returned Operation can be used to track execution of
	// workflow by polling
	// [google.cloud.dataproc.v1beta2.OperationService.GetOperation][].
	// The Operation will complete when entire workflow is finished.
	//
	// The running workflow can be aborted via
	// [google.cloud.dataproc.v1beta2.OperationService.CancelOperation][].
	//
	// The [google.cloud.dataproc.v1beta2.Operation.metadata][] will always be
	// [google.cloud.dataproc.v1beta2.WorkflowMetadata][google.cloud.dataproc.v1beta2.WorkflowMetadata].
	//
	// The [google.cloud.dataproc.v1beta2.Operation.result][] will always be
	// [google.protobuf.Empty][google.protobuf.Empty].
	InstantiateWorkflowTemplate(context.Context, *InstantiateWorkflowTemplateRequest) (*google_longrunning.Operation, error)
	// Updates (replaces) workflow template. The updated template
	// must contain version that matches the current server version.
	UpdateWorkflowTemplate(context.Context, *UpdateWorkflowTemplateRequest) (*WorkflowTemplate, error)
	// Lists workflows that match the specified filter in the request.
	ListWorkflowTemplates(context.Context, *ListWorkflowTemplatesRequest) (*ListWorkflowTemplatesResponse, error)
	// Deletes a workflow template. It does not cancel in-progress workflows.
	DeleteWorkflowTemplate(context.Context, *DeleteWorkflowTemplateRequest) (*google_protobuf2.Empty, error)
}

func RegisterWorkflowTemplateServiceServer(s *grpc.Server, srv WorkflowTemplateServiceServer) {
	s.RegisterService(&_WorkflowTemplateService_serviceDesc, srv)
}

func _WorkflowTemplateService_CreateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/CreateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).CreateWorkflowTemplate(ctx, req.(*CreateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_GetWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/GetWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).GetWorkflowTemplate(ctx, req.(*GetWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InstantiateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/InstantiateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).InstantiateWorkflowTemplate(ctx, req.(*InstantiateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_UpdateWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/UpdateWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).UpdateWorkflowTemplate(ctx, req.(*UpdateWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_ListWorkflowTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkflowTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/ListWorkflowTemplates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).ListWorkflowTemplates(ctx, req.(*ListWorkflowTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WorkflowTemplateService_DeleteWorkflowTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteWorkflowTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.WorkflowTemplateService/DeleteWorkflowTemplate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkflowTemplateServiceServer).DeleteWorkflowTemplate(ctx, req.(*DeleteWorkflowTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WorkflowTemplateService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.WorkflowTemplateService",
	HandlerType: (*WorkflowTemplateServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_CreateWorkflowTemplate_Handler,
		},
		{
			MethodName: "GetWorkflowTemplate",
			Handler:    _WorkflowTemplateService_GetWorkflowTemplate_Handler,
		},
		{
			MethodName: "InstantiateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_InstantiateWorkflowTemplate_Handler,
		},
		{
			MethodName: "UpdateWorkflowTemplate",
			Handler:    _WorkflowTemplateService_UpdateWorkflowTemplate_Handler,
		},
		{
			MethodName: "ListWorkflowTemplates",
			Handler:    _WorkflowTemplateService_ListWorkflowTemplates_Handler,
		},
		{
			MethodName: "DeleteWorkflowTemplate",
			Handler:    _WorkflowTemplateService_DeleteWorkflowTemplate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/workflow_templates.proto",
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1beta2/workflow_templates.proto", fileDescriptor3)
}

var fileDescriptor3 = []byte{
	// 1634 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x5d, 0x6f, 0xdb, 0x5c,
	0x1d, 0xaf, 0xd3, 0x26, 0x4d, 0xfe, 0x59, 0xdb, 0xe8, 0x3c, 0xac, 0x0b, 0xe9, 0x53, 0xad, 0x33,
	0x62, 0x94, 0x32, 0x12, 0x11, 0x04, 0xea, 0xba, 0x4d, 0x5a, 0xdb, 0x64, 0x6b, 0xda, 0x34, 0x09,
	0x4e, 0xbb, 0x21, 0xb8, 0x88, 0x9c, 0xf8, 0xcc, 0x75, 0xeb, 0xf8, 0xb8, 0xb6, 0xd3, 0xd1, 0xa1,
	0xdd, 0xa0, 0x49, 0x7c, 0x00, 0x24, 0x3e, 0x07, 0x9f, 0x01, 0xbe, 0x00, 0x68, 0x5c, 0x22, 0x71,
	0x83, 0xb8, 0xdf, 0x15, 0xb7, 0xe8, 0xbc, 0xd8, 0x71, 0x5e, 0x9d, 0x74, 0xcf, 0x4d, 0xe4, 0x73,
	0x72, 0x7e, 0xbf, 0xf3, 0xfb, 0xbf, 0x1e, 0x1f, 0xc3, 0x2f, 0x75, 0x42, 0x74, 0x13, 0x17, 0x3a,
	0x26, 0xe9, 0x69, 0x05, 0x4d, 0xf5, 0x54, 0xdb, 0x21, 0x9d, 0xc2, 0xcd, 0xcf, 0xda, 0xd8, 0x53,
	0x8b, 0x85, 0xf7, 0xc4, 0xb9, 0x7a, 0x67, 0x92, 0xf7, 0x2d, 0x0f, 0x77, 0x6d, 0x53, 0xf5, 0xb0,
	0x9b, 0xb7, 0x1d, 0xe2, 0x11, 0xb4, 0xc9, 0x71, 0x79, 0x86, 0xcb, 0xfb, 0xb8, 0xbc, 0xc0, 0xe5,
	0xbe, 0x15, 0xb4, 0xaa, 0x6d, 0x14, 0x54, 0xcb, 0x22, 0x9e, 0xea, 0x19, 0xc4, 0x12, 0xe0, 0xdc,
	0x93, 0xe9, 0x9b, 0x76, 0xcc, 0x9e, 0xeb, 0x61, 0xc7, 0x5f, 0xbd, 0x3d, 0x7d, 0xf5, 0x25, 0x69,
	0xfb, 0x2b, 0x7f, 0x20, 0x56, 0x9a, 0xc4, 0xd2, 0x9d, 0x9e, 0x65, 0x19, 0x96, 0x5e, 0x20, 0x36,
	0x76, 0x06, 0x36, 0xdf, 0x10, 0x8b, 0xd8, 0xa8, 0xdd, 0x7b, 0x57, 0xc0, 0x5d, 0xdb, 0xbb, 0x15,
	0x7f, 0x3e, 0x1c, 0xfe, 0xd3, 0x33, 0xba, 0xd8, 0xf5, 0xd4, 0xae, 0xcd, 0x17, 0xc8, 0x5f, 0x16,
	0x21, 0xf3, 0x56, 0x38, 0xe5, 0x4c, 0xf8, 0x04, 0xad, 0x42, 0xcc, 0xd0, 0xb2, 0xb1, 0x2d, 0x69,
	0x3b, 0xa5, 0xc4, 0x0c, 0x0d, 0x21, 0x58, 0xb2, 0xd4, 0x2e, 0xce, 0x4a, 0x6c, 0x86, 0x3d, 0xa3,
	0x2c, 0x2c, 0xdf, 0x60, 0xc7, 0x35, 0x88, 0x95, 0x5d, 0xdc, 0x92, 0xb6, 0xe3, 0x8a, 0x3f, 0x44,
	0xcf, 0x20, 0xdd, 0x71, 0xb0, 0xea, 0xe1, 0x16, 0xdd, 0x2c, 0xbb, 0xb4, 0x25, 0x6d, 0xa7, 0x8b,
	0xb9, 0xbc, 0x70, 0xb0, 0xaf, 0x24, 0x7f, 0xe6, 0x2b, 0x51, 0x80, 0x2f, 0xa7, 0x13, 0x14, 0xdc,
	0xb3, 0xb5, 0x00, 0x1c, 0x8f, 0x06, 0xf3, 0xe5, 0x0c, 0xdc, 0x84, 0x84, 0xa9, 0xb6, 0xb1, 0xe9,
	0x66, 0x13, 0x5b, 0x8b, 0xdb, 0xe9, 0xe2, 0xb3, 0xfc, 0xd4, 0xa8, 0xe6, 0x87, 0x0d, 0xcf, 0x57,
	0x19, 0xba, 0x6c, 0x79, 0xce, 0xad, 0x22, 0xa8, 0xd0, 0x1b, 0x48, 0xd9, 0xa6, 0xda, 0xc1, 0x5d,
	0x6c, 0x79, 0xd9, 0x65, 0xa6, 0x67, 0x77, 0x4e, 0xde, 0x86, 0x8f, 0x57, 0xfa, 0x54, 0xe8, 0x05,
	0x2c, 0xd1, 0x50, 0x67, 0x93, 0x4c, 0xea, 0x8f, 0x23, 0x28, 0xeb, 0x8e, 0x86, 0x1d, 0xac, 0x1d,
	0x93, 0xb6, 0xc2, 0x60, 0xb9, 0xa7, 0x90, 0x0e, 0xa9, 0x45, 0x19, 0x58, 0xbc, 0xc2, 0xb7, 0x22,
	0x42, 0xf4, 0x11, 0x7d, 0x0f, 0xe2, 0x37, 0xaa, 0xd9, 0xc3, 0x22, 0x8e, 0x7c, 0xb0, 0x17, 0xdb,
	0x95, 0xe4, 0x7f, 0x4b, 0xf0, 0xfd, 0x89, 0x12, 0xd1, 0xaf, 0x61, 0xad, 0xab, 0x5a, 0xaa, 0x8e,
	0xb5, 0x96, 0x48, 0x5c, 0xc6, 0x9a, 0x2e, 0xfe, 0x34, 0x42, 0xe2, 0x29, 0x47, 0x1d, 0x72, 0xd0,
	0xd1, 0x82, 0xb2, 0xda, 0x1d, 0x98, 0x41, 0xbf, 0x85, 0x8c, 0x60, 0x6c, 0xb9, 0xd8, 0xc4, 0x1d,
	0x8f, 0x38, 0x4c, 0x5c, 0xba, 0x98, 0x8f, 0xa0, 0x16, 0x0c, 0x4d, 0x81, 0x3a, 0x5a, 0x50, 0xd6,
	0x3a, 0x83, 0x53, 0x07, 0xe9, 0x50, 0x98, 0xe4, 0x3f, 0xc6, 0x60, 0x75, 0x50, 0x0e, 0x7a, 0x04,
	0xf7, 0xfc, 0xcd, 0x59, 0x2e, 0x73, 0xaf, 0xa4, 0xc5, 0x5c, 0x8d, 0xa6, 0x74, 0x09, 0x12, 0x1d,
	0x62, 0xbd, 0x33, 0x74, 0x96, 0xd1, 0xe9, 0xe2, 0x93, 0xd9, 0x54, 0x1d, 0x32, 0x8c, 0x22, 0xb0,
	0xe8, 0x57, 0x41, 0x12, 0x2e, 0xb1, 0xc8, 0x3e, 0x9d, 0xcb, 0x6d, 0xe3, 0x52, 0xf0, 0x6b, 0x62,
	0xfd, 0x0f, 0x09, 0xd6, 0x86, 0xbc, 0x47, 0xcb, 0xf9, 0x03, 0xb1, 0x82, 0x72, 0xa6, 0xcf, 0xe8,
	0x02, 0x56, 0x7d, 0xf7, 0x08, 0xf5, 0x31, 0xa6, 0x7e, 0x7f, 0xbe, 0xc8, 0xf8, 0xe3, 0xb0, 0x15,
	0x2b, 0x9d, 0xf0, 0x5c, 0xee, 0x25, 0xa0, 0xd1, 0x45, 0x73, 0xd9, 0xf4, 0xbf, 0x38, 0x40, 0xbf,
	0x1e, 0xd0, 0x03, 0x58, 0x76, 0x3d, 0x6c, 0xb7, 0x0c, 0x4d, 0xc0, 0x13, 0x74, 0x58, 0xd1, 0x50,
	0x05, 0xe0, 0x42, 0xd5, 0x08, 0xb1, 0x5b, 0x97, 0xa4, 0x2d, 0x32, 0x6d, 0x3b, 0xc2, 0x9e, 0x23,
	0x06, 0x38, 0x26, 0xed, 0xa3, 0x05, 0x25, 0x75, 0xe1, 0x0f, 0xd0, 0x2b, 0x48, 0xb9, 0xb6, 0xea,
	0x5c, 0x31, 0x26, 0x9e, 0x1d, 0x3f, 0x8a, 0x60, 0x6a, 0xd2, 0xf5, 0x9c, 0x28, 0xe9, 0x8a, 0x67,
	0x54, 0x85, 0xb4, 0x7d, 0xdb, 0x67, 0xe2, 0xbd, 0x31, 0xaa, 0xf6, 0x1b, 0xb7, 0x21, 0x2e, 0x10,
	0x78, 0xca, 0x76, 0x08, 0xc9, 0x0b, 0xe3, 0x06, 0x33, 0x2a, 0xde, 0x29, 0x1f, 0x47, 0x99, 0x67,
	0xdc, 0x60, 0xce, 0xb3, 0x7c, 0xc1, 0x1f, 0xd1, 0x4b, 0x58, 0xb6, 0x0d, 0x9d, 0x71, 0x24, 0x18,
	0xc7, 0x0f, 0xa3, 0xe4, 0x18, 0x3a, 0xa7, 0x48, 0xd8, 0xec, 0x09, 0x35, 0x60, 0x85, 0x9b, 0xe4,
	0x5e, 0x9b, 0x8c, 0x87, 0x77, 0xc9, 0x9d, 0x59, 0x1c, 0xd4, 0xbc, 0x36, 0x39, 0x59, 0xda, 0xed,
	0x0f, 0xd1, 0x69, 0x50, 0x43, 0xbc, 0x3b, 0xfe, 0x62, 0xe6, 0xee, 0x38, 0xb6, 0x85, 0x57, 0x01,
	0xdc, 0xce, 0x05, 0xd6, 0x7a, 0xa6, 0x61, 0xe9, 0xd9, 0xd4, 0x4c, 0xc5, 0x7d, 0x4c, 0xda, 0xcd,
	0x00, 0xa3, 0x84, 0xf0, 0xa8, 0x08, 0xf7, 0x6d, 0x07, 0x3b, 0xf8, 0xba, 0x67, 0xb8, 0x86, 0x87,
	0x5b, 0x22, 0xf9, 0xdc, 0x2c, 0x6c, 0x2d, 0x6e, 0xa7, 0x94, 0x6f, 0xc2, 0x7f, 0x36, 0x59, 0x26,
	0x7e, 0x4d, 0x05, 0x1f, 0x00, 0x24, 0x2f, 0x49, 0xbb, 0xe5, 0xdd, 0xda, 0x58, 0xfe, 0x6f, 0xe8,
	0xb4, 0x3e, 0xc5, 0x9e, 0x4a, 0x55, 0xa3, 0x1c, 0x24, 0xfd, 0xb7, 0x19, 0xc1, 0x18, 0x8c, 0xc3,
	0xa7, 0x74, 0x6c, 0xf0, 0x94, 0x7e, 0x03, 0xab, 0xe2, 0x94, 0xf6, 0xbb, 0x3c, 0x4f, 0xeb, 0xc2,
	0x6c, 0x05, 0x5f, 0xf7, 0x5f, 0x43, 0x94, 0x15, 0x4e, 0xe3, 0xf7, 0xd9, 0x03, 0x88, 0xeb, 0x8e,
	0x6a, 0x5f, 0x88, 0xdc, 0x7e, 0x32, 0xe3, 0x51, 0xf9, 0x9a, 0x62, 0x14, 0x0e, 0xa5, 0xda, 0x34,
	0x6c, 0xe2, 0x90, 0xb6, 0xf8, 0x1d, 0xb5, 0x71, 0x1a, 0x5f, 0xdb, 0x09, 0xc4, 0x5d, 0x8f, 0xba,
	0x89, 0x26, 0xfa, 0x6a, 0x64, 0x56, 0x0d, 0x7b, 0x3a, 0xdf, 0xa4, 0x60, 0x85, 0x73, 0x8c, 0x1c,
	0x28, 0xcb, 0x23, 0x07, 0x8a, 0xbc, 0x0b, 0x71, 0x06, 0x41, 0x69, 0x58, 0x3e, 0xaf, 0x9d, 0xd4,
	0xea, 0x6f, 0x6b, 0x99, 0x05, 0x3a, 0x68, 0x94, 0x6b, 0xa5, 0x4a, 0xed, 0x75, 0x46, 0xa2, 0x03,
	0xe5, 0xbc, 0x56, 0xa3, 0x83, 0x18, 0x4a, 0xc2, 0x52, 0xa9, 0x5e, 0x2b, 0x67, 0x16, 0xe5, 0x16,
	0x64, 0x86, 0x8d, 0xa1, 0x1b, 0x06, 0x2f, 0x7f, 0xfd, 0x66, 0x97, 0x0e, 0xe6, 0x2a, 0x1a, 0xcd,
	0x22, 0xec, 0x38, 0xe2, 0x58, 0x4d, 0x29, 0x7c, 0x40, 0xfb, 0xbd, 0x46, 0xfb, 0x3d, 0x0d, 0x70,
	0x52, 0x61, 0xcf, 0xb2, 0x02, 0x2b, 0x03, 0xae, 0x47, 0xfb, 0x10, 0xb7, 0x88, 0x86, 0xdd, 0xac,
	0xc4, 0x2a, 0xee, 0x27, 0x33, 0xfa, 0xa6, 0x46, 0x34, 0xac, 0x70, 0xa4, 0xfc, 0xd7, 0x18, 0xdc,
	0x0b, 0xcf, 0x4f, 0xee, 0xcc, 0x13, 0x4b, 0x28, 0x36, 0xb1, 0x84, 0xd0, 0x7d, 0x48, 0xd0, 0x3a,
	0x30, 0x34, 0x66, 0x47, 0x4a, 0x89, 0x5f, 0x92, 0x76, 0x45, 0xeb, 0xc7, 0x34, 0x3e, 0x57, 0x4c,
	0xa9, 0xbe, 0x3c, 0xfd, 0x19, 0x88, 0x69, 0xe0, 0xbf, 0x44, 0xc8, 0x7f, 0xf2, 0x15, 0xa4, 0x82,
	0x95, 0x68, 0x03, 0x1e, 0xd4, 0xea, 0xa5, 0x72, 0xab, 0x79, 0xb6, 0x7f, 0x76, 0xde, 0x6c, 0x9d,
	0xd7, 0x9a, 0x8d, 0xf2, 0x61, 0xe5, 0x55, 0xa5, 0x5c, 0xe2, 0xa1, 0x3d, 0xa8, 0xd6, 0x0f, 0x4f,
	0xca, 0xa5, 0x8c, 0x84, 0xee, 0x41, 0x92, 0x86, 0x76, 0xff, 0xa0, 0x5a, 0xce, 0xc4, 0xc2, 0x81,
	0x5e, 0x44, 0x2b, 0x90, 0x3a, 0xac, 0x9f, 0x36, 0xaa, 0xe5, 0xb3, 0x72, 0x29, 0xb3, 0x84, 0x00,
	0x12, 0xaf, 0xf6, 0x2b, 0xd5, 0x72, 0x29, 0x13, 0x97, 0x3f, 0x49, 0xb0, 0x79, 0xc8, 0x2a, 0x6a,
	0xf8, 0x15, 0x4d, 0xc1, 0xd7, 0x3d, 0xec, 0x7a, 0x68, 0x1d, 0x12, 0xb6, 0xea, 0xd0, 0xb7, 0x51,
	0xe1, 0x54, 0x3e, 0x42, 0x27, 0xa1, 0x3e, 0x10, 0x9b, 0xa9, 0x5e, 0x46, 0x76, 0x08, 0x08, 0xe4,
	0x63, 0xc8, 0xbd, 0xc6, 0xde, 0x24, 0x09, 0x11, 0x17, 0x82, 0xc1, 0x56, 0x23, 0xbb, 0x20, 0x57,
	0x2c, 0xd7, 0x53, 0x2d, 0xcf, 0x98, 0x62, 0xd6, 0x5c, 0x9c, 0xe8, 0x21, 0xa4, 0x0d, 0xc6, 0xd9,
	0xc1, 0xfd, 0x94, 0x00, 0x7f, 0xaa, 0xa2, 0xc9, 0x26, 0x6c, 0x9e, 0xb3, 0x9b, 0xc1, 0xa4, 0xfd,
	0x4e, 0x86, 0xda, 0xe6, 0x57, 0xb9, 0xcb, 0x81, 0x6f, 0xab, 0x86, 0x3b, 0xe2, 0x2f, 0x37, 0x2a,
	0x66, 0x1b, 0x90, 0xb2, 0x55, 0x1d, 0xb7, 0x5c, 0xe3, 0x03, 0x16, 0x26, 0x26, 0xe9, 0x44, 0xd3,
	0xf8, 0x80, 0xd1, 0x26, 0x00, 0xfb, 0xd3, 0x23, 0x57, 0xd8, 0x12, 0x26, 0xb2, 0xe5, 0x67, 0x74,
	0x42, 0xfe, 0xb3, 0x04, 0x9b, 0x13, 0x36, 0x75, 0x6d, 0x62, 0xb9, 0x18, 0x9d, 0x42, 0x2a, 0xb8,
	0xe7, 0x8a, 0xba, 0x9e, 0xdb, 0xc6, 0x3e, 0x03, 0x7a, 0x0c, 0x6b, 0x16, 0xfe, 0x9d, 0xd7, 0x0a,
	0x89, 0xe2, 0x7d, 0x66, 0x85, 0x4e, 0x37, 0x02, 0x61, 0xa7, 0xb0, 0x59, 0x62, 0x7d, 0xf7, 0x3b,
	0x09, 0x75, 0xf1, 0x4b, 0x0a, 0x1e, 0x0c, 0x33, 0x35, 0xb1, 0x73, 0x63, 0x74, 0x30, 0xfa, 0x2c,
	0xc1, 0xfa, 0xf8, 0x6a, 0x41, 0xcf, 0xa3, 0x0e, 0x8b, 0x69, 0x45, 0x96, 0x9b, 0xd7, 0x4f, 0xf2,
	0xf1, 0x1f, 0x3e, 0xff, 0xe7, 0x4f, 0xb1, 0x92, 0xbc, 0x1b, 0x5c, 0xe4, 0x7f, 0xcf, 0x63, 0xfc,
	0xc2, 0x76, 0xc8, 0x25, 0xee, 0x78, 0x6e, 0x61, 0xa7, 0xe0, 0x60, 0x9d, 0xde, 0xdc, 0x0b, 0x3b,
	0x1f, 0x83, 0x2f, 0x11, 0x41, 0xd4, 0xf6, 0xfa, 0xa7, 0xf6, 0xdf, 0x24, 0xf8, 0x66, 0x4c, 0xf5,
	0xa1, 0xa8, 0xab, 0xc4, 0xe4, 0x8a, 0x9d, 0xdf, 0x9e, 0x97, 0xcc, 0x9e, 0x3d, 0x14, 0xb2, 0x87,
	0xc6, 0x69, 0xac, 0x35, 0xa3, 0xc6, 0x14, 0x76, 0x3e, 0xa2, 0xbf, 0x4b, 0xb0, 0x31, 0xa5, 0xee,
	0x51, 0xd4, 0xd5, 0x22, 0xba, 0x67, 0xe4, 0x36, 0x7d, 0x8a, 0xd0, 0x17, 0x92, 0x7c, 0x70, 0x62,
	0xca, 0x75, 0x66, 0x43, 0x45, 0x2e, 0xdd, 0xd5, 0x86, 0x3d, 0xa3, 0xaf, 0x61, 0x4f, 0xda, 0x41,
	0xff, 0x92, 0x60, 0x7d, 0x7c, 0x57, 0x89, 0x4c, 0xb7, 0xa9, 0xcd, 0x68, 0xfe, 0xf0, 0x34, 0x99,
	0x69, 0xa7, 0xb9, 0xfd, 0xbe, 0x69, 0x7e, 0xfa, 0xe4, 0xe7, 0xb4, 0xb1, 0x9f, 0x77, 0xff, 0x94,
	0xe0, 0xfe, 0xd8, 0x8e, 0x82, 0xa2, 0xbe, 0xa4, 0x4c, 0x6b, 0x7e, 0xb9, 0xe7, 0x77, 0x03, 0xf3,
	0x26, 0x36, 0x2e, 0x11, 0xe7, 0x2b, 0x2c, 0xf4, 0x17, 0x09, 0xd6, 0xc7, 0x37, 0xa4, 0xc8, 0xa8,
	0x4d, 0xed, 0x63, 0xb9, 0xf5, 0x91, 0xef, 0x52, 0xe5, 0xae, 0xed, 0xdd, 0xfa, 0x92, 0x77, 0xee,
	0x5c, 0x3b, 0x07, 0x9f, 0x24, 0x78, 0xd4, 0x21, 0xdd, 0xe9, 0xea, 0x0e, 0xd6, 0x47, 0xbc, 0xd6,
	0xa0, 0x42, 0x1a, 0xd2, 0x6f, 0xca, 0x02, 0xa8, 0x13, 0x53, 0xb5, 0xf4, 0x3c, 0x71, 0xf4, 0x82,
	0x8e, 0x2d, 0x26, 0xb3, 0xc0, 0xff, 0x52, 0x6d, 0xc3, 0x9d, 0xf0, 0x09, 0xf2, 0x99, 0x3f, 0xd1,
	0x4e, 0x30, 0xc4, 0xcf, 0xff, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x4a, 0x21, 0xc2, 0x3b, 0x56, 0x15,
	0x00, 0x00,
}
