; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -mattr=sse2 -machine-combiner-verify-pattern-order=true < %s | FileCheck %s --check-prefix=SSE
; RUN: llc -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -mattr=avx2 -machine-combiner-verify-pattern-order=true < %s | FileCheck %s --check-prefix=AVX --check-prefix=AVX2
; RUN: llc -mtriple=x86_64-unknown-unknown -mcpu=x86-64 -mattr=avx512vl,avx512bw -machine-combiner-verify-pattern-order=true < %s | FileCheck %s --check-prefix=AVX --check-prefix=AVX512

; Verify that 128-bit vector logical ops are reassociated.

define <4 x i32> @reassociate_and_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_and_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_and_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpand %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = and <4 x i32> %x2, %t0
  %t2 = and <4 x i32> %x3, %t1
  ret <4 x i32> %t2
}

define <4 x i32> @reassociate_or_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_or_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_or_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpor %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = or <4 x i32> %x2, %t0
  %t2 = or <4 x i32> %x3, %t1
  ret <4 x i32> %t2
}

define <4 x i32> @reassociate_xor_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_xor_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_xor_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpxor %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = xor <4 x i32> %x2, %t0
  %t2 = xor <4 x i32> %x3, %t1
  ret <4 x i32> %t2
}

; Verify that 256-bit vector logical ops are reassociated.

define <8 x i32> @reassociate_and_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_and_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_and_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpand %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = and <8 x i32> %x2, %t0
  %t2 = and <8 x i32> %x3, %t1
  ret <8 x i32> %t2
}

define <8 x i32> @reassociate_or_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_or_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm4
; SSE-NEXT:    por %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_or_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpor %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = or <8 x i32> %x2, %t0
  %t2 = or <8 x i32> %x3, %t1
  ret <8 x i32> %t2
}

define <8 x i32> @reassociate_xor_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_xor_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm5
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_xor_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpxor %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = xor <8 x i32> %x2, %t0
  %t2 = xor <8 x i32> %x3, %t1
  ret <8 x i32> %t2
}


; Verify that 512-bit vector logical ops are reassociated.

define <16 x i32> @reassociate_and_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_and_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pand {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_and_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_and_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpandd %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpandd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = and <16 x i32> %x2, %t0
  %t2 = and <16 x i32> %x3, %t1
  ret <16 x i32> %t2
}

define <16 x i32> @reassociate_or_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_or_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    por {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_or_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpor %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_or_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpord %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = or <16 x i32> %x2, %t0
  %t2 = or <16 x i32> %x3, %t1
  ret <16 x i32> %t2
}

define <16 x i32> @reassociate_xor_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_xor_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_xor_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_xor_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpxord %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpxord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = xor <16 x i32> %x2, %t0
  %t2 = xor <16 x i32> %x3, %t1
  ret <16 x i32> %t2
}

; Verify that 128-bit vector min/max are reassociated.

define <16 x i8> @reassociate_umax_v16i8(<16 x i8> %x0, <16 x i8> %x1, <16 x i8> %x2, <16 x i8> %x3) {
; SSE-LABEL: reassociate_umax_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm1, %xmm0
; SSE-NEXT:    pmaxub %xmm3, %xmm2
; SSE-NEXT:    pmaxub %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxub %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <16 x i8> %x0, %x1
  %t1 = icmp ugt <16 x i8> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i8> %x2, <16 x i8> %t0
  %t3 = icmp ugt <16 x i8> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i8> %x3, <16 x i8> %t2
  ret <16 x i8> %t4
}

define <8 x i16> @reassociate_umax_v8i16(<8 x i16> %x0, <8 x i16> %x1, <8 x i16> %x2, <8 x i16> %x3) {
; SSE-LABEL: reassociate_umax_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pmaxsw %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    pmaxsw %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxuw %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <8 x i16> %x0, %x1
  %t1 = icmp ugt <8 x i16> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i16> %x2, <8 x i16> %t0
  %t3 = icmp ugt <8 x i16> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i16> %x3, <8 x i16> %t2
  ret <8 x i16> %t4
}

define <4 x i32> @reassociate_umax_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_umax_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm5, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm4
; SSE-NEXT:    por %xmm2, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    pandn %xmm4, %xmm1
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxud %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxud %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = icmp ugt <4 x i32> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i32> %x2, <4 x i32> %t0
  %t3 = icmp ugt <4 x i32> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i32> %x3, <4 x i32> %t2
  ret <4 x i32> %t4
}

define <2 x i64> @reassociate_umax_v2i64(<2 x i64> %x0, <2 x i64> %x1, <2 x i64> %x2, <2 x i64> %x3) {
; SSE-LABEL: reassociate_umax_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %xmm1, %xmm2, %xmm4
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm5
; AVX2-NEXT:    vpcmpgtq %xmm5, %xmm4, %xmm4
; AVX2-NEXT:    vblendvpd %xmm4, %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vxorpd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpxor %xmm1, %xmm3, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm1, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxuq %xmm3, %xmm2, %xmm1
; AVX512-NEXT:    vpmaxuq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq

  %t0 = add <2 x i64> %x0, %x1
  %t1 = icmp ugt <2 x i64> %x2, %t0
  %t2 = select <2 x i1> %t1, <2 x i64> %x2, <2 x i64> %t0
  %t3 = icmp ugt <2 x i64> %x3, %t2
  %t4 = select <2 x i1> %t3, <2 x i64> %x3, <2 x i64> %t2
  ret <2 x i64> %t4
}

define <16 x i8> @reassociate_smax_v16i8(<16 x i8> %x0, <16 x i8> %x1, <16 x i8> %x2, <16 x i8> %x3) {
; SSE-LABEL: reassociate_smax_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxsb %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <16 x i8> %x0, %x1
  %t1 = icmp sgt <16 x i8> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i8> %x2, <16 x i8> %t0
  %t3 = icmp sgt <16 x i8> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i8> %x3, <16 x i8> %t2
  ret <16 x i8> %t4
}

define <8 x i16> @reassociate_smax_v8i16(<8 x i16> %x0, <8 x i16> %x1, <8 x i16> %x2, <8 x i16> %x3) {
; SSE-LABEL: reassociate_smax_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    pmaxsw %xmm3, %xmm2
; SSE-NEXT:    pmaxsw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxsw %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <8 x i16> %x0, %x1
  %t1 = icmp sgt <8 x i16> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i16> %x2, <8 x i16> %t0
  %t3 = icmp sgt <8 x i16> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i16> %x3, <8 x i16> %t2
  ret <8 x i16> %t4
}

define <4 x i32> @reassociate_smax_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_smax_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpmaxsd %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = icmp sgt <4 x i32> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i32> %x2, <4 x i32> %t0
  %t3 = icmp sgt <4 x i32> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i32> %x3, <4 x i32> %t2
  ret <4 x i32> %t4
}

define <2 x i64> @reassociate_smax_v2i64(<2 x i64> %x0, <2 x i64> %x1, <2 x i64> %x2, <2 x i64> %x3) {
; SSE-LABEL: reassociate_smax_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm0, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm2, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpmaxsq %xmm3, %xmm2, %xmm1
; AVX512-NEXT:    vpmaxsq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq

  %t0 = add <2 x i64> %x0, %x1
  %t1 = icmp sgt <2 x i64> %x2, %t0
  %t2 = select <2 x i1> %t1, <2 x i64> %x2, <2 x i64> %t0
  %t3 = icmp sgt <2 x i64> %x3, %t2
  %t4 = select <2 x i1> %t3, <2 x i64> %x3, <2 x i64> %t2
  ret <2 x i64> %t4
}

define <16 x i8> @reassociate_umin_v16i8(<16 x i8> %x0, <16 x i8> %x1, <16 x i8> %x2, <16 x i8> %x3) {
; SSE-LABEL: reassociate_umin_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm1, %xmm0
; SSE-NEXT:    pminub %xmm3, %xmm2
; SSE-NEXT:    pminub %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminub %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminub %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <16 x i8> %x0, %x1
  %t1 = icmp ult <16 x i8> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i8> %x2, <16 x i8> %t0
  %t3 = icmp ult <16 x i8> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i8> %x3, <16 x i8> %t2
  ret <16 x i8> %t4
}

define <8 x i16> @reassociate_umin_v8i16(<8 x i16> %x0, <8 x i16> %x1, <8 x i16> %x2, <8 x i16> %x3) {
; SSE-LABEL: reassociate_umin_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pminsw %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    pminsw %xmm3, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminuw %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminuw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <8 x i16> %x0, %x1
  %t1 = icmp ult <8 x i16> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i16> %x2, <8 x i16> %t0
  %t3 = icmp ult <8 x i16> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i16> %x3, <8 x i16> %t2
  ret <8 x i16> %t4
}

define <4 x i32> @reassociate_umin_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_umin_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminud %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminud %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = icmp ult <4 x i32> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i32> %x2, <4 x i32> %t0
  %t3 = icmp ult <4 x i32> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i32> %x3, <4 x i32> %t2
  ret <4 x i32> %t4
}

define <2 x i64> @reassociate_umin_v2i64(<2 x i64> %x0, <2 x i64> %x1, <2 x i64> %x2, <2 x i64> %x3) {
; SSE-LABEL: reassociate_umin_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %xmm1, %xmm2, %xmm4
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm5
; AVX2-NEXT:    vpcmpgtq %xmm4, %xmm5, %xmm4
; AVX2-NEXT:    vblendvpd %xmm4, %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vxorpd %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpxor %xmm1, %xmm3, %xmm1
; AVX2-NEXT:    vpcmpgtq %xmm1, %xmm2, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpminuq %xmm3, %xmm2, %xmm1
; AVX512-NEXT:    vpminuq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq

  %t0 = add <2 x i64> %x0, %x1
  %t1 = icmp ult <2 x i64> %x2, %t0
  %t2 = select <2 x i1> %t1, <2 x i64> %x2, <2 x i64> %t0
  %t3 = icmp ult <2 x i64> %x3, %t2
  %t4 = select <2 x i1> %t3, <2 x i64> %x3, <2 x i64> %t2
  ret <2 x i64> %t4
}

define <16 x i8> @reassociate_smin_v16i8(<16 x i8> %x0, <16 x i8> %x1, <16 x i8> %x2, <16 x i8> %x3) {
; SSE-LABEL: reassociate_smin_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtb %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v16i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminsb %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminsb %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <16 x i8> %x0, %x1
  %t1 = icmp slt <16 x i8> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i8> %x2, <16 x i8> %t0
  %t3 = icmp slt <16 x i8> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i8> %x3, <16 x i8> %t2
  ret <16 x i8> %t4
}

define <8 x i16> @reassociate_smin_v8i16(<8 x i16> %x0, <8 x i16> %x1, <8 x i16> %x2, <8 x i16> %x3) {
; SSE-LABEL: reassociate_smin_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm1, %xmm0
; SSE-NEXT:    pminsw %xmm3, %xmm2
; SSE-NEXT:    pminsw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminsw %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminsw %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <8 x i16> %x0, %x1
  %t1 = icmp slt <8 x i16> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i16> %x2, <8 x i16> %t0
  %t3 = icmp slt <8 x i16> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i16> %x3, <8 x i16> %t2
  ret <8 x i16> %t4
}

define <4 x i32> @reassociate_smin_v4i32(<4 x i32> %x0, <4 x i32> %x1, <4 x i32> %x2, <4 x i32> %x3) {
; SSE-LABEL: reassociate_smin_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm2, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtd %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpminsd %xmm3, %xmm2, %xmm1
; AVX-NEXT:    vpminsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %t0 = add <4 x i32> %x0, %x1
  %t1 = icmp slt <4 x i32> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i32> %x2, <4 x i32> %t0
  %t3 = icmp slt <4 x i32> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i32> %x3, <4 x i32> %t2
  ret <4 x i32> %t4
}

define <2 x i64> @reassociate_smin_v2i64(<2 x i64> %x0, <2 x i64> %x1, <2 x i64> %x2, <2 x i64> %x3) {
; SSE-LABEL: reassociate_smin_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm7 = xmm6[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm2
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm2, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm2, %xmm0, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpcmpgtq %xmm3, %xmm0, %xmm1
; AVX2-NEXT:    vblendvpd %xmm1, %xmm3, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpminsq %xmm3, %xmm2, %xmm1
; AVX512-NEXT:    vpminsq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq

  %t0 = add <2 x i64> %x0, %x1
  %t1 = icmp slt <2 x i64> %x2, %t0
  %t2 = select <2 x i1> %t1, <2 x i64> %x2, <2 x i64> %t0
  %t3 = icmp slt <2 x i64> %x3, %t2
  %t4 = select <2 x i1> %t3, <2 x i64> %x3, <2 x i64> %t2
  ret <2 x i64> %t4
}

; Verify that 256-bit vector min/max are reassociated.

define <32 x i8> @reassociate_umax_v32i8(<32 x i8> %x0, <32 x i8> %x1, <32 x i8> %x2, <32 x i8> %x3) {
; SSE-LABEL: reassociate_umax_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    paddb %xmm3, %xmm1
; SSE-NEXT:    pmaxub %xmm6, %xmm4
; SSE-NEXT:    pmaxub %xmm4, %xmm0
; SSE-NEXT:    pmaxub %xmm7, %xmm5
; SSE-NEXT:    pmaxub %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v32i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxub %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxub %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <32 x i8> %x0, %x1
  %t1 = icmp ugt <32 x i8> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i8> %x2, <32 x i8> %t0
  %t3 = icmp ugt <32 x i8> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i8> %x3, <32 x i8> %t2
  ret <32 x i8> %t4
}

define <16 x i16> @reassociate_umax_v16i16(<16 x i16> %x0, <16 x i16> %x1, <16 x i16> %x2, <16 x i16> %x3) {
; SSE-LABEL: reassociate_umax_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    paddw %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm2, %xmm5
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    pmaxsw %xmm5, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pmaxsw %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm6
; SSE-NEXT:    pmaxsw %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm7
; SSE-NEXT:    pmaxsw %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v16i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxuw %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <16 x i16> %x0, %x1
  %t1 = icmp ugt <16 x i16> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i16> %x2, <16 x i16> %t0
  %t3 = icmp ugt <16 x i16> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i16> %x3, <16 x i16> %t2
  ret <16 x i16> %t4
}

define <8 x i32> @reassociate_umax_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_umax_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm1, %xmm8
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm3
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pxor %xmm1, %xmm4
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm3, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm7, %xmm1
; SSE-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umax_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxud %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxud %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = icmp ugt <8 x i32> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i32> %x2, <8 x i32> %t0
  %t3 = icmp ugt <8 x i32> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i32> %x3, <8 x i32> %t2
  ret <8 x i32> %t4
}

define <4 x i64> @reassociate_umax_v4i64(<4 x i64> %x0, <4 x i64> %x1, <4 x i64> %x2, <4 x i64> %x3) {
; SSE-LABEL: reassociate_umax_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    paddq %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    pcmpgtd %xmm2, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm1, %ymm2, %ymm4
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm4, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmaxuq %ymm3, %ymm2, %ymm1
; AVX512-NEXT:    vpmaxuq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq

  %t0 = add <4 x i64> %x0, %x1
  %t1 = icmp ugt <4 x i64> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i64> %x2, <4 x i64> %t0
  %t3 = icmp ugt <4 x i64> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i64> %x3, <4 x i64> %t2
  ret <4 x i64> %t4
}

define <32 x i8> @reassociate_smax_v32i8(<32 x i8> %x0, <32 x i8> %x1, <32 x i8> %x2, <32 x i8> %x3) {
; SSE-LABEL: reassociate_smax_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    paddb %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v32i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxsb %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <32 x i8> %x0, %x1
  %t1 = icmp sgt <32 x i8> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i8> %x2, <32 x i8> %t0
  %t3 = icmp sgt <32 x i8> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i8> %x3, <32 x i8> %t2
  ret <32 x i8> %t4
}

define <16 x i16> @reassociate_smax_v16i16(<16 x i16> %x0, <16 x i16> %x1, <16 x i16> %x2, <16 x i16> %x3) {
; SSE-LABEL: reassociate_smax_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    paddw %xmm3, %xmm1
; SSE-NEXT:    pmaxsw %xmm6, %xmm4
; SSE-NEXT:    pmaxsw %xmm4, %xmm0
; SSE-NEXT:    pmaxsw %xmm7, %xmm5
; SSE-NEXT:    pmaxsw %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v16i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxsw %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <16 x i16> %x0, %x1
  %t1 = icmp sgt <16 x i16> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i16> %x2, <16 x i16> %t0
  %t3 = icmp sgt <16 x i16> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i16> %x3, <16 x i16> %t2
  ret <16 x i16> %t4
}

define <8 x i32> @reassociate_smax_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_smax_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smax_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpmaxsd %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = icmp sgt <8 x i32> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i32> %x2, <8 x i32> %t0
  %t3 = icmp sgt <8 x i32> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i32> %x3, <8 x i32> %t2
  ret <8 x i32> %t4
}

define <4 x i64> @reassociate_smax_v4i64(<4 x i64> %x0, <4 x i64> %x1, <4 x i64> %x2, <4 x i64> %x3) {
; SSE-LABEL: reassociate_smax_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    paddq %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm9
; SSE-NEXT:    pcmpgtd %xmm2, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pcmpgtd %xmm0, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm2, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm3, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpmaxsq %ymm3, %ymm2, %ymm1
; AVX512-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq

  %t0 = add <4 x i64> %x0, %x1
  %t1 = icmp sgt <4 x i64> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i64> %x2, <4 x i64> %t0
  %t3 = icmp sgt <4 x i64> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i64> %x3, <4 x i64> %t2
  ret <4 x i64> %t4
}

define <32 x i8> @reassociate_umin_v32i8(<32 x i8> %x0, <32 x i8> %x1, <32 x i8> %x2, <32 x i8> %x3) {
; SSE-LABEL: reassociate_umin_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    paddb %xmm3, %xmm1
; SSE-NEXT:    pminub %xmm6, %xmm4
; SSE-NEXT:    pminub %xmm4, %xmm0
; SSE-NEXT:    pminub %xmm7, %xmm5
; SSE-NEXT:    pminub %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v32i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminub %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminub %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <32 x i8> %x0, %x1
  %t1 = icmp ult <32 x i8> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i8> %x2, <32 x i8> %t0
  %t3 = icmp ult <32 x i8> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i8> %x3, <32 x i8> %t2
  ret <32 x i8> %t4
}

define <16 x i16> @reassociate_umin_v16i16(<16 x i16> %x0, <16 x i16> %x1, <16 x i16> %x2, <16 x i16> %x3) {
; SSE-LABEL: reassociate_umin_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    paddw %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm2, %xmm5
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    pminsw %xmm5, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pminsw %xmm4, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm6
; SSE-NEXT:    pminsw %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm7
; SSE-NEXT:    pminsw %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v16i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminuw %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminuw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <16 x i16> %x0, %x1
  %t1 = icmp ult <16 x i16> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i16> %x2, <16 x i16> %t0
  %t3 = icmp ult <16 x i16> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i16> %x3, <16 x i16> %t2
  ret <16 x i16> %t4
}

define <8 x i32> @reassociate_umin_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_umin_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm5, %xmm8
; SSE-NEXT:    pxor %xmm3, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    pcmpgtd %xmm8, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm5
; SSE-NEXT:    pxor %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    pcmpgtd %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_umin_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminud %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminud %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = icmp ult <8 x i32> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i32> %x2, <8 x i32> %t0
  %t3 = icmp ult <8 x i32> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i32> %x3, <8 x i32> %t2
  ret <8 x i32> %t4
}

define <4 x i64> @reassociate_umin_v4i64(<4 x i64> %x0, <4 x i64> %x1, <4 x i64> %x2, <4 x i64> %x3) {
; SSE-LABEL: reassociate_umin_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    paddq %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm9
; SSE-NEXT:    pcmpgtd %xmm3, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm1, %ymm2, %ymm4
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm5, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm3, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpminuq %ymm3, %ymm2, %ymm1
; AVX512-NEXT:    vpminuq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq

  %t0 = add <4 x i64> %x0, %x1
  %t1 = icmp ult <4 x i64> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i64> %x2, <4 x i64> %t0
  %t3 = icmp ult <4 x i64> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i64> %x3, <4 x i64> %t2
  ret <4 x i64> %t4
}

define <32 x i8> @reassociate_smin_v32i8(<32 x i8> %x0, <32 x i8> %x1, <32 x i8> %x2, <32 x i8> %x3) {
; SSE-LABEL: reassociate_smin_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    paddb %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtb %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtb %xmm4, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtb %xmm6, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtb %xmm7, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v32i8:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminsb %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminsb %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <32 x i8> %x0, %x1
  %t1 = icmp slt <32 x i8> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i8> %x2, <32 x i8> %t0
  %t3 = icmp slt <32 x i8> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i8> %x3, <32 x i8> %t2
  ret <32 x i8> %t4
}

define <16 x i16> @reassociate_smin_v16i16(<16 x i16> %x0, <16 x i16> %x1, <16 x i16> %x2, <16 x i16> %x3) {
; SSE-LABEL: reassociate_smin_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    paddw %xmm3, %xmm1
; SSE-NEXT:    pminsw %xmm6, %xmm4
; SSE-NEXT:    pminsw %xmm4, %xmm0
; SSE-NEXT:    pminsw %xmm7, %xmm5
; SSE-NEXT:    pminsw %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v16i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminsw %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminsw %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <16 x i16> %x0, %x1
  %t1 = icmp slt <16 x i16> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i16> %x2, <16 x i16> %t0
  %t3 = icmp slt <16 x i16> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i16> %x3, <16 x i16> %t2
  ret <16 x i16> %t4
}

define <8 x i32> @reassociate_smin_v8i32(<8 x i32> %x0, <8 x i32> %x1, <8 x i32> %x2, <8 x i32> %x3) {
; SSE-LABEL: reassociate_smin_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    paddd %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtd %xmm6, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm7, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX-LABEL: reassociate_smin_v8i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    vpminsd %ymm3, %ymm2, %ymm1
; AVX-NEXT:    vpminsd %ymm1, %ymm0, %ymm0
; AVX-NEXT:    retq

  %t0 = add <8 x i32> %x0, %x1
  %t1 = icmp slt <8 x i32> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i32> %x2, <8 x i32> %t0
  %t3 = icmp slt <8 x i32> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i32> %x3, <8 x i32> %t2
  ret <8 x i32> %t4
}

define <4 x i64> @reassociate_smin_v4i64(<4 x i64> %x0, <4 x i64> %x1, <4 x i64> %x2, <4 x i64> %x3) {
; SSE-LABEL: reassociate_smin_v4i64:
; SSE:       # %bb.0:
; SSE-NEXT:    paddq %xmm2, %xmm0
; SSE-NEXT:    paddq %xmm3, %xmm1
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm8, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm9
; SSE-NEXT:    pcmpgtd %xmm3, %xmm9
; SSE-NEXT:    pshufd {{.*#+}} xmm10 = xmm9[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm10, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm9[1,1,3,3]
; SSE-NEXT:    por %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm1, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    movdqa %xmm4, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pxor %xmm8, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm5[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    pand %xmm9, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pandn %xmm0, %xmm2
; SSE-NEXT:    por %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm6, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pcmpgtd %xmm1, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm1[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm4[1,1,3,3]
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm6
; SSE-NEXT:    pandn %xmm2, %xmm0
; SSE-NEXT:    por %xmm6, %xmm0
; SSE-NEXT:    movdqa %xmm3, %xmm1
; SSE-NEXT:    pxor %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm7, %xmm8
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm8, %xmm2
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[0,0,2,2]
; SSE-NEXT:    pcmpeqd %xmm1, %xmm8
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm8[1,1,3,3]
; SSE-NEXT:    pand %xmm4, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm3, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm0, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm0, %ymm1
; AVX2-NEXT:    vblendvpd %ymm1, %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpminsq %ymm3, %ymm2, %ymm1
; AVX512-NEXT:    vpminsq %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq

  %t0 = add <4 x i64> %x0, %x1
  %t1 = icmp slt <4 x i64> %x2, %t0
  %t2 = select <4 x i1> %t1, <4 x i64> %x2, <4 x i64> %t0
  %t3 = icmp slt <4 x i64> %x3, %t2
  %t4 = select <4 x i1> %t3, <4 x i64> %x3, <4 x i64> %t2
  ret <4 x i64> %t4
}

; Verify that 512-bit vector min/max are reassociated.

define <64 x i8> @reassociate_umax_v64i8(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, <64 x i8> %x3) {
; SSE-LABEL: reassociate_umax_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm6, %xmm2
; SSE-NEXT:    paddb %xmm7, %xmm3
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pmaxub {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxub %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxub %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxub %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxub %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxub %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxub %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <64 x i8> %x0, %x1
  %t1 = icmp ugt <64 x i8> %x2, %t0
  %t2 = select <64 x i1> %t1, <64 x i8> %x2, <64 x i8> %t0
  %t3 = icmp ugt <64 x i8> %x3, %t2
  %t4 = select <64 x i1> %t3, <64 x i8> %x3, <64 x i8> %t2
  ret <64 x i8> %t4
}

define <32 x i16> @reassociate_umax_v32i16(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, <32 x i16> %x3) {
; SSE-LABEL: reassociate_umax_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    paddw %xmm5, %xmm1
; SSE-NEXT:    paddw %xmm6, %xmm2
; SSE-NEXT:    paddw %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    pmaxsw %xmm3, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pmaxsw %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    pmaxsw %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    pmaxsw %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    pmaxsw %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    pmaxsw %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    pmaxsw %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pmaxsw %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxuw %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxuw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxuw %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxuw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxuw %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxuw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <32 x i16> %x0, %x1
  %t1 = icmp ugt <32 x i16> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i16> %x2, <32 x i16> %t0
  %t3 = icmp ugt <32 x i16> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i16> %x3, <32 x i16> %t2
  ret <32 x i16> %t4
}

define <16 x i32> @reassociate_umax_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_umax_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm7, %xmm9
; SSE-NEXT:    movdqa %xmm4, %xmm7
; SSE-NEXT:    movdqa %xmm3, %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm4
; SSE-NEXT:    paddd %xmm7, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm9, %xmm8
; SSE-NEXT:    movdqa {{.*#+}} xmm3 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pxor %xmm3, %xmm6
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pxor %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pandn %xmm8, %xmm6
; SSE-NEXT:    por %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm15, %xmm5
; SSE-NEXT:    pxor %xmm3, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    pcmpgtd %xmm4, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm15
; SSE-NEXT:    pandn %xmm2, %xmm5
; SSE-NEXT:    por %xmm15, %xmm5
; SSE-NEXT:    movdqa %xmm14, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm14
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm14, %xmm2
; SSE-NEXT:    movdqa %xmm13, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm13
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm13, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm12, %xmm0
; SSE-NEXT:    pxor %xmm3, %xmm0
; SSE-NEXT:    pcmpgtd %xmm4, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm12
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm12, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    pcmpgtd %xmm4, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm11
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm11, %xmm1
; SSE-NEXT:    movdqa %xmm5, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    movdqa %xmm10, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm2
; SSE-NEXT:    pcmpgtd %xmm4, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm10
; SSE-NEXT:    pandn %xmm5, %xmm2
; SSE-NEXT:    por %xmm10, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm4
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pxor %xmm5, %xmm3
; SSE-NEXT:    pcmpgtd %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm6, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxud %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxud %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxud %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxud %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxud %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = icmp ugt <16 x i32> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i32> %x2, <16 x i32> %t0
  %t3 = icmp ugt <16 x i32> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i32> %x3, <16 x i32> %t2
  ret <16 x i32> %t4
}

define <8 x i64> @reassociate_umax_v8i64(<8 x i64> %x0, <8 x i64> %x1, <8 x i64> %x2, <8 x i64> %x3) {
; SSE-LABEL: reassociate_umax_v8i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    paddq %xmm5, %xmm1
; SSE-NEXT:    paddq %xmm6, %xmm2
; SSE-NEXT:    paddq %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umax_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm3, %ymm5, %ymm8
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm9
; AVX2-NEXT:    vpcmpgtq %ymm9, %ymm8, %ymm8
; AVX2-NEXT:    vblendvpd %ymm8, %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm6, %ymm4
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm4, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm7, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umax_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxuq %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <8 x i64> %x0, %x1
  %t1 = icmp ugt <8 x i64> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i64> %x2, <8 x i64> %t0
  %t3 = icmp ugt <8 x i64> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i64> %x3, <8 x i64> %t2
  ret <8 x i64> %t4
}

define <64 x i8> @reassociate_smax_v64i8(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, <64 x i8> %x3) {
; SSE-LABEL: reassociate_smax_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm6, %xmm2
; SSE-NEXT:    paddb %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pcmpgtb %xmm3, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm15, %xmm4
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pcmpgtb %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pcmpgtb %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pcmpgtb %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pcmpgtb %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pcmpgtb %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pcmpgtb %xmm3, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pcmpgtb %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxsb %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxsb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxsb %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxsb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxsb %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxsb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <64 x i8> %x0, %x1
  %t1 = icmp sgt <64 x i8> %x2, %t0
  %t2 = select <64 x i1> %t1, <64 x i8> %x2, <64 x i8> %t0
  %t3 = icmp sgt <64 x i8> %x3, %t2
  %t4 = select <64 x i1> %t3, <64 x i8> %x3, <64 x i8> %t2
  ret <64 x i8> %t4
}

define <32 x i16> @reassociate_smax_v32i16(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, <32 x i16> %x3) {
; SSE-LABEL: reassociate_smax_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    paddw %xmm5, %xmm1
; SSE-NEXT:    paddw %xmm6, %xmm2
; SSE-NEXT:    paddw %xmm7, %xmm3
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pmaxsw {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxsw %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxsw %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxsw %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxsw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <32 x i16> %x0, %x1
  %t1 = icmp sgt <32 x i16> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i16> %x2, <32 x i16> %t0
  %t3 = icmp sgt <32 x i16> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i16> %x3, <32 x i16> %t2
  ret <32 x i16> %t4
}

define <16 x i32> @reassociate_smax_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_smax_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm15, %xmm4
; SSE-NEXT:    pcmpgtd %xmm3, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm15, %xmm4
; SSE-NEXT:    movdqa %xmm14, %xmm3
; SSE-NEXT:    pcmpgtd %xmm2, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm2
; SSE-NEXT:    pcmpgtd %xmm1, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pcmpgtd %xmm0, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm11, %xmm0
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm10, %xmm1
; SSE-NEXT:    pcmpgtd %xmm2, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm9, %xmm2
; SSE-NEXT:    pcmpgtd %xmm3, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm8, %xmm3
; SSE-NEXT:    pcmpgtd %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpmaxsd %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpmaxsd %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxsd %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = icmp sgt <16 x i32> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i32> %x2, <16 x i32> %t0
  %t3 = icmp sgt <16 x i32> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i32> %x3, <16 x i32> %t2
  ret <16 x i32> %t4
}

define <8 x i64> @reassociate_smax_v8i64(<8 x i64> %x0, <8 x i64> %x1, <8 x i64> %x2, <8 x i64> %x3) {
; SSE-LABEL: reassociate_smax_v8i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    paddq %xmm5, %xmm1
; SSE-NEXT:    paddq %xmm6, %xmm2
; SSE-NEXT:    paddq %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm5, %xmm7
; SSE-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm3, %xmm7
; SSE-NEXT:    pcmpgtd %xmm6, %xmm7
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pcmpgtd %xmm5, %xmm6
; SSE-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm0, %xmm6
; SSE-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm2, %xmm5
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm4, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smax_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm5, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm4, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm6, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm7, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smax_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpmaxsq %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <8 x i64> %x0, %x1
  %t1 = icmp sgt <8 x i64> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i64> %x2, <8 x i64> %t0
  %t3 = icmp sgt <8 x i64> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i64> %x3, <8 x i64> %t2
  ret <8 x i64> %t4
}

define <64 x i8> @reassociate_umin_v64i8(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, <64 x i8> %x3) {
; SSE-LABEL: reassociate_umin_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm6, %xmm2
; SSE-NEXT:    paddb %xmm7, %xmm3
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pminub {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminub %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminub %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminub %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminub %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminub %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminub %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <64 x i8> %x0, %x1
  %t1 = icmp ult <64 x i8> %x2, %t0
  %t2 = select <64 x i1> %t1, <64 x i8> %x2, <64 x i8> %t0
  %t3 = icmp ult <64 x i8> %x3, %t2
  %t4 = select <64 x i1> %t3, <64 x i8> %x3, <64 x i8> %t2
  ret <64 x i8> %t4
}

define <32 x i16> @reassociate_umin_v32i16(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, <32 x i16> %x3) {
; SSE-LABEL: reassociate_umin_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    paddw %xmm5, %xmm1
; SSE-NEXT:    paddw %xmm6, %xmm2
; SSE-NEXT:    paddw %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [32768,32768,32768,32768,32768,32768,32768,32768]
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    pminsw %xmm3, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pminsw %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    pminsw %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    pminsw %xmm0, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    pminsw %xmm1, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    pminsw %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    pminsw %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pminsw %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminuw %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminuw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminuw %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminuw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminuw %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminuw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <32 x i16> %x0, %x1
  %t1 = icmp ult <32 x i16> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i16> %x2, <32 x i16> %t0
  %t3 = icmp ult <32 x i16> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i16> %x3, <32 x i16> %t2
  ret <32 x i16> %t4
}

define <16 x i32> @reassociate_umin_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_umin_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [2147483648,2147483648,2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm15, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pxor %xmm5, %xmm4
; SSE-NEXT:    pcmpgtd %xmm6, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm15, %xmm4
; SSE-NEXT:    movdqa %xmm14, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm3
; SSE-NEXT:    pcmpgtd %xmm6, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm13, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm5, %xmm2
; SSE-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm12, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm1, %xmm6
; SSE-NEXT:    pand %xmm6, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm6
; SSE-NEXT:    por %xmm12, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm0
; SSE-NEXT:    pxor %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm11, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    pcmpgtd %xmm1, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm6, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    movdqa %xmm10, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm6, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm5, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm6
; SSE-NEXT:    pxor %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm6, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm8, %xmm5
; SSE-NEXT:    pcmpgtd %xmm5, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminud %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminud %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminud %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminud %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminud %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminud %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = icmp ult <16 x i32> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i32> %x2, <16 x i32> %t0
  %t3 = icmp ult <16 x i32> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i32> %x3, <16 x i32> %t2
  ret <16 x i32> %t4
}

define <8 x i64> @reassociate_umin_v8i64(<8 x i64> %x0, <8 x i64> %x1, <8 x i64> %x2, <8 x i64> %x3) {
; SSE-LABEL: reassociate_umin_v8i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    paddq %xmm5, %xmm1
; SSE-NEXT:    paddq %xmm6, %xmm2
; SSE-NEXT:    paddq %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [9223372039002259456,9223372039002259456]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm3, %xmm7
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_umin_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm3, %ymm5, %ymm8
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm9
; AVX2-NEXT:    vpcmpgtq %ymm8, %ymm9, %ymm8
; AVX2-NEXT:    vblendvpd %ymm8, %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm3, %ymm4, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm0, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm5, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm3, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm6, %ymm4
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vxorpd %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm7, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_umin_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminuq %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminuq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <8 x i64> %x0, %x1
  %t1 = icmp ult <8 x i64> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i64> %x2, <8 x i64> %t0
  %t3 = icmp ult <8 x i64> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i64> %x3, <8 x i64> %t2
  ret <8 x i64> %t4
}

define <64 x i8> @reassociate_smin_v64i8(<64 x i8> %x0, <64 x i8> %x1, <64 x i8> %x2, <64 x i8> %x3) {
; SSE-LABEL: reassociate_smin_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm6, %xmm2
; SSE-NEXT:    paddb %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pcmpgtb %xmm15, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm15, %xmm4
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtb %xmm14, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtb %xmm13, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtb %xmm12, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtb %xmm11, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtb %xmm10, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pcmpgtb %xmm9, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pcmpgtb %xmm8, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminsb %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminsb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminsb %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminsb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminsb %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminsb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <64 x i8> %x0, %x1
  %t1 = icmp slt <64 x i8> %x2, %t0
  %t2 = select <64 x i1> %t1, <64 x i8> %x2, <64 x i8> %t0
  %t3 = icmp slt <64 x i8> %x3, %t2
  %t4 = select <64 x i1> %t3, <64 x i8> %x3, <64 x i8> %t2
  ret <64 x i8> %t4
}

define <32 x i16> @reassociate_smin_v32i16(<32 x i16> %x0, <32 x i16> %x1, <32 x i16> %x2, <32 x i16> %x3) {
; SSE-LABEL: reassociate_smin_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    paddw %xmm5, %xmm1
; SSE-NEXT:    paddw %xmm6, %xmm2
; SSE-NEXT:    paddw %xmm7, %xmm3
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm0
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm2
; SSE-NEXT:    pminsw {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminsw %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminsw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminsw %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminsw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminsw %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminsw %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <32 x i16> %x0, %x1
  %t1 = icmp slt <32 x i16> %x2, %t0
  %t2 = select <32 x i1> %t1, <32 x i16> %x2, <32 x i16> %t0
  %t3 = icmp slt <32 x i16> %x3, %t2
  %t4 = select <32 x i1> %t3, <32 x i16> %x3, <32 x i16> %t2
  ret <32 x i16> %t4
}

define <16 x i32> @reassociate_smin_v16i32(<16 x i32> %x0, <16 x i32> %x1, <16 x i32> %x2, <16 x i32> %x3) {
; SSE-LABEL: reassociate_smin_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm9
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm10
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm11
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm12
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm13
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm14
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm15
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    paddd %xmm5, %xmm1
; SSE-NEXT:    paddd %xmm6, %xmm2
; SSE-NEXT:    paddd %xmm7, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pcmpgtd %xmm15, %xmm4
; SSE-NEXT:    pand %xmm4, %xmm15
; SSE-NEXT:    pandn %xmm3, %xmm4
; SSE-NEXT:    por %xmm15, %xmm4
; SSE-NEXT:    movdqa %xmm2, %xmm3
; SSE-NEXT:    pcmpgtd %xmm14, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm14
; SSE-NEXT:    pandn %xmm2, %xmm3
; SSE-NEXT:    por %xmm14, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pcmpgtd %xmm13, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm13
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm13, %xmm2
; SSE-NEXT:    movdqa %xmm0, %xmm1
; SSE-NEXT:    pcmpgtd %xmm12, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm12
; SSE-NEXT:    pandn %xmm0, %xmm1
; SSE-NEXT:    por %xmm12, %xmm1
; SSE-NEXT:    movdqa %xmm1, %xmm0
; SSE-NEXT:    pcmpgtd %xmm11, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm11
; SSE-NEXT:    pandn %xmm1, %xmm0
; SSE-NEXT:    por %xmm11, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pcmpgtd %xmm10, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm10
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm10, %xmm1
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pcmpgtd %xmm9, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm9
; SSE-NEXT:    pandn %xmm3, %xmm2
; SSE-NEXT:    por %xmm9, %xmm2
; SSE-NEXT:    movdqa %xmm4, %xmm3
; SSE-NEXT:    pcmpgtd %xmm8, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm8
; SSE-NEXT:    pandn %xmm4, %xmm3
; SSE-NEXT:    por %xmm8, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpminsd %ymm6, %ymm4, %ymm2
; AVX2-NEXT:    vpminsd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpminsd %ymm7, %ymm5, %ymm2
; AVX2-NEXT:    vpminsd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminsd %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminsd %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <16 x i32> %x0, %x1
  %t1 = icmp slt <16 x i32> %x2, %t0
  %t2 = select <16 x i1> %t1, <16 x i32> %x2, <16 x i32> %t0
  %t3 = icmp slt <16 x i32> %x3, %t2
  %t4 = select <16 x i1> %t3, <16 x i32> %x3, <16 x i32> %t2
  ret <16 x i32> %t4
}

define <8 x i64> @reassociate_smin_v8i64(<8 x i64> %x0, <8 x i64> %x1, <8 x i64> %x2, <8 x i64> %x3) {
; SSE-LABEL: reassociate_smin_v8i64:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm8
; SSE-NEXT:    paddq %xmm4, %xmm0
; SSE-NEXT:    paddq %xmm5, %xmm1
; SSE-NEXT:    paddq %xmm6, %xmm2
; SSE-NEXT:    paddq %xmm7, %xmm3
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [2147483648,2147483648]
; SSE-NEXT:    movdqa %xmm8, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm5, %xmm7
; SSE-NEXT:    pcmpeqd %xmm5, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm5, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm9 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm9
; SSE-NEXT:    pand %xmm9, %xmm8
; SSE-NEXT:    pandn %xmm3, %xmm9
; SSE-NEXT:    por %xmm8, %xmm9
; SSE-NEXT:    movdqa %xmm5, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm6
; SSE-NEXT:    pxor %xmm4, %xmm6
; SSE-NEXT:    movdqa %xmm6, %xmm7
; SSE-NEXT:    pcmpgtd %xmm3, %xmm7
; SSE-NEXT:    pcmpeqd %xmm3, %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm7[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm6 = xmm6[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm6
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm8 = xmm7[1,1,3,3]
; SSE-NEXT:    por %xmm6, %xmm8
; SSE-NEXT:    pand %xmm8, %xmm5
; SSE-NEXT:    pandn %xmm2, %xmm8
; SSE-NEXT:    por %xmm5, %xmm8
; SSE-NEXT:    movdqa %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pxor %xmm4, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm6
; SSE-NEXT:    pcmpgtd %xmm2, %xmm6
; SSE-NEXT:    pcmpeqd %xmm2, %xmm5
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm5
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm5, %xmm2
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pandn %xmm1, %xmm2
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa %xmm7, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pcmpgtd %xmm1, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm1
; SSE-NEXT:    pshufd {{.*#+}} xmm5 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm5
; SSE-NEXT:    pand %xmm5, %xmm7
; SSE-NEXT:    pandn %xmm0, %xmm5
; SSE-NEXT:    por %xmm7, %xmm5
; SSE-NEXT:    movdqa %xmm5, %xmm0
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm0, %xmm6
; SSE-NEXT:    pcmpgtd %xmm3, %xmm6
; SSE-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm0, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm7
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm0
; SSE-NEXT:    pand %xmm0, %xmm1
; SSE-NEXT:    pandn %xmm5, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    movdqa %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm7, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm1, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm1, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm1, %xmm3
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm6
; SSE-NEXT:    pshufd {{.*#+}} xmm1 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm1
; SSE-NEXT:    pand %xmm1, %xmm7
; SSE-NEXT:    pandn %xmm2, %xmm1
; SSE-NEXT:    por %xmm7, %xmm1
; SSE-NEXT:    movdqa %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm6, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pcmpgtd %xmm3, %xmm5
; SSE-NEXT:    pcmpeqd %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm3[1,1,3,3]
; SSE-NEXT:    pand %xmm2, %xmm3
; SSE-NEXT:    pshufd {{.*#+}} xmm2 = xmm5[1,1,3,3]
; SSE-NEXT:    por %xmm3, %xmm2
; SSE-NEXT:    movdqa {{[0-9]+}}(%rsp), %xmm5
; SSE-NEXT:    pand %xmm2, %xmm6
; SSE-NEXT:    pandn %xmm8, %xmm2
; SSE-NEXT:    por %xmm6, %xmm2
; SSE-NEXT:    movdqa %xmm9, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    pxor %xmm5, %xmm4
; SSE-NEXT:    movdqa %xmm3, %xmm6
; SSE-NEXT:    pcmpgtd %xmm4, %xmm6
; SSE-NEXT:    pcmpeqd %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[0,0,2,2]
; SSE-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[1,1,3,3]
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pshufd {{.*#+}} xmm3 = xmm6[1,1,3,3]
; SSE-NEXT:    por %xmm4, %xmm3
; SSE-NEXT:    pand %xmm3, %xmm5
; SSE-NEXT:    pandn %xmm9, %xmm3
; SSE-NEXT:    por %xmm5, %xmm3
; SSE-NEXT:    retq
;
; AVX2-LABEL: reassociate_smin_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpaddq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm5, %ymm1, %ymm3
; AVX2-NEXT:    vblendvpd %ymm3, %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm4, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm6, %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm6, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpgtq %ymm7, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm7, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: reassociate_smin_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpaddq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpminsq %zmm3, %zmm2, %zmm1
; AVX512-NEXT:    vpminsq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq

  %t0 = add <8 x i64> %x0, %x1
  %t1 = icmp slt <8 x i64> %x2, %t0
  %t2 = select <8 x i1> %t1, <8 x i64> %x2, <8 x i64> %t0
  %t3 = icmp slt <8 x i64> %x3, %t2
  %t4 = select <8 x i1> %t3, <8 x i64> %x3, <8 x i64> %t2
  ret <8 x i64> %t4
}
